/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;

public class Debug
extends PrintStream {
    private boolean _debug = false;
    private int _dotCount = 0;
    private int _lineCount = 0;
    private HashMap<String, LogTarget> _debugLogs = new HashMap();
    public static final Debug out = new Debug(System.out);
    private PrintStream _output;

    public Debug(PrintStream output) {
        super(System.out);
        this._output = output;
    }

    public void dot() {
        ++this._dotCount;
        if (this._dotCount == 100) {
            this._dotCount = 0;
            this.print(".");
            ++this._lineCount;
            if (this._lineCount == 78) {
                this._lineCount = 0;
                this.println("");
            }
        }
    }

    public void endDot() {
        if (this._lineCount > 0) {
            this.println("");
        }
        this._lineCount = 0;
        this._dotCount = 0;
    }

    public ProgressCounter initPC(int max) {
        this.print("  0%\r");
        return new ProgressCounter(max);
    }

    public void incPC(ProgressCounter pc) {
        ++pc.cur;
        byte perc = (byte)(100.0f / (float)pc.max * (float)pc.cur);
        if (perc > pc.lastPercentage) {
            pc.lastPercentage = perc;
            this.format("%3d%%\r", perc);
        }
    }

    public PrintStream getOutput() {
        return this._output;
    }

    public void setOutput(PrintStream output) {
        this._output = output;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    protected boolean debugOutput() {
        return this._debug;
    }

    public void write(int b) {
        if (this.debugOutput()) {
            this._output.write(b);
        }
    }

    public void write(byte[] buf, int off, int len) {
        if (this.debugOutput()) {
            this._output.write(buf, off, len);
        }
    }

    public void print(boolean b) {
        if (this.debugOutput()) {
            this._output.print(b);
        }
    }

    public void print(char c) {
        if (this.debugOutput()) {
            this._output.print(c);
        }
    }

    public void print(int i) {
        if (this.debugOutput()) {
            this._output.print(i);
        }
    }

    public void print(long l) {
        if (this.debugOutput()) {
            this._output.print(l);
        }
    }

    public void print(float f) {
        if (this.debugOutput()) {
            this._output.print(f);
        }
    }

    public void print(double d) {
        if (this.debugOutput()) {
            this._output.print(d);
        }
    }

    public void print(char[] s) {
        if (this.debugOutput()) {
            this._output.print(s);
        }
    }

    public void print(String s) {
        if (this.debugOutput()) {
            this._output.print(s);
        }
    }

    public void print(Object obj) {
        if (this.debugOutput()) {
            this._output.print(obj);
        }
    }

    public void println() {
        if (this.debugOutput()) {
            this._output.println();
        }
    }

    public void println(boolean x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(char x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(int x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(long x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(float x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(double x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(char[] x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(String x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public void println(Object x) {
        if (this.debugOutput()) {
            this._output.println(x);
        }
    }

    public PrintStream printf(String format, Object ... args) {
        if (this.debugOutput()) {
            this._output.printf(format, args);
        }
        return this;
    }

    public PrintStream printf(Locale l, String format, Object ... args) {
        if (this.debugOutput()) {
            this._output.printf(l, format, args);
        }
        return this;
    }

    public PrintStream format(String format, Object ... args) {
        if (this.debugOutput()) {
            this._output.format(format, args);
        }
        return this;
    }

    public PrintStream format(Locale l, String format, Object ... args) {
        if (this.debugOutput()) {
            this._output.format(l, format, args);
        }
        return this;
    }

    public PrintStream append(CharSequence csq) {
        if (this.debugOutput()) {
            this._output.append(csq);
        }
        return this;
    }

    public PrintStream append(char c) {
        if (this.debugOutput()) {
            this._output.append(c);
        }
        return this;
    }

    public void write(byte[] b) throws IOException {
        if (this.debugOutput()) {
            this._output.write(b);
        }
    }

    public void setLogTarget(String logName, LogTarget target) {
        this._debugLogs.put(logName, target);
    }

    public LogTarget getLogTarget(String logName) {
        LogTarget b = this._debugLogs.get(logName);
        return b == null ? LogTarget.NONE : b;
    }

    protected boolean isFileEnabled(String logName) {
        LogTarget b = this.getLogTarget(logName);
        return b == LogTarget.FILE || b == LogTarget.BOTH;
    }

    protected boolean isConsoleEnabled(String logName) {
        LogTarget b = this.getLogTarget(logName);
        return b == LogTarget.MAIN || b == LogTarget.BOTH;
    }

    public void print(String logName, boolean b) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(b);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(b);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String logName, char c) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(c);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(c);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String logName, int i) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(i);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(i);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String logName, long l) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(l);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(l);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void print(String logName, float f) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(f);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(f);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String logName, double d) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(d);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(d);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void print(String logName, char[] s) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(s);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(s);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String logName, String s) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(s);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(s);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void print(String logName, Object obj) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.print(obj);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.print(obj);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, boolean x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, char x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, int x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, long x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void println(String logName, float x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, double x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void println(String logName, char[] x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, String x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String logName, Object x) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.println(x);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter((Writer)new FileWriter(logName + ".log"), true);
                w.println(x);
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public PrintStream printf(String logName, String format, Object ... args) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.printf(format, args);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(logName + ".log"));
                w.printf(format, args);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this;
    }

    public PrintStream format(String logName, String format, Object ... args) {
        if (this.debugOutput() && this.isConsoleEnabled(logName)) {
            this._output.format(format, args);
        }
        if (this.debugOutput() && this.isFileEnabled(logName)) {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(logName + ".log"));
                w.format(format, args);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this;
    }

    public static class ProgressCounter {
        public int cur;
        public int max;
        public byte lastPercentage;

        public ProgressCounter(int max) {
            this.max = max;
            this.cur = 0;
            this.lastPercentage = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogTarget {
        NONE,
        MAIN,
        FILE,
        BOTH;

    }
}

