/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.util;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.DoNotInstrument;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.util.Debug;

public abstract class ConditionalStrategy
implements IInstrumentationStrategy {
    IInstrumentationStrategy _decoree;

    public ConditionalStrategy(IInstrumentationStrategy decoree) {
        this._decoree = decoree;
    }

    public void instrument(ClassFile cf) {
        String[] doNotInstrumentPatterns = new String[]{};
        AAttributeInfo attr = cf.getAttribute(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName());
        if (null != attr) {
            RuntimeInvisibleAnnotationsAttributeInfo ann = (RuntimeInvisibleAnnotationsAttributeInfo)attr;
            block0: for (AAnnotationsAttributeInfo.Annotation a : ann.getAnnotations()) {
                String typeString = ClassFileTools.getTypeString(a.getType(), "");
                if (!typeString.substring(0, typeString.length() - 1).equals(DoNotInstrument.class.getName())) continue;
                for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : a.getPairs()) {
                    if (!nvp.getName().toString().equals("instrumentors")) continue;
                    AAnnotationsAttributeInfo.Annotation.ConstantMemberValue c = nvp.getValue().execute(AAnnotationsAttributeInfo.Annotation.CheckConstantMemberVisitor.singleton(), null);
                    AUTFPoolInfo patternString = c.getConstValue().execute(CheckUTFVisitor.singleton(), null);
                    doNotInstrumentPatterns = patternString.toString().split(";");
                    break block0;
                }
                break;
            }
        }
        if (this.apply(cf)) {
            if (!ClassFileTools.classNameMatches(this._decoree.getClass().getName(), doNotInstrumentPatterns)) {
                this._decoree.instrument(cf);
            } else {
                Debug.out.println("Class " + cf.getThisClassName() + " not instrumented with " + this._decoree.getClass().getName() + " because it matched @DoNotInstrument instrumentors");
            }
        }
    }

    public abstract boolean apply(ClassFile var1);

    public void done() {
        this._decoree.done();
    }
}

