/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.threadCheck;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.ASingleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeVisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.DoublePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.FloatPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.IntegerPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.LongPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.MethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.NameAndTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckMethodVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckNameAndTypeVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.threadCheck.AThreadCheckStrategy;
import edu.rice.cs.cunit.instrumentors.threadCheck.ClassNotFoundWarning;
import edu.rice.cs.cunit.instrumentors.threadCheck.PredicateAnnotationRecord;
import edu.rice.cs.cunit.instrumentors.threadCheck.SubtypingWarning;
import edu.rice.cs.cunit.instrumentors.threadCheck.ThreadCheckAnnotationRecord;
import edu.rice.cs.cunit.instrumentors.threadCheck.ThreadCheckDefinitionRecord;
import edu.rice.cs.cunit.instrumentors.util.IScannerStrategy;
import edu.rice.cs.cunit.threadCheck.NotRunBy;
import edu.rice.cs.cunit.threadCheck.OnlyRunBy;
import edu.rice.cs.cunit.threadCheck.SuppressSubtypingWarning;
import edu.rice.cs.cunit.threadCheck.ThreadCheckException;
import edu.rice.cs.cunit.threadCheck.XMLAnnotUtils;
import edu.rice.cs.cunit.util.Debug;
import edu.rice.cs.cunit.util.ILambda;
import edu.rice.cs.cunit.util.IPredicate;
import edu.rice.cs.cunit.util.Ref;
import edu.rice.cs.cunit.util.SoftHashMap;
import edu.rice.cs.cunit.util.StringOps;
import edu.rice.cs.cunit.util.XMLConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AAddThreadCheckStrategy
extends AThreadCheckStrategy {
    public static final String XML_ANNOT_SAVE_MERGED_PREFIX = "xml-save-merged=";
    SharedAddData _sharedAddData;

    public AAddThreadCheckStrategy(AThreadCheckStrategy.SharedData shared, SharedAddData sharedAdd) {
        this(new ArrayList<String>(), shared, sharedAdd);
    }

    public AAddThreadCheckStrategy(List<String> parameters, AThreadCheckStrategy.SharedData shared, SharedAddData sharedAdd) {
        super(parameters, shared);
        this._sharedAddData = sharedAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadCheckAnnotationRecord getClassAnnotations(ClassFile cf) {
        ThreadCheckAnnotationRecord classAR;
        block20: {
            ThreadCheckAnnotationRecord ca = this._sharedAddData.classAnnotations.get(cf.getThisClassName());
            if (ca != null) {
                this._sharedAddData.cacheInfo.incClassCacheHit();
                return ca;
            }
            this._sharedAddData.cacheInfo.incClassCacheMiss();
            classAR = new ThreadCheckAnnotationRecord();
            this.extractLists("L" + NotRunBy.class.getName(), cf.getAttributes(), classAR.denyThreadNames, classAR.denyThreadIds, classAR.denyThreadGroups, null);
            Ref<Object> allowEventThread = new Ref<Object>(null);
            this.extractLists("L" + OnlyRunBy.class.getName(), cf.getAttributes(), classAR.allowThreadNames, classAR.allowThreadIds, classAR.allowThreadGroups, allowEventThread);
            classAR.allowEventThread = allowEventThread.get() != null ? (OnlyRunBy.EVENT_THREAD)allowEventThread.get() : OnlyRunBy.EVENT_THREAD.NO;
            this.extractPredicateSet(cf.getAttributes(), classAR.predicateAnnotations, null);
            if (!cf.getSuperClassName().equals("")) {
                ClassFileTools.ClassLocation cl = null;
                try {
                    cl = ClassFileTools.findClassFile(cf.getSuperClassName(), this._sharedData.getClassPath());
                    if (cl != null) {
                        ClassFile scf = cl.getClassFile();
                        ThreadCheckAnnotationRecord superClassAR = this.getClassAnnotations(scf);
                        classAR.add(superClassAR);
                    } else {
                        this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(cf.getSuperClassName(), this._sharedData.getCurrentClassName()));
                    }
                    for (ClassPoolInfo cpi : cf.getInterfaces()) {
                        String interfaceName = cpi.getName().toString().replace('/', '.');
                        cl = ClassFileTools.findClassFile(interfaceName, this._sharedData.getClassPath());
                        if (cl != null) {
                            ClassFile icf = cl.getClassFile();
                            ThreadCheckAnnotationRecord interfClassAR = this.getClassAnnotations(icf);
                            classAR.add(interfClassAR);
                            continue;
                        }
                        this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(interfaceName, this._sharedData.getCurrentClassName()));
                    }
                }
                finally {
                    try {
                        if (cl != null) {
                            cl.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            try {
                String path = "concutest/threadcheck/" + cf.getThisClassName().replace('.', '/').replace('$', '-') + "/class";
                List<Node> classNodes = this._sharedAddData.xmlAnnot.getNodes(path);
                if (classNodes.size() > 1) {
                    throw new ThreadCheckException("There may only be one <class> tag per class (path: " + path + ").");
                }
                if (classNodes.size() != 1) break block20;
                try {
                    ThreadCheckAnnotationRecord xmlClassAR = this.extractXMLAnnotations(classNodes.get(0));
                    classAR.add(xmlClassAR);
                }
                catch (ThreadCheckException e) {
                    throw new ThreadCheckException("Exception extracting XML annotations for path " + path + ".", e);
                }
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
        }
        this._sharedAddData.classAnnotations.put(cf.getThisClassName(), classAR);
        return classAR;
    }

    public List<ThreadCheckDefinitionRecord> extractXMLConcDef(XMLConfig xc) {
        final ArrayList<ThreadCheckDefinitionRecord> concDefs = new ArrayList<ThreadCheckDefinitionRecord>();
        List<Node> defs = xc.getNodes("concutest/threadcheck:def/");
        for (Node def : defs) {
            try {
                ThreadCheckDefinitionRecord cd = this.extractXMLConcDef(xc, def);
                if (cd == null) continue;
                concDefs.add(cd);
            }
            catch (ThreadCheckException e) {}
        }
        IPredicate<String> processClassPred = new IPredicate<String>(){

            @Override
            public Boolean apply(String className) {
                return true;
            }
        };
        ILambda.Ternary<Object, String, ThreadCheckAnnotationRecord, HashMap<String, ThreadCheckAnnotationRecord>> classLambda = new ILambda.Ternary<Object, String, ThreadCheckAnnotationRecord, HashMap<String, ThreadCheckAnnotationRecord>>(){

            @Override
            public Object apply(String className, ThreadCheckAnnotationRecord classAnnots, HashMap<String, ThreadCheckAnnotationRecord> methodAnnots) {
                if (!classAnnots.empty()) {
                    ThreadCheckDefinitionRecord cd = new ThreadCheckDefinitionRecord(classAnnots);
                    cd.addClass(className);
                    concDefs.add(cd);
                }
                for (String sig : methodAnnots.keySet()) {
                    ThreadCheckAnnotationRecord annots = methodAnnots.get(sig);
                    if (annots.empty()) continue;
                    ThreadCheckDefinitionRecord cd = new ThreadCheckDefinitionRecord(annots);
                    cd.addMethod(className, sig, methodAnnots.get((Object)sig).suppressSubtypingWarning);
                    concDefs.add(cd);
                }
                return null;
            }
        };
        ArrayList<ThreadCheckException> exList = new ArrayList<ThreadCheckException>();
        XMLAnnotUtils.ClassBased.processNode(xc, classLambda, processClassPred, exList);
        if (exList.size() > 0) {
            throw new ThreadCheckException("Errors reading <threadcheck> nodes: " + Arrays.toString(exList.toArray()));
        }
        return concDefs;
    }

    public ThreadCheckAnnotationRecord extractXMLAnnotations(Node elt) {
        ThreadCheckAnnotationRecord xmlAR = new ThreadCheckAnnotationRecord();
        for (int i = 0; i < elt.getChildNodes().getLength(); ++i) {
            Node n;
            PredicateAnnotationRecord par;
            AAnnotationsAttributeInfo.Annotation annot;
            Node value;
            Node type;
            Node element = elt.getChildNodes().item(i);
            if (element.getNodeName().equalsIgnoreCase("name")) {
                if (element.getAttributes().getLength() != 2) {
                    throw new ThreadCheckException("The <name> tag should have type and value attributes.");
                }
                type = element.getAttributes().getNamedItem("type");
                value = element.getAttributes().getNamedItem("value");
                if (type == null || value == null) {
                    throw new ThreadCheckException("The <name> tag should have type and value attributes.");
                }
                if (type.getNodeValue().equalsIgnoreCase("only")) {
                    xmlAR.allowThreadNames.add(value.getNodeValue());
                    continue;
                }
                if (type.getNodeValue().equalsIgnoreCase("not")) {
                    xmlAR.denyThreadNames.add(value.getNodeValue());
                    continue;
                }
                throw new ThreadCheckException("The type attribute of the <name> tag should either be \"only\" or \"not\"");
            }
            if (element.getNodeName().equalsIgnoreCase("group")) {
                if (element.getAttributes().getLength() != 2) {
                    throw new ThreadCheckException("The <group> tag should have type and value attributes.");
                }
                type = element.getAttributes().getNamedItem("type");
                value = element.getAttributes().getNamedItem("value");
                if (type == null || value == null) {
                    throw new ThreadCheckException("The <group> tag should have type and value attributes.");
                }
                if (type.getNodeValue().equalsIgnoreCase("only")) {
                    xmlAR.allowThreadGroups.add(value.getNodeValue());
                    continue;
                }
                if (type.getNodeValue().equalsIgnoreCase("not")) {
                    xmlAR.denyThreadGroups.add(value.getNodeValue());
                    continue;
                }
                throw new ThreadCheckException("The type attribute of the <group> tag should either be \"only\" or \"not\"");
            }
            if (element.getNodeName().equalsIgnoreCase("id")) {
                if (element.getAttributes().getLength() != 2) {
                    throw new ThreadCheckException("The <id> tag should have type and value attributes.");
                }
                type = element.getAttributes().getNamedItem("type");
                value = element.getAttributes().getNamedItem("value");
                if (type == null || value == null) {
                    throw new ThreadCheckException("The <id> tag should have type and value attributes.");
                }
                if (type.getNodeValue().equalsIgnoreCase("only")) {
                    xmlAR.allowThreadIds.add(Long.valueOf(value.getNodeValue()));
                    continue;
                }
                if (type.getNodeValue().equalsIgnoreCase("not")) {
                    xmlAR.denyThreadIds.add(Long.valueOf(value.getNodeValue()));
                    continue;
                }
                throw new ThreadCheckException("The type attribute of the <id> tag should either be \"only\" or \"not\"");
            }
            if (element.getNodeName().equalsIgnoreCase("eventThread")) {
                if (element.getAttributes().getLength() != 1) {
                    throw new ThreadCheckException("The <eventThread> tag should only have a type attribute.");
                }
                type = element.getAttributes().getNamedItem("type");
                if (type == null) {
                    throw new ThreadCheckException("The <eventThread> tag should have a type attribute.");
                }
                String str = type.getNodeValue();
                if (str.equalsIgnoreCase("NO")) {
                    xmlAR.allowEventThread = OnlyRunBy.EVENT_THREAD.NO;
                    continue;
                }
                if (str.equalsIgnoreCase("ONLY")) {
                    xmlAR.allowEventThread = OnlyRunBy.EVENT_THREAD.ONLY;
                    continue;
                }
                if (str.equalsIgnoreCase("ONLY_AFTER_REALIZED")) {
                    xmlAR.allowEventThread = OnlyRunBy.EVENT_THREAD.ONLY_AFTER_REALIZED;
                    continue;
                }
                throw new ThreadCheckException("The type attribute of the <eventThread> tag should be an OnlyRunBy.EVENT_THREAD (was '" + str + "')");
            }
            if (element.getNodeName().equalsIgnoreCase("predicate")) {
                annot = this.extractAnnotation(element, element.getAttributes().getNamedItem("type"), true);
                par = this.processAnnotation(annot);
                if (par == null) continue;
                xmlAR.predicateAnnotations.add(par);
                n = element.getAttributes().getNamedItem("arguments");
                if (n == null || !n.getNodeValue().equalsIgnoreCase("true")) continue;
                par.passArguments = true;
                continue;
            }
            if (!element.getNodeName().equalsIgnoreCase("combine") || (par = this.processAnnotation(annot = this.extractAnnotation(element, element.getAttributes().getNamedItem("type"), true))) == null) continue;
            xmlAR.predicateAnnotations.add(par);
            n = element.getAttributes().getNamedItem("arguments");
            if (n == null || !n.getNodeValue().equalsIgnoreCase("true")) continue;
            par.passArguments = true;
        }
        return xmlAR;
    }

    private AAnnotationsAttributeInfo.Annotation extractAnnotation(Node element, Node annotType, boolean requireArrayDesc) {
        if (annotType == null) {
            throw new ThreadCheckException("The XML tag should have a type attribute.");
        }
        ASCIIPoolInfo annotTypeName = new ASCIIPoolInfo(annotType.getNodeValue(), null);
        ArrayList<AAnnotationsAttributeInfo.Annotation.NameValuePair> pairs = new ArrayList<AAnnotationsAttributeInfo.Annotation.NameValuePair>();
        for (int childIdx = 0; childIdx < element.getChildNodes().getLength(); ++childIdx) {
            Node childNode = element.getChildNodes().item(childIdx);
            if (!childNode.getNodeName().equals("arg")) continue;
            Node name = childNode.getAttributes().getNamedItem("name");
            if (name == null) {
                throw new ThreadCheckException("The <arg> tag should have a name attribute.");
            }
            ASCIIPoolInfo pairName = new ASCIIPoolInfo(name.getNodeValue(), null);
            AAnnotationsAttributeInfo.Annotation.AMemberValue mv = this.extractMemberValue(childNode, requireArrayDesc);
            pairs.add(new AAnnotationsAttributeInfo.Annotation.NameValuePair(pairName, mv));
        }
        return new AAnnotationsAttributeInfo.Annotation(annotTypeName, (short)pairs.size(), pairs.toArray(new AAnnotationsAttributeInfo.Annotation.NameValuePair[0]));
    }

    protected AAnnotationsAttributeInfo.Annotation.AMemberValue extractMemberValue(Node childNode, boolean requireArrayDesc) {
        AAnnotationsAttributeInfo.Annotation.AMemberValue mv;
        block21: {
            Node type = childNode.getAttributes().getNamedItem("type");
            if (type == null || type.getNodeValue().length() != 1) {
                throw new ThreadCheckException("The <arg> tag should have a single-character type attribute.");
            }
            Node value = childNode.getAttributes().getNamedItem("value");
            if (value == null) {
                throw new ThreadCheckException("The <arg> tag should have a value attribute.");
            }
            String nodeValue = value.getNodeValue();
            char tag = type.getNodeValue().charAt(0);
            try {
                if ("BCDFIJSZs".indexOf(tag) != -1) {
                    APoolInfo poolItem = null;
                    switch (tag) {
                        case 'B': 
                        case 'C': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            poolItem = new IntegerPoolInfo(Integer.valueOf(nodeValue), null);
                            break;
                        }
                        case 'J': {
                            poolItem = new LongPoolInfo(Long.valueOf(nodeValue), null);
                            break;
                        }
                        case 'F': {
                            poolItem = new FloatPoolInfo(Float.valueOf(nodeValue).floatValue(), null);
                            break;
                        }
                        case 'D': {
                            poolItem = new DoublePoolInfo(Double.valueOf(nodeValue), null);
                            break;
                        }
                        case 's': {
                            poolItem = new ASCIIPoolInfo(nodeValue, null);
                        }
                    }
                    mv = new AAnnotationsAttributeInfo.Annotation.ConstantMemberValue(tag, poolItem);
                    break block21;
                }
                if (tag == 'e') {
                    ASCIIPoolInfo typeName = new ASCIIPoolInfo(nodeValue.substring(0, nodeValue.indexOf(46)), null);
                    ASCIIPoolInfo constValue = new ASCIIPoolInfo(nodeValue.substring(nodeValue.indexOf(46) + 1), null);
                    mv = new AAnnotationsAttributeInfo.Annotation.EnumMemberValue(tag, typeName, constValue);
                    break block21;
                }
                if (tag == 'c') {
                    ASCIIPoolInfo className = new ASCIIPoolInfo(nodeValue, null);
                    mv = new AAnnotationsAttributeInfo.Annotation.ClassMemberValue(tag, className);
                    break block21;
                }
                if (tag == '@') {
                    AAnnotationsAttributeInfo.Annotation annotation = this.extractAnnotation(childNode, childNode.getAttributes().getNamedItem("value"), false);
                    mv = new AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue(tag, annotation);
                    break block21;
                }
                if (tag == '[') {
                    if (requireArrayDesc) {
                        Node desc = childNode.getAttributes().getNamedItem("desc");
                        if (desc == null) {
                            throw new ThreadCheckException("The <arg> tag should have a desc attribute \"[x\" if it is an array, where \"x\" stands for the type of the element (path=" + XMLConfig.getNodePath(childNode) + ").");
                        }
                        if (!desc.getNodeValue().startsWith("[") || desc.getNodeValue().length() < 2) {
                            throw new ThreadCheckException("The <arg> tag should have a desc attribute \"[x\" if it is an array, where \"x\" stands for the type of the element, was '" + desc.getNodeValue() + "' (path=" + XMLConfig.getNodePath(childNode) + ").");
                        }
                    }
                    AAnnotationsAttributeInfo.Annotation.AMemberValue[] array = new AAnnotationsAttributeInfo.Annotation.AMemberValue[Integer.valueOf(value.getNodeValue()).intValue()];
                    int nextIdx = 0;
                    for (int eltIdx = 0; eltIdx < childNode.getChildNodes().getLength(); ++eltIdx) {
                        Node eltNode = childNode.getChildNodes().item(eltIdx);
                        if (!eltNode.getNodeName().equals("element")) continue;
                        array[nextIdx] = this.extractMemberValue(eltNode, false);
                        ++nextIdx;
                    }
                    if (nextIdx != array.length) {
                        throw new ThreadCheckException("The <arg> tag had an incorrect number of <element> children for the array.");
                    }
                    mv = new AAnnotationsAttributeInfo.Annotation.ArrayMemberValue(tag, array.length, array);
                    break block21;
                }
                throw new ThreadCheckException("The <arg> tag had an unrecognized type attribute.");
            }
            catch (RuntimeException e) {
                throw new ThreadCheckException("The <arg> tag's value attribute was ill-formatted.", e);
            }
        }
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ThreadCheckAnnotationRecord getMethodAnnotations(ClassFile cf, MethodInfo mi) {
        HashSet<String> definedAbove;
        ThreadCheckAnnotationRecord methodAR;
        String key;
        block44: {
            ClassFile curcf;
            boolean found;
            key = cf.getThisClassName() + "::" + mi.getName().toString() + mi.getDescriptor().toString();
            ThreadCheckAnnotationRecord ca = this._sharedAddData.methodAnnotations.get(key);
            if (ca != null) {
                this._sharedAddData.cacheInfo.incMethodCacheHit();
                return ca;
            }
            this._sharedAddData.cacheInfo.incMethodCacheMiss();
            methodAR = new ThreadCheckAnnotationRecord();
            try {
                String path = "concutest/threadcheck/" + cf.getThisClassName().replace('.', '/').replace('$', '-') + "/class";
                List<Node> classNodes = this._sharedAddData.xmlAnnot.getNodes(path);
                if (classNodes.size() > 1) {
                    throw new ThreadCheckException("There may only be one <class> tag per class.");
                }
                if (classNodes.size() == 1) {
                    List<Node> methodNodes = this._sharedAddData.xmlAnnot.getNodes("method", classNodes.get(0));
                    for (Node mn : methodNodes) {
                        Node sig = mn.getAttributes().getNamedItem("sig");
                        if (sig == null) {
                            throw new ThreadCheckException("The <method> tag should have a sig attribute.");
                        }
                        if (!sig.getNodeValue().equals(mi.getName().toString() + mi.getDescriptor().toString())) continue;
                        try {
                            ThreadCheckAnnotationRecord xmlMethodAR = this.extractXMLAnnotations(mn);
                            Node suppress = mn.getAttributes().getNamedItem("suppress");
                            if (suppress != null && suppress.getNodeValue().equalsIgnoreCase("true")) {
                                xmlMethodAR.suppressSubtypingWarning = true;
                            }
                            methodAR.add(xmlMethodAR);
                        }
                        catch (ThreadCheckException e) {
                            throw new ThreadCheckException("Exception extracting XML annotations for path " + path + ".", e);
                        }
                    }
                }
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            Iterator<AAttributeInfo> i$ = mi.getAttributes().iterator();
            block23: while (true) {
                AAttributeInfo ai;
                if (i$.hasNext()) {
                    ai = i$.next();
                    if (!ai.getName().toString().equals(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()) && !ai.getName().toString().equals(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName())) continue;
                } else {
                    this.extractLists("L" + NotRunBy.class.getName(), mi.getAttributes(), methodAR.denyThreadNames, methodAR.denyThreadIds, methodAR.denyThreadGroups, null);
                    Ref<Object> allowEventThread = new Ref<Object>(null);
                    this.extractLists("L" + OnlyRunBy.class.getName(), mi.getAttributes(), methodAR.allowThreadNames, methodAR.allowThreadIds, methodAR.allowThreadGroups, allowEventThread);
                    methodAR.allowEventThread = allowEventThread.get() != null ? (OnlyRunBy.EVENT_THREAD)allowEventThread.get() : OnlyRunBy.EVENT_THREAD.NO;
                    this.extractPredicateSet(mi.getAttributes(), methodAR.predicateAnnotations, mi.getDescriptor().toString());
                    definedAbove = new HashSet<String>();
                    if (!cf.getSuperClassName().equals("")) {
                        found = false;
                        curcf = cf;
                        break;
                    }
                    break block44;
                }
                ASingleAnnotationsAttributeInfo aa = (ASingleAnnotationsAttributeInfo)ai;
                AAnnotationsAttributeInfo.Annotation[] arr$ = aa.getAnnotations();
                int len$ = arr$.length;
                int i$2 = 0;
                while (true) {
                    if (i$2 >= len$) continue block23;
                    AAnnotationsAttributeInfo.Annotation annot = arr$[i$2];
                    if (annot.getType().equals("L" + SuppressSubtypingWarning.class.getName().replace('.', '/') + ";")) {
                        methodAR.suppressSubtypingWarning = true;
                        continue block23;
                    }
                    ++i$2;
                }
                break;
            }
            while (!found && !curcf.getSuperClassName().equals("")) {
                ClassFileTools.ClassLocation cl = null;
                try {
                    cl = ClassFileTools.findClassFile(curcf.getSuperClassName(), this._sharedData.getClassPath());
                    if (cl != null) {
                        ClassFile scf = cl.getClassFile();
                        for (MethodInfo smi : scf.getMethods()) {
                            definedAbove.add(smi.getName().toString() + smi.getDescriptor().toString());
                            if (!smi.getName().toString().equals(mi.getName().toString()) || !smi.getDescriptor().toString().equals(mi.getDescriptor().toString())) continue;
                            ThreadCheckAnnotationRecord superClassMethodAR = this.getMethodAnnotations(scf, smi);
                            if (!methodAR.suppressSubtypingWarning) {
                                this.checkForSubtypingClassWarnings(cf, mi, scf, methodAR, superClassMethodAR);
                            }
                            methodAR.add(superClassMethodAR);
                            found = true;
                        }
                        if (found) continue;
                        curcf = scf;
                        continue;
                    }
                    this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(curcf.getSuperClassName(), this._sharedData.getCurrentClassName()));
                    break;
                }
                finally {
                    try {
                        if (cl == null) continue;
                        cl.close();
                    }
                    catch (IOException e) {}
                }
            }
            block27: for (ClassPoolInfo cpi : cf.getInterfaces()) {
                found = false;
                curcf = cf;
                String superName = cpi.getName().toString().replace('/', '.');
                while (!found && !superName.equals("")) {
                    ClassFileTools.ClassLocation cl = null;
                    try {
                        cl = ClassFileTools.findClassFile(superName, this._sharedData.getClassPath());
                        if (cl != null) {
                            ClassFile scf = cl.getClassFile();
                            for (MethodInfo smi : scf.getMethods()) {
                                definedAbove.add(smi.getName().toString() + smi.getDescriptor().toString());
                                if (!smi.getName().toString().equals(mi.getName().toString()) || !smi.getDescriptor().toString().equals(mi.getDescriptor().toString())) continue;
                                ThreadCheckAnnotationRecord interfClassMethodAR = this.getMethodAnnotations(scf, smi);
                                if (!methodAR.suppressSubtypingWarning) {
                                    this.checkForSubtypingClassWarnings(cf, mi, scf, methodAR, interfClassMethodAR);
                                }
                                methodAR.add(interfClassMethodAR);
                                found = true;
                            }
                            if (found) continue;
                            curcf = scf;
                            superName = scf.getSuperClassName();
                            continue;
                        }
                        this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(superName, this._sharedData.getCurrentClassName()));
                        continue block27;
                    }
                    finally {
                        try {
                            if (cl == null) continue;
                            cl.getInputStream().close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        if (!definedAbove.contains(mi.getName().toString() + mi.getDescriptor().toString())) {
            methodAR.add(this.getClassAnnotations(cf));
        }
        this._sharedAddData.methodAnnotations.put(key, methodAR);
        return methodAR;
    }

    protected void checkForSubtypingClassWarnings(ClassFile cf, MethodInfo mi, ClassFile scf, ThreadCheckAnnotationRecord classAR, ThreadCheckAnnotationRecord superClassAR) {
        String s;
        String s2;
        String methodName = null;
        String methodDesc = null;
        if (mi != null) {
            methodName = mi.getName().toString();
            methodDesc = mi.getDescriptor().toString();
        }
        for (String annot : classAR.denyThreadNames) {
            if (superClassAR.denyThreadNames.contains(annot)) continue;
            s2 = "@NotRunBy thread name '" + annot + "'";
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s2))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s2));
        }
        Iterator<Object> i$ = classAR.denyThreadIds.iterator();
        while (i$.hasNext()) {
            long annot = (Long)i$.next();
            if (superClassAR.denyThreadIds.contains(annot)) continue;
            s = "@NotRunBy thread name '" + annot + "'";
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s));
        }
        for (String annot : classAR.allowThreadGroups) {
            if (superClassAR.allowThreadGroups.contains(annot)) continue;
            s2 = "@OnlyRunBy thread group '" + annot + "'";
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s2))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s2));
        }
        for (String annot : classAR.allowThreadNames) {
            if (superClassAR.allowThreadNames.contains(annot)) continue;
            s2 = "@OnlyRunBy thread name '" + annot + "'";
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s2))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s2));
        }
        i$ = classAR.allowThreadIds.iterator();
        while (i$.hasNext()) {
            long annot = (Long)i$.next();
            if (superClassAR.allowThreadIds.contains(annot)) continue;
            s = "@OnlyRunBy thread id '" + annot + "'";
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s));
        }
        for (String annot : classAR.allowThreadGroups) {
            if (superClassAR.allowThreadGroups.contains(annot)) continue;
            s2 = "@OnlyRunBy thread group '" + annot + "'";
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s2))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s2));
        }
        if (classAR.allowEventThread.compareTo(superClassAR.allowEventThread) > 0) {
            String s3 = "@OnlyRunBy event thread " + classAR.allowEventThread.toString() + " (>" + superClassAR.allowEventThread.toString() + ")";
            if (!this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s3))) {
                this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s3));
            }
        }
        for (PredicateAnnotationRecord par : classAR.predicateAnnotations) {
            if (superClassAR.predicateAnnotations.contains(par)) continue;
            s2 = "Predicate annotation " + par.annotation;
            if (this._sharedAddData.subtypingWarnings.contains(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), null, null, s2))) continue;
            this._sharedAddData.subtypingWarnings.add(new SubtypingWarning(cf.getThisClassName(), scf.getThisClassName(), methodName, methodDesc, s2));
        }
    }

    public ThreadCheckDefinitionRecord extractXMLConcDef(XMLConfig xc, Node def) {
        int anum;
        List<String> attribs;
        int cnum;
        List<Node> invs = xc.getNodes("invariant", def);
        if (invs.size() != 1) {
            throw new ThreadCheckException("There must be exactly one invariant per definition, found " + invs.size() + " (path: " + "concutest/threadcheck:def/" + "invariant)");
        }
        Node inv = invs.get(0);
        List<Node> annots = xc.getNodes("*", inv);
        if (annots.size() != 1) {
            throw new ThreadCheckException("There must be exactly one annotation per invariant, found " + annots.size() + " (path: " + XMLConfig.getNodePath(annots.get(0)) + ")");
        }
        List<Node> classes = xc.getNodes("class", def);
        List<Node> methods = xc.getNodes("method", def);
        if (classes.size() + methods.size() <= 0) {
            throw new ThreadCheckException("There must be at least one class or method per definition, found " + classes.size() + " <class> and " + methods.size() + " <method> " + "(path: " + "concutest/threadcheck:def/" + ")");
        }
        List<Node> all = xc.getNodes("*", def);
        if (all.size() - invs.size() - classes.size() - methods.size() != 0) {
            throw new ThreadCheckException("There must be exactly one invariant and at least one class or method per definition, only <invariant>, <class> and <method> are allowed , found " + classes.size() + " <class> and " + methods.size() + " <method>, 1 <invariant>, but " + all.size() + " children (path: " + "concutest/threadcheck:def/" + ")");
        }
        ThreadCheckDefinitionRecord concDef = new ThreadCheckDefinitionRecord(this.extractXMLAnnotations(inv));
        for (Node target : classes) {
            cnum = xc.getNodes("*", target).size();
            if (cnum != 0) {
                throw new ThreadCheckException("A class node should have no child nodes, found " + cnum + " (path: " + "concutest/threadcheck:def/" + "class)");
            }
            attribs = xc.getMultiple(".*", target);
            anum = attribs.size();
            if (anum != 1) {
                throw new ThreadCheckException("There should be only a name attribute for a class node, found " + anum + " (path: " + "concutest/threadcheck:def/" + "class)");
            }
            if (xc.getMultiple(".name", target).size() != 1) {
                throw new ThreadCheckException("The name attribute is missing for the class node (path: concutest/threadcheck:def/class)");
            }
            concDef.addClass(xc.getMultiple(".name", target).get(0));
        }
        for (Node target : methods) {
            cnum = xc.getNodes("*", target).size();
            if (cnum != 0) {
                throw new ThreadCheckException("A method node should have no child nodes, there were " + cnum + " (path: " + "concutest/threadcheck:def/" + "method)");
            }
            attribs = xc.getMultiple(".*", target);
            anum = attribs.size();
            if (anum != 2) {
                throw new ThreadCheckException("There should be only a name and a sig attribute for a method node, found " + anum + " (path: " + "concutest/threadcheck:def/" + "method)");
            }
            if (xc.getMultiple(".name", target).size() != 1) {
                throw new ThreadCheckException("The name attribute is missing for the method node (path: concutest/threadcheck:def/method)");
            }
            if (xc.getMultiple(".sig", target).size() != 1) {
                throw new ThreadCheckException("The name attribute is missing for the method node (path: concutest/threadcheck:def/method)");
            }
            if (xc.getNodes(".suppress", target).size() > 1) {
                throw new ThreadCheckException("There should be at most one suppress atribute for the method node (path: concutest/threadcheck:def/method)");
            }
            boolean suppressSubtypingWarnings = xc.getNodes(".suppress", target).size() == 1;
            concDef.addMethod(xc.getMultiple(".name", target).get(0), xc.getMultiple(".sig", target).get(0), suppressSubtypingWarnings);
        }
        return concDef;
    }

    public static Set<ThreadCheckException> checkXMLConcDef(XMLConfig xc) {
        ArrayList<String> parameters = new ArrayList<String>();
        AThreadCheckStrategy.SharedData sharedData = new AThreadCheckStrategy.SharedData(parameters);
        AAddThreadCheckStrategy dummy = new AAddThreadCheckStrategy(sharedData, new SharedAddData(parameters, sharedData)){

            public void instrument(ClassFile cf) {
            }

            public void done() {
            }
        };
        HashSet<ThreadCheckException> tces = new HashSet<ThreadCheckException>();
        List<Node> defs = xc.getNodes("concutest/threadcheck:def/");
        for (Node def : defs) {
            try {
                dummy.extractXMLConcDef(xc, def);
            }
            catch (ThreadCheckException e) {
                tces.add(e);
            }
        }
        return tces;
    }

    @Override
    public void done() {
    }

    protected void insertCtorCall(ClassFile cf, MethodInfo mi, InstructionList il, String className, String ctorSig, AInstruction loadValue) {
        AUTFPoolInfo ctorClassName = new ASCIIPoolInfo(className, cf.getConstantPool());
        int[] l = cf.addConstantPoolItems(new APoolInfo[]{ctorClassName});
        ctorClassName = cf.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        ClassPoolInfo ctorClass = new ClassPoolInfo(ctorClassName, cf.getConstantPool());
        l = cf.addConstantPoolItems(new APoolInfo[]{ctorClass});
        ctorClass = cf.getConstantPoolItem(l[0]).execute(CheckClassVisitor.singleton(), null);
        AUTFPoolInfo ctorMethodType = new ASCIIPoolInfo(ctorSig, cf.getConstantPool());
        l = cf.addConstantPoolItems(new APoolInfo[]{ctorMethodType});
        ctorMethodType = cf.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        AUTFPoolInfo ctorMethodName = new ASCIIPoolInfo("<init>", cf.getConstantPool());
        l = cf.addConstantPoolItems(new APoolInfo[]{ctorMethodName});
        ctorMethodName = cf.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        NameAndTypePoolInfo ctorNat = new NameAndTypePoolInfo(ctorMethodName, ctorMethodType, cf.getConstantPool());
        l = cf.addConstantPoolItems(new APoolInfo[]{ctorNat});
        ctorNat = cf.getConstantPoolItem(l[0]).execute(CheckNameAndTypeVisitor.singleton(), null);
        MethodPoolInfo ctorMethod = new MethodPoolInfo(ctorClass, ctorNat, cf.getConstantPool());
        l = cf.addConstantPoolItems(new APoolInfo[]{ctorMethod});
        ctorMethod = cf.getConstantPoolItem(l[0]).execute(CheckMethodVisitor.singleton(), null);
        ReferenceInstruction newCall = new ReferenceInstruction(-69, cf.getConstantPool().indexOf(ctorClass));
        il.insertInstr(newCall, mi.getCodeAttributeInfo());
        boolean res = il.advanceIndex();
        assert (res);
        il.insertInstr(new GenericInstruction(89), mi.getCodeAttributeInfo());
        res = il.advanceIndex();
        assert (res);
        il.insertInstr(loadValue, mi.getCodeAttributeInfo());
        res = il.advanceIndex();
        assert (res);
        ReferenceInstruction ctorCall = new ReferenceInstruction(-73, l[0]);
        il.insertInstr(ctorCall, mi.getCodeAttributeInfo());
        res = il.advanceIndex();
        assert (res);
    }

    public static class OnlyAfterRealizedWarning
    implements IScannerStrategy.IScanResult {
        String msg;

        public OnlyAfterRealizedWarning(String msg) {
            this.msg = msg;
        }

        public String getPropertyName() {
            return "ThreadChecker ONLY_AFTER_REALIZED Warning";
        }

        public String toString() {
            return this.msg;
        }
    }

    public static class CacheInfo
    implements IScannerStrategy.IScanResult {
        long _classCacheHit = 0L;
        long _classCacheMiss = 0L;
        long _methodCacheHit = 0L;
        long _methodCacheMiss = 0L;
        long _combinePredicateCacheHit = 0L;
        long _combinePredicateCacheMiss = 0L;
        long _timeSpent = 0L;

        public void incClassCacheHit() {
            ++this._classCacheHit;
        }

        public void incClassCacheMiss() {
            ++this._classCacheMiss;
        }

        public void incMethodCacheHit() {
            ++this._methodCacheHit;
        }

        public void incMethodCacheMiss() {
            ++this._methodCacheMiss;
        }

        public void incCombinePredicateCacheHit() {
            ++this._combinePredicateCacheHit;
        }

        public void incCombinePredicateCacheMiss() {
            ++this._combinePredicateCacheMiss;
        }

        public void addTimeSpent(long t) {
            this._timeSpent += t;
        }

        public String getPropertyName() {
            return "ThreadChecker Cache Info";
        }

        public String toString() {
            return "Class cache " + this._classCacheHit + "/" + this._classCacheMiss + ", method cache " + this._methodCacheHit + "/" + this._methodCacheMiss + ", combined predicate cache " + this._combinePredicateCacheHit + "/" + this._combinePredicateCacheMiss + " (hits/misses), time spent = " + StringOps.toStringMillis(this._timeSpent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SharedAddData
    implements IScannerStrategy {
        protected SoftHashMap<String, ThreadCheckAnnotationRecord> classAnnotations = new SoftHashMap();
        protected SoftHashMap<String, ThreadCheckAnnotationRecord> methodAnnotations = new SoftHashMap();
        protected CacheInfo cacheInfo = new CacheInfo();
        protected HashSet<IScannerStrategy.IScanResult> otherWarnings = new HashSet();
        protected HashSet<SubtypingWarning> subtypingWarnings = new HashSet();
        protected XMLConfig xmlAnnot = new XMLConfig();

        public SoftHashMap<String, ThreadCheckAnnotationRecord> getClassAnnotations() {
            return this.classAnnotations;
        }

        public SoftHashMap<String, ThreadCheckAnnotationRecord> getMethodAnnotations() {
            return this.methodAnnotations;
        }

        public CacheInfo getCacheInfo() {
            return this.cacheInfo;
        }

        public HashSet<IScannerStrategy.IScanResult> getOtherWarnings() {
            return this.otherWarnings;
        }

        public HashSet<SubtypingWarning> getSubtypingWarnings() {
            return this.subtypingWarnings;
        }

        public XMLConfig getXmlAnnot() {
            return this.xmlAnnot;
        }

        public SharedAddData(List<String> parameters, AThreadCheckStrategy.SharedData sharedData) {
            String[] fns;
            XMLAnnotUtils.ConcurrentyDefinitions concDefs = new XMLAnnotUtils.ConcurrentyDefinitions();
            if (sharedData.getXmlFileName() != null && (fns = sharedData.getXmlFileName().split(System.getProperty("path.separator"))).length > 0) {
                Debug.out.println("Using XML annotations/concurrency definitions:");
                for (int i = 0; i < fns.length; ++i) {
                    XMLConfig xc = new XMLConfig(fns[i]);
                    XMLAnnotUtils.joinXMLConcDefs(xc, concDefs);
                    Debug.out.println("\t" + fns[i]);
                }
            }
            this.xmlAnnot = XMLAnnotUtils.convertConcDefsToClassBasedXML(concDefs);
            for (String p : parameters) {
                if (!p.toLowerCase().startsWith(AAddThreadCheckStrategy.XML_ANNOT_SAVE_MERGED_PREFIX)) continue;
                Debug.out.println("Saving merged XML file:");
                String xmlMergeFileName = p.substring(AAddThreadCheckStrategy.XML_ANNOT_SAVE_MERGED_PREFIX.length());
                this.xmlAnnot.save(xmlMergeFileName);
                Debug.out.println("\t" + xmlMergeFileName);
            }
        }

        @Override
        public void instrument(ClassFile cf) {
        }

        @Override
        public List<? extends IScannerStrategy.IScanResult> getScanResults() {
            ArrayList<SubtypingWarning> stlist = new ArrayList<SubtypingWarning>(this.subtypingWarnings);
            Collections.sort(stlist);
            ArrayList<SubtypingWarning> list = new ArrayList<SubtypingWarning>(stlist);
            list.addAll(this.otherWarnings);
            list.add((SubtypingWarning)((Object)this.cacheInfo));
            return list;
        }

        @Override
        public void done() {
        }
    }
}

