/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.record;

import edu.rice.cs.cunit.SyncPointBuffer;
import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.instrumentors.record.CompactRecordBufferCodeStrategy;
import edu.rice.cs.cunit.util.IPredicate;

public class CompactRecordThreadExitStrategy
extends CompactRecordBufferCodeStrategy {
    public CompactRecordThreadExitStrategy() {
        super(new IPredicate<ClassFile>(){

            @Override
            public Boolean apply(ClassFile param) {
                return param.getThisClassName().equals("java.lang.Thread");
            }
        }, new IPredicate.Binary<ClassFile, MethodInfo>(){

            @Override
            public Boolean apply(ClassFile cf, MethodInfo param) {
                return param.getName().toString().equals("exit");
            }
        }, new IPredicate.Ternary<ClassFile, MethodInfo, InstructionList>(){

            @Override
            public Boolean apply(ClassFile cf, MethodInfo mi, InstructionList il) {
                return Opcode.isReturn(il.getOpcode());
            }
        }, SyncPointBuffer.SP.THREADEXIT.intValue());
    }

    public boolean insertEndOfMethod(ClassFile cf, MethodInfo mi, InstructionList il, boolean insertBefore, boolean insertAfter) {
        int exceptionEndPC = il.getPCFromIndex(il.getIndex() - 1);
        int exceptionHandlerPC = il.getPCFromIndex(il.getIndex());
        this.insertInstructionsBefore(cf, mi, il);
        CodeAttributeInfo codeAttr = mi.getCodeAttributeInfo();
        il.insertInstr(new GenericInstruction(-65), codeAttr);
        boolean result = il.advanceIndex();
        assert (result);
        CodeAttributeInfo.ExceptionTableEntry[] excTable = new CodeAttributeInfo.ExceptionTableEntry[codeAttr.getExceptionTableEntries().length + 1];
        System.arraycopy(codeAttr.getExceptionTableEntries(), 0, excTable, 0, codeAttr.getExceptionTableEntries().length);
        excTable[excTable.length - 1] = new CodeAttributeInfo.ExceptionTableEntry(0, exceptionEndPC, exceptionHandlerPC, 0);
        codeAttr.setExceptionTableEntries(excTable);
        return true;
    }
}

