/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.DoublePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.FloatPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.IntegerPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.LongPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.StringPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantValueAttributeInfo
extends AAttributeInfo {
    public ConstantValueAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public APoolInfo getConstantValue() throws ClassFormatError {
        return ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 0))).execute(new ADefaultPoolInfoVisitor<APoolInfo, Object>(){

            @Override
            public APoolInfo defaultCase(APoolInfo host, Object o) {
                throw new ClassFormatError("Variable type item expected for ConstantValue attribute.");
            }

            @Override
            public APoolInfo stringCase(StringPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo intCase(IntegerPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo floatCase(FloatPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo longCase(LongPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo doubleCase(DoublePoolInfo host, Object o) {
                return host;
            }
        }, null);
    }

    public void setConstantValue(APoolInfo newConst) throws IllegalArgumentException {
        Types.bytesFromShort(this._constantPool.indexOf(newConst.execute(new ADefaultPoolInfoVisitor<APoolInfo, Object>(){

            @Override
            public APoolInfo defaultCase(APoolInfo host, Object o) {
                throw new IllegalArgumentException("Variable type item expected for ConstantValue attribute.");
            }

            @Override
            public APoolInfo stringCase(StringPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo intCase(IntegerPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo floatCase(FloatPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo longCase(LongPoolInfo host, Object o) {
                return host;
            }

            @Override
            public APoolInfo doubleCase(DoublePoolInfo host, Object o) {
                return host;
            }
        }, null)), this._data, 0);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.constantValueCase(this, param);
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "ConstantValue";
    }
}

