/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AnnotationDefaultAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.ConstantValueAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.DeprecatedAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.EnclosingMethodAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.ExceptionsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.InnerClassesAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.InstrumentationAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.LineNumberTableAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.LocalVariableTableAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.LocalVariableTypeTableAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleLocalVariableAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleParameterAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeVisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeVisibleLocalVariableAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeVisibleParameterAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.SignatureAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.SourceFileAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.SyntheticAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.UnknownAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AAttributeInfo
implements Cloneable {
    protected AUTFPoolInfo _name;
    protected byte[] _data;
    protected ConstantPool _constantPool;
    private static Class<AAttributeInfo>[] _knownAttributes = new Class[]{SourceFileAttributeInfo.class, ConstantValueAttributeInfo.class, CodeAttributeInfo.class, ExceptionsAttributeInfo.class, LineNumberTableAttributeInfo.class, LocalVariableTableAttributeInfo.class, LocalVariableTypeTableAttributeInfo.class, SignatureAttributeInfo.class, DeprecatedAttributeInfo.class, SyntheticAttributeInfo.class, EnclosingMethodAttributeInfo.class, AnnotationDefaultAttributeInfo.class, RuntimeInvisibleAnnotationsAttributeInfo.class, RuntimeVisibleAnnotationsAttributeInfo.class, RuntimeInvisibleParameterAnnotationsAttributeInfo.class, RuntimeVisibleParameterAnnotationsAttributeInfo.class, InnerClassesAttributeInfo.class, InstrumentationAttributeInfo.class, RuntimeInvisibleLocalVariableAnnotationsAttributeInfo.class, RuntimeVisibleLocalVariableAnnotationsAttributeInfo.class};

    public static AAttributeInfo read(DataInputStream di, ConstantPool pool) throws IOException, ClassFormatError {
        int bytesRead;
        AUTFPoolInfo name = ((APoolInfo)pool.get(di.readShort())).execute(CheckUTFVisitor.singleton(), null);
        String attrName = name.toString();
        int len = di.readInt();
        byte[] data = new byte[len];
        for (int offset = 0; offset < data.length && (bytesRead = di.read(data, offset, data.length - offset)) != -1; offset += bytesRead) {
        }
        if (len != data.length && (len != -1 || data.length != 0)) {
            throw new ClassFormatError("Attribute data of " + attrName + " has wrong length, actual=" + data.length + ", expected=" + len);
        }
        for (Class<AAttributeInfo> c : _knownAttributes) {
            try {
                Method m = c.getMethod("getAttributeName", new Class[0]);
                String knownName = (String)m.invoke(null, new Object[0]);
                if (!knownName.equals(name.toString())) continue;
                Constructor<AAttributeInfo> ctor = c.getConstructor(AUTFPoolInfo.class, byte[].class, ConstantPool.class);
                return ctor.newInstance(name, data, pool);
            }
            catch (NoSuchMethodException e) {
                throw new Error("Error creating attribute info", e);
            }
            catch (IllegalAccessException e) {
                throw new Error("Error creating attribute info", e);
            }
            catch (InvocationTargetException e) {
                throw new Error("Error creating attribute info", e);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return new UnknownAttributeInfo(name, data, pool);
    }

    public AAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) {
        this._name = name;
        this._data = data;
        this._constantPool = cp;
    }

    public AUTFPoolInfo getName() {
        return this._name;
    }

    public void setName(AUTFPoolInfo name) {
        this._name = name;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this._constantPool.indexOf(this._name));
        dos.writeInt(this._data.length);
        dos.write(this._data, 0, this._data.length);
    }

    public String toString() {
        String hexChars = "0123456789abcdef";
        StringBuilder sb = new StringBuilder();
        sb.append(this._name);
        sb.append(" <");
        sb.append(this._data.length);
        sb.append(" bytes:");
        for (byte b : this._data) {
            sb.append(" ");
            sb.append("0123456789abcdef".charAt(b >>> 4 & 0xF));
            sb.append("0123456789abcdef".charAt(b & 0xF));
        }
        sb.append(">");
        return sb.toString();
    }

    public abstract <R, D> R execute(IAttributeVisitor<R, D> var1, D var2);

    public abstract void adjustPC(int var1, int var2);

    public abstract void translatePC(int var1, int var2, LineNumberTable var3, LineNumberTable var4);

    public Object clone() throws CloneNotSupportedException {
        AAttributeInfo a = (AAttributeInfo)super.clone();
        a._data = new byte[this._data.length];
        System.arraycopy(this._data, 0, a._data, 0, this._data.length);
        return a;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AAttributeInfo that = (AAttributeInfo)o;
        if (this._constantPool != null ? !this._constantPool.equals(that._constantPool) : that._constantPool != null) {
            return false;
        }
        if (!Arrays.equals(this._data, that._data)) {
            return false;
        }
        return !(this._name != null ? !this._name.equals(that._name) : that._name != null);
    }

    public int hashCode() {
        int result = this._name != null ? this._name.hashCode() : 0;
        result = 31 * result + (this._data != null ? Arrays.hashCode(this._data) : 0);
        result = 31 * result + (this._constantPool != null ? this._constantPool.hashCode() : 0);
        return result;
    }
}

