/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.InstrumentationAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.CompoundCompactRecordStrategy;
import edu.rice.cs.cunit.instrumentors.CompoundCompactSystemStrategy;
import edu.rice.cs.cunit.instrumentors.CouldNotDeleteAndRenameException;
import edu.rice.cs.cunit.instrumentors.CouldNotDoubleRenameException;
import edu.rice.cs.cunit.instrumentors.CouldNotRenameException;
import edu.rice.cs.cunit.instrumentors.DoNotInstrument;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.instrumentors.RetryIOException;
import edu.rice.cs.cunit.instrumentors.util.IScannerStrategy;
import edu.rice.cs.cunit.util.Debug;
import edu.rice.cs.cunit.util.FileOps;
import edu.rice.cs.cunit.util.ILambda;
import edu.rice.cs.cunit.util.StringOps;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInstrumentor {
    protected ArrayList<IInstrumentationStrategy> _instrumentors = new ArrayList();
    public static final String INSTRUMENTOR_PACKAGE_PREFIX = "edu.rice.cs.cunit.instrumentors.";
    protected static FileOutputStream _debugOut;
    protected static boolean _addAnnotationAttribute;
    protected static boolean _forceInstrumentation;
    protected static String _defaultDestRtJarName;
    protected static String _defaultCunitRtJarName;
    protected static String _defaultInstrumentorName;
    protected static String _defaultSystemInstrumentorName;

    public List<IInstrumentationStrategy> getInstrumentors() {
        return this._instrumentors;
    }

    public FileInstrumentor(IInstrumentationStrategy[] instrumentors) {
        for (IInstrumentationStrategy itor : instrumentors) {
            this._instrumentors.add(itor);
        }
    }

    public void done() {
        for (IInstrumentationStrategy itor : this._instrumentors) {
            itor.done();
        }
    }

    public boolean instrumentStream(InputStream is, OutputStream os) throws IOException, ClassFormatError {
        int bytesRead;
        ClassFile cf = null;
        byte[] b = new byte[is.available()];
        for (int offset = 0; offset < b.length && -1 != (bytesRead = is.read(b, offset, b.length - offset)); offset += bytesRead) {
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean doInstrument = false;
        try {
            cf = new ClassFile(new ByteArrayInputStream(b));
            boolean bl = doInstrument = _forceInstrumentation || cf.getAttribute("edu.rice.cs.cunit.Instrumentation") == null;
            if (doInstrument) {
                String[] doNotInstrumentPatterns = new String[]{};
                AAttributeInfo attr = cf.getAttribute(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName());
                if (null != attr) {
                    RuntimeInvisibleAnnotationsAttributeInfo ann = (RuntimeInvisibleAnnotationsAttributeInfo)attr;
                    block3: for (AAnnotationsAttributeInfo.Annotation a : ann.getAnnotations()) {
                        String typeString = ClassFileTools.getTypeString(a.getType(), "");
                        if (!typeString.substring(0, typeString.length() - 1).equals(DoNotInstrument.class.getName())) continue;
                        for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : a.getPairs()) {
                            if (!nvp.getName().toString().equals("instrumentors")) continue;
                            AAnnotationsAttributeInfo.Annotation.ConstantMemberValue c = nvp.getValue().execute(AAnnotationsAttributeInfo.Annotation.CheckConstantMemberVisitor.singleton(), null);
                            AUTFPoolInfo patternString = c.getConstValue().execute(CheckUTFVisitor.singleton(), null);
                            doNotInstrumentPatterns = patternString.toString().split(";");
                            break block3;
                        }
                        break;
                    }
                }
                ArrayList<IInstrumentationStrategy> appliedInstrumentors = new ArrayList<IInstrumentationStrategy>();
                for (IInstrumentationStrategy itor : this._instrumentors) {
                    if (!ClassFileTools.classNameMatches(itor.getClass().getName(), doNotInstrumentPatterns)) {
                        itor.instrument(cf);
                        appliedInstrumentors.add(itor);
                        continue;
                    }
                    Debug.out.println("Class " + cf.getThisClassName() + " not instrumented with " + itor.getClass().getName() + " because it matched @DoNotInstrument instrumentors");
                }
                if (_addAnnotationAttribute) {
                    InstrumentationAttributeInfo.addInstrumentationAttributeInfo(cf, appliedInstrumentors);
                }
            }
            Debug.out.endDot();
            cf.write(bos);
        }
        catch (ClassFormatError cfe) {
            cfe.printStackTrace(Debug.out);
            Debug.out.println("Copying unmodified class file.");
            bos.write(b, 0, b.length);
        }
        os.write(bos.toByteArray());
        return doInstrument;
    }

    public boolean instrumentFile(String inName, String outName) throws IOException, ClassFormatError {
        FileInputStream fis = new FileInputStream(inName);
        FileOutputStream fos = new FileOutputStream(outName);
        boolean wasInstrumented = this.instrumentStream(fis, fos);
        fis.close();
        fos.close();
        return wasInstrumented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instrumentJarStream(String inJarName, JarOutputStream jos, List<String> filters) throws IOException, ClassFormatError {
        JarFile jf = null;
        try {
            jf = new JarFile(inJarName);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                Debug.out.print(e.getName());
                boolean matches = true;
                if (filters.size() > 0) {
                    matches = false;
                    for (String f : filters) {
                        String rest;
                        if (!e.getName().startsWith(f) || (rest = e.getName().substring(f.length())).indexOf(47) >= 0) continue;
                        matches = true;
                        break;
                    }
                }
                if (matches && !"META-INF/MANIFEST.MF".equals(e.getName())) {
                    InputStream is = null;
                    try {
                        is = jf.getInputStream(e);
                        try {
                            jos.putNextEntry(new JarEntry(e.getName()));
                            if (e.getName().endsWith(".class")) {
                                if (this.instrumentStream(is, jos)) {
                                    Debug.out.print(" <instrumented>");
                                } else {
                                    Debug.out.print(" <skipped: attribute/annotation>");
                                }
                            } else {
                                int bytesRead;
                                byte[] buffer = new byte[1024];
                                while (-1 != (bytesRead = is.read(buffer))) {
                                    jos.write(buffer, 0, bytesRead);
                                }
                            }
                        }
                        catch (ZipException zipExc) {
                            if (!zipExc.getMessage().startsWith("duplicate entry:")) {
                                throw zipExc;
                            }
                            Debug.out.print(" <duplicate>");
                        }
                        Debug.out.println();
                        continue;
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                        continue;
                    }
                }
                if (!matches) {
                    Debug.out.println(" <skipped: no filter matched>");
                    continue;
                }
                Debug.out.println(" <skipped>");
            }
        }
        finally {
            if (jf != null) {
                jf.close();
            }
        }
    }

    public void instrumentJar(String inJarName, String outJarName) throws IOException, ClassFormatError {
        JarFile jf = null;
        FileOutputStream fos = null;
        ZipOutputStream jos = null;
        try {
            jf = new JarFile(inJarName);
            fos = new FileOutputStream(outJarName);
            Manifest manif = jf.getManifest();
            jos = manif != null ? new JarOutputStream((OutputStream)fos, manif) : new JarOutputStream(fos);
            this.instrumentJarStream(inJarName, (JarOutputStream)jos, new ArrayList<String>());
        }
        catch (IOException ioe) {
            IOException n = new IOException("Error instrumenting jar file " + inJarName + " to " + outJarName);
            n.initCause(ioe);
            throw n;
        }
        catch (ClassFormatError cfe) {
            ClassFormatError n = new ClassFormatError("Error instrumenting jar file " + inJarName + " to " + outJarName);
            n.initCause(cfe);
            throw n;
        }
        finally {
            if (jf != null) {
                jf.close();
            }
            if (jos != null) {
                jos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void addClassJarStream(String inFileName, String outFileName, JarOutputStream jos, boolean markAsInstrumented) throws IOException {
        jos.putNextEntry(new JarEntry(outFileName));
        FileInputStream fis = new FileInputStream(inFileName);
        if (markAsInstrumented && _addAnnotationAttribute) {
            try {
                ClassFile cf = new ClassFile(fis);
                InstrumentationAttributeInfo.addInstrumentationAttributeInfo(cf, "");
                cf.write(jos);
            }
            catch (ClassFormatError cfe) {
                int bytesRead;
                cfe.printStackTrace(Debug.out);
                Debug.out.println("Copying unmodified class file.");
                byte[] buffer = new byte[1024];
                while (-1 != (bytesRead = fis.read(buffer))) {
                    jos.write(buffer, 0, bytesRead);
                }
            }
        } else {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while (-1 != (bytesRead = fis.read(buffer))) {
                jos.write(buffer, 0, bytesRead);
            }
        }
        fis.close();
    }

    public void addJarStream(String inJarName, JarOutputStream jos, boolean markAsInstrumented) throws IOException, ClassFormatError {
        JarFile jf = new JarFile(inJarName);
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            InputStream is;
            block9: {
                JarEntry e = entries.nextElement();
                Debug.out.print(e.getName());
                if ("META-INF/MANIFEST.MF".equals(e.getName())) continue;
                is = jf.getInputStream(e);
                try {
                    int bytesRead;
                    jos.putNextEntry(new JarEntry(e.getName()));
                    if (markAsInstrumented && e.getName().toLowerCase().endsWith(".class") && _addAnnotationAttribute) {
                        try {
                            ClassFile cf = new ClassFile(is);
                            InstrumentationAttributeInfo.addInstrumentationAttributeInfo(cf, "");
                            cf.write(jos);
                            break block9;
                        }
                        catch (ClassFormatError cfe) {
                            int bytesRead2;
                            cfe.printStackTrace(Debug.out);
                            Debug.out.println("Copying unmodified class file.");
                            byte[] buffer = new byte[1024];
                            while (-1 != (bytesRead2 = is.read(buffer))) {
                                jos.write(buffer, 0, bytesRead2);
                            }
                            break block9;
                        }
                    }
                    byte[] buffer = new byte[1024];
                    while (-1 != (bytesRead = is.read(buffer))) {
                        jos.write(buffer, 0, bytesRead);
                    }
                }
                catch (ZipException zipExc) {
                    if (!zipExc.getMessage().startsWith("duplicate entry:")) {
                        throw zipExc;
                    }
                    Debug.out.print(" <duplicate>");
                }
            }
            Debug.out.println();
            is.close();
        }
        jf.close();
    }

    public static String getDefaultSystemInstrumentorName() {
        return _defaultSystemInstrumentorName;
    }

    public static void setDefaultSystemInstrumentorName(String defaultSystemInstrumentorName) {
        _defaultSystemInstrumentorName = defaultSystemInstrumentorName;
    }

    public static String getDefaultInstrumentorName() {
        return _defaultInstrumentorName;
    }

    public static void setDefaultInstrumentorName(String defaultInstrumentorName) {
        _defaultInstrumentorName = defaultInstrumentorName;
    }

    public static String getDefaultDestRtJarName() {
        return _defaultDestRtJarName;
    }

    public static void setDefaultDestRtJarName(String defaultDestRtJarName) {
        _defaultDestRtJarName = defaultDestRtJarName;
    }

    public static String getDefaultCunitRtJarName() {
        return _defaultCunitRtJarName;
    }

    public static void setDefaultCunitRtJarName(String defaultCunitRtJarName) {
        _defaultCunitRtJarName = defaultCunitRtJarName;
    }

    public static String getDefaultSourceRtJarName() {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String p = System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator;
            return p + "classes.jar" + File.pathSeparator + p + "ui.jar";
        }
        return System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar";
    }

    private static void instrumentList(boolean createBackups, boolean recurse, FileInstrumentor fi, HashMap<String, File> tempDirMap, ILambda.Binary<Void, String, IOException> exceptionAction, String ... names) throws IOException {
        for (String name : names) {
            try {
                Debug.out.print(name);
                File f = new File(name);
                boolean cb = createBackups;
                if (cb) {
                    for (File tempDir : tempDirMap.values()) {
                        if (!FileOps.isContainedIn(f, tempDir)) continue;
                        cb = false;
                        break;
                    }
                }
                if (f.isDirectory()) {
                    if (recurse) {
                        Debug.out.println(" <directory>");
                        File[] files = f.listFiles();
                        HashSet<String> fileNames = new HashSet<String>();
                        for (File file : files) {
                            fileNames.add(file.getPath());
                        }
                        FileInstrumentor.instrumentList(cb, recurse, fi, tempDirMap, exceptionAction, fileNames.toArray(new String[0]));
                        continue;
                    }
                    Debug.out.println(" <skipped: not recursing into directory>");
                    continue;
                }
                if (name.endsWith(".class")) {
                    boolean wasInstrumented;
                    Debug.out.print(" <class>");
                    if (cb) {
                        wasInstrumented = FileInstrumentor.instrumentAndRename(name, fi);
                    } else {
                        String n = name.replace(".class", "_i.class");
                        wasInstrumented = fi.instrumentFile(name, n);
                        if (!new File(name).delete() || !new File(n).renameTo(new File(name))) {
                            throw new CouldNotDeleteAndRenameException(new File(name), new File(n));
                        }
                    }
                    if (wasInstrumented) {
                        Debug.out.println(" <instrumented>");
                        continue;
                    }
                    Debug.out.println(" <skipped>");
                    continue;
                }
                if (name.endsWith(".jar")) {
                    Debug.out.println(" <jar>");
                    if (cb) {
                        FileInstrumentor.instrumentAndRenameJar(name, fi);
                        continue;
                    }
                    String n = name.replace(".jar", "_i.jar");
                    fi.instrumentJar(name, n);
                    if (new File(name).delete() && new File(n).renameTo(new File(name))) continue;
                    throw new CouldNotDeleteAndRenameException(new File(name), new File(n));
                }
                Debug.out.println(" <skipped: unknown file type>");
            }
            catch (IOException e) {
                if (exceptionAction != null) {
                    exceptionAction.apply(name, e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean instrumentAndRename(String classFileName, FileInstrumentor fi) throws IOException {
        String newFileName = classFileName.replace(".class", "_i.class");
        boolean wasInstrumented = fi.instrumentFile(classFileName, newFileName);
        if (wasInstrumented) {
            String oldFileName = classFileName.replace(".class", ".class~");
            if (!new File(classFileName).renameTo(new File(oldFileName))) {
                throw new CouldNotDoubleRenameException(new File(classFileName), new File(oldFileName), new File(newFileName));
            }
            if (!new File(newFileName).renameTo(new File(classFileName))) {
                throw new CouldNotRenameException(new File(newFileName), new File(classFileName));
            }
        }
        return wasInstrumented;
    }

    private static void instrumentAndRenameJar(String jarFileName, FileInstrumentor fi) throws IOException {
        String instrFileName = jarFileName.replace(".jar", "_i.jar");
        fi.instrumentJar(jarFileName, instrFileName);
        String oldFileName = jarFileName.replace(".jar", ".jar~");
        if (!new File(jarFileName).renameTo(new File(oldFileName))) {
            throw new CouldNotDoubleRenameException(new File(jarFileName), new File(oldFileName), new File(instrFileName));
        }
        if (!new File(instrFileName).renameTo(new File(jarFileName))) {
            throw new CouldNotRenameException(new File(instrFileName), new File(jarFileName));
        }
    }

    private static void instrumentRTJar(String sourceRtJarName, String destRtJarName, String cunitRtJarName, List<String> cunitFilters, FileInstrumentor fi, FileInstrumentor fiSystem) throws IOException {
        FileOutputStream fos = new FileOutputStream(destRtJarName);
        ZipOutputStream jos = null;
        String[] paths = FileOps.splitPaths(sourceRtJarName, File.pathSeparatorChar);
        String[] bootClassPaths = FileOps.splitPaths(System.getProperty("sun.boot.class.path"), File.pathSeparatorChar);
        HashSet<File> bootClassPathFiles = new HashSet<File>();
        for (String p : bootClassPaths) {
            File f = new File(p);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            bootClassPathFiles.add(f);
        }
        HashSet<File> inputFiles = new HashSet<File>();
        for (String p : paths) {
            File f = new File(p);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputFiles.add(f);
        }
        inputFiles.retainAll(bootClassPathFiles);
        boolean instrumentingCurrentJavaVersion = !inputFiles.isEmpty();
        File cunitRtJarFile = new File(cunitRtJarName);
        for (String p : paths) {
            Debug.out.println("Instrumenting " + p);
            JarFile jf = new JarFile(p);
            if (jos == null) {
                Manifest manif = jf.getManifest();
                if (instrumentingCurrentJavaVersion) {
                    manif.getMainAttributes().put(new Attributes.Name("Edu-Rice-Cs-CUnit-JavaVersion-Vendor"), JavaVersion.CURRENT_FULL.vendor().toString());
                    manif.getMainAttributes().put(new Attributes.Name("Edu-Rice-Cs-CUnit-JavaVersion"), JavaVersion.CURRENT_FULL.toString());
                    manif.getMainAttributes().put(new Attributes.Name("Edu-Rice-Cs-CUnit-CUnitRuntimeJar"), cunitRtJarFile.getName() + "/" + cunitRtJarFile.length());
                }
                jos = new JarOutputStream((OutputStream)fos, manif);
            }
            fi.instrumentJarStream(p, (JarOutputStream)jos, new ArrayList<String>());
            jf.close();
        }
        Debug.out.println("Instrumenting " + cunitRtJarName);
        fiSystem.instrumentJarStream(cunitRtJarName, (JarOutputStream)jos, cunitFilters);
        if (jos != null) {
            jos.close();
        }
        fos.close();
    }

    public static void main(String[] args) {
        new Tool().run(args);
    }

    static {
        _addAnnotationAttribute = true;
        _forceInstrumentation = false;
        _defaultDestRtJarName = "rt_i.jar";
        _defaultCunitRtJarName = "cunitrt.jar";
        _defaultInstrumentorName = CompoundCompactRecordStrategy.class.getName();
        _defaultSystemInstrumentorName = CompoundCompactSystemStrategy.class.getName();
    }

    public static class Tool {
        protected Date _startDate;
        protected boolean _createBackups = true;
        protected boolean _unpackJars = false;
        protected boolean _instrumentRt = false;
        protected String _cunitRtJarName = FileInstrumentor.getDefaultCunitRtJarName();
        protected List<String> _cunitFilters = new ArrayList<String>();
        protected String _destRtJarName = FileInstrumentor.getDefaultDestRtJarName();
        protected String _sourceRtJarName = FileInstrumentor.getDefaultSourceRtJarName();
        protected String _instrumentorClassName = FileInstrumentor.getDefaultInstrumentorName();
        protected String _sysInstrumentorClassName = FileInstrumentor.getDefaultSystemInstrumentorName();
        protected List<String> _parameters = new ArrayList<String>();

        public void run(String[] args) {
            Class<?> c;
            this._startDate = new Date();
            Debug.out.setDebug(true);
            int argIndex = this.checkArgs(args);
            Debug.out.println("Start time = " + this._startDate);
            HashSet<String> fileNames = new HashSet<String>();
            for (int i = argIndex; i < args.length; ++i) {
                if (fileNames.contains(args[i])) {
                    Debug.out.println("Duplicate input file: " + args[i]);
                }
                fileNames.add(args[i]);
            }
            String[] names = fileNames.toArray(new String[0]);
            HashMap<String, File> tempDirMap = new HashMap<String, File>();
            if (this._unpackJars) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    File f = new File(name);
                    if (!f.isFile() || !name.endsWith(".jar")) continue;
                    File tempDir = null;
                    try {
                        tempDir = FileOps.createTempDirectory("cunitfi", null);
                        Debug.out.println("Unpacking jar " + name + " to " + tempDir.getPath());
                        long unpackCount = FileOps.unpackJar(f, tempDir);
                        Debug.out.println("\t" + unpackCount + " files unpacked");
                        tempDirMap.put(name, tempDir);
                        names[i] = tempDir.getPath();
                        continue;
                    }
                    catch (IOException ioe) {
                        Debug.out.println("Error: Could not unpack jar " + name + " to " + tempDir);
                        tempDirMap.remove(name);
                        names[i] = args[argIndex + i];
                    }
                }
                for (int paramIndex = 0; paramIndex < this._parameters.size(); ++paramIndex) {
                    String p = this._parameters.get(paramIndex);
                    if (!p.startsWith("class-path=")) continue;
                    String cp = p.substring("class-path=".length());
                    String[] paths = cp.split(System.getProperty("path.separator"));
                    StringBuilder sb = new StringBuilder();
                    sb.append("class-path=");
                    boolean first = true;
                    for (String path : paths) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(System.getProperty("path.separator"));
                        }
                        File tempDir = (File)tempDirMap.get(path);
                        if (tempDir != null) {
                            sb.append(tempDir.getPath());
                            continue;
                        }
                        sb.append(path);
                    }
                    this._parameters.set(paramIndex, sb.toString());
                }
            }
            FileInstrumentor fi = null;
            try {
                Class<?> c2 = Class.forName(this._instrumentorClassName);
                fi = new FileInstrumentor(new IInstrumentationStrategy[]{(IInstrumentationStrategy)c2.getConstructor(List.class).newInstance(this._parameters)});
            }
            catch (NoSuchMethodException e) {
                try {
                    c = Class.forName(this._instrumentorClassName);
                    fi = new FileInstrumentor(new IInstrumentationStrategy[]{(IInstrumentationStrategy)c.getConstructor(new Class[0]).newInstance(new Object[0])});
                }
                catch (Throwable e2) {
                    e2.printStackTrace(Debug.out);
                    System.exit(1);
                }
            }
            catch (Throwable e2) {
                e2.printStackTrace(Debug.out);
                System.exit(1);
            }
            FileInstrumentor fiSystem = null;
            try {
                c = Class.forName(this._sysInstrumentorClassName);
                fiSystem = new FileInstrumentor(new IInstrumentationStrategy[]{(IInstrumentationStrategy)c.getConstructor(List.class).newInstance(this._parameters)});
            }
            catch (NoSuchMethodException e) {
                try {
                    Class<?> c3 = Class.forName(this._sysInstrumentorClassName);
                    fiSystem = new FileInstrumentor(new IInstrumentationStrategy[]{(IInstrumentationStrategy)c3.getConstructor(new Class[0]).newInstance(new Object[0])});
                }
                catch (Throwable e2) {
                    e2.printStackTrace(Debug.out);
                    System.exit(1);
                }
            }
            catch (Throwable e2) {
                e2.printStackTrace(Debug.out);
                System.exit(1);
            }
            Debug.out.println("Parameters: " + this._parameters.size());
            for (String s : this._parameters) {
                Debug.out.println(s);
            }
            Debug.out.println();
            final ArrayList<IOException> exceptionList = new ArrayList<IOException>();
            try {
                if (this._instrumentRt) {
                    FileInstrumentor.instrumentRTJar(this._sourceRtJarName, this._destRtJarName, this._cunitRtJarName, this._cunitFilters, fi, fiSystem);
                }
                FileInstrumentor.instrumentList(this._createBackups, true, fi, tempDirMap, new ILambda.Binary<Void, String, IOException>(){

                    @Override
                    public Void apply(String fileName, IOException ioe) {
                        exceptionList.add(ioe);
                        return null;
                    }
                }, names);
                if (fi != null) {
                    fi.done();
                }
                if (fiSystem != null) {
                    fiSystem.done();
                }
            }
            catch (Throwable t) {
                Debug.out.println(t);
                t.printStackTrace(Debug.out);
            }
            if (this._unpackJars) {
                for (String name : tempDirMap.keySet()) {
                    try {
                        File tempDir = (File)tempDirMap.get(name);
                        String newJarName = name.replace(".jar", "_i.jar");
                        try {
                            long packCount = FileOps.packJar(tempDir, new File(newJarName));
                            Debug.out.println("\t" + packCount + " files packed");
                        }
                        catch (IOException ioe) {
                            Debug.out.println("Error: Could not pack " + tempDir + " to jar " + newJarName);
                            System.exit(1);
                        }
                        if (this._createBackups) {
                            String oldJarName = name.replace(".jar", ".jar~");
                            boolean bl = new File(name).renameTo(new File(oldJarName));
                            if (!bl) {
                                throw new CouldNotDoubleRenameException(new File(name), new File(oldJarName), new File(newJarName));
                            }
                            bl = new File(newJarName).renameTo(new File(name));
                            if (!bl) {
                                throw new CouldNotRenameException(new File(newJarName), new File(name));
                            }
                        } else if (!new File(name).delete() || !new File(newJarName).renameTo(new File(name))) {
                            throw new CouldNotDeleteAndRenameException(new File(name), new File(newJarName));
                        }
                        if (FileOps.deleteDirectory(tempDir)) continue;
                        Debug.out.println("Error: Could not delete directory " + tempDir);
                        System.exit(1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        exceptionList.add(e);
                    }
                }
            }
            Debug.out.println("Scanner results: ");
            boolean found = false;
            for (IInstrumentationStrategy itor : fi.getInstrumentors()) {
                if (itor instanceof IScannerStrategy) {
                    IScannerStrategy scanner = (IScannerStrategy)itor;
                    for (IScannerStrategy.IScanResult iScanResult : scanner.getScanResults()) {
                        found = true;
                        Debug.out.println("\t" + iScanResult.getPropertyName() + ": " + iScanResult);
                    }
                }
                Debug.out.println();
            }
            if (!found) {
                Debug.out.println("\tNone");
            }
            Debug.out.println();
            Debug.out.println("IOExceptions: " + exceptionList.size());
            if (exceptionList.size() > 0) {
                Debug.out.println("Retrying IOExceptions...");
                int undoneCount = 0;
                boolean first = true;
                for (IOException ioe : exceptionList) {
                    if (ioe instanceof RetryIOException) {
                        RetryIOException retryIOException = (RetryIOException)ioe;
                        try {
                            retryIOException.retry();
                            ++undoneCount;
                        }
                        catch (IOException e) {
                            if (first) {
                                first = false;
                            } else {
                                Debug.out.println("The following IOExceptions could not be undone:");
                            }
                            Debug.out.println("\t" + ioe.getMessage());
                            ioe.printStackTrace(Debug.out);
                            Debug.out.println("----------------------------------------");
                        }
                        continue;
                    }
                    if (first) {
                        first = false;
                    } else {
                        Debug.out.println("The following IOExceptions could not be undone:");
                    }
                    Debug.out.println("\t" + ioe.getMessage());
                    ioe.printStackTrace(Debug.out);
                    Debug.out.println("----------------------------------------");
                }
                Debug.out.println();
                Debug.out.println("IOExceptions: " + (exceptionList.size() - undoneCount));
            }
            Date endDate = new Date();
            Debug.out.println("End time = " + endDate);
            Debug.out.println(StringOps.toStringMillis(endDate.getTime() - this._startDate.getTime()));
            if (_debugOut != null) {
                Debug.out.close();
                try {
                    _debugOut.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Debug.out.setOutput(System.out);
            }
        }

        protected int checkArgs(String[] args) {
            if (args.length == 0) {
                this.help(System.out);
                System.exit(1);
            }
            int argIndex = 0;
            while (argIndex < args.length && args[argIndex].startsWith("-")) {
                String a;
                if ((a = args[argIndex++]).equals("-h")) {
                    this.help(System.out);
                    System.exit(1);
                    continue;
                }
                if (a.equals("-quiet")) {
                    Debug.out.setDebug(false);
                    continue;
                }
                if (a.equals("-nobackup")) {
                    this._createBackups = false;
                    continue;
                }
                if (a.equals("-unpackjars")) {
                    this._unpackJars = true;
                    continue;
                }
                if (a.equals("-force")) {
                    _forceInstrumentation = true;
                    continue;
                }
                if (a.equals("-noannot")) {
                    _addAnnotationAttribute = false;
                    continue;
                }
                if (a.equals("-output")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <txt> file parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    String name = args[argIndex++];
                    try {
                        _debugOut = new FileOutputStream(name);
                        Debug.out.setOutput(new PrintStream(_debugOut, true));
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Error: Could not open <txt> file " + name + " for output.");
                        System.exit(1);
                    }
                    continue;
                }
                if (a.equals("-rt")) {
                    this._instrumentRt = true;
                    continue;
                }
                if (a.equals("-rts")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <s> jar file parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    this._sourceRtJarName = args[argIndex++];
                    continue;
                }
                if (a.equals("-rtm")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <m> jar file parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    this._cunitRtJarName = args[argIndex++];
                    continue;
                }
                if (a.equals("-rtmfilter")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <f> filter parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    String filters = args[argIndex++];
                    this._cunitFilters = new ArrayList<String>();
                    String pathSep = File.pathSeparator;
                    for (String f : filters.split(File.pathSeparator)) {
                        this._cunitFilters.add(f);
                    }
                    continue;
                }
                if (a.equals("-rtd")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <d> jar file parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    this._destRtJarName = args[argIndex++];
                    continue;
                }
                if (a.equals("-i")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <iclass> file parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    this._instrumentorClassName = args[argIndex++];
                    if (this._instrumentorClassName.indexOf(46) >= 0) continue;
                    this._instrumentorClassName = FileInstrumentor.INSTRUMENTOR_PACKAGE_PREFIX + this._instrumentorClassName;
                    continue;
                }
                if (a.equals("-s")) {
                    if (argIndex + 1 > args.length) {
                        System.err.println("Error: <sclass> file parameter missing.");
                        this.help(System.err);
                        System.exit(1);
                    }
                    this._sysInstrumentorClassName = args[argIndex++];
                    if (this._sysInstrumentorClassName.indexOf(46) >= 0) continue;
                    this._sysInstrumentorClassName = FileInstrumentor.INSTRUMENTOR_PACKAGE_PREFIX + this._sysInstrumentorClassName;
                    continue;
                }
                if (!a.equals("-X")) continue;
                if (argIndex + 1 > args.length) {
                    System.err.println("Error: <s> parameter missing.");
                    this.help(System.err);
                    System.exit(1);
                }
                this._parameters.add(args[argIndex++]);
            }
            return argIndex;
        }

        protected void help(PrintStream out) {
            out.println("Flags : [-h] [-quiet] [-output <txt>] [-rt] [-rts <s>] [-rtm <m>] [-rtd <d>]");
            out.println("        [-nobackup] [-i <iclass>] [-s <sclass] [-X <s>] [-force]");
            out.println("        [-noannot] [<filename> ...]");
            out.println("-h                Show this help");
            out.println("-quiet            No output");
            out.println("-output <txt>     Save output in the text file <txt>");
            out.println("-rt               Instrument the rt.jar file <s> using the instrumentor,");
            out.println("                  instrument the Concutest jar file <m> using the");
            out.println("                  system instrumentor, and write to the jar file <d>");
            out.println("-rts <s>          Specify the source rt.jar file <s> (rt.jar)");
            out.println("-rtm <m>          Specify the Concutest jar file <m> (cunitrt.jar)");
            out.println("-rtmfilter <f>    Specify filters for jar file <m>");
            out.println("-rtd <d>          Specify the destination jar file <d> (rt_i.jar)");
            out.println("-nobackup         Do not create backup files (*.jar~ or *.class~)");
            out.println("-i <iclass>       Specify <iclass> as instrumentor class name");
            out.println("-s <sclass>       Specify <sclass> as system instrumentor class name");
            out.println("-X <s>            Pass <s> as parameter to instrumentors; may be repeated");
            out.println("-force            Force the annotation, even if already marked instrumented");
            out.println("-noannot          Do not annotate class files with the instrumentors used");
            out.println("-unpackjars       Unpack/repack all jar files into temporary directories");
            out.println("<filename> ...    List of class or jar file names to instrument using");
            out.println("                  the instrumentor");
            out.println();
            out.println("Instrumentors must have a unary constructor (favored) accepting a");
            out.println("List<String> with parameters, or a zeroary constructor.");
            out.println();
            out.println("If instrumentor class names do not explicitly specify a package, the package");
            out.println("edu.rice.cs.cunit.instrumentors is assumed.");
            out.println();
            out.println("Default instrumentor:        CompoundCompactRecordStrategy");
            out.println("Default system instrumentor: CompoundCompactSystemStrategy");
            out.println();
            out.println("If -unpackjars is used and -X class-path= has been specified, then the");
            out.println("jar files on the class path will be replaced by their temporary directories.");
            out.println("Jar files inside jar files will not be unpacked.");
        }
    }
}

