/** An instance is an HSV value. */
public class HSV {
    /** h, s, and v are the components of an HSV value */
    
    private double h; /* The hue. 0 <= h < 360. */
    private double s; /* The saturation. 0 <= s <= 1.*/
    private double v; /* The value, or brightness. 0 <= v <= 1. */
    
    /** Constructor: the HSV color (h, s, v).
        Precondition: 0 <= h < 360, 0 <= s <= 1, 0 <= v <= 1.  */
    public HSV(double h, double s, double v) {
        this.h= h;
        this.s= s;
        this.v= v;
    }
    
    /** = the hue component of this HSV value */
    public double hue() {
        return h;
    }
    
    /** = the saturation component of this HSV value */
    public double sat() {
        return s;
    }
    
    /** = the value component of this HSV value */
    public double val() {
        return v;
    }
    
    /** A representation of this HSV color. */
    public String toString() {
        return A4Methods.toString(this);
    }
}
