import junit.framework.TestCase;
import java.awt.*;
/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class A4Tester extends TestCase {

     /** Test complement */
    public void testComplement() {
        assertEquals(new Color(255-250, 255-0, 255-71), A4Methods.complementRGB(new Color(250, 0, 71)));
    }
    
    /** Test methods complement and truncateTo5   */
    public void testTruncateTo5() {
        assertEquals("130.5",  A4Methods.truncateTo5(130.59));
        assertEquals("130.5",  A4Methods.truncateTo5(130.54));
        assertEquals("100.0",  A4Methods.truncateTo5(100));
        assertEquals("99.56",  A4Methods.truncateTo5(99.566));
        assertEquals("99.99",  A4Methods.truncateTo5(99.99));
        assertEquals("99.99",  A4Methods.truncateTo5(99.995));
        assertEquals("21.99",  A4Methods.truncateTo5(21.99575));
        assertEquals("21.99",  A4Methods.truncateTo5(21.994));
        assertEquals("10.01",  A4Methods.truncateTo5(10.013567));
        assertEquals("10.00",  A4Methods.truncateTo5(10.000000005));
        assertEquals("9.999",  A4Methods.truncateTo5(9.9999));
        assertEquals("9.999",  A4Methods.truncateTo5(9.9993));
        assertEquals("1.354",  A4Methods.truncateTo5(1.3546));
        assertEquals("1.354",  A4Methods.truncateTo5(1.3544));
        assertEquals("0.045",  A4Methods.truncateTo5(.0456));
        assertEquals("0.045",  A4Methods.truncateTo5(.0453));
        assertEquals("0.005",  A4Methods.truncateTo5(.0056));
        assertEquals("0.001",  A4Methods.truncateTo5(.0013));
        assertEquals("0.000",  A4Methods.truncateTo5(.0004));
        assertEquals("0.000",  A4Methods.truncateTo5(.0009999));
    }
             
    public void testroundTo5() {
        assertEquals("130.6",  A4Methods.roundTo5(130.59));
        assertEquals("130.5",  A4Methods.roundTo5(130.54));
        assertEquals("100.0",  A4Methods.roundTo5(100));
        assertEquals("99.57",  A4Methods.roundTo5(99.566));
        assertEquals("99.99",  A4Methods.roundTo5(99.99));
        assertEquals("100.0",  A4Methods.roundTo5(99.995));
        assertEquals("22.00",  A4Methods.roundTo5(21.99575));
        assertEquals("21.99",  A4Methods.roundTo5(21.994));
        assertEquals("10.01",  A4Methods.roundTo5(10.013567));
        assertEquals("10.00",  A4Methods.roundTo5(10.000000005));
        assertEquals("10.00",  A4Methods.roundTo5(9.9999));
        assertEquals("9.999",  A4Methods.roundTo5(9.9993));
        assertEquals("1.355",  A4Methods.roundTo5(1.3546));
        assertEquals("1.354",  A4Methods.roundTo5(1.3544));
        assertEquals("0.046",  A4Methods.roundTo5(.0456));
        assertEquals("0.045",  A4Methods.roundTo5(.0453));
        assertEquals("0.006",  A4Methods.roundTo5(.0056));
        assertEquals("0.001",  A4Methods.roundTo5(.0013));
        assertEquals("0.000",  A4Methods.roundTo5(.0004));
        assertEquals("0.001",  A4Methods.roundTo5(.0009999));
    }
    
    /** Test methods toString(...) functions   */
    public void testToStrings() {
        assertEquals("(30, 240, 230)",  A4Methods.toString(new Color(30, 240, 230)));
        

        
    }

    /** Test the translation functions */
    public void testTranslations() {
        Color rgb= new Color(255, 255, 255);
        CMYK cmyk= A4Methods.RGB2CMYK(rgb);
        assertEquals(0.0, cmyk.cyan());
        assertEquals(0.0, cmyk.magenta());
        assertEquals(0.0, cmyk.yellow());
        assertEquals(0.0, cmyk.black());
        
        rgb= new Color(0, 0, 0);
        cmyk= A4Methods.RGB2CMYK(rgb);
        assertEquals(0.0, cmyk.cyan());
        assertEquals(0.0, cmyk.magenta());
        assertEquals(0.0, cmyk.yellow());
        assertEquals(100.0, cmyk.black());
        
        rgb= new Color(217, 43, 164);
        cmyk= A4Methods.RGB2CMYK(rgb);
        assertEquals("0.000", A4Methods.roundTo5(cmyk.cyan()));
        assertEquals("80.18", A4Methods.roundTo5(cmyk.magenta()));
        assertEquals("24.42", A4Methods.roundTo5(cmyk.yellow()));
        assertEquals("14.90", A4Methods.roundTo5(cmyk.black()));
        

        // test cmyk to rgb
        
        
        
        
        // Test rgb to hsv
        
        
        
        
        
        // Test hsv to rgb
        
        
        
        
    }
    

}
