/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class A4
extends JApplet
implements ChangeListener,
ActionListener {
    private JFrame jf = null;
    private JPanel image;
    private JPanel compImage;
    private JLabel imageLabel;
    private JLabel compImageLabel;
    private JSlider RSlider = new JSlider(1, 0, 25500, 0);
    private JSlider GSlider = new JSlider(1, 0, 25500, 25500);
    private JSlider BSlider = new JSlider(1, 0, 25500, 0);
    private JSlider CSlider = new JSlider(1, 0, 10000, 10000);
    private JSlider MSlider = new JSlider(1, 0, 10000, 0);
    private JSlider YSlider = new JSlider(1, 0, 10000, 10000);
    private JSlider KSlider = new JSlider(1, 0, 10000, 0);
    private JSlider HSlider = new JSlider(1, 0, 35999, 12000);
    private JSlider SSlider = new JSlider(1, 0, 100, 100);
    private JSlider VSlider = new JSlider(1, 0, 100, 100);
    private JButton inputrgb = new JButton("RGB");
    private JTextField rfield = new JTextField();
    private JTextField gfield = new JTextField();
    private JTextField bfield = new JTextField();
    private JButton inputcmyk = new JButton("CMYK");
    private JTextField cfield = new JTextField();
    private JTextField mfield = new JTextField();
    private JTextField yfield = new JTextField();
    private JTextField kfield = new JTextField();
    private JButton inputhsv = new JButton("HSV");
    private JTextField hfield = new JTextField();
    private JTextField sfield = new JTextField();
    private JTextField vfield = new JTextField();

    public static void main(String[] args) {
        A4 a4 = new A4();
    }

    @Override
    public void init() {
    }

    public A4() {
        this.jf = new JFrame("Color");
        this.jf.setSize(600, 200);
        this.jf.setResizable(false);
        Color rgb = new Color(0, 255, 0);
        CMYK cmyk = A4Methods.RGB2CMYK(rgb);
        HSV hsv = A4Methods.RGB2HSV(rgb);
        this.image = new JPanel();
        this.image.setSize(230, 200);
        this.image.setPreferredSize(new Dimension(230, 200));
        this.imageLabel = new JLabel("");
        this.imageLabel.setPreferredSize(new Dimension(230, 160));
        this.imageLabel.setVerticalAlignment(1);
        this.image.add(this.imageLabel);
        this.compImage = new JPanel();
        this.compImage.setSize(230, 200);
        this.compImage.setPreferredSize(new Dimension(230, 200));
        this.compImageLabel = new JLabel("");
        this.compImageLabel.setPreferredSize(new Dimension(230, 160));
        this.compImageLabel.setVerticalAlignment(1);
        this.compImage.add(this.compImageLabel);
        Box sliders = new Box(0);
        this.fixSlider(sliders, this.RSlider, 'R');
        this.fixSlider(sliders, this.GSlider, 'G');
        this.fixSlider(sliders, this.BSlider, 'B');
        sliders.add(Box.createRigidArea(new Dimension(20, 0)));
        this.fixSlider(sliders, this.CSlider, 'C');
        this.fixSlider(sliders, this.MSlider, 'M');
        this.fixSlider(sliders, this.YSlider, 'Y');
        this.fixSlider(sliders, this.KSlider, 'K');
        sliders.add(Box.createRigidArea(new Dimension(20, 0)));
        this.fixSlider(sliders, this.HSlider, 'H');
        this.fixSlider(sliders, this.SSlider, 'S');
        this.fixSlider(sliders, this.VSlider, 'V');
        Box GUI = new Box(0);
        GUI.add(this.image);
        GUI.add(this.compImage);
        GUI.add(sliders);
        this.setSliders(rgb, hsv, cmyk);
        this.setColorPanels(rgb, hsv, cmyk);
        Box fields = this.createFields();
        Box finalBox = new Box(1);
        finalBox.add(GUI);
        finalBox.add(fields);
        this.jf.getContentPane().add(finalBox);
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public Box createFields() {
        Box fields = new Box(0);
        fields.add(this.inputrgb);
        this.inputrgb.addActionListener(this);
        fields.add(new JLabel("R"));
        fields.add(this.rfield);
        fields.add(new JLabel("G"));
        fields.add(this.gfield);
        fields.add(new JLabel("B"));
        fields.add(this.bfield);
        fields.add(this.inputcmyk);
        this.inputcmyk.addActionListener(this);
        fields.add(new JLabel("C"));
        fields.add(this.cfield);
        fields.add(new JLabel("M"));
        fields.add(this.mfield);
        fields.add(new JLabel("Y"));
        fields.add(this.yfield);
        fields.add(new JLabel("K"));
        fields.add(this.kfield);
        fields.add(this.inputhsv);
        this.inputhsv.addActionListener(this);
        fields.add(new JLabel("hue"));
        fields.add(this.hfield);
        fields.add(new JLabel("sat"));
        fields.add(this.sfield);
        fields.add(new JLabel("val"));
        fields.add(this.vfield);
        return fields;
    }

    public void fixSlider(Box sliders, JSlider s, char c) {
        Box b = new Box(1);
        b.add(new JLabel("" + c));
        b.add(s);
        sliders.add(b);
        s.addChangeListener(this);
    }

    public void fixListeners(boolean b) {
        if (b) {
            this.RSlider.addChangeListener(this);
            this.GSlider.addChangeListener(this);
            this.BSlider.addChangeListener(this);
            this.HSlider.addChangeListener(this);
            this.SSlider.addChangeListener(this);
            this.VSlider.addChangeListener(this);
            this.CSlider.addChangeListener(this);
            this.MSlider.addChangeListener(this);
            this.YSlider.addChangeListener(this);
            this.KSlider.addChangeListener(this);
        } else {
            this.RSlider.removeChangeListener(this);
            this.GSlider.removeChangeListener(this);
            this.BSlider.removeChangeListener(this);
            this.CSlider.removeChangeListener(this);
            this.MSlider.removeChangeListener(this);
            this.YSlider.removeChangeListener(this);
            this.KSlider.removeChangeListener(this);
            this.HSlider.removeChangeListener(this);
            this.SSlider.removeChangeListener(this);
            this.VSlider.removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        CMYK cmyk;
        Color rgb;
        HSV hsv;
        this.fixListeners(false);
        JSlider source = (JSlider)e.getSource();
        if (source.equals(this.HSlider) || source.equals(this.SSlider) || source.equals(this.VSlider)) {
            double H = (double)this.HSlider.getValue() / 100.0;
            double S = (double)this.SSlider.getValue() / 100.0;
            double V = (double)this.VSlider.getValue() / 100.0;
            hsv = new HSV(H, S, V);
            rgb = A4Methods.HSV2RGB(hsv);
            cmyk = A4Methods.RGB2CMYK(rgb);
        } else if (source.equals(this.RSlider) || source.equals(this.GSlider) || source.equals(this.BSlider)) {
            int R = (int)Math.round((double)this.RSlider.getValue() / 100.0);
            int G = (int)Math.round((double)this.GSlider.getValue() / 100.0);
            int B = (int)Math.round((double)this.BSlider.getValue() / 100.0);
            rgb = new Color(R, G, B);
            hsv = A4Methods.RGB2HSV(rgb);
            cmyk = A4Methods.RGB2CMYK(rgb);
        } else if (source.equals(this.CSlider) || source.equals(this.MSlider) || source.equals(this.YSlider) || source.equals(this.KSlider)) {
            double C = (double)this.CSlider.getValue() / 100.0;
            double M = (double)this.MSlider.getValue() / 100.0;
            double Y = (double)this.YSlider.getValue() / 100.0;
            double K = (double)this.KSlider.getValue() / 100.0;
            cmyk = new CMYK(C, M, Y, K);
            rgb = A4Methods.CMYK2RGB(cmyk);
            hsv = A4Methods.RGB2HSV(rgb);
        } else {
            return;
        }
        this.setSliders(rgb, hsv, cmyk);
        this.setColorPanels(rgb, hsv, cmyk);
        this.fixListeners(true);
    }

    public void setSliders(Color rgb, HSV hsv, CMYK cmyk) {
        this.RSlider.setValue(rgb.getRed() * 100);
        this.GSlider.setValue(rgb.getGreen() * 100);
        this.BSlider.setValue(rgb.getBlue() * 100);
        this.HSlider.setValue((int)(hsv.hue() * 100.0));
        this.SSlider.setValue((int)(hsv.sat() * 100.0));
        this.VSlider.setValue((int)(hsv.val() * 100.0));
        this.CSlider.setValue((int)(cmyk.cyan() * 100.0));
        this.MSlider.setValue((int)(cmyk.magenta() * 100.0));
        this.YSlider.setValue((int)(cmyk.yellow() * 100.0));
        this.KSlider.setValue((int)(cmyk.black() * 100.0));
    }

    public void setColorPanels(Color rgb, HSV hsv, CMYK cmyk) {
        this.image.setBackground(rgb);
        Color compRgb = A4Methods.complementRGB(rgb);
        this.compImage.setBackground(compRgb);
        this.imageLabel.setForeground(compRgb);
        this.imageLabel.setText("<html>&nbsp;Color<br>&nbsp;RGB:&nbsp;&nbsp;&nbsp;&nbsp;" + A4Methods.toString(rgb) + "<br>&nbsp;CMYK:&nbsp;" + A4Methods.toString(cmyk) + "<br>&nbsp;HSV:&nbsp;&nbsp;&nbsp;&nbsp;" + A4Methods.toString(hsv) + "<br><br>" + "&nbsp;R,G,B sliders in: 0..255<br>" + "&nbsp;C,M,Y,K sliders: 0 to 100%<br>" + "&nbsp;H slider: 0 &lt;= H &lt; 360 degrees<br>" + "&nbsp;S,V sliders: 0 &lt;= S,V &lt;= 1" + "</html>");
        this.compImageLabel.setForeground(rgb);
        HSV compHsv = A4Methods.RGB2HSV(compRgb);
        CMYK compCmyk = A4Methods.RGB2CMYK(compRgb);
        this.compImageLabel.setText("<html>&nbsp;Complementary Color<br>&nbsp;RGB:&nbsp;&nbsp;&nbsp;&nbsp;" + A4Methods.toString(compRgb) + "<br>&nbsp;CMYK:&nbsp;" + A4Methods.toString(compCmyk) + "<br>&nbsp;HSV:&nbsp;&nbsp;&nbsp;&nbsp;" + A4Methods.toString(compHsv) + "<br><br>" + "&nbsp;R,G,B sliders in: 0..255<br>" + "&nbsp;C,M,Y,K sliders: 0 to 100%<br>" + "&nbsp;H slider: 0 &lt;= H &lt; 360 degrees<br>" + "&nbsp;S,V sliders: 0 &lt;= S,V &lt;= 1" + "</html>");
        this.jf.setTitle("Color RGB: " + A4Methods.toString(rgb));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CMYK cmyk;
        HSV hsv;
        Color rgb;
        this.fixListeners(false);
        if (e.getSource() == this.inputrgb) {
            int r = A4.getInt(this.rfield.getText());
            int g = A4.getInt(this.gfield.getText());
            int b = A4.getInt(this.bfield.getText());
            this.rfield.setText("" + r);
            this.gfield.setText("" + g);
            this.bfield.setText("" + b);
            rgb = new Color(r, g, b);
            hsv = A4Methods.RGB2HSV(rgb);
            cmyk = A4Methods.RGB2CMYK(rgb);
        } else if (e.getSource() == this.inputcmyk) {
            double c = A4.getDouble100(this.cfield.getText());
            double m = A4.getDouble100(this.mfield.getText());
            double y = A4.getDouble100(this.yfield.getText());
            double k = A4.getDouble100(this.kfield.getText());
            this.cfield.setText(A4Methods.roundTo5(c));
            this.mfield.setText(A4Methods.roundTo5(m));
            this.yfield.setText(A4Methods.roundTo5(y));
            this.kfield.setText(A4Methods.roundTo5(k));
            cmyk = new CMYK(c, m, y, k);
            rgb = A4Methods.CMYK2RGB(cmyk);
            hsv = A4Methods.RGB2HSV(rgb);
        } else {
            double h = A4.getDouble360(this.hfield.getText());
            double s = A4.getDouble(this.sfield.getText());
            double v = A4.getDouble(this.vfield.getText());
            hsv = new HSV(h, s, v);
            rgb = A4Methods.HSV2RGB(hsv);
            cmyk = A4Methods.RGB2CMYK(rgb);
            this.hfield.setText(A4Methods.roundTo5(h));
            this.sfield.setText(A4Methods.roundTo5(s));
            this.vfield.setText(A4Methods.roundTo5(v));
        }
        this.setColorPanels(rgb, hsv, cmyk);
        this.setSliders(rgb, hsv, cmyk);
        this.fixListeners(true);
    }

    public static int getInt(String s) {
        try {
            int i = Integer.parseInt(s.trim());
            return Math.max(0, Math.min(255, i));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static double getDouble(String s) {
        try {
            double d = Double.parseDouble(s.trim());
            return Math.max(0.0, Math.min(1.0, d));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static double getDouble100(String s) {
        try {
            double d = Double.parseDouble(s.trim());
            return Math.max(0.0, Math.min(100.0, d));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static double getDouble360(String s) {
        try {
            double d = Double.parseDouble(s.trim());
            return Math.max(0.0, Math.min(359.9, d));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }
}

