/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.Statement;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchStatement
extends Statement {
    public static final String SELECTOR = "selector";
    public static final String BINDINGS = "bindings";
    private Expression selector;
    private List<SwitchBlock> bindings;

    public SwitchStatement(Expression sel, List<SwitchBlock> cases, SourceInfo si) {
        super(si);
        if (sel == null) {
            throw new IllegalArgumentException("sel == null");
        }
        if (cases == null) {
            throw new IllegalArgumentException("cases == null");
        }
        this.selector = sel;
        this.bindings = cases;
    }

    public Expression getSelector() {
        return this.selector;
    }

    public void setSelector(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.selector = e;
        this.firePropertyChange(SELECTOR, this.selector, this.selector);
    }

    public List<SwitchBlock> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<SwitchBlock> l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.bindings = l;
        this.firePropertyChange(BINDINGS, this.bindings, this.bindings);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getSelector() + " " + this.getBindings() + ")";
    }
}

