/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.Arrays;
import java.util.List;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceTypeName
extends TypeName {
    public static final String REPRESENTATION = "representation";
    private String representation;
    public static final String IDENTIFIERS = "identifiers";
    private List<? extends IdentifierToken> identifiers;

    public ReferenceTypeName(List<? extends IdentifierToken> ids) {
        this(ids, SourceInfo.NONE);
    }

    public ReferenceTypeName(IdentifierToken ... ids) {
        this(Arrays.asList(ids));
    }

    public ReferenceTypeName(String ... names) {
        this(ReferenceTypeName.stringsToIdentifiers(names));
    }

    private static IdentifierToken[] stringsToIdentifiers(String[] names) {
        IdentifierToken[] ids = new IdentifierToken[names.length];
        for (int i = 0; i < names.length; ++i) {
            ids[i] = new Identifier(names[i]);
        }
        return ids;
    }

    public ReferenceTypeName(List<? extends IdentifierToken> ids, SourceInfo si) {
        super(si);
        if (ids == null) {
            throw new IllegalArgumentException("ids == null");
        }
        if (ids.size() == 0) {
            throw new IllegalArgumentException("ids.size() == 0");
        }
        this.identifiers = ids;
        this.representation = TreeUtilities.listToName(ids);
    }

    public String getRepresentation() {
        return this.representation;
    }

    public List<? extends IdentifierToken> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<? extends IdentifierToken> ids) {
        if (ids == null) {
            throw new IllegalArgumentException("ids == null");
        }
        if (ids.size() == 0) {
            throw new IllegalArgumentException("ids.size() == 0");
        }
        this.identifiers = ids;
        this.firePropertyChange(IDENTIFIERS, this.identifiers, this.identifiers);
        this.representation = TreeUtilities.listToName(ids);
        this.firePropertyChange(REPRESENTATION, this.representation, this.representation);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.toStringHelper() + ")";
    }

    protected String toStringHelper() {
        return this.getRepresentation();
    }
}

