/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.MethodCall;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMethodCall
extends MethodCall
implements ExpressionContainer {
    private Expression expression;

    public ObjectMethodCall(Expression exp, String mn, List<? extends Expression> args, SourceInfo si) {
        super(mn, args, si);
        if (exp == null) {
            throw new IllegalArgumentException("exp == null");
        }
        this.expression = exp;
    }

    public ObjectMethodCall(Expression exp, String mn, List<? extends Expression> args) {
        this(exp, mn, args, SourceInfo.NONE);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.expression = e;
        this.firePropertyChange("expression", this.expression, this.expression);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.toStringHelper() + ")";
    }

    public String toStringHelper() {
        return this.getMethodName() + " " + this.getArguments() + " " + this.getExpression();
    }
}

