/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceOfExpression
extends Expression
implements ExpressionContainer {
    public static final String REFERENCE_TYPE = "referenceType";
    private Expression expression;
    private TypeName referenceType;

    public InstanceOfExpression(Expression exp, TypeName t) {
        this(exp, t, SourceInfo.NONE);
    }

    public InstanceOfExpression(Expression exp, TypeName t, SourceInfo si) {
        super(si);
        if (exp == null) {
            throw new IllegalArgumentException("exp == null");
        }
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.expression = exp;
        this.referenceType = t;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.expression = e;
        this.firePropertyChange("expression", this.expression, this.expression);
    }

    public TypeName getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.referenceType = t;
        this.firePropertyChange(REFERENCE_TYPE, this.referenceType, this.referenceType);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getExpression() + " " + this.getReferenceType() + ")";
    }
}

