/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDeclaration
extends Node {
    public static final String NAME = "name";
    public static final String PACKAGE = "package";
    private String name;
    private boolean pckage;
    private boolean sttic;

    public ImportDeclaration(List<IdentifierToken> ident, boolean pkg, boolean sttc) {
        this(ident, pkg, sttc, SourceInfo.NONE);
    }

    public ImportDeclaration(List<IdentifierToken> ident, boolean pkg, boolean sttc, SourceInfo si) {
        super(si);
        if (ident == null) {
            throw new IllegalArgumentException("ident == null");
        }
        this.pckage = pkg;
        this.sttic = sttc;
        this.name = TreeUtilities.listToName(ident);
    }

    public ImportDeclaration(String nm, boolean pkg, boolean sttc, SourceInfo si) {
        super(si);
        if (nm == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.pckage = pkg;
        this.sttic = sttc;
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public boolean isPackage() {
        return this.pckage;
    }

    public boolean isStaticImportClass() {
        return this.sttic && this.pckage;
    }

    public void setPackage(boolean b) {
        this.pckage = b;
        this.firePropertyChange(PACKAGE, this.pckage, this.pckage);
    }

    public boolean isStatic() {
        return this.sttic;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.toStringHelper() + ")";
    }

    public String toStringHelper() {
        return this.getName() + " " + this.isPackage() + " " + this.isStatic();
    }
}

