/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.Statement;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStatement
extends Statement {
    public static final String STATEMENTS = "statements";
    private List<Node> statements;

    public BlockStatement(List<Node> stmts) {
        this(stmts, SourceInfo.NONE);
    }

    public BlockStatement(List<Node> stmts, SourceInfo si) {
        super(si);
        if (stmts == null) {
            throw new IllegalArgumentException("stmts == null");
        }
        this.statements = stmts;
    }

    public List<Node> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Node> l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.statements = l;
        this.firePropertyChange(STATEMENTS, this.statements, this.statements);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getStatements() + ")";
    }
}

