/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.ArrayList;
import java.util.List;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAllocation
extends PrimaryExpression {
    public static final String ELEMENT_TYPE = "creationType";
    private TypeName elementType;
    private TypeDescriptor typeDescriptor;

    public ArrayAllocation(TypeName tp, TypeDescriptor td) {
        this(tp, td, SourceInfo.NONE);
    }

    public ArrayAllocation(TypeName tp, TypeDescriptor td, SourceInfo si) {
        super(si);
        if (tp == null) {
            throw new IllegalArgumentException("tp == null");
        }
        if (td == null) {
            throw new IllegalArgumentException("td == null");
        }
        this.elementType = tp;
        this.typeDescriptor = td;
        td.initialize(tp);
    }

    public TypeName getElementType() {
        return this.elementType;
    }

    public void setElementType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.elementType = t;
        this.firePropertyChange(ELEMENT_TYPE, this.elementType, this.elementType);
    }

    public int getDimension() {
        return this.typeDescriptor.dimension;
    }

    public void setDimension(int dim) {
        this.typeDescriptor.dimension = dim;
    }

    public List<Expression> getSizes() {
        return this.typeDescriptor.sizes;
    }

    public void setSizes(List<? extends Expression> sz) {
        this.typeDescriptor.sizes = sz == null ? null : new ArrayList<Expression>(sz);
    }

    public ArrayInitializer getInitialization() {
        return this.typeDescriptor.initialization;
    }

    public void setInitialization(ArrayInitializer init) {
        this.typeDescriptor.initialization = init;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getElementType() + " " + this.getDimension() + " " + this.getSizes() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeDescriptor
    implements SourceInfo.Wrapper {
        List<Expression> sizes;
        int dimension;
        ArrayInitializer initialization;
        SourceInfo sourceInfo;

        public TypeDescriptor(List<? extends Expression> sizes, int dim, ArrayInitializer init, SourceInfo si) {
            this.sizes = sizes == null ? null : new ArrayList<Expression>(sizes);
            this.dimension = dim;
            this.initialization = init;
            this.sourceInfo = si;
        }

        @Override
        public SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        void initialize(TypeName t) {
            if (this.initialization != null) {
                TypeName et = this.dimension > 1 ? new ArrayTypeName(t, this.dimension - 1, false, SourceInfo.span((SourceInfo.Wrapper)t, (SourceInfo.Wrapper)this)) : t;
                this.initialization.setElementType(et);
            }
        }
    }
}

