/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.LeftHandSide;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAccess
extends PrimaryExpression
implements LeftHandSide,
ExpressionContainer {
    public static final String EXPRESSION = "expression";
    public static final String CELL_NUMBER = "cellNumber";
    private Expression expression;
    private Expression cellNumber;

    public ArrayAccess(Expression exp, Expression cell) {
        this(exp, cell, SourceInfo.NONE);
    }

    public ArrayAccess(Expression exp, Expression cell, SourceInfo si) {
        super(si);
        if (exp == null) {
            throw new IllegalArgumentException("exp == null");
        }
        if (cell == null) {
            throw new IllegalArgumentException("cell == null");
        }
        this.expression = exp;
        this.cellNumber = cell;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.expression = e;
        this.firePropertyChange(EXPRESSION, this.expression, this.expression);
    }

    public Expression getCellNumber() {
        return this.cellNumber;
    }

    public void setCellNumber(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.cellNumber = e;
        this.firePropertyChange(CELL_NUMBER, this.cellNumber, this.cellNumber);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getExpression() + " " + this.getCellNumber() + ")";
    }
}

