/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileOps {
    private static Log _log = new Log("FileOpsTest.txt", false);
    public static final File NULL_FILE = NullFile.ONLY;
    @Deprecated
    public static final FileFilter JAVA_FILE_FILTER = new FileFilter(){

        public boolean accept(File f) {
            StringBuilder name = new StringBuilder(f.getAbsolutePath());
            String shortName = f.getName();
            if (shortName.length() < 6) {
                return false;
            }
            name.delete(name.length() - 5, name.length());
            name.append(".java");
            File test = new File(name.toString());
            return test.equals(f);
        }
    };

    @Deprecated
    public static File makeFile(String path) {
        File f = new File(path);
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f;
        }
    }

    @Deprecated
    public static File makeFile(File parentDir, String child) {
        File f = new File(parentDir, child);
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f;
        }
    }

    @Deprecated
    public static boolean inFileTree(File f, File root) {
        if (root == null || f == null) {
            return false;
        }
        try {
            if (!f.isDirectory()) {
                f = f.getParentFile();
            }
            String filePath = f.getCanonicalPath() + File.separator;
            String projectPath = root.getCanonicalPath() + File.separator;
            return filePath.startsWith(projectPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isAncestorOf(File ancestor, File f) {
        ancestor = ancestor.getAbsoluteFile();
        _log.log("ancestor = " + ancestor + "     f = " + f);
        for (f = f.getAbsoluteFile(); !ancestor.equals(f) && f != null; f = f.getParentFile()) {
        }
        return ancestor.equals(f);
    }

    public static File makeRelativeTo(File f, File b) throws IOException, SecurityException {
        return new File(b, FileOps.stringMakeRelativeTo(f, b));
    }

    public static String stringMakeRelativeTo(File f, File b) throws IOException, SecurityException {
        int i;
        try {
            File[] roots = File.listRoots();
            File fRoot = null;
            File bRoot = null;
            for (File r : roots) {
                if (FileOps.isAncestorOf(r, f)) {
                    fRoot = r;
                }
                if (FileOps.isAncestorOf(r, b)) {
                    bRoot = r;
                }
                if (fRoot != null && bRoot != null) break;
            }
            if (!(fRoot != null && fRoot.equals(bRoot) || f.getAbsoluteFile().getCanonicalFile().toString().startsWith(File.separator + File.separator))) {
                return f.getAbsoluteFile().getCanonicalFile().toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        File base = b.getCanonicalFile();
        File abs = f.getCanonicalFile();
        if (!base.isDirectory()) {
            base = base.getParentFile();
        }
        String last = "";
        if (!abs.isDirectory()) {
            String tmp = abs.getPath();
            last = tmp.substring(tmp.lastIndexOf(File.separator) + 1);
            abs = abs.getParentFile();
        }
        String[] basParts = FileOps.splitFile(base);
        String[] absParts = FileOps.splitFile(abs);
        StringBuilder result = new StringBuilder();
        int diffIndex = -1;
        boolean different = false;
        for (i = 0; i < basParts.length; ++i) {
            if (!(different || i < absParts.length && basParts[i].equals(absParts[i]))) {
                different = true;
                diffIndex = i;
            }
            if (!different) continue;
            result.append("..").append(File.separator);
        }
        if (diffIndex < 0) {
            diffIndex = basParts.length;
        }
        for (i = diffIndex; i < absParts.length; ++i) {
            result.append(absParts[i]).append(File.separator);
        }
        result.append(last);
        return result.toString();
    }

    @Deprecated
    public static String[] splitFile(File fileToSplit) {
        String path = fileToSplit.getPath();
        ArrayList<String> list = new ArrayList<String>();
        while (!path.equals("")) {
            int idx = path.indexOf(File.separator);
            if (idx < 0) {
                list.add(path);
                path = "";
                continue;
            }
            list.add(path.substring(0, idx));
            path = path.substring(idx + 1);
        }
        return list.toArray(new String[list.size()]);
    }

    @Deprecated
    public static ArrayList<File> getFilesInDir(File d, boolean recur, FileFilter f) {
        ArrayList<File> l = new ArrayList<File>();
        FileOps.getFilesInDir(d, l, recur, f);
        return l;
    }

    private static void getFilesInDir(File d, List<File> acc, boolean recur, FileFilter filter) {
        File[] files;
        if (d.isDirectory() && (files = d.listFiles(filter)) != null) {
            for (File f : files) {
                if (f.isDirectory() && recur) {
                    FileOps.getFilesInDir(f, acc, recur, filter);
                    continue;
                }
                if (!f.isFile()) continue;
                acc.add(f);
            }
        }
    }

    @Deprecated
    public static File getCanonicalFile(File f) {
        if (f == null) {
            return f;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return f.getAbsoluteFile();
    }

    @Deprecated
    public static String getCanonicalPath(File f) {
        return FileOps.getCanonicalFile(f).getPath();
    }

    public static File validate(File f) {
        if (f.exists()) {
            return f;
        }
        return NULL_FILE;
    }

    @Deprecated
    public static byte[] readStreamAsBytes(InputStream stream) throws IOException {
        BufferedInputStream buffered = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int readVal = buffered.read();
        while (readVal != -1) {
            out.write(readVal);
            readVal = buffered.read();
        }
        stream.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsSwingText(File file) throws IOException {
        String string;
        block8: {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                StringBuilder buf = new StringBuilder();
                int pred = 0;
                while (reader.ready()) {
                    char c = (char)reader.read();
                    if (c != '\n' || pred != 13) {
                        if (c == '\r') {
                            buf.append('\n');
                        } else if (c < ' ' && c != '\n') {
                            buf.append(' ');
                        } else {
                            buf.append(c);
                        }
                    }
                    pred = c;
                }
                string = buf.toString();
                Object var6_6 = null;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_7 = null;
                    if (reader == null) break block9;
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String readFileAsString(File file) throws IOException {
        String string;
        block3: {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                StringBuilder buf = new StringBuilder();
                while (reader.ready()) {
                    char c = (char)reader.read();
                    buf.append(c);
                }
                string = buf.toString();
                Object var5_5 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var5_6 = null;
                    if (reader == null) break block4;
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return string;
    }

    @Deprecated
    public static void copyFile(File source, File dest) throws IOException {
        String text = FileOps.readFileAsString(source);
        FileOps.writeStringToFile(dest, text);
    }

    @Deprecated
    public static File writeStringToNewTempFile(String prefix, String suffix, String text) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        FileOps.writeStringToFile(file, text);
        return file;
    }

    @Deprecated
    public static void writeStringToFile(File file, String text) throws IOException {
        FileOps.writeStringToFile(file, text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static void writeStringToFile(File file, String text, boolean append) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, append);
            writer.write(text);
            Object var5_4 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (writer == null) throw throwable;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    @Deprecated
    public static boolean writeIfPossible(File file, String text, boolean append) {
        try {
            FileOps.writeStringToFile(file, text, append);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File createTempDirectory(String name) throws IOException {
        return FileOps.createTempDirectory(name, null);
    }

    public static File createTempDirectory(String name, File parent) throws IOException {
        File result = File.createTempFile(name, "", parent);
        boolean success = result.delete();
        boolean bl = success = success && result.mkdir();
        if (!success) {
            throw new IOException("Attempt to create directory failed");
        }
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    @Deprecated
    public static boolean deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            boolean res = dir.delete();
            return res;
        }
        boolean ret = true;
        File[] childFiles = dir.listFiles();
        if (childFiles != null) {
            for (File f : childFiles) {
                ret = ret && FileOps.deleteDirectory(f);
            }
        }
        ret = ret && dir.delete();
        return ret;
    }

    @Deprecated
    public static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        _log.log("Deleting file/directory " + dir + " on exit");
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                FileOps.deleteDirectoryOnExit(f);
            }
        }
    }

    public static LinkedList<String> packageExplore(String prefix, File root) {
        final HashSet<File> exploredDirectories = new HashSet<File>();
        LinkedList<String> output = new LinkedList<String>();
        Stack<PrefixAndFile> working = new Stack<PrefixAndFile>();
        class PrefixAndFile {
            public String prefix;
            public File root;

            public PrefixAndFile(String prefix, File root) {
                this.root = root;
                this.prefix = prefix;
            }
        }
        working.push(new PrefixAndFile(prefix, root));
        exploredDirectories.add(root);
        FileFilter directoryFilter = new FileFilter(){

            public boolean accept(File f) {
                boolean toReturn = f.isDirectory() && !exploredDirectories.contains(f);
                exploredDirectories.add(f);
                return toReturn;
            }
        };
        while (!working.empty()) {
            File[] javaFiles;
            PrefixAndFile current = (PrefixAndFile)working.pop();
            File[] subDirectories = current.root.listFiles(directoryFilter);
            if (subDirectories != null) {
                for (File dir : subDirectories) {
                    PrefixAndFile paf = current.prefix.equals("") ? new PrefixAndFile(dir.getName(), dir) : new PrefixAndFile(current.prefix + "." + dir.getName(), dir);
                    working.push(paf);
                }
            }
            if ((javaFiles = current.root.listFiles(JAVA_FILE_FILTER)) == null || javaFiles.length == 0 || current.prefix.equals("")) continue;
            output.add(current.prefix);
        }
        return output;
    }

    @Deprecated
    public static boolean renameFile(File file, File dest) {
        if (dest.exists()) {
            dest.delete();
        }
        return file.renameTo(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveFile(FileSaver fileSaver) throws IOException {
        File backup;
        File file;
        boolean success;
        boolean makeBackup;
        block12: {
            makeBackup = fileSaver.shouldBackup();
            success = false;
            file = fileSaver.getTargetFile();
            backup = null;
            boolean tempFileUsed = true;
            if (file.exists() && !file.canWrite()) {
                throw new IOException("Permission denied");
            }
            if (makeBackup) {
                backup = fileSaver.getBackupFile();
                if (!FileOps.renameFile(file, backup)) {
                    throw new IOException("Save failed. Could not create backup file " + backup.getAbsolutePath() + "\nIt may be possible to save by disabling file backups\n");
                }
                fileSaver.backupDone();
            }
            File parent = file.getParentFile();
            File tempFile = File.createTempFile("drjava", ".temp", parent);
            try {
                FileOutputStream fos;
                try {
                    fos = new FileOutputStream(tempFile);
                }
                catch (FileNotFoundException fnfe) {
                    if (!fileSaver.continueWhenTempFileCreationFails()) throw new IOException("Could not create temp file " + tempFile + " in attempt to save " + file);
                    fos = new FileOutputStream(file);
                    tempFileUsed = false;
                }
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                fileSaver.saveTo(bos);
                bos.close();
                if (tempFileUsed && !FileOps.renameFile(tempFile, file)) {
                    throw new IOException("Save failed. Another process may be using " + file + ".");
                }
                success = true;
                Object var11_11 = null;
                if (!tempFileUsed) break block12;
                tempFile.delete();
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (tempFileUsed) {
                    tempFile.delete();
                }
                if (!makeBackup) throw throwable;
                if (success) {
                    fileSaver.backupDone();
                    throw throwable;
                } else {
                    FileOps.renameFile(backup, file);
                }
                throw throwable;
            }
        }
        if (!makeBackup) return;
        if (success) {
            fileSaver.backupDone();
            return;
        }
        FileOps.renameFile(backup, file);
    }

    @Deprecated
    public static String convertToAbsolutePathEntries(String path) {
        String pathSep = System.getProperty("path.separator");
        path = path + pathSep + "x";
        String[] pathEntries = path.split(pathSep);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pathEntries.length - 1; ++i) {
            File f = new File(pathEntries[i]);
            sb.append(f.getAbsolutePath());
            sb.append(pathSep);
        }
        String reconstructedPath = sb.toString();
        if (reconstructedPath.length() != 0) {
            reconstructedPath = reconstructedPath.substring(0, reconstructedPath.length() - 1);
        }
        return reconstructedPath;
    }

    public static File getValidDirectory(File origFile) {
        File file = origFile;
        if (file == NULL_FILE || file == null) {
            file = new File(System.getProperty("user.home"));
        }
        assert (file != null);
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file == null) {
            file = new File(System.getProperty("user.home"));
        }
        assert (file != null);
        if (!file.isDirectory() && file.getParent() != null) {
            if ((file = file.getParentFile()) == null) {
                file = new File(System.getProperty("user.home"));
            }
            assert (file != null);
        }
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        throw new UnexpectedException(new IOException(origFile.getPath() + " is not a valid directory, and all attempts " + "to locate a valid directory have failed. " + "Check your configuration."));
    }

    public static URL toURL(File f) throws MalformedURLException {
        return f.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean makeWritable(File roFile) throws IOException {
        boolean bl;
        block30: {
            boolean shouldBackup = DrJava.getConfig().getSetting(OptionConstants.BACKUP_FILES);
            boolean madeBackup = false;
            File backup = new File(roFile.getAbsolutePath() + "~");
            try {
                boolean noBackup = true;
                if (backup.exists()) {
                    try {
                        noBackup = backup.delete();
                    }
                    catch (SecurityException se) {
                        noBackup = false;
                    }
                }
                if (noBackup) {
                    try {
                        noBackup = roFile.renameTo(backup);
                        madeBackup = true;
                        roFile.createNewFile();
                    }
                    catch (SecurityException se) {
                        noBackup = false;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        roFile.createNewFile();
                    }
                    catch (SecurityException se) {
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (!noBackup) {
                    try {
                        roFile.delete();
                    }
                    catch (SecurityException se) {
                        boolean bl2 = false;
                        Object var8_18 = null;
                        if (!shouldBackup && madeBackup) {
                            try {
                                backup.delete();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        return bl2;
                    }
                }
                try {
                    IOUtil.copyFile(backup, roFile);
                }
                catch (SecurityException se) {
                    boolean bl3 = false;
                    Object var8_19 = null;
                    if (!shouldBackup && madeBackup) {
                        try {
                            backup.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return bl3;
                }
                catch (IOException ioe) {
                    boolean bl4 = false;
                    Object var8_20 = null;
                    if (!shouldBackup && madeBackup) {
                        try {
                            backup.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return bl4;
                }
                bl = true;
                Object var8_21 = null;
                if (shouldBackup || !madeBackup) break block30;
            }
            catch (Throwable throwable) {
                block31: {
                    Object var8_22 = null;
                    if (shouldBackup || !madeBackup) break block31;
                    try {
                        backup.delete();
                    }
                    catch (Exception e) {}
                }
                throw throwable;
            }
            try {
                backup.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean moveRecursively(File f, File n) {
        boolean res = true;
        try {
            if (!f.exists()) {
                return false;
            }
            if (f.isFile()) {
                return IOUtil.attemptMove(f, n);
            }
            if (!n.mkdir()) {
                return false;
            }
            for (String child : f.list()) {
                File oldChild = new File(f, child);
                File newChild = new File(n, child);
                res = res && FileOps.moveRecursively(oldChild, newChild);
            }
            if (!f.delete()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return res;
    }

    public static File generateNewFileName(File base) throws IOException {
        return FileOps.generateNewFileName(base.getParentFile(), base.getName());
    }

    public static File generateNewFileName(File dir, String name) throws IOException {
        return FileOps.generateNewFileName(dir, name, "", 100);
    }

    public static File generateNewFileName(File dir, String prefix, String suffix) throws IOException {
        return FileOps.generateNewFileName(dir, prefix, suffix, 100);
    }

    public static File generateNewFileName(File dir, String prefix, String suffix, int max) throws IOException {
        File temp = new File(dir, prefix + suffix);
        if (temp.exists()) {
            int count = 2;
            while ((temp = new File(dir, prefix + "-" + count + suffix)).exists() && ++count < max) {
            }
            if (temp.exists()) {
                throw new IOException("Could not generate a file name that did not already exist.");
            }
        }
        return temp;
    }

    public static abstract class DefaultFileSaver
    implements FileSaver {
        private File outputFile = NULL_FILE;
        private static Set<File> filesNotNeedingBackup = new HashSet<File>();
        private boolean backupsEnabled = DrJava.getConfig().getSetting(OptionConstants.BACKUP_FILES);
        private boolean isCanonical = false;

        public DefaultFileSaver(File file) {
            this.outputFile = file.getAbsoluteFile();
        }

        public boolean continueWhenTempFileCreationFails() {
            return true;
        }

        public File getBackupFile() throws IOException {
            return new File(this.getTargetFile().getPath() + "~");
        }

        public boolean shouldBackup() throws IOException {
            if (!this.backupsEnabled) {
                return false;
            }
            if (!this.getTargetFile().exists()) {
                return false;
            }
            return !filesNotNeedingBackup.contains(this.getTargetFile());
        }

        public void backupDone() {
            try {
                filesNotNeedingBackup.add(this.getTargetFile());
            }
            catch (IOException ioe) {
                throw new UnexpectedException(ioe, "getTargetFile should fail earlier");
            }
        }

        public File getTargetFile() throws IOException {
            if (!this.isCanonical) {
                this.outputFile = this.outputFile.getCanonicalFile();
                this.isCanonical = true;
            }
            return this.outputFile;
        }
    }

    public static interface FileSaver {
        public File getBackupFile() throws IOException;

        public boolean shouldBackup() throws IOException;

        public boolean continueWhenTempFileCreationFails();

        public void backupDone();

        public void saveTo(OutputStream var1) throws IOException;

        public File getTargetFile() throws IOException;
    }

    public static class NullFile
    extends File {
        public static final NullFile ONLY = new NullFile();

        private NullFile() {
            super("");
        }

        public boolean canRead() {
            return false;
        }

        public boolean canWrite() {
            return false;
        }

        public int compareTo(File f) {
            return f == this ? 0 : -1;
        }

        public boolean createNewFile() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public void deleteOnExit() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public boolean exists() {
            return false;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public File getAbsoluteFile() {
            return this;
        }

        public String getAbsolutePath() {
            return "";
        }

        public File getCanonicalFile() {
            return this;
        }

        public String getCanonicalPath() {
            return "";
        }

        public String getName() {
            return "";
        }

        public String getParent() {
            return null;
        }

        public File getParentFile() {
            return null;
        }

        public String getPath() {
            return "";
        }

        public boolean isAbsolute() {
            return false;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isFile() {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String[] list() {
            return null;
        }

        public String[] list(FilenameFilter filter) {
            return null;
        }

        public File[] listFiles() {
            return null;
        }

        public File[] listFiles(FileFilter filter) {
            return null;
        }

        public File[] listFiles(FilenameFilter filter) {
            return null;
        }

        public boolean mkdir() {
            return false;
        }

        public boolean mkdirs() {
            return false;
        }

        public boolean renameTo(File dest) {
            return false;
        }

        public boolean setLastModified(long time) {
            return false;
        }

        public boolean setReadOnly() {
            return false;
        }

        public String toString() {
            return "";
        }
    }
}

