/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.text;

import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.plt.tuple.Quad;
import edu.rice.cs.plt.tuple.Triple;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ArgumentParser {
    private final Map<String, Integer> _supportedOptions = new HashMap<String, Integer>();
    private final HashMap<String, Iterable<String>> _defaults = new HashMap();
    private final Map<String, String> _aliases = new HashMap<String, String>();
    private boolean _strictOrder = false;
    private int _requiredParams = 0;

    public void requireStrictOrder() {
        this._strictOrder = true;
    }

    public void requireParams(int count) {
        this._requiredParams = count;
    }

    public boolean supportsOption(String name) {
        return this._supportedOptions.containsKey(name) || this._aliases.containsKey(name);
    }

    public void supportOption(String name, int arity) {
        if (this.supportsOption(name)) {
            throw new IllegalArgumentException(name + " is already supported");
        }
        this._supportedOptions.put(name, arity);
    }

    public void supportOption(String name, String ... defaultArguments) {
        this.supportOption(name, defaultArguments.length);
        if (defaultArguments.length > 0) {
            this._defaults.put(name, IterUtil.asIterable(defaultArguments));
        }
    }

    public void supportVarargOption(String name) {
        if (this.supportsOption(name)) {
            throw new IllegalArgumentException(name + " is already supported");
        }
        this._supportedOptions.put(name, -1);
    }

    public void supportVarargOption(String name, String ... defaultArguments) {
        this.supportVarargOption(name);
        this._defaults.put(name, IterUtil.asIterable(defaultArguments));
    }

    public void supportAlias(String aliasName, String optionName) {
        if (this.supportsOption(aliasName)) {
            throw new IllegalArgumentException(aliasName + " is already supported");
        }
        if (!this.supportsOption(optionName)) {
            throw new IllegalArgumentException(optionName + " is not supported");
        }
        if (this._aliases.containsKey(optionName)) {
            optionName = this._aliases.get(optionName);
        }
        this._aliases.put(aliasName, optionName);
    }

    public Result parse(String ... args) throws IllegalArgumentException {
        Map options = (Map)this._defaults.clone();
        LinkedList<String> params = new LinkedList<String>();
        String currentOption = null;
        LinkedList<String> currentOptionArgs = null;
        int optionArgsCount = -1;
        boolean allowMoreOptions = true;
        for (String s : args) {
            if (currentOption != null && optionArgsCount == 0) {
                options.put(currentOption, IterUtil.asSizedIterable(currentOptionArgs));
                currentOption = null;
            }
            if (s.startsWith("-")) {
                String opt = s.substring(1);
                if (this._aliases.containsKey(opt)) {
                    opt = this._aliases.get(opt);
                }
                if (optionArgsCount > 0) {
                    throw new IllegalArgumentException("Expected " + optionArgsCount + " more argument(s) for option " + currentOption);
                }
                if (!allowMoreOptions) {
                    throw new IllegalArgumentException("Unexpected option: " + opt);
                }
                if (!this._supportedOptions.containsKey(opt)) {
                    throw new IllegalArgumentException("Unrecognized option: " + opt);
                }
                if (currentOption != null) {
                    options.put(currentOption, IterUtil.asSizedIterable(currentOptionArgs));
                }
                currentOption = opt;
                currentOptionArgs = new LinkedList<String>();
                optionArgsCount = this._supportedOptions.get(opt);
                continue;
            }
            if (currentOption == null) {
                if (this._strictOrder) {
                    allowMoreOptions = false;
                }
                params.add(s);
                continue;
            }
            currentOptionArgs.add(s);
            if (optionArgsCount <= 0) continue;
            --optionArgsCount;
        }
        if (optionArgsCount > 0) {
            throw new IllegalArgumentException("Expected " + optionArgsCount + " more argument(s) for option " + currentOption);
        }
        if (currentOption != null) {
            options.put(currentOption, IterUtil.asSizedIterable(currentOptionArgs));
        }
        if (params.size() < this._requiredParams) {
            throw new IllegalArgumentException("Expected at least " + this._requiredParams + " parameter(s)");
        }
        return new Result(options, params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result {
        private final Map<String, Iterable<String>> _options;
        private final Iterable<String> _params;

        public Result(Map<String, Iterable<String>> options, Iterable<String> params) {
            this._options = options;
            this._params = params;
        }

        public Iterable<String> params() {
            return this._params;
        }

        public boolean hasOption(String opt) {
            return this._options.containsKey(opt);
        }

        public Iterable<String> getOption(String opt) {
            return this._options.get(opt);
        }

        public boolean hasNullaryOption(String opt) {
            return this._options.containsKey(opt) && IterUtil.isEmpty(this._options.get(opt));
        }

        public String getUnaryOption(String opt) {
            Iterable<String> result = this._options.get(opt);
            if (result == null || IterUtil.sizeOf(result) != 1) {
                return null;
            }
            return IterUtil.first(result);
        }

        public Pair<String, String> getBinaryOption(String opt) {
            Iterable<String> result = this._options.get(opt);
            if (result == null || IterUtil.sizeOf(result) != 2) {
                return null;
            }
            return IterUtil.makePair(result);
        }

        public Triple<String, String, String> getTernaryOption(String opt) {
            Iterable<String> result = this._options.get(opt);
            if (result == null || IterUtil.sizeOf(result) != 3) {
                return null;
            }
            return IterUtil.makeTriple(result);
        }

        public Quad<String, String, String, String> getQuaternaryOption(String opt) {
            Iterable<String> result = this._options.get(opt);
            if (result == null || IterUtil.sizeOf(result) != 4) {
                return null;
            }
            return IterUtil.makeQuad(result);
        }
    }
}

