/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.MappedIterator;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedIterable<S, T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Composite,
Serializable {
    private final Iterable<? extends S> _source;
    private final Lambda<? super S, ? extends T> _map;

    public MappedIterable(Iterable<? extends S> source, Lambda<? super S, ? extends T> map) {
        this._source = source;
        this._map = map;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._source) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._source) + 1;
    }

    public MappedIterator<S, T> iterator() {
        return new MappedIterator<S, T>(this._source.iterator(), this._map);
    }

    @Override
    public boolean isEmpty() {
        return IterUtil.isEmpty(this._source);
    }

    @Override
    public int size() {
        return IterUtil.sizeOf(this._source);
    }

    @Override
    public int size(int bound) {
        return IterUtil.sizeOf(this._source, bound);
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._source);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._source);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public T last() {
        return this._map.value(IterUtil.last(this._source));
    }

    public static <S, T> MappedIterable<S, T> make(Iterable<? extends S> source, Lambda<? super S, ? extends T> map) {
        return new MappedIterable<S, T>(source, map);
    }

    public static <S, T> SnapshotIterable<T> makeSnapshot(Iterable<? extends S> source, Lambda<? super S, ? extends T> map) {
        return new SnapshotIterable(new MappedIterable<S, T>(source, map));
    }
}

