/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.debug.ThreadSnapshot;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Option;
import java.io.IOException;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredLogSink
implements LogSink {
    private final LogSink _delegate;
    private final Predicate<? super LogSink.Message> _pred;

    public FilteredLogSink(LogSink delegate, Predicate<? super LogSink.Message> pred) {
        this._delegate = delegate;
        this._pred = pred;
    }

    @Override
    public void close() throws IOException {
        this._delegate.close();
    }

    @Override
    public void log(LogSink.StandardMessage m) {
        if (this._pred.contains(m)) {
            this._delegate.log(m);
        }
    }

    @Override
    public void logEnd(LogSink.EndMessage m) {
        if (this._pred.contains(m)) {
            this._delegate.logEnd(m);
        }
    }

    @Override
    public void logError(LogSink.ErrorMessage m) {
        if (this._pred.contains(m)) {
            this._delegate.logError(m);
        }
    }

    @Override
    public void logStack(LogSink.StackMessage m) {
        if (this._pred.contains(m)) {
            this._delegate.logStack(m);
        }
    }

    @Override
    public void logStart(LogSink.StartMessage m) {
        if (this._pred.contains(m)) {
            this._delegate.logStart(m);
        }
    }

    public static FilteredLogSink byLocationWhiteList(LogSink delegate, String ... prefixes) {
        return new FilteredLogSink(delegate, FilteredLogSink.locationWhiteListPredicate(prefixes));
    }

    public static FilteredLogSink byLocationBlackList(LogSink delegate, String ... prefixes) {
        return new FilteredLogSink(delegate, FilteredLogSink.locationBlackListPredicate(prefixes));
    }

    public static FilteredLogSink byLocation(LogSink delegate, Predicate<? super String> pred) {
        return new FilteredLogSink(delegate, FilteredLogSink.locationPredicate(pred));
    }

    public static FilteredLogSink byStackDepth(LogSink delegate, int maxDepth) {
        return new FilteredLogSink(delegate, FilteredLogSink.stackDepthPredicate(maxDepth));
    }

    public static FilteredLogSink byThreadWhiteList(LogSink delegate, Thread ... threads) {
        return new FilteredLogSink(delegate, FilteredLogSink.threadWhiteListPredicate(threads));
    }

    public static FilteredLogSink byThreadWhiteList(LogSink delegate, String ... nameParts) {
        return new FilteredLogSink(delegate, FilteredLogSink.threadWhiteListPredicate(nameParts));
    }

    public static FilteredLogSink byThreadBlackList(LogSink delegate, Thread ... threads) {
        return new FilteredLogSink(delegate, FilteredLogSink.threadBlackListPredicate(threads));
    }

    public static FilteredLogSink byThreadBlackList(LogSink delegate, String ... nameParts) {
        return new FilteredLogSink(delegate, FilteredLogSink.threadBlackListPredicate(nameParts));
    }

    public static FilteredLogSink byThread(LogSink delegate, Predicate<? super ThreadSnapshot> pred) {
        return new FilteredLogSink(delegate, FilteredLogSink.threadPredicate(pred));
    }

    public static Predicate<LogSink.Message> locationWhiteListPredicate(final String ... prefixes) {
        return FilteredLogSink.locationPredicate((Predicate<? super String>)new Predicate<String>(){

            @Override
            public boolean contains(String s) {
                return TextUtil.startsWithAny(s, prefixes);
            }
        });
    }

    public static Predicate<LogSink.Message> locationBlackListPredicate(String ... prefixes) {
        return LambdaUtil.negate(FilteredLogSink.locationWhiteListPredicate(prefixes));
    }

    public static Predicate<LogSink.Message> locationPredicate(final Predicate<? super String> pred) {
        return new Predicate<LogSink.Message>(){

            @Override
            public boolean contains(LogSink.Message m) {
                Option<StackTraceElement> locOpt = m.caller();
                if (locOpt.isSome()) {
                    StackTraceElement loc = locOpt.unwrap();
                    return pred.contains(loc.getClassName() + "." + loc.getMethodName());
                }
                return pred.contains("");
            }
        };
    }

    public static Predicate<LogSink.Message> stackDepthPredicate(final int maxDepth) {
        return new Predicate<LogSink.Message>(){

            @Override
            public boolean contains(LogSink.Message m) {
                return m.thread().getStackTrace().size() <= maxDepth;
            }
        };
    }

    public static Predicate<LogSink.Message> threadWhiteListPredicate(Thread ... threads) {
        final HashSet<Long> ids = new HashSet<Long>();
        for (Thread t : threads) {
            ids.add(t.getId());
        }
        threads = null;
        return FilteredLogSink.threadPredicate((Predicate<? super ThreadSnapshot>)new Predicate<ThreadSnapshot>(){

            @Override
            public boolean contains(ThreadSnapshot t) {
                return ids.contains(t.getId());
            }
        });
    }

    public static Predicate<LogSink.Message> threadWhiteListPredicate(final String ... nameParts) {
        return FilteredLogSink.threadPredicate((Predicate<? super ThreadSnapshot>)new Predicate<ThreadSnapshot>(){

            @Override
            public boolean contains(ThreadSnapshot t) {
                return TextUtil.containsAny(t.getName(), nameParts);
            }
        });
    }

    public static Predicate<LogSink.Message> threadBlackListPredicate(Thread ... threads) {
        return LambdaUtil.negate(FilteredLogSink.threadWhiteListPredicate(threads));
    }

    public static Predicate<LogSink.Message> threadBlackListPredicate(String ... nameParts) {
        return LambdaUtil.negate(FilteredLogSink.threadWhiteListPredicate(nameParts));
    }

    public static Predicate<LogSink.Message> threadPredicate(final Predicate<? super ThreadSnapshot> pred) {
        return new Predicate<LogSink.Message>(){

            @Override
            public boolean contains(LogSink.Message m) {
                return pred.contains(m.thread());
            }
        };
    }
}

