/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractKeyBasedMap;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.IterableCollection;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.iter.MappedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedMap<K, X, V>
extends AbstractKeyBasedMap<K, V>
implements Composite,
Serializable {
    private final Map<K, ? extends X> _map;
    private final Lambda<? super X, ? extends V> _lambda;

    public MappedMap(Map<K, ? extends X> map, Lambda<? super X, ? extends V> lambda) {
        this._map = map;
        this._lambda = lambda;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._map, this._lambda) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._map, this._lambda) + 1;
    }

    @Override
    public V get(Object key) {
        if (this._map.containsKey(key)) {
            return this._lambda.value(this._map.get(key));
        }
        return null;
    }

    @Override
    public PredicateSet<K> keySet() {
        return CollectUtil.asPredicateSet(this._map.keySet());
    }

    @Override
    public V remove(Object key) {
        if (this._map.containsKey(key)) {
            X resultX = this._map.remove(key);
            return this._lambda.value(resultX);
        }
        return null;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public Collection<V> values() {
        return new IterableCollection(new MappedIterable<X, V>(this._map.values(), this._lambda));
    }
}

