/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.util;

import edu.rice.cs.javalanglevels.util.ScrollableDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class Utilities {
    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        EventQueue.invokeLater(task);
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Utilities.clearEventQueue();
    }

    public static void clearEventQueue() {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
            }
        });
    }

    public static void show(final String msg) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new ScrollableDialog(null, "Debug Message", "Debug Message from Utilities.show():", msg, false).show();
            }
        });
    }

    public static void showDebug(String msg) {
        Utilities.showMessageBox(msg, "Debug Message");
    }

    public static void showMessageBox(final String msg, final String title) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new ScrollableDialog(null, title, "Message:", msg, false).show();
            }
        });
    }

    public static void showStackTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new ScrollableDialog(null, "Stack Trace", "Stack Trace:", Utilities.getStackTrace(t), false).show();
            }
        });
    }

    public static String getClipboardSelection(Component c) {
        Clipboard cb = c.getToolkit().getSystemClipboard();
        if (cb == null) {
            return null;
        }
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        String s = null;
        try {
            int ch;
            Reader r = DataFlavor.stringFlavor.getReaderForText(t);
            StringBuilder sb = new StringBuilder();
            while ((ch = r.read()) != -1) {
                sb.append((char)ch);
            }
            s = sb.toString();
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public static AbstractAction createDelegateAction(String newName, final Action delegate) {
        return new AbstractAction(newName){

            public void actionPerformed(ActionEvent ae) {
                delegate.actionPerformed(ae);
            }
        };
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String getStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceElement[] stes = e.getStackTrace();
            int skip = 1;
            for (StackTraceElement ste : stes) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                pw.print("at ");
                pw.println(ste);
            }
            return sw.toString();
        }
    }
}

