/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.AdvancedVisitor;
import edu.rice.cs.javalanglevels.Augmentor;
import edu.rice.cs.javalanglevels.ElementaryVisitor;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Options;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.parser.ParseException;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFAbstractVisitor;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.util.Log;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelConverter {
    public static final Log _log = new Log("LLConverter.txt", false);
    static Symboltable symbolTable = new Symboltable();
    public static Options OPT = Options.DEFAULT;
    private static final boolean SAFE_SUPPORT_CODE = false;
    public static final int INPUT_BUFFER_SIZE = 8192;
    public static final int LINE_NUM_MAPPINGS_PER_LINE = 8;
    private LinkedList<JExprParseException> _parseExceptions = new LinkedList();
    private LinkedList<Pair<String, JExpressionIF>> _visitorErrors = new LinkedList();

    private void _addParseException(ParseException pe) {
        JExprParseException jpe = pe instanceof JExprParseException ? (JExprParseException)pe : new JExprParseException(pe);
        this._parseExceptions.addLast(jpe);
    }

    private void _addVisitorError(Pair<String, JExpressionIF> ve) {
        this._visitorErrors.addLast(ve);
    }

    public Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> convert(File[] files, Options options) {
        Hashtable<File, Set<String>> sourceToTopLevelClassMap = new Hashtable<File, Set<String>>();
        return this.convert(files, options, sourceToTopLevelClassMap);
    }

    public Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> convert(File[] files, Options options, Map<File, Set<String>> sourceToTopLevelClassMap) {
        int ind;
        LanguageLevelVisitor llv;
        String firstLine;
        OPT = options;
        LanguageLevelVisitor.symbolTable = symbolTable = new Symboltable();
        LanguageLevelVisitor._newSDs = new Hashtable();
        LinkedList<Pair<String, JExpressionIF>> languageLevelVisitorErrors = new LinkedList<Pair<String, JExpressionIF>>();
        Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations = new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>();
        Hashtable<SymbolData, LanguageLevelVisitor> languageLevelNewSDs = new Hashtable<SymbolData, LanguageLevelVisitor>();
        LinkedList<Pair<LanguageLevelVisitor, SourceFile>> languageLevelVisitedFiles = new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>();
        Hashtable mediator = new Hashtable();
        LinkedList<File> filesNotToCheck = new LinkedList<File>();
        int originalNumOfFiles = files.length;
        LinkedList<Pair<ElementaryVisitor, SourceFile>> visited = new LinkedList<Pair<ElementaryVisitor, SourceFile>>();
        for (File f : files) {
            try {
                SourceFile sf;
                if (filesNotToCheck.contains(f)) continue;
                BufferedReader tempBr = new BufferedReader(new FileReader(f));
                firstLine = tempBr.readLine();
                tempBr.close();
                if (firstLine == null || !LanguageLevelConverter._isLanguageLevelFile(f)) continue;
                System.out.flush();
                JExprParser jep = new JExprParser(f);
                try {
                    sf = jep.SourceFile();
                    final HashSet topLevelClasses = new HashSet();
                    for (TypeDefBase t : sf.getTypes()) {
                        t.visit(new JExpressionIFAbstractVisitor<Void>(){

                            @Override
                            public Void forClassDef(ClassDef that) {
                                topLevelClasses.add(that.getName().getText());
                                return null;
                            }

                            @Override
                            public Void defaultCase(JExpressionIF that) {
                                return null;
                            }
                        });
                    }
                    sourceToTopLevelClassMap.put(f, topLevelClasses);
                }
                catch (ParseException pe) {
                    this._addParseException(pe);
                    _log.log("GENERATED ParseException for file " + f);
                    continue;
                }
                llv = null;
                if (LanguageLevelConverter.isElementaryFile(f)) {
                    llv = new ElementaryVisitor(f, new LinkedList<Pair<String, JExpressionIF>>(), symbolTable, new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles, languageLevelNewSDs);
                } else if (LanguageLevelConverter.isIntermediateFile(f)) {
                    llv = new IntermediateVisitor(f, new LinkedList<Pair<String, JExpressionIF>>(), symbolTable, new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles, languageLevelNewSDs);
                } else if (LanguageLevelConverter.isAdvancedFile(f)) {
                    llv = new AdvancedVisitor(f, new LinkedList<Pair<String, JExpressionIF>>(), symbolTable, new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles, languageLevelNewSDs);
                } else {
                    throw new RuntimeException("Internal Bug: Invalid file format not caught initially.  Please report this bug.");
                }
                sf.visit(llv);
                _log.log("\nDUMPING SYMBOLTABLE AFTER PHASE 1 PROCESSING OF " + f + "\n\n" + symbolTable + "\n");
                visited.add(new Pair<ElementaryVisitor, SourceFile>((ElementaryVisitor)llv, sf));
                _log.log("\nCONTINUATIONS AFTER PHASE 1 PROCESSING OF " + f + "\n\n" + LanguageLevelVisitor.continuations + "\n");
                _log.log("\nERRORS AFTER PHASE 1 PROCESSING OF " + f + "\n\n" + LanguageLevelVisitor.errors + "\n");
                continuations.putAll(LanguageLevelVisitor.continuations);
                languageLevelVisitorErrors.addAll(LanguageLevelVisitor.errors);
            }
            catch (IOException ioe) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ioe.getMessage(), new NullLiteral(JExprParser.NO_SOURCE_INFO)));
            }
        }
        LanguageLevelVisitor.errors = new LinkedList();
        _log.log("\nDUMPING SYMBOLTABLE BEFORE CONTINUATION RESOLUTION\n\n" + symbolTable + "\n");
        _log.log("Resolving continuations: " + continuations + "\n");
        while (!continuations.isEmpty()) {
            Enumeration en = continuations.keys();
            while (en.hasMoreElements()) {
                String className = (String)en.nextElement();
                Pair pair = (Pair)continuations.remove(className);
                SymbolData returnedSd = ((LanguageLevelVisitor)pair.getSecond()).getSymbolData(className, (SourceInfo)pair.getFirst(), true);
                _log.log("Attempting to resolve " + className + "\n  Result = " + returnedSd);
                if (returnedSd != null) continue;
                LanguageLevelVisitor.errors.add(new Pair<String, NullLiteral>("Converter could not resolve " + className, new NullLiteral((SourceInfo)pair.getFirst())));
            }
        }
        _log.log("\nDUMPING SYMBOLTABLE AFTER PASS 1\n\n" + symbolTable + "\n");
        Hashtable<SymbolData, LanguageLevelVisitor> newSDs = LanguageLevelVisitor._newSDs;
        Enumeration<SymbolData> keys = newSDs.keys();
        while (keys.hasMoreElements()) {
            SymbolData key = keys.nextElement();
            LanguageLevelVisitor sdlv = newSDs.get(key);
            if (sdlv == null) continue;
            sdlv.createConstructor(key);
        }
        assert (LanguageLevelVisitor._newSDs.isEmpty());
        languageLevelVisitorErrors.addAll(LanguageLevelVisitor.errors);
        if (languageLevelVisitorErrors.size() > 0) {
            this._visitorErrors.addAll(languageLevelVisitorErrors);
        } else {
            for (ind = 0; ind < visited.size(); ++ind) {
                LanguageLevelVisitor llv2 = (LanguageLevelVisitor)((Pair)visited.get(ind)).getFirst();
                SourceFile sf = (SourceFile)((Pair)visited.get(ind)).getSecond();
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Integer") == null) {
                    llv2.getSymbolData("java.lang.Integer", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Double") == null) {
                    llv2.getSymbolData("java.lang.Double", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Character") == null) {
                    llv2.getSymbolData("java.lang.Character", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Boolean") == null) {
                    llv2.getSymbolData("java.lang.Boolean", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Long") == null) {
                    llv2.getSymbolData("java.lang.Long", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Byte") == null) {
                    llv2.getSymbolData("java.lang.Byte", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Short") == null) {
                    llv2.getSymbolData("java.lang.Short", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Float") == null) {
                    llv2.getSymbolData("java.lang.Float", JExprParser.NO_SOURCE_INFO);
                }
                TypeChecker btc = new TypeChecker(llv2._file, llv2._package, LanguageLevelVisitor.errors, symbolTable, llv2._importedFiles, llv2._importedPackages);
                sf.visit(btc);
                if (TypeChecker.errors.size() <= 0) continue;
                this._visitorErrors.addAll(TypeChecker.errors);
            }
            Iterator iter = visited.iterator();
            LinkedList<File> newFiles = new LinkedList<File>();
            int ind2 = 0;
            while (iter.hasNext()) {
                Pair currPair = (Pair)iter.next();
                File fileToAdd = ((LanguageLevelVisitor)currPair.getFirst())._file;
                if (LanguageLevelConverter._isLanguageLevelFile(fileToAdd)) {
                    newFiles.addLast(fileToAdd);
                    mediator.put(ind2, new Pair(currPair.getSecond(), currPair.getFirst()));
                }
                if (!filesNotToCheck.contains(fileToAdd)) {
                    filesNotToCheck.addLast(fileToAdd);
                }
                ++ind2;
            }
            files = newFiles.toArray(new File[newFiles.size()]);
        }
        if (this._parseExceptions.size() > 0 || this._visitorErrors.size() > 0) {
            return new Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>>(this._parseExceptions, this._visitorErrors);
        }
        for (ind = 0; ind < files.length; ++ind) {
            File f;
            f = files[ind];
            try {
                BufferedReader tempBr = new BufferedReader(new FileReader(f));
                firstLine = tempBr.readLine();
                tempBr.close();
                if (firstLine == null || !LanguageLevelConverter._isLanguageLevelFile(f)) continue;
                Pair pair = (Pair)mediator.get(new Integer(ind));
                if (pair == null) {
                    // empty if block
                }
                if (pair == null) continue;
                SourceFile sf = (SourceFile)pair.getFirst();
                llv = (LanguageLevelVisitor)pair.getSecond();
                String augmentedFilePath = f.getAbsolutePath();
                augmentedFilePath = augmentedFilePath.substring(0, augmentedFilePath.length() - 4);
                File augmentedFile = new File(augmentedFilePath + ".java");
                BufferedReader br = new BufferedReader(new FileReader(f), 8192);
                StringWriter sw = new StringWriter();
                BufferedWriter bw = new BufferedWriter(sw);
                Augmentor a = new Augmentor(false, br, bw, llv);
                sf.visit(a);
                br.close();
                bw.close();
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(augmentedFile)));
                SortedMap<Integer, Integer> lineNumberMap = a.getLineNumberMap();
                pw.println("// Language Level Converter line number map: dj*->java. Entries: " + lineNumberMap.size());
                int numLines = (int)Math.ceil((double)lineNumberMap.size() / 8.0);
                int mapCount = 0;
                for (Map.Entry<Integer, Integer> e : lineNumberMap.entrySet()) {
                    if (mapCount % 8 == 0) {
                        pw.print("//");
                    }
                    pw.printf(" %5d->%-5d", e.getKey(), e.getValue() + numLines + 1);
                    if (mapCount % 8 == 7) {
                        pw.println();
                    }
                    ++mapCount;
                }
                if (mapCount % 8 != 0) {
                    pw.println();
                }
                String augmented = sw.toString();
                pw.write(augmented, 0, augmented.length());
                pw.close();
                continue;
            }
            catch (Augmentor.Exception ae) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ae.getMessage(), new NullLiteral(JExprParser.NO_SOURCE_INFO)));
                continue;
            }
            catch (IOException ioe) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ioe.getMessage(), new NullLiteral(JExprParser.NO_SOURCE_INFO)));
            }
        }
        return new Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>>(this._parseExceptions, this._visitorErrors);
    }

    public static boolean isElementaryFile(File f) {
        return f.getPath().endsWith(".dj0");
    }

    public static boolean isIntermediateFile(File f) {
        return f.getPath().endsWith(".dj1");
    }

    public static boolean isAdvancedFile(File f) {
        return f.getPath().endsWith(".dj2");
    }

    public static boolean _isLanguageLevelFile(File f) {
        return LanguageLevelConverter.isElementaryFile(f) || LanguageLevelConverter.isIntermediateFile(f) || LanguageLevelConverter.isAdvancedFile(f);
    }

    public static boolean versionSupportsAutoboxing(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionSupportsGenerics(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionSupportsForEach(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionIs15(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static void main(String[] args) {
        LanguageLevelConverter llc = new LanguageLevelConverter();
        File[] files = new File[args.length];
        for (int i = 0; i < args.length; ++i) {
            files[i] = new File(args[i]);
        }
        Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> result = llc.convert(files, new Options(JavaVersion.JAVA_5, IterUtil.empty()));
        System.out.println(result.getFirst().size() + result.getSecond().size() + " errors.");
        for (JExprParseException jExprParseException : result.getFirst()) {
            System.out.println(jExprParseException);
        }
        for (Pair pair : result.getSecond()) {
            System.out.println((String)pair.getFirst() + " " + ((JExpressionIF)pair.getSecond()).getSourceInfo());
        }
    }
}

