/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ClassBodyElementaryVisitor;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ArrayType;
import edu.rice.cs.javalanglevels.tree.BreakStatement;
import edu.rice.cs.javalanglevels.tree.CastExpression;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ConditionalExpression;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.ContinueStatement;
import edu.rice.cs.javalanglevels.tree.DoStatement;
import edu.rice.cs.javalanglevels.tree.ForStatement;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.ImportStatement;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InstanceofExpression;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.LabeledStatement;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.PrimitiveType;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.StaticInitializer;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.SynchronizedStatement;
import edu.rice.cs.javalanglevels.tree.ThrowStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import edu.rice.cs.javalanglevels.tree.WhileStatement;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementaryVisitor
extends LanguageLevelVisitor {
    public ElementaryVisitor(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
    }

    public ElementaryVisitor(File file) {
        this(file, new LinkedList<Pair<String, JExpressionIF>>(), new Symboltable(), new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>(), new Hashtable<SymbolData, LanguageLevelVisitor>());
    }

    public ElementaryVisitor(File file, LinkedList<Pair<String, JExpressionIF>> errors, Symboltable symbolTable, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations, LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles, Hashtable<SymbolData, LanguageLevelVisitor> newSDs) {
        super(file, "", new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), continuations);
        ElementaryVisitor.errors = errors;
        ElementaryVisitor.symbolTable = symbolTable;
        ElementaryVisitor.visitedFiles = visitedFiles;
        _newSDs = newSDs;
        _hierarchy = new Hashtable();
    }

    @Override
    protected SymbolData getSymbolData(String className, SourceInfo si, boolean resolve, boolean fromClassFile) {
        if (className.indexOf(".") != -1 && !fromClassFile) {
            ElementaryVisitor._addAndIgnoreError("Class names should not contain \".\" at the Elementary level", new NullLiteral(si));
            return null;
        }
        return super.getSymbolDataHelper(className, si, resolve, fromClassFile, true, false);
    }

    @Override
    protected VariableData[] _variableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        VariableData[] vds = super._variableDeclaration2VariableData(vd, enclosingData);
        for (int i = 0; i < vds.length; ++i) {
            vds[i].setPrivateAndFinal();
        }
        return vds;
    }

    protected VariableData[] llVariableDeclaration2VariableData(VariableDeclaration vd, Data enclosingData) {
        return super._variableDeclaration2VariableData(vd, enclosingData);
    }

    @Override
    public Void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        String temp;
        String[] modifiersAndVisibility = that.getModifiers();
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (int i = 0; i < modifiersAndVisibility.length; ++i) {
            temp = modifiersAndVisibility[i];
            if (temp.equals("abstract")) continue;
            sb.append(" \"" + temp + "\"");
            ++count;
        }
        temp = "The keyword";
        if (sb.length() > 0) {
            if (count > 1) {
                temp = temp + "s";
            }
            ElementaryVisitor._addAndIgnoreError(temp + sb.toString() + " cannot be used at the Elementary level", that);
            return null;
        }
        return super.forModifiersAndVisibilityDoFirst(that);
    }

    @Override
    public Void forClassDefDoFirst(ClassDef that) {
        if (that.getInterfaces().length > 0) {
            ElementaryVisitor._addAndIgnoreError("The keyword \"implements\" cannot be used at the Elementary level", that);
        }
        SymbolData javaLangClass = this.getSymbolData("java.lang." + that.getName().getText(), that.getSourceInfo(), true, false, false, false);
        if (that.getName().getText().equals("TestCase") || javaLangClass != null && !javaLangClass.isContinuation()) {
            ElementaryVisitor._addError("You cannot define a class with the name " + that.getName().getText() + " at the Elementary Level, because that class name is reserved." + "  Please choose a different name for this class", that);
        }
        return super.forClassDefDoFirst(that);
    }

    @Override
    public Void forInnerClassDefDoFirst(InnerClassDef that) {
        ElementaryVisitor._addError("You cannot define classes inside of other classes at the Elementary level", that);
        return null;
    }

    @Override
    public Void forInterfaceDefDoFirst(InterfaceDef that) {
        ElementaryVisitor._addError("Interfaces cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forConstructorDefDoFirst(ConstructorDef that) {
        ElementaryVisitor._addError("All methods must have a return type and a name at the Elementary level", that);
        return null;
    }

    @Override
    public Void forStaticInitializerDoFirst(StaticInitializer that) {
        ElementaryVisitor._addError("Static initializers cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forPackageStatementDoFirst(PackageStatement that) {
        ElementaryVisitor._addError("Package statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forImportStatementDoFirst(ImportStatement that) {
        ElementaryVisitor._addError("Import statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forLabeledStatementDoFirst(LabeledStatement that) {
        ElementaryVisitor._addError("Labeled statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forSwitchStatementDoFirst(SwitchStatement that) {
        ElementaryVisitor._addError("Switch statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forWhileStatementDoFirst(WhileStatement that) {
        ElementaryVisitor._addError("While statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forDoStatementDoFirst(DoStatement that) {
        ElementaryVisitor._addError("Do statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forForStatementDoFirst(ForStatement that) {
        ElementaryVisitor._addError("For statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forBreakStatementDoFirst(BreakStatement that) {
        ElementaryVisitor._addError("Break statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forContinueStatementDoFirst(ContinueStatement that) {
        ElementaryVisitor._addError("Continue statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forThrowStatementDoFirst(ThrowStatement that) {
        ElementaryVisitor._addError("Throw statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forSynchronizedStatementDoFirst(SynchronizedStatement that) {
        ElementaryVisitor._addError("Synchronized statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forTryCatchStatementDoFirst(TryCatchStatement that) {
        ElementaryVisitor._addError("Try-catch statements cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forFormalParameterDoFirst(FormalParameter that) {
        if (that.isIsFinal()) {
            ElementaryVisitor._addError("The keyword \"final\" cannot be used at the Elementary level", that);
            return null;
        }
        return super.forFormalParameterDoFirst(that);
    }

    @Override
    public Void forTypeParameterDoFirst(TypeParameter that) {
        ElementaryVisitor._addError("Type Parameters cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forPrimitiveTypeDoFirst(PrimitiveType that) {
        String name = that.getName();
        if (!(name.equals("int") || name.equals("double") || name.equals("boolean") || name.equals("char"))) {
            ElementaryVisitor._addError("Only the primitive types \"int\", \"double\", \"boolean\", and \"char\" can be used at the Elementary level", that);
        }
        return null;
    }

    @Override
    public Void forArrayTypeDoFirst(ArrayType that) {
        ElementaryVisitor._addError("Arrays cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forConditionalExpressionDoFirst(ConditionalExpression that) {
        ElementaryVisitor._addError("Conditional expressions cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forInstanceofExpressionDoFirst(InstanceofExpression that) {
        ElementaryVisitor._addError("Instanceof cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forCastExpressionDoFirst(CastExpression that) {
        ElementaryVisitor._addError("Cast expressions cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forAnonymousClassInstantiationDoFirst(AnonymousClassInstantiation that) {
        ElementaryVisitor._addError("Anonymous inner classes cannot be used at the Elementary level", that);
        return null;
    }

    @Override
    public Void forNullLiteralDoFirst(NullLiteral that) {
        ElementaryVisitor._addError("Null cannot be used at the Elementary level", that);
        return null;
    }

    private boolean _isClassInCurrentFile(String className) {
        for (String s : this._classNamesInThisFile) {
            if (!s.equals(className) && !s.endsWith("." + className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void forClassDef(ClassDef that) {
        int i;
        this.forClassDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        boolean isTestCase = false;
        String className = this.getQualifiedClassName(that.getName().getText());
        String superName = that.getSuperclass().getName();
        if (superName.equals("TestCase") || superName.equals("junit.framework.TestCase")) {
            isTestCase = true;
            if (!this._importedPackages.contains("junit.framework")) {
                this._importedPackages.addFirst("junit.framework");
            }
            this.getSymbolData("junit.framework.TestCase", that.getSourceInfo(), true, false, true, false);
        }
        SymbolData sd = this.addSymbolData(that, className);
        that.getMav().visit(this);
        that.getName().visit(this);
        that.getSuperclass().visit(this);
        if (sd == null) {
            return null;
        }
        if (isTestCase) {
            sd.addModifier("public");
        }
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        if (sd != null) {
            that.getBody().visit(new ClassBodyElementaryVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
            ElementaryVisitor.createAccessors(sd, this._file);
            this.createToString(sd);
            this.createHashCode(sd);
            this.createEquals(sd);
        }
        this.forClassDefOnly(that);
        this._classesToBeParsed.remove(className);
        return null;
    }

    static /* synthetic */ boolean access$000(ElementaryVisitor x0, String x1) {
        return x0._isClassInCurrentFile(x1);
    }
}

