/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFDepthFirstVisitor;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Augmentor
extends JExpressionIFDepthFirstVisitor<Void> {
    private static final String newLine = System.getProperty("line.separator");
    private static final int indentWidth = 2;
    private static BufferedReader _fileIn;
    private static int _fileInLine;
    private static int _fileInColumn;
    private static BufferedWriter _fileOut;
    private static int _fileOutLine;
    private static int _fileOutCorrespondingLine;
    private static TreeMap<Integer, Integer> _lineNumberMap;
    private static LanguageLevelVisitor _llv;
    private static boolean _safeSupportCode;
    private static List<String> _endOfClassVarDefs;
    private Data _enclosingData;

    public Augmentor(boolean safeSupportCode, BufferedReader fileIn, BufferedWriter fileOut, LanguageLevelVisitor llv) {
        _fileIn = fileIn;
        _fileInLine = 1;
        _fileInColumn = 1;
        _fileOut = fileOut;
        _fileOutLine = 1;
        _fileOutCorrespondingLine = 1;
        _lineNumberMap = new TreeMap();
        _llv = llv;
        _safeSupportCode = safeSupportCode;
        _endOfClassVarDefs = new LinkedList<String>();
        this._enclosingData = null;
    }

    protected Augmentor(Data d) {
        this._enclosingData = d;
    }

    @Override
    protected Void defaultCase(JExpressionIF that) {
        return null;
    }

    protected Void[] makeArrayOfRetType(int len) {
        return new Void[len];
    }

    protected void augmentVariableDeclarationModifiers(VariableDeclaration that) {
        String variableDeclarationModifiers = "";
        if (Augmentor._isElementaryFile()) {
            variableDeclarationModifiers = "private final ";
        } else if (Augmentor._isIntermediateFile()) {
            variableDeclarationModifiers = "private final ";
            String[] mavs = that.getMav().getModifiers();
            for (int i = 0; i < mavs.length; ++i) {
                if (!mavs[i].equals("static")) continue;
                variableDeclarationModifiers = "public final ";
                break;
            }
        }
        Augmentor._writeToFileOut(variableDeclarationModifiers);
    }

    @Override
    public Void forVariableDeclaration(VariableDeclaration that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        this.augmentVariableDeclarationModifiers(that);
        super.forVariableDeclaration(that);
        return null;
    }

    @Override
    public Void forFormalParameter(FormalParameter that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        if (Augmentor._isElementaryFile() || Augmentor._isIntermediateFile()) {
            Augmentor._writeToFileOut("final ");
        }
        return null;
    }

    @Override
    public Void forConstructorDef(ConstructorDef that) {
        Augmentor._readAndWriteThroughIndex(that.getSourceInfo().getStartLine(), that.getSourceInfo().getStartColumn() - 1);
        if (Augmentor._isIntermediateFile()) {
            String[] modifiers = that.getMav().getModifiers();
            boolean hasVisibilityModifier = false;
            for (int i = 0; i < modifiers.length; ++i) {
                if (!modifiers[i].equals("private") && !modifiers[i].equals("public") && !modifiers[i].equals("protected")) continue;
                hasVisibilityModifier = true;
                break;
            }
            if (!hasVisibilityModifier) {
                Augmentor._writeToFileOut("public ");
            }
        }
        for (FormalParameter fp : that.getParameters()) {
            fp.visit(this);
        }
        return null;
    }

    public Void forMethodDef(MethodDef that) {
        SourceInfo mdSourceInfo = that.getSourceInfo();
        Augmentor._readAndWriteThroughIndex(mdSourceInfo.getStartLine(), mdSourceInfo.getStartColumn() - 1);
        if (Augmentor._isElementaryFile()) {
            Augmentor._writeToFileOut("public ");
        }
        if (Augmentor._isIntermediateFile()) {
            String[] modifiers = that.getMav().getModifiers();
            String visibilityModifier = null;
            for (int i = 0; i < modifiers.length; ++i) {
                if (!modifiers[i].equals("private") && !modifiers[i].equals("public") && !modifiers[i].equals("protected")) continue;
                visibilityModifier = modifiers[i];
                break;
            }
            if (visibilityModifier == null) {
                Augmentor._writeToFileOut("public ");
            }
        }
        for (FormalParameter fp : that.getParams()) {
            fp.visit(this);
        }
        return null;
    }

    @Override
    public Void forAbstractMethodDef(AbstractMethodDef md) {
        this.forMethodDef(md);
        return null;
    }

    @Override
    public Void forConcreteMethodDef(ConcreteMethodDef that) {
        this.forMethodDef(that);
        MethodData md = this._enclosingData.getSymbolData().getMethod(that.getName().getText(), Augmentor.formalParameters2TypeDatas(that.getParams(), this._enclosingData));
        if (md == null) {
            throw new RuntimeException("Internal Program Error: Can't find method data for " + that.getName() + " Please report this bug.");
        }
        that.getBody().visit(new MethodBodyAugmentor(md));
        return null;
    }

    @Override
    public Void forClassDef(ClassDef cd) {
        String className = cd.getName().getText();
        SymbolData sd = LanguageLevelVisitor.symbolTable.get(_llv.getQualifiedClassName(className));
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Can't find SymbolData for " + cd.getName().getText() + " Please report this bug.");
        }
        ModifiersAndVisibility m = cd.getMav();
        if (Augmentor._isElementaryFile() && sd.hasModifier("public")) {
            Augmentor._readAndWriteThroughIndex(m.getSourceInfo().getStartLine(), m.getSourceInfo().getStartColumn() - 1);
            Augmentor._writeToFileOut("public ");
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        int baseIndent = cd.getSourceInfo().getStartColumn() - 1;
        className = LanguageLevelVisitor.getUnqualifiedClassName(sd.getName());
        Augmentor._readAndWriteThroughIndex(cd.getSourceInfo().getEndLine(), cd.getSourceInfo().getEndColumn() - 1);
        if (Augmentor._isElementaryFile() || Augmentor._isIntermediateFile()) {
            Augmentor.writeConstructor(className, sd, baseIndent);
            Augmentor.writeAccessors(sd, baseIndent);
            String valueToStringName = Augmentor.writeValueToString(sd, baseIndent);
            String valueEqualsName = Augmentor.writeValueEquals(sd, baseIndent);
            String valueHashCodeName = Augmentor.writeValueHashCode(sd, baseIndent, valueEqualsName);
            Augmentor.writeToString(sd, baseIndent, valueToStringName);
            Augmentor.writeEquals(className, sd, baseIndent, valueEqualsName);
            Augmentor.writeHashCode(className, sd, baseIndent, false, valueHashCodeName);
            for (String s : _endOfClassVarDefs) {
                Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + s);
            }
            if (_endOfClassVarDefs.size() > 0) {
                Augmentor._writeToFileOut(newLine);
                _endOfClassVarDefs.clear();
            }
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 0));
        }
        return null;
    }

    @Override
    public Void forInnerClassDef(InnerClassDef cd) {
        String className = cd.getName().getText();
        if (this._enclosingData == null) {
            throw new RuntimeException("Internal Program Error: Enclosing Data is null.  Please report this bug.");
        }
        SymbolData sd = this._enclosingData.getInnerClassOrInterface(className);
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Can't find SymbolData for " + cd.getName().getText() + ". Please report this bug.");
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        Augmentor._readAndWriteThroughIndex(cd.getSourceInfo().getEndLine(), cd.getSourceInfo().getEndColumn() - 1);
        return null;
    }

    @Override
    public Void forInterfaceDef(InterfaceDef cd) {
        String interfaceName = cd.getName().getText();
        SymbolData sd = LanguageLevelVisitor.symbolTable.get(_llv.getQualifiedClassName(interfaceName));
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Can't find SymbolData for " + cd.getName().getText() + ".  Please report this bug.");
        }
        ModifiersAndVisibility m = cd.getMav();
        if (Augmentor._isElementaryFile()) {
            Augmentor._readAndWriteThroughIndex(m.getSourceInfo().getStartLine(), m.getSourceInfo().getStartColumn() - 1);
            Augmentor._writeToFileOut("public ");
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        int baseIndent = cd.getSourceInfo().getStartColumn() - 1;
        Augmentor._readAndWriteThroughIndex(cd.getSourceInfo().getEndLine(), cd.getSourceInfo().getEndColumn() - 1);
        for (String s : _endOfClassVarDefs) {
            Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + s);
        }
        if (_endOfClassVarDefs.size() > 0) {
            Augmentor._writeToFileOut(newLine);
            _endOfClassVarDefs.clear();
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 0));
        return null;
    }

    @Override
    public Void forInnerInterfaceDef(InnerInterfaceDef cd) {
        String interfaceName = cd.getName().getText();
        if (this._enclosingData == null) {
            throw new RuntimeException("Internal Program Error: Enclosing Data is null.  Please report this bug.");
        }
        SymbolData sd = this._enclosingData.getInnerClassOrInterface(interfaceName);
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Can't find SymbolData for " + cd.getName().getText() + ". Please report this bug.");
        }
        BracedBody bb = cd.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        return null;
    }

    public Void forAnonymousClassInstantiation(AnonymousClassInstantiation e) {
        SymbolData sd = this._enclosingData.getNextAnonymousInnerClass();
        if (sd == null) {
            throw new RuntimeException("Internal Program Error: Couldn't find the SymbolData for the anonymous inner class.  Please report this bug.");
        }
        BracedBody bb = e.getBody();
        sd.setAnonymousInnerClassNum(0);
        bb.visit(new Augmentor(sd));
        int baseIndent = e.getSourceInfo().getStartColumn() - 1;
        Augmentor._readAndWriteThroughIndex(e.getSourceInfo().getEndLine(), e.getSourceInfo().getEndColumn() - 1);
        if (Augmentor._isElementaryFile() || Augmentor._isIntermediateFile()) {
            String className = Data.dollarSignsToDots(e.getType().getName());
            Augmentor.writeAccessors(sd, baseIndent);
            String valueToStringName = Augmentor.writeValueToString(sd, baseIndent);
            String valueEqualsName = Augmentor.writeValueEquals(sd, baseIndent);
            String valueHashCodeName = Augmentor.writeValueHashCode(sd, baseIndent, valueEqualsName);
            Augmentor.writeToString(sd, baseIndent, valueToStringName);
            if (!_safeSupportCode) {
                Augmentor.writeAnonEquals(baseIndent);
            } else {
                Augmentor.writeEquals(className, sd, baseIndent, valueEqualsName);
            }
            Augmentor.writeHashCode(className, sd, baseIndent, true, valueHashCodeName);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 0));
        }
        return null;
    }

    @Override
    public Void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation e) {
        this.forAnonymousClassInstantiation(e);
        return null;
    }

    @Override
    public Void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation e) {
        e.getEnclosing().visit(this);
        this.forAnonymousClassInstantiation(e);
        return null;
    }

    @Override
    public Void forSourceFile(SourceFile sf) {
        TypeDefBase[] cds = sf.getTypes();
        if (Augmentor._isElementaryFile() && Augmentor._llv._importedPackages.contains("junit.framework")) {
            Augmentor._writeToFileOut("import junit.framework.*;" + newLine);
        }
        for (TypeDefBase cd : cds) {
            cd.visit(this);
        }
        String remainder = Augmentor._readThroughIndex(sf.getSourceInfo().getEndLine(), sf.getSourceInfo().getEndColumn());
        if (!remainder.endsWith(newLine)) {
            remainder = remainder + newLine;
        }
        Augmentor._writeToFileOut(remainder, true);
        return null;
    }

    protected static TypeData[] formalParameters2TypeDatas(FormalParameter[] fp, Data enclosing) {
        TypeData[] tds = new TypeData[fp.length];
        for (int j = 0; j < fp.length; ++j) {
            SymbolData type = _llv.getSymbolData(fp[j].getDeclarator().getType().getName(), fp[j].getSourceInfo());
            if (type == null) {
                type = enclosing.getInnerClassOrInterface(fp[j].getDeclarator().getType().getName());
            }
            tds[j] = type;
        }
        return tds;
    }

    protected static void writeConstructor(String className, SymbolData sd, int baseIndent) {
        MethodData constructor = null;
        for (MethodData currMd : sd.getMethods()) {
            if (!currMd.getName().equals(LanguageLevelVisitor.getUnqualifiedClassName(sd.getName())) || !currMd.isGenerated()) continue;
            constructor = currMd;
            break;
        }
        if (constructor == null) {
            return;
        }
        VariableData[] constructorParams = constructor.getParams();
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public " + className + "(");
        for (int q = 0; q < constructorParams.length; ++q) {
            if (q > 0) {
                Augmentor._writeToFileOut(", ");
            }
            VariableData vd = constructorParams[q];
            Augmentor._writeToFileOut(Data.dollarSignsToDots(vd.getType().getName()) + " " + vd.getName());
        }
        Augmentor._writeToFileOut(") {" + newLine);
        LinkedList<VariableData> superParams = new LinkedList<VariableData>();
        LinkedList<VariableData> localParams = new LinkedList<VariableData>();
        LinkedList<VariableData> localFields = sd.getVars();
        for (VariableData param : constructorParams) {
            boolean hasLocalField = false;
            for (VariableData field : localFields) {
                if (!(hasLocalField = hasLocalField || field.getName().equals(param.getName()))) continue;
                break;
            }
            if (hasLocalField) {
                localParams.add(param);
                continue;
            }
            if (param.getName().startsWith("super_")) {
                superParams.add(param);
                continue;
            }
            throw new RuntimeException("Internal Program Error: Unexpected parameter name in generated constructor: " + param.getName() + ".  Please report this bug");
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "super(");
        for (int z = 0; z < superParams.size(); ++z) {
            if (z > 0) {
                Augmentor._writeToFileOut(", ");
            }
            Augmentor._writeToFileOut(((VariableData)superParams.get(z)).getName());
        }
        Augmentor._writeToFileOut(");" + newLine);
        for (int i = 0; i < localParams.size(); ++i) {
            String varName = ((VariableData)localParams.get(i)).getName();
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "this." + varName + " = " + varName + ";" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeAccessors(SymbolData sd, int baseIndent) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData accessor = null;
        Iterator iter = methods.iterator();
        VariableData[] vars = sd.getVars().toArray(new VariableData[sd.getVars().size()]);
        for (int i = 0; i < vars.length; ++i) {
            accessor = null;
            for (MethodData currMd : methods) {
                if (!currMd.getName().equals(vars[i].getName()) || !currMd.isGenerated()) continue;
                accessor = currMd;
                break;
            }
            if (accessor == null) continue;
            Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public " + Data.dollarSignsToDots(vars[i].getType().getName()) + " " + LanguageLevelVisitor.getFieldAccessorName(vars[i].getName()) + "() {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "return " + vars[i].getName() + ";" + newLine + Augmentor.indentString(baseIndent, 1) + "}" + newLine);
        }
    }

    protected static void writeToString(SymbolData sd, int baseIndent, String valueToStringName) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData toString = null;
        for (MethodData currMd : methods) {
            if (!currMd.getName().equals("toString") || !currMd.isGenerated()) continue;
            toString = currMd;
            break;
        }
        if (toString == null) {
            return;
        }
        LinkedList<MethodData> allMds = Augmentor._getVariableAccessorListHelper(sd);
        MethodData[] mds = allMds.toArray(new MethodData[allMds.size()]);
        if (_safeSupportCode) {
            Augmentor.writeSafeToString(sd, baseIndent, valueToStringName, mds);
        } else {
            Augmentor.writeSimpleToString(sd, baseIndent, valueToStringName, mds);
        }
    }

    protected static void writeSafeToString(SymbolData sd, int baseIndent, String valueToStringName, MethodData[] accessors) {
        String flagName = sd.createUniqueName("__toStringFlag");
        VariableData toStringFlag = new VariableData(flagName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"private", "static"}), _llv.getSymbolDataHelper("java.util.LinkedList", JExprParser.NO_SOURCE_INFO, false, false, false, false), true, sd);
        toStringFlag.setGenerated(true);
        sd.addVar(toStringFlag);
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This field is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private boolean " + flagName + " = false;" + newLine);
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public java.lang.String toString() {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (" + flagName + ") {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return getClass().getName() + \"(...)\";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + flagName + " = true;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "String result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "try {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "result = getClass().getName() + \"(\" + " + newLine);
        for (int i = 0; i < accessors.length; ++i) {
            if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5) || !accessors[i].getReturnType().getSymbolData().isPrimitiveType()) {
                Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + valueToStringName + "(" + accessors[i].getName() + "()) + ");
            } else {
                Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + accessors[i].getName() + "() + ");
            }
            if (i < accessors.length - 1) {
                Augmentor._writeToFileOut("\", \" + ");
            }
            Augmentor._writeToFileOut(newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "\")\";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "catch (RuntimeException e) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + flagName + " = false;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "throw e;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + flagName + " = false;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeSimpleToString(SymbolData sd, int baseIndent, String valueToStringName, MethodData[] accessors) {
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public java.lang.String toString() {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "return getClass().getName() + \"(\" + " + newLine);
        for (int i = 0; i < accessors.length; ++i) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + accessors[i].getName() + "() + ");
            if (i < accessors.length - 1) {
                Augmentor._writeToFileOut("\", \" + ");
            }
            Augmentor._writeToFileOut(newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "\")\";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeEquals(String className, SymbolData sd, int baseIndent, String valueEqualsName) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData equals = null;
        for (MethodData currMd : methods) {
            if (!currMd.getName().equals("equals") || !currMd.isGenerated()) continue;
            equals = currMd;
            break;
        }
        if (equals == null) {
            return;
        }
        LinkedList<MethodData> allMds = Augmentor._getVariableAccessorListHelper(sd);
        MethodData[] mds = allMds.toArray(new MethodData[allMds.size()]);
        if (_safeSupportCode) {
            Augmentor.writeSafeEquals(className, sd, baseIndent, valueEqualsName, mds);
        } else {
            Augmentor.writeSimpleEquals(className, sd, baseIndent, valueEqualsName, mds);
        }
    }

    protected static void writeSafeEquals(String className, SymbolData sd, int baseIndent, String valueEqualsName, MethodData[] accessors) {
        String listName = sd.createUniqueName("__equalsList");
        VariableData equalsList = new VariableData(listName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"private", "static"}), _llv.getSymbolDataHelper("java.util.LinkedList", JExprParser.NO_SOURCE_INFO, false, false, false, false), true, sd);
        equalsList.setGenerated(true);
        sd.addVar(equalsList);
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This field is automatically generated by the Language Level Converter. */");
        if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5)) {
            Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "private java.util.LinkedList<" + className + "> " + listName + " = new java.util.LinkedList<" + className + ">();" + newLine);
        } else {
            Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "private java.util.LinkedList " + listName + " = new java.util.LinkedList();" + newLine + newLine);
        }
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public boolean equals(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (this == o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return true;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if ((o == null) || (! o.getClass().equals(getClass()))) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return false;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "boolean alreadyTested = false;" + newLine);
        if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5)) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "for (" + className + " element : " + listName + ")" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "alreadyTested = alreadyTested || (o == element);" + newLine + newLine);
        } else {
            if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5)) {
                Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "java.util.Iterator<" + className + "> i = " + listName + ".iterator();" + newLine);
            } else {
                Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "java.util.Iterator i = " + listName + ".iterator();" + newLine);
            }
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "while (!alreadyTested && i.hasNext())" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "alreadyTested = alreadyTested || (o == i.next());" + newLine + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "if (alreadyTested) { " + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "return true;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + className + " cast = ((" + className + ") o);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + listName + ".addLast(cast);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "boolean result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "try {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "result = ");
        int variablesCompared = 0;
        for (int i = 0; i < accessors.length; ++i) {
            if (variablesCompared > 0) {
                Augmentor._writeToFileOut(" && " + newLine + Augmentor.indentString(baseIndent, 7));
            }
            ++variablesCompared;
            String varName = accessors[i].getName() + "()";
            if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5) || !accessors[i].getReturnType().getSymbolData().isPrimitiveType()) {
                Augmentor._writeToFileOut(valueEqualsName + "(" + varName + ", cast." + varName + ")");
                continue;
            }
            Augmentor._writeToFileOut("(" + varName + " == cast." + varName + ")");
        }
        if (variablesCompared == 0) {
            Augmentor._writeToFileOut("true");
        }
        Augmentor._writeToFileOut(";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "catch (RuntimeException e) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + listName + ".removeLast();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "throw e;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + listName + ".removeLast();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "return result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeSimpleEquals(String className, SymbolData sd, int baseIndent, String valueEqualsName, MethodData[] accessors) {
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public boolean equals(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (this == o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return true;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if ((o == null) || (! o.getClass().equals(getClass()))) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return false;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + className + " cast = ((" + className + ") o);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return ");
        int variablesCompared = 0;
        for (int i = 0; i < accessors.length; ++i) {
            if (variablesCompared > 0) {
                Augmentor._writeToFileOut(" && " + newLine + Augmentor.indentString(baseIndent, 5));
            }
            ++variablesCompared;
            String varName = accessors[i].getName() + "()";
            if (!accessors[i].getReturnType().getSymbolData().isPrimitiveType()) {
                Augmentor._writeToFileOut("(" + varName + " != null && " + varName + ".equals(cast." + varName + "))");
                continue;
            }
            Augmentor._writeToFileOut("(" + varName + " == cast." + varName + ")");
        }
        if (variablesCompared == 0) {
            Augmentor._writeToFileOut("true");
        }
        Augmentor._writeToFileOut(";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeAnonEquals(int baseIndent) {
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "public boolean equals(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "return (this == o);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeHashCode(String className, SymbolData sd, int baseIndent, boolean waitForVarDef, String valueHashCodeName) {
        LinkedList<MethodData> methods = sd.getMethods();
        MethodData hashCode = null;
        for (MethodData currMd : methods) {
            if (!currMd.getName().equals("hashCode") || !currMd.isGenerated()) continue;
            hashCode = currMd;
            break;
        }
        if (hashCode == null) {
            return;
        }
        LinkedList<MethodData> allMds = Augmentor._getVariableAccessorListHelper(sd);
        MethodData[] mds = allMds.toArray(new MethodData[allMds.size()]);
        if (_safeSupportCode) {
            Augmentor.writeSafeHashCode(className, sd, baseIndent, waitForVarDef, valueHashCodeName, mds);
        } else {
            Augmentor.writeSimpleHashCode(className, sd, baseIndent, waitForVarDef, valueHashCodeName, mds);
        }
    }

    protected static void writeSafeHashCode(String className, SymbolData sd, int baseIndent, boolean waitForVarDef, String valueHashCodeName, MethodData[] accessors) {
        String listName = "__hashCodeList";
        listName = sd.createUniqueName(listName);
        VariableData hashCodeList = new VariableData(listName, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"private", "static"}), _llv.getSymbolDataHelper("java.util.LinkedList", JExprParser.NO_SOURCE_INFO, false, false, false, false), true, sd);
        hashCodeList.setGenerated(true);
        if (waitForVarDef) {
            SymbolData outermostData = sd;
            while (outermostData.getOuterData() != null) {
                outermostData = outermostData.getOuterData().getSymbolData();
            }
            outermostData.addVar(hashCodeList);
            _endOfClassVarDefs.add("/** This field is automatically generated by the Language Level Converter. */");
            if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5)) {
                _endOfClassVarDefs.add("private static java.util.LinkedList<Object> " + listName + " = new java.util.LinkedList<Object>();");
            } else {
                _endOfClassVarDefs.add("private static java.util.LinkedList " + listName + " = new java.util.LinkedList();");
            }
            _endOfClassVarDefs.add("");
        } else {
            sd.addVar(hashCodeList);
            Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This field is automatically generated by the Language Level Converter. */");
            if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5)) {
                Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "private static java.util.LinkedList<" + className + "> " + listName + " = new java.util.LinkedList<" + className + ">();" + newLine);
            } else {
                Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "private static java.util.LinkedList " + listName + " = new java.util.LinkedList();" + newLine);
            }
        }
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */");
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "public int hashCode() {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (" + listName + ".contains(this)) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return -1;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + listName + ".addLast(this);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "int result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "try {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "result = getClass().hashCode()");
        for (int i = 0; i < accessors.length; ++i) {
            Augmentor._writeToFileOut(" ^ " + newLine + Augmentor.indentString(baseIndent, 6));
            SymbolData type = accessors[i].getReturnType().getSymbolData();
            if (LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5) || !type.isPrimitiveType()) {
                Augmentor._writeToFileOut(valueHashCodeName + "(" + accessors[i].getName() + "())");
                continue;
            }
            if (type == SymbolData.BOOLEAN_TYPE) {
                Augmentor._writeToFileOut("(" + accessors[i].getName() + "() ? 1 : 0)");
                continue;
            }
            if (type.isAssignableTo(SymbolData.INT_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
                Augmentor._writeToFileOut(accessors[i].getName() + "()");
                continue;
            }
            Augmentor._writeToFileOut("(int) " + accessors[i].getName() + "()");
        }
        Augmentor._writeToFileOut(";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "catch (RuntimeException e) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + listName + ".removeLast();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "throw e;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + listName + ".removeLast();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "return result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    protected static void writeSimpleHashCode(String className, SymbolData sd, int baseIndent, boolean waitForVarDef, String valueHashCodeName, MethodData[] accessors) {
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "/** This method is automatically generated by the Language Level Converter. */");
        Augmentor._writeToFileOut(newLine + Augmentor.indentString(baseIndent, 1) + "public int hashCode() {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "return getClass().hashCode()");
        for (int i = 0; i < accessors.length; ++i) {
            Augmentor._writeToFileOut(" ^ " + newLine + Augmentor.indentString(baseIndent, 4));
            SymbolData type = accessors[i].getReturnType().getSymbolData();
            if (!type.isPrimitiveType()) {
                Augmentor._writeToFileOut("(" + accessors[i].getName() + "() == null ? 0 : " + accessors[i].getName() + "().hashCode())");
                continue;
            }
            if (type == SymbolData.BOOLEAN_TYPE) {
                Augmentor._writeToFileOut("(" + accessors[i].getName() + "() ? 1 : 0)");
                continue;
            }
            if (type.isAssignableTo(SymbolData.INT_TYPE, LanguageLevelConverter.OPT.javaVersion())) {
                Augmentor._writeToFileOut(accessors[i].getName() + "()");
                continue;
            }
            Augmentor._writeToFileOut("(int) " + accessors[i].getName() + "()");
        }
        Augmentor._writeToFileOut(";" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static String writeValueToString(SymbolData sd, int baseIndent) {
        String methodName = sd.createUniqueMethodName("__valueToString");
        if (_safeSupportCode) {
            Augmentor.writeSafeValueToString(sd, baseIndent, methodName);
        }
        return methodName;
    }

    private static void writeSafeValueToString(SymbolData sd, int baseIndent, String methodName) {
        String[] primitiveTypes = new String[]{"byte[]", "short[]", "char[]", "int[]", "long[]", "float[]", "double[]", "boolean[]"};
        boolean useGenerics = LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5);
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "/**" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * This method is automatically generated by the LanguageLevelConverter." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * As a helper to toString(), it recursively generates a string for any object," + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * including nulls, arrays, and standard reference types." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private java.lang.String " + methodName + "(java.lang.Object o) {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "class ArrayToString {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public String valueFor(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (o instanceof java.lang.Object[]) {" + newLine);
        if (useGenerics) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayToString((java.lang.Object[]) o, new java.util.HashSet<java.lang.Object[]>());" + newLine);
        } else {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayToString((java.lang.Object[]) o, new java.util.HashSet());" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else if (o instanceof " + type + ") {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayToString((" + type + ") o);" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "// o should be an array, but if not, toString() is called" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return o.toString();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public java.lang.String arrayToString(" + type + " array) {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "java.lang.StringBuffer result = new java.lang.StringBuffer();" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "result.append(\"[\");" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (array.length > 0) { result.append(array[0]); }" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "for (int i = 1; i < array.length; i++) {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "result.append(\", \");" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "result.append(array[i]);" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "result.append(\"]\");" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "return result.toString();" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        }
        if (useGenerics) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public java.lang.String arrayToString(java.lang.Object[] array, java.util.HashSet<java.lang.Object[]> alreadyPrinted) {" + newLine);
        } else {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public java.lang.String arrayToString(java.lang.Object[] array, java.util.HashSet alreadyPrinted) {" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (alreadyPrinted.contains(array)) { return (\"[...]\"); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else { alreadyPrinted.add(array); }" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "java.lang.StringBuffer result = new java.lang.StringBuffer();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "result.append(\"[\");" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "boolean nonEmpty = false;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "for (int i = 0; i < array.length; i++) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "if (nonEmpty) { result.append(\", \"); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "nonEmpty = true;" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "if (array[i] instanceof java.lang.Object[]) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "result.append(arrayToString((java.lang.Object[]) array[i], alreadyPrinted));" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "result.append(" + methodName + "(array[i]));" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "result.append(\"]\");" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "alreadyPrinted.remove(array);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "return result.toString();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (o == null) { return \"\" + null; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if (o.getClass().isArray()) { return new ArrayToString().valueFor(o); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else { return o.toString(); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static void writeSimpleValueToString(SymbolData sd, int baseIndent, String methodName) {
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "/**" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * This method is automatically generated by the LanguageLevelConverter." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * As a helper to toString(), it generates a string for any object," + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * including nulls and standard reference types." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private java.lang.String " + methodName + "(java.lang.Object o) {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (o == null) { return \"\" + null; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else { return o.toString(); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static String writeValueEquals(SymbolData sd, int baseIndent) {
        String methodName = sd.createUniqueMethodName("__valueEquals");
        if (_safeSupportCode) {
            Augmentor.writeSafeValueEquals(sd, baseIndent, methodName);
        }
        return methodName;
    }

    private static void writeSafeValueEquals(SymbolData sd, int baseIndent, String methodName) {
        String[] primitiveTypes = new String[]{"byte[]", "short[]", "char[]", "int[]", "long[]", "float[]", "double[]", "boolean[]"};
        boolean useGenerics = LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5);
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "/**" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * This method is automatically generated by the LanguageLevelConverter." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * As a helper to equals(Object), it recursively compares any two objects," + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * including nulls, arrays, and standard reference types." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private boolean " + methodName + "(java.lang.Object o1, java.lang.Object o2) {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "class ArrayEquals {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public boolean valueFor(java.lang.Object o1, java.lang.Object o2) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (o1 instanceof java.lang.Object[] && o2 instanceof java.lang.Object[]) {" + newLine);
        if (useGenerics) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayEquals((java.lang.Object[]) o1, (java.lang.Object[]) o2, new java.util.HashSet<java.lang.Object>());" + newLine);
        } else {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayEquals((java.lang.Object[]) o1, (java.lang.Object[]) o2, new java.util.HashSet());" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else if (o1 instanceof " + type + " && o2 instanceof " + type + ") {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayEquals((" + type + ") o1, (" + type + ") o2);" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "// o1 and o2 should be arrays, but if not, or if they have different types, equals(Object) is called" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return o1.equals(o2);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public boolean arrayEquals(" + type + " array1, " + type + " array2) {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (array1.length != array2.length) { return false; }" + newLine + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "for (int i = 0; i < array1.length; i++) {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "if (array1[i] != array2[i]) { return false; }" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return true;" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        }
        if (useGenerics) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public boolean arrayEquals(final java.lang.Object[] array1, final java.lang.Object[] array2, java.util.HashSet<java.lang.Object> alreadyCompared) {" + newLine + newLine);
        } else {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public boolean arrayEquals(final java.lang.Object[] array1, final java.lang.Object[] array2, java.util.HashSet alreadyCompared) {" + newLine + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "class ArrayPair {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public java.lang.Object[] array1() { return array1; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public java.lang.Object[] array2() { return array2; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public boolean equals(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "if ((o == null) || ! (o instanceof ArrayPair)) { return false; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "else { return (array1.equals(((ArrayPair) o).array1())) && (array2.equals(((ArrayPair) o).array2())); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public int hashCode() { return array1.hashCode() ^ (array2.hashCode() << 1); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (array1.length != array2.length) { return false; }" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "ArrayPair currentPair = new ArrayPair();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "if (alreadyCompared.contains(currentPair)) { return true; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "alreadyCompared.add(currentPair);" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "boolean result = true;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "for (int i = 0; i < array1.length; i++) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "if (array1[i] instanceof java.lang.Object[] && array2[i] instanceof java.lang.Object[]) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 7) + "result = arrayEquals((java.lang.Object[]) array1[i], (java.lang.Object[]) array2[i], alreadyCompared);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 7) + "result = " + methodName + "(array1[i], array2[i]);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "if (!result) { break; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "alreadyCompared.remove(currentPair);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (o1 == null) { return o2 == null; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if (o2 == null) { return false; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if (o1.getClass().isArray() && o2.getClass().isArray()) { return new ArrayEquals().valueFor(o1, o2); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else { return o1.equals(o2); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static void writeSimpleValueEquals(SymbolData sd, int baseIndent, String methodName) {
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "/**" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * This method is automatically generated by the LanguageLevelConverter." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * As a helper to equals(Object), it compares any two objects," + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * including nulls and standard reference types." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private boolean " + methodName + "(java.lang.Object o1, java.lang.Object o2) {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (o1 == null) { return o2 == null; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if (o2 == null) { return false; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else { return o1.equals(o2); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static String writeValueHashCode(SymbolData sd, int baseIndent, String valueEqualsName) {
        String methodName = sd.createUniqueMethodName("__valueHashCode");
        if (_safeSupportCode) {
            Augmentor.writeSafeValueHashCode(sd, baseIndent, valueEqualsName, methodName);
        }
        return methodName;
    }

    private static void writeSafeValueHashCode(SymbolData sd, int baseIndent, String valueEqualsName, String methodName) {
        String[] primitiveTypes = new String[]{"byte[]", "short[]", "char[]", "int[]", "long[]", "float[]", "double[]", "boolean[]"};
        boolean useGenerics = LanguageLevelConverter.OPT.javaVersion().supports(JavaVersion.JAVA_5);
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "/**" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * This method is automatically generated by the LanguageLevelConverter." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * As a helper to hashCode(), it recursively generates a hash code for any object," + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * including nulls, arrays, and standard reference types." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private int " + methodName + "(java.lang.Object o) {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "class ArrayHashCode {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public int valueFor(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (o instanceof java.lang.Object[]) {" + newLine);
        if (useGenerics) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayHashCode((java.lang.Object[]) o, new java.util.LinkedList<java.lang.Object>());" + newLine);
        } else {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayHashCode((java.lang.Object[]) o, new java.util.LinkedList());" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else if (o instanceof " + type + ") {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return arrayHashCode((" + type + ") o);" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "// o should be an array, but if not, hashCode() is called" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "return o.hashCode();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        for (String type : primitiveTypes) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public int arrayHashCode(" + type + " array) {" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "int result = 0;" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "for (int i = 0; i < array.length; i++) {" + newLine);
            if (type.equals("boolean[]")) {
                Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "result = (result << 1) ^ (array[i] ? 1 : 0);" + newLine);
            } else {
                Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "result = (result << 1) ^ (int) array[i];" + newLine);
            }
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "return result;" + newLine);
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        }
        if (useGenerics) {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public int arrayHashCode(final java.lang.Object[] array, final java.util.LinkedList<java.lang.Object> alreadyGenerated) {" + newLine + newLine);
        } else {
            Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "public int arrayHashCode(final java.lang.Object[] array, final java.util.LinkedList alreadyGenerated) {" + newLine + newLine);
        }
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "class ArrayWrapper {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public java.lang.Object[] array() { return array; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public boolean equals(java.lang.Object o) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "return (o != null) && (o instanceof ArrayWrapper)  && " + valueEqualsName + "(array, ((ArrayWrapper) o).array());" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "public int hashCode() { return 0; } // This method should never be used -- only here for consistency." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "ArrayWrapper currentWrapper = new ArrayWrapper();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "if (alreadyGenerated.contains(currentWrapper)) { return -1; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "alreadyGenerated.addLast(currentWrapper);" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "int result = 0;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "for (int i = 0; i < array.length; i++) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "if (array[i] instanceof java.lang.Object[]) {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "result = (result << 1) ^ (arrayHashCode((java.lang.Object[]) array[i], alreadyGenerated) >> 1);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "else {" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 6) + "result = (result << 1) ^ " + methodName + "(array[i]);" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 5) + "}" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "alreadyGenerated.removeLast();" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 4) + "return result;" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 3) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "}" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (o == null) { return 0; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else if (o.getClass().isArray()) { return new ArrayHashCode().valueFor(o); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else { return o.hashCode(); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static void writeSimpleValueHashCode(SymbolData sd, int baseIndent, String valueEqualsName, String methodName) {
        Augmentor._writeToFileOut(newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "/**" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * This method is automatically generated by the LanguageLevelConverter." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * As a helper to hashCode(), it generates a hash code for any object," + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " * including nulls and standard reference types." + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + " */" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "private int " + methodName + "(java.lang.Object o) {" + newLine + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "if (o == null) { return 0; }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 2) + "else { return o.hashCode(); }" + newLine);
        Augmentor._writeToFileOut(Augmentor.indentString(baseIndent, 1) + "}" + newLine);
    }

    private static String indentString(int baseIndent, int indentCount) {
        int length = indentCount * 2 + baseIndent;
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            result.append(' ');
        }
        return result.toString();
    }

    private static boolean _isElementaryFile() {
        return LanguageLevelConverter.isElementaryFile(Augmentor._llv._file);
    }

    private static boolean _isIntermediateFile() {
        return LanguageLevelConverter.isIntermediateFile(Augmentor._llv._file);
    }

    private static boolean _isAdvancedFile() {
        return LanguageLevelConverter.isAdvancedFile(Augmentor._llv._file);
    }

    private static LinkedList<MethodData> _getVariableAccessorListHelper(SymbolData currClass) {
        MethodData md;
        SymbolData tempSd;
        Vector<Pair<VariableData, MethodData>> accessorMappings = new Vector<Pair<VariableData, MethodData>>();
        LinkedList<SymbolData> classes = new LinkedList<SymbolData>();
        classes.add(currClass);
        while (classes.size() > 0 && !LanguageLevelVisitor.isJavaLibraryClass((tempSd = (SymbolData)classes.removeFirst()).getName())) {
            Data outerData;
            for (int i = 0; i < tempSd.getVars().size(); ++i) {
                VariableData tempVd = tempSd.getVars().get(i);
                md = tempSd.getMethod(tempVd.getName(), new TypeData[0]);
                if (md == null) continue;
                accessorMappings.add(new Pair<VariableData, MethodData>(tempVd, md));
            }
            SymbolData superClass = tempSd.getSuperClass();
            if (superClass != null) {
                classes.addFirst(superClass);
            }
            if ((outerData = tempSd.getOuterData()) == null) continue;
            classes.addLast(outerData.getSymbolData());
        }
        LinkedList<MethodData> allMethods = new LinkedList<MethodData>();
        for (int i = accessorMappings.size() - 1; i >= 0; --i) {
            VariableData vd = (VariableData)((Pair)accessorMappings.get(i)).getFirst();
            md = (MethodData)((Pair)accessorMappings.get(i)).getSecond();
            boolean canSeeMethod = TypeChecker.checkAccessibility(new NullLiteral(JExprParser.NO_SOURCE_INFO), md.getMav(), md.getName(), md.getSymbolData(), currClass, "method", false);
            if (!canSeeMethod || md.hasModifier("static") || md.getThrown().length != 0 || !vd.getType().getSymbolData().isAssignableTo(md.getReturnType(), LanguageLevelConverter.OPT.javaVersion())) continue;
            boolean isShadowed = false;
            for (int j = i - 1; j >= 0; --j) {
                if (!((MethodData)((Pair)accessorMappings.get(j)).getSecond()).getName().equals(md.getName())) continue;
                isShadowed = true;
                break;
            }
            if (isShadowed) continue;
            allMethods.addFirst(md);
        }
        return allMethods;
    }

    private static String _readThroughIndex(int line, int column) {
        if (_fileInLine > line || _fileInLine == line && _fileInColumn - 1 > column) {
            throw new RuntimeException("Internal Program Error: Attempt to read in " + Augmentor._llv._file.getName() + " at a point that is already past: line " + line + ", column " + column + "; (currently at " + _fileInLine + ", " + _fileInColumn + ").  Please report this bug.");
        }
        try {
            StringBuffer result = new StringBuffer();
            while (_fileInLine < line) {
                String l = _fileIn.readLine();
                if (l == null) {
                    _fileOut.flush();
                    throw new RuntimeException("Internal Program Error: Attempt to read in " + Augmentor._llv._file.getName() + " past the end of file: line " + line + ", column " + column + "; (currently at " + _fileInLine + ", " + _fileInColumn + ").  Please report this bug.");
                }
                result.append(l).append(newLine);
                ++_fileInLine;
                _fileInColumn = 1;
            }
            int lastLineLength = column - _fileInColumn + 1;
            char[] chars = new char[lastLineLength];
            int charsRead = _fileIn.read(chars, 0, lastLineLength);
            if (charsRead != lastLineLength) {
                _fileOut.flush();
                throw new RuntimeException("Internal Program Error: Attempt to read in " + Augmentor._llv._file.getName() + " past the end of file: line " + line + ", column " + column + "; (currently at " + _fileInLine + ", " + _fileInColumn + ").  Please report this bug.");
            }
            result.append(chars);
            _fileInLine = line;
            _fileInColumn = column + 1;
            return result.toString();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    private static void _readAndWriteThroughIndex(int line, int column) {
        String text = Augmentor._readThroughIndex(line, column);
        Augmentor._writeToFileOut(text, true);
    }

    private static void _writeToFileOut(String s) {
        Augmentor._writeToFileOut(s, false);
    }

    private static void _writeToFileOut(String s, boolean fromInput) {
        try {
            String[] lines = s.split(newLine, -1);
            for (int i = 0; i < lines.length - 1; ++i) {
                _fileOut.write(lines[i]);
                if (_lineNumberMap.get(_fileOutCorrespondingLine) == null) {
                    _lineNumberMap.put(_fileOutCorrespondingLine, _fileOutLine);
                }
                _fileOut.write(newLine);
                ++_fileOutLine;
                if (!fromInput) continue;
                ++_fileOutCorrespondingLine;
            }
            _fileOut.write(lines[lines.length - 1]);
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    private static String _peek(int line, int column) {
        try {
            _fileIn.mark(8192);
            int fileInLine = _fileInLine;
            int fileInColumn = _fileInColumn;
            String text = Augmentor._readThroughIndex(line, column);
            _fileIn.reset();
            _fileInLine = fileInLine;
            _fileInColumn = fileInColumn;
            return text;
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    public static SortedMap<Integer, Integer> getLineNumberMap() {
        return new TreeMap<Integer, Integer>((SortedMap<Integer, Integer>)_lineNumberMap);
    }

    static /* synthetic */ Data access$200(Augmentor x0) {
        return x0._enclosingData;
    }

    static /* synthetic */ Data access$202(Augmentor x0, Data x1) {
        x0._enclosingData = x1;
        return x0._enclosingData;
    }

    static /* synthetic */ String access$300(int x0, int x1) {
        return Augmentor.indentString(x0, x1);
    }

    static /* synthetic */ LanguageLevelVisitor access$402(LanguageLevelVisitor x0) {
        _llv = x0;
        return _llv;
    }

    static /* synthetic */ boolean access$500() {
        return Augmentor._isElementaryFile();
    }

    static /* synthetic */ boolean access$600() {
        return Augmentor._isIntermediateFile();
    }

    static /* synthetic */ LinkedList access$700(SymbolData x0) {
        return Augmentor._getVariableAccessorListHelper(x0);
    }

    public static class Exception
    extends RuntimeException {
        public Exception(java.lang.Exception nested) {
            super(nested);
        }
    }

    public static class MethodBodyAugmentor
    extends Augmentor {
        protected MethodBodyAugmentor(Data enclosing) {
            super(enclosing);
        }

        protected void augmentVariableDeclarationModifiers(VariableDeclaration that) {
            if (!Augmentor._isAdvancedFile()) {
                Augmentor._writeToFileOut("final ");
            }
        }
    }
}

