/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ClassBodyAdvancedVisitor;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InterfaceBodyAdvancedVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ArrayType;
import edu.rice.cs.javalanglevels.tree.BodyItemI;
import edu.rice.cs.javalanglevels.tree.BracedBody;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConditionalExpression;
import edu.rice.cs.javalanglevels.tree.DefaultCase;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.InstanceofExpression;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.LabeledBreakStatement;
import edu.rice.cs.javalanglevels.tree.LabeledContinueStatement;
import edu.rice.cs.javalanglevels.tree.LabeledStatement;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.PrimitiveType;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.StaticInitializer;
import edu.rice.cs.javalanglevels.tree.SwitchCase;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.SynchronizedStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclarator;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedVisitor
extends LanguageLevelVisitor {
    public AdvancedVisitor(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classNamesInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classNamesInThisFile, continuations);
    }

    public AdvancedVisitor(File file, LinkedList<Pair<String, JExpressionIF>> errors, Symboltable symbolTable, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations, LinkedList<Pair<LanguageLevelVisitor, SourceFile>> visitedFiles, Hashtable<SymbolData, LanguageLevelVisitor> newSDs) {
        super(file, "", new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), continuations);
        AdvancedVisitor.errors = errors;
        AdvancedVisitor.symbolTable = symbolTable;
        AdvancedVisitor.visitedFiles = visitedFiles;
        _newSDs = newSDs;
        _hierarchy = new Hashtable();
    }

    @Override
    public void createConstructor(SymbolData sd) {
        SymbolData superSd = sd.getSuperClass();
        if (sd.isContinuation()) {
            return;
        }
        String name = AdvancedVisitor.getUnqualifiedClassName(sd.getName());
        boolean hasOtherConstructor = sd.hasMethod(name);
        if (hasOtherConstructor) {
            _newSDs.remove(sd);
            return;
        }
        MethodData md = MethodData.make(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, new String[]{"public"}), new TypeParameter[0], sd, new VariableData[0], new String[0], sd, null);
        AdvancedVisitor.addGeneratedMethod(sd, md);
        _newSDs.remove(sd);
    }

    @Override
    public Void forModifiersAndVisibilityDoFirst(ModifiersAndVisibility that) {
        String temp;
        String[] modifiersAndVisibility = that.getModifiers();
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (int i = 0; i < modifiersAndVisibility.length; ++i) {
            temp = modifiersAndVisibility[i];
            if (temp.equals("abstract") || temp.equals("public") || temp.equals("private") || temp.equals("protected") || temp.equals("static") || temp.equals("final")) continue;
            sb.append(" \"" + temp + "\"");
            ++count;
        }
        temp = "The keyword";
        if (sb.length() > 0) {
            if (count > 1) {
                temp = temp + "s";
            }
            AdvancedVisitor._addAndIgnoreError(temp + sb.toString() + " cannot be used at the Advanced level", that);
            return null;
        }
        return super.forModifiersAndVisibilityDoFirst(that);
    }

    @Override
    public Void forSwitchStatementDoFirst(SwitchStatement that) {
        for (int i = 0; i < that.getCases().length - 1; ++i) {
            SwitchCase sc = that.getCases()[i];
            if (!(sc instanceof DefaultCase)) continue;
            AdvancedVisitor._addAndIgnoreError("Default case must be the last case of a switch statement at the Advanced level", sc);
        }
        return super.forSwitchStatementDoFirst(that);
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        AdvancedVisitor._addError("Instance initializers cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forStaticInitializerDoFirst(StaticInitializer that) {
        AdvancedVisitor._addError("Static initializers cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forLabeledStatementDoFirst(LabeledStatement that) {
        AdvancedVisitor._addError("Labeled statements cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forLabeledBreakStatementDoFirst(LabeledBreakStatement that) {
        AdvancedVisitor._addError("Labeled statements cannot be used at the Advanced level, so you cannot break to a label", that);
        return null;
    }

    @Override
    public Void forLabeledContinueStatementDoFirst(LabeledContinueStatement that) {
        AdvancedVisitor._addError("Labeled statements cannot be used at the Advanced level, so you cannot use a labeled continue statement", that);
        return null;
    }

    @Override
    public Void forSynchronizedStatementDoFirst(SynchronizedStatement that) {
        AdvancedVisitor._addError("Synchronized statements cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forTypeParameterDoFirst(TypeParameter that) {
        AdvancedVisitor._addError("Type Parameters cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forConditionalExpressionDoFirst(ConditionalExpression that) {
        AdvancedVisitor._addError("Conditional expressions cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forInstanceofExpressionDoFirst(InstanceofExpression that) {
        AdvancedVisitor._addError("Instanceof expressions cannot be used at the Advanced level", that);
        return null;
    }

    @Override
    public Void forPrimitiveTypeDoFirst(PrimitiveType that) {
        String name = that.getName();
        if (!(name.equals("int") || name.equals("double") || name.equals("boolean") || name.equals("char"))) {
            AdvancedVisitor._addError("Only the primitive types \"int\", \"double\", \"boolean\", and \"char\" can be used at the Advanced level", that);
            return null;
        }
        return super.forPrimitiveTypeDoFirst(that);
    }

    @Override
    public Void forTryCatchStatementDoFirst(TryCatchStatement that) {
        AdvancedVisitor._addAndIgnoreError("A try-catch statement cannot appear here", that);
        return super.forTryCatchStatementDoFirst(that);
    }

    private boolean _isClassInCurrentFile(String className) {
        for (String s : this._classNamesInThisFile) {
            if (!s.equals(className) && !s.endsWith("." + className)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected VariableData[] formalParameters2VariableData(FormalParameter[] fps, Data d) {
        VariableData[] varData = new VariableData[fps.length];
        String[] mav = d instanceof MethodData && d.hasModifier("static") ? new String[]{"final", "static"} : new String[]{"final"};
        for (int i = 0; i < varData.length; ++i) {
            VariableDeclarator vd = fps[i].getDeclarator();
            String name = vd.getName().getText();
            SourceInfo si = vd.getType().getSourceInfo();
            String typeName = vd.getType().getName();
            SymbolData type = this.getSymbolData(typeName, si);
            if (type == null) {
                type = d.getInnerClassOrInterface(typeName);
            }
            if (type == null) {
                String qualifiedTypeName = d.getSymbolData().getName() + "." + typeName;
                type = this._innerClassesToBeParsed.contains(qualifiedTypeName) ? this.addInnerSymbolData(si, qualifiedTypeName, d) : this.addSymbolData(si, typeName);
            }
            varData[i] = new VariableData(name, new ModifiersAndVisibility(JExprParser.NO_SOURCE_INFO, mav), type, true, d);
            varData[i].gotValue();
        }
        return varData;
    }

    @Override
    public Void forClassDef(ClassDef that) {
        int i;
        this.forClassDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        String className = this.getQualifiedClassName(that.getName().getText());
        _log.log("Adding SymbolData for " + className);
        SymbolData sd = this.addSymbolData(that, className);
        that.getMav().visit(this);
        that.getName().visit(this);
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        that.getSuperclass().visit(this);
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        if (sd != null) {
            that.getBody().visit(new ClassBodyAdvancedVisitor(sd, className, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations));
            AdvancedVisitor.createAccessors(sd, this._file);
            this.createToString(sd);
            this.createHashCode(sd);
            this.createEquals(sd);
        }
        this.forClassDefOnly(that);
        this._classesToBeParsed.remove(className);
        return null;
    }

    @Override
    public Void forBracedBodyDoFirst(BracedBody that) {
        if (this._enclosingClassName != null) {
            for (BodyItemI bi : that.getStatements()) {
                if (!(bi instanceof TypeDefBase)) continue;
                TypeDefBase type = (TypeDefBase)((Object)bi);
                String innerClassName = this._enclosingClassName + "." + type.getName().getText();
                _log.log("Adding " + innerClassName + " to _innerClassesToBeParsed inside " + that + "\n");
                this._innerClassesToBeParsed.add(innerClassName);
            }
        }
        return super.forBracedBodyDoFirst(that);
    }

    @Override
    protected void createToString(SymbolData sd) {
    }

    @Override
    protected void createHashCode(SymbolData sd) {
    }

    @Override
    protected void createEquals(SymbolData sd) {
    }

    @Override
    public Void forInterfaceDef(InterfaceDef that) {
        this.forInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        String className = that.getName().getText();
        that.getMav().visit(this);
        that.getName().visit(this);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        SymbolData sd = this.addSymbolData(that, this.getQualifiedClassName(className));
        if (sd != null) {
            sd.setInterface(true);
            that.getBody().visit(new InterfaceBodyAdvancedVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        }
        this.forInterfaceDefOnly(that);
        this._classesToBeParsed.remove(this.getQualifiedClassName(className));
        return null;
    }

    protected void handleInnerClassDef(InnerClassDef that, Data data, String name) {
        int i;
        this.forInnerClassDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.addInnerSymbolData(that, name, that.getName().getText(), data, true);
        if (sd != null) {
            that.getBody().visit(new ClassBodyAdvancedVisitor(sd, name, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations));
            AdvancedVisitor.createAccessors(sd, this._file);
            this.createToString(sd);
            this.createHashCode(sd);
            this.createEquals(sd);
        }
        this.forInnerClassDefOnly(that);
    }

    protected void handleInnerInterfaceDef(InnerInterfaceDef that, SymbolData symbolData, String name) {
        int i;
        this.forInnerInterfaceDefDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getMav().visit(this);
        that.getName().visit(this);
        for (i = 0; i < that.getTypeParameters().length; ++i) {
            that.getTypeParameters()[i].visit(this);
        }
        for (i = 0; i < that.getInterfaces().length; ++i) {
            that.getInterfaces()[i].visit(this);
        }
        SymbolData sd = this.addInnerSymbolData(that, name, that.getName().getText(), symbolData, true);
        if (sd != null) {
            that.getBody().visit(new InterfaceBodyAdvancedVisitor(sd, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, this._classNamesInThisFile, (Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>)continuations));
        }
        this.forInnerInterfaceDefOnly(that);
    }

    public void anonymousClassInstantiationHelper(AnonymousClassInstantiation that, Data enclosing, SymbolData superC) {
        that.getArguments().visit(this);
        String anonName = this.getQualifiedClassName(enclosing.getSymbolData().getName()) + "$" + enclosing.getSymbolData().preincrementAnonymousInnerClassNum();
        SymbolData sd = new SymbolData(anonName);
        enclosing.addInnerClass(sd);
        sd.setOuterData(enclosing);
        if (superC != null && !superC.isInterface()) {
            sd.setSuperClass(superC);
        }
        sd.setPackage(this._package);
        this.createToString(sd);
        this.createHashCode(sd);
        this.createEquals(sd);
        that.getBody().visit(new ClassBodyAdvancedVisitor(sd, anonName, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations));
    }

    public void simpleAnonymousClassInstantiationHelper(SimpleAnonymousClassInstantiation that, Data data) {
        this.forSimpleAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        SymbolData superC = this.getSymbolData(that.getType().getName(), that.getSourceInfo());
        this.anonymousClassInstantiationHelper(that, data, superC);
        this.forSimpleAnonymousClassInstantiationOnly(that);
    }

    public void complexAnonymousClassInstantiationHelper(ComplexAnonymousClassInstantiation that, Data data) {
        this.forComplexAnonymousClassInstantiationDoFirst(that);
        if (this.prune(that)) {
            return;
        }
        that.getEnclosing().visit(this);
        this.anonymousClassInstantiationHelper(that, data, null);
        this.forComplexAnonymousClassInstantiationOnly(that);
    }

    @Override
    public Void forArrayType(ArrayType that) {
        this.forArrayTypeDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        this.getSymbolData(that.getName(), that.getSourceInfo());
        return null;
    }

    static /* synthetic */ boolean access$000(AdvancedVisitor x0, String x1) {
        return x0._isClassInCurrentFile(x1);
    }
}

