/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJField;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.type.BooleanType;
import edu.rice.cs.dynamicjava.symbol.type.BottomType;
import edu.rice.cs.dynamicjava.symbol.type.ByteType;
import edu.rice.cs.dynamicjava.symbol.type.CharType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.DoubleType;
import edu.rice.cs.dynamicjava.symbol.type.FloatType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.LongType;
import edu.rice.cs.dynamicjava.symbol.type.NullType;
import edu.rice.cs.dynamicjava.symbol.type.ShortType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleClassType;
import edu.rice.cs.dynamicjava.symbol.type.TopType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VoidType;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import koala.dynamicjava.tree.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeSystem {
    public static final BooleanType BOOLEAN = new BooleanType();
    public static final CharType CHAR = new CharType();
    public static final ByteType BYTE = new ByteType();
    public static final ShortType SHORT = new ShortType();
    public static final IntType INT = new IntType();
    public static final LongType LONG = new LongType();
    public static final FloatType FLOAT = new FloatType();
    public static final DoubleType DOUBLE = new DoubleType();
    public static final NullType NULL = new NullType();
    public static final VoidType VOID = new VoidType();
    public static final TopType TOP = new TopType();
    public static final BottomType BOTTOM = new BottomType();
    public static final SimpleClassType OBJECT = new SimpleClassType(SymbolUtil.wrapClass(Object.class));
    public static final SimpleClassType STRING = new SimpleClassType(SymbolUtil.wrapClass(String.class));
    public static final SimpleClassType CLONEABLE = new SimpleClassType(SymbolUtil.wrapClass(Cloneable.class));
    public static final SimpleClassType SERIALIZABLE = new SimpleClassType(SymbolUtil.wrapClass(Serializable.class));
    public static final SimpleClassType THROWABLE = new SimpleClassType(SymbolUtil.wrapClass(Throwable.class));
    public static final SimpleClassType EXCEPTION = new SimpleClassType(SymbolUtil.wrapClass(Exception.class));
    public static final SimpleClassType RUNTIME_EXCEPTION = new SimpleClassType(SymbolUtil.wrapClass(RuntimeException.class));
    public static final SimpleClassType BOOLEAN_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Boolean.class));
    public static final SimpleClassType CHARACTER_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Character.class));
    public static final SimpleClassType BYTE_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Byte.class));
    public static final SimpleClassType SHORT_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Short.class));
    public static final SimpleClassType INTEGER_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Integer.class));
    public static final SimpleClassType LONG_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Long.class));
    public static final SimpleClassType FLOAT_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Float.class));
    public static final SimpleClassType DOUBLE_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Double.class));
    public static final SimpleClassType VOID_CLASS = new SimpleClassType(SymbolUtil.wrapClass(Void.class));
    protected static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    protected static final Iterable<Type> EMPTY_TYPE_ITERABLE = IterUtil.empty();
    protected static final Iterable<Expression> EMPTY_EXPRESSION_ITERABLE = IterUtil.empty();
    protected static final Option<Type> NONE_TYPE_OPTION = Option.none();
    private final Lambda<Type, TypeWrapper> WRAP_TYPE = new Lambda<Type, TypeWrapper>(){

        @Override
        public TypeWrapper value(Type t) {
            return t == null ? null : new TypeWrapper(t);
        }
    };

    public TypeWrapper wrap(Type t) {
        return t == null ? null : new TypeWrapper(t);
    }

    public Iterable<TypeWrapper> wrap(Iterable<? extends Type> ts) {
        return ts == null ? null : IterUtil.map(ts, this.WRAP_TYPE);
    }

    public Option<TypeWrapper> wrap(Option<Type> t) {
        if (t == null) {
            return null;
        }
        return t.isSome() ? Option.some(new TypeWrapper(t.unwrap())) : Option.none();
    }

    public abstract boolean isPrimitive(Type var1);

    public abstract boolean isReference(Type var1);

    public abstract boolean isArray(Type var1);

    public abstract boolean isWellFormed(Type var1);

    public abstract boolean isIterable(Type var1);

    public abstract boolean isEnum(Type var1);

    public abstract boolean isReifiable(Type var1);

    public abstract boolean isConcrete(Type var1);

    public abstract boolean isStatic(Type var1);

    public abstract boolean isExtendable(Type var1);

    public abstract boolean isImplementable(Type var1);

    public abstract boolean isEqual(Type var1, Type var2);

    public abstract boolean isSubtype(Type var1, Type var2);

    public abstract boolean isCastable(Type var1, Type var2);

    public abstract boolean isAssignable(Type var1, Type var2);

    public abstract boolean isAssignable(Type var1, Type var2, Object var3);

    public abstract boolean isPrimitiveConvertible(Type var1);

    public abstract boolean isReferenceConvertible(Type var1);

    public abstract Type join(Iterable<? extends Type> var1);

    public Type join(Type t1, Type t2) {
        return this.join(IterUtil.make(t1, t2));
    }

    public abstract Type meet(Iterable<? extends Type> var1);

    public Type meet(Type t1, Type t2) {
        return this.meet(IterUtil.make(t1, t2));
    }

    public abstract Type capture(Type var1);

    public abstract Type erase(Type var1);

    public abstract Thunk<Class<?>> erasedClass(Type var1);

    public abstract Type reflectionClassOf(Type var1);

    public abstract Type arrayElementType(Type var1);

    public abstract String userRepresentation(Type var1);

    public abstract ClassType makeClassType(DJClass var1);

    public abstract ClassType makeClassType(DJClass var1, Iterable<? extends Type> var2) throws InvalidTypeArgumentException;

    public abstract Expression makePrimitive(Expression var1) throws UnsupportedConversionException;

    public abstract Expression makeReference(Expression var1) throws UnsupportedConversionException;

    public abstract Expression unaryPromote(Expression var1) throws UnsupportedConversionException;

    public abstract Pair<Expression, Expression> binaryPromote(Expression var1, Expression var2) throws UnsupportedConversionException;

    public abstract Pair<Expression, Expression> mergeConditional(Expression var1, Expression var2) throws UnsupportedConversionException;

    public abstract Expression cast(Type var1, Expression var2) throws UnsupportedConversionException;

    public abstract Expression assign(Type var1, Expression var2) throws UnsupportedConversionException;

    public abstract ConstructorInvocation lookupConstructor(Type var1, Iterable<? extends Type> var2, Iterable<? extends Expression> var3, Option<Type> var4) throws InvalidTargetException, InvalidTypeArgumentException, UnmatchedLookupException;

    public abstract boolean containsMethod(Type var1, String var2);

    public abstract boolean containsStaticMethod(Type var1, String var2);

    public abstract ObjectMethodInvocation lookupMethod(Expression var1, String var2, Iterable<? extends Type> var3, Iterable<? extends Expression> var4, Option<Type> var5) throws InvalidTargetException, InvalidTypeArgumentException, UnmatchedLookupException;

    public abstract StaticMethodInvocation lookupStaticMethod(Type var1, String var2, Iterable<? extends Type> var3, Iterable<? extends Expression> var4, Option<Type> var5) throws InvalidTargetException, InvalidTypeArgumentException, UnmatchedLookupException;

    public abstract boolean containsField(Type var1, String var2);

    public abstract boolean containsStaticField(Type var1, String var2);

    public abstract ObjectFieldReference lookupField(Expression var1, String var2) throws InvalidTargetException, UnmatchedLookupException;

    public abstract StaticFieldReference lookupStaticField(Type var1, String var2) throws InvalidTargetException, UnmatchedLookupException;

    public abstract boolean containsClass(Type var1, String var2);

    public abstract boolean containsStaticClass(Type var1, String var2);

    public abstract ClassType lookupClass(Expression var1, String var2, Iterable<? extends Type> var3) throws InvalidTargetException, InvalidTypeArgumentException, UnmatchedLookupException;

    public abstract ClassType lookupClass(Type var1, String var2, Iterable<? extends Type> var3) throws InvalidTargetException, InvalidTypeArgumentException, UnmatchedLookupException;

    public abstract ClassType lookupStaticClass(Type var1, String var2, Iterable<? extends Type> var3) throws InvalidTargetException, InvalidTypeArgumentException, UnmatchedLookupException;

    public static class UnmatchedLookupException
    extends TypeSystemException {
        private final int _matches;

        public UnmatchedLookupException(int matches) {
            this._matches = matches;
        }

        public int matches() {
            return this._matches;
        }
    }

    public static class InvalidTargetException
    extends TypeSystemException {
    }

    public static class UnsupportedConversionException
    extends TypeSystemException {
    }

    public static class InvalidTypeArgumentException
    extends TypeSystemException {
    }

    public static class TypeSystemException
    extends Exception {
    }

    public static class StaticFieldReference
    extends FieldReference {
        public StaticFieldReference(DJField field, Type type) {
            super(field, type);
        }
    }

    public static class ObjectFieldReference
    extends FieldReference {
        private final Expression _object;

        public ObjectFieldReference(DJField field, Type type, Expression object) {
            super(field, type);
            this._object = object;
        }

        public Expression object() {
            return this._object;
        }
    }

    public static abstract class FieldReference {
        private final DJField _field;
        private final Type _type;

        protected FieldReference(DJField field, Type type) {
            this._field = field;
            this._type = type;
        }

        public DJField field() {
            return this._field;
        }

        public Type type() {
            return this._type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticMethodInvocation
    extends MethodInvocation {
        public StaticMethodInvocation(DJMethod method, Type returnType, Iterable<? extends Type> typeArgs, Iterable<? extends Expression> args, Iterable<? extends Type> thrown) {
            super(method, returnType, typeArgs, args, thrown);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectMethodInvocation
    extends MethodInvocation {
        private final Expression _object;

        public ObjectMethodInvocation(DJMethod method, Type returnType, Expression object, Iterable<? extends Type> typeArgs, Iterable<? extends Expression> args, Iterable<? extends Type> thrown) {
            super(method, returnType, typeArgs, args, thrown);
            this._object = object;
        }

        public Expression object() {
            return this._object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MethodInvocation
    extends ProcedureInvocation {
        private final DJMethod _method;
        private final Type _returnType;

        protected MethodInvocation(DJMethod method, Type returnType, Iterable<? extends Type> typeArgs, Iterable<? extends Expression> args, Iterable<? extends Type> thrown) {
            super(typeArgs, args, thrown);
            this._method = method;
            this._returnType = returnType;
        }

        public DJMethod method() {
            return this._method;
        }

        public Type returnType() {
            return this._returnType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorInvocation
    extends ProcedureInvocation {
        private final DJConstructor _constructor;

        public ConstructorInvocation(DJConstructor constructor, Iterable<? extends Type> typeArgs, Iterable<? extends Expression> args, Iterable<? extends Type> thrown) {
            super(typeArgs, args, thrown);
            this._constructor = constructor;
        }

        public DJConstructor constructor() {
            return this._constructor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ProcedureInvocation {
        private final Iterable<? extends Type> _typeArgs;
        private final Iterable<? extends Expression> _args;
        private final Iterable<? extends Type> _thrown;

        protected ProcedureInvocation(Iterable<? extends Type> typeArgs, Iterable<? extends Expression> args, Iterable<? extends Type> thrown) {
            this._typeArgs = typeArgs;
            this._args = args;
            this._thrown = thrown;
        }

        public Iterable<? extends Type> typeArgs() {
            return this._typeArgs;
        }

        public Iterable<? extends Expression> args() {
            return this._args;
        }

        public Iterable<? extends Type> thrown() {
            return this._thrown;
        }
    }

    public class TypeWrapper {
        private Type _t;

        public TypeWrapper(Type t) {
            this._t = t;
        }

        public String toString() {
            return TypeSystem.this.userRepresentation(this._t);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeWrapper)) {
                return false;
            }
            return TypeSystem.this.isEqual(this._t, ((TypeWrapper)o)._t);
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

