/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.ArrayLengthField;
import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJField;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ArrayType;
import edu.rice.cs.dynamicjava.symbol.type.BooleanType;
import edu.rice.cs.dynamicjava.symbol.type.BottomType;
import edu.rice.cs.dynamicjava.symbol.type.ByteType;
import edu.rice.cs.dynamicjava.symbol.type.CharType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.DoubleType;
import edu.rice.cs.dynamicjava.symbol.type.FloatType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.IntersectionType;
import edu.rice.cs.dynamicjava.symbol.type.LongType;
import edu.rice.cs.dynamicjava.symbol.type.NullType;
import edu.rice.cs.dynamicjava.symbol.type.NumericType;
import edu.rice.cs.dynamicjava.symbol.type.ParameterizedClassType;
import edu.rice.cs.dynamicjava.symbol.type.PrimitiveType;
import edu.rice.cs.dynamicjava.symbol.type.RawClassType;
import edu.rice.cs.dynamicjava.symbol.type.ReferenceType;
import edu.rice.cs.dynamicjava.symbol.type.ShortType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleClassType;
import edu.rice.cs.dynamicjava.symbol.type.TopType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.TypeAbstractVisitor;
import edu.rice.cs.dynamicjava.symbol.type.TypeUpdateVisitor;
import edu.rice.cs.dynamicjava.symbol.type.TypeVisitor;
import edu.rice.cs.dynamicjava.symbol.type.TypeVisitorLambda;
import edu.rice.cs.dynamicjava.symbol.type.TypeVisitor_void;
import edu.rice.cs.dynamicjava.symbol.type.UnionType;
import edu.rice.cs.dynamicjava.symbol.type.VarargArrayType;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.dynamicjava.symbol.type.VoidType;
import edu.rice.cs.dynamicjava.symbol.type.Wildcard;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.EmptyIterable;
import edu.rice.cs.plt.iter.FilteredIterable;
import edu.rice.cs.plt.iter.FiniteSequenceIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.recur.PrecomputedRecursionStack;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeUtil;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.TypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardTypeSystem
extends TypeSystem {
    private final boolean _supportBoxing;
    protected static final Type CLONEABLE_AND_SERIALIZABLE = new IntersectionType(IterUtil.make(CLONEABLE, SERIALIZABLE));
    private final Type ITERABLE;
    private final Type COLLECTION;
    private final Type ENUM;
    private final DJClass CLASS;
    private static final TypeVisitorLambda<Boolean> IS_PRIMITIVE = new TypeAbstractVisitor<Boolean>(){

        @Override
        public Boolean defaultCase(Type t) {
            return false;
        }

        @Override
        public Boolean forPrimitiveType(PrimitiveType t) {
            return true;
        }
    };
    private static final TypeVisitorLambda<Boolean> IS_REFERENCE = new TypeAbstractVisitor<Boolean>(){

        @Override
        public Boolean defaultCase(Type t) {
            return false;
        }

        @Override
        public Boolean forReferenceType(ReferenceType t) {
            return true;
        }

        @Override
        public Boolean forVariableType(VariableType t) {
            return true;
        }

        @Override
        public Boolean forIntersectionType(IntersectionType t) {
            return true;
        }

        @Override
        public Boolean forUnionType(UnionType t) {
            return true;
        }
    };
    private static final TypeVisitorLambda<Boolean> IS_ARRAY = new TypeAbstractVisitor<Boolean>(){
        private final Predicate<Type> PRED = LambdaUtil.asPredicate(this);

        @Override
        public Boolean defaultCase(Type t) {
            return false;
        }

        @Override
        public Boolean forArrayType(ArrayType t) {
            return true;
        }

        @Override
        public Boolean forVariableType(VariableType t) {
            return t.symbol().upperBound().apply(this);
        }

        @Override
        public Boolean forIntersectionType(IntersectionType t) {
            return IterUtil.or(t.ofTypes(), this.PRED);
        }

        @Override
        public Boolean forUnionType(UnionType t) {
            return !IterUtil.isEmpty(t.ofTypes()) && IterUtil.and(t.ofTypes(), this.PRED);
        }
    };
    private final TypeVisitorLambda<Boolean> IS_REIFIABLE;
    private final TypeVisitorLambda<Boolean> IS_UNBOUNDED_WILDCARD;
    private static final TypeVisitorLambda<Boolean> IS_CONCRETE = new TypeAbstractVisitor<Boolean>(){

        @Override
        public Boolean defaultCase(Type t) {
            return false;
        }

        @Override
        public Boolean forPrimitiveType(PrimitiveType t) {
            return true;
        }

        @Override
        public Boolean forArrayType(ArrayType t) {
            return true;
        }

        @Override
        public Boolean forSimpleClassType(SimpleClassType t) {
            return this.isConcreteClass(t.ofClass());
        }

        @Override
        public Boolean forRawClassType(RawClassType t) {
            return this.isConcreteClass(t.ofClass());
        }

        @Override
        public Boolean forParameterizedClassType(ParameterizedClassType t) {
            if (!this.isConcreteClass(t.ofClass())) {
                return false;
            }
            for (Type type : t.typeArguments()) {
                if (!(type instanceof Wildcard)) continue;
                return false;
            }
            return true;
        }

        private boolean isConcreteClass(DJClass c) {
            return !c.isInterface() && !c.isAbstract();
        }
    };
    private static final TypeVisitorLambda<Boolean> IS_STATIC = new TypeAbstractVisitor<Boolean>(){

        @Override
        public Boolean defaultCase(Type t) {
            return true;
        }

        @Override
        public Boolean forClassType(ClassType t) {
            DJClass outer = null;
            for (DJClass inner : SymbolUtil.outerClassChain(t.ofClass())) {
                if (outer != null && !inner.isStatic()) {
                    return false;
                }
                outer = inner;
            }
            return true;
        }
    };
    private static final TypeVisitorLambda<Boolean> IS_EXTENDABLE = new TypeAbstractVisitor<Boolean>(){

        @Override
        public Boolean defaultCase(Type t) {
            return false;
        }

        @Override
        public Boolean forClassType(ClassType t) {
            return !t.ofClass().isInterface() && !t.ofClass().isFinal();
        }
    };
    private static final TypeVisitorLambda<Boolean> IS_IMPLEMENTABLE = new TypeAbstractVisitor<Boolean>(){

        @Override
        public Boolean defaultCase(Type t) {
            return false;
        }

        @Override
        public Boolean forClassType(ClassType t) {
            return t.ofClass().isInterface();
        }
    };
    private final TypeVisitorLambda<Type> CAPTURE;
    private static final TypeVisitorLambda<Type> ERASE = new TypeAbstractVisitor<Type>(){

        @Override
        public Type defaultCase(Type t) {
            return t;
        }

        @Override
        public Type forNullType(NullType t) {
            return TypeSystem.OBJECT;
        }

        @Override
        public Type forSimpleArrayType(SimpleArrayType t) {
            Type newElementType = t.ofType().apply(this);
            return t.ofType() == newElementType ? t : new SimpleArrayType(newElementType);
        }

        @Override
        public Type forVarargArrayType(VarargArrayType t) {
            Type newElementType = t.ofType().apply(this);
            return t.ofType() == newElementType ? t : new VarargArrayType(newElementType);
        }

        @Override
        public Type forParameterizedClassType(ParameterizedClassType t) {
            return new RawClassType(t.ofClass());
        }

        @Override
        public Type forVariableType(VariableType t) {
            return t.symbol().upperBound().apply(this);
        }

        @Override
        public Type forIntersectionType(IntersectionType t) {
            if (IterUtil.isEmpty(t.ofTypes())) {
                return TypeSystem.OBJECT;
            }
            return IterUtil.first(t.ofTypes()).apply(this);
        }

        @Override
        public Type forUnionType(UnionType t) {
            return TypeSystem.OBJECT;
        }

        @Override
        public Type forWildcard(Wildcard t) {
            throw new IllegalArgumentException();
        }

        @Override
        public Type forTopType(TopType t) {
            throw new IllegalArgumentException();
        }

        @Override
        public Type forBottomType(BottomType t) {
            throw new IllegalArgumentException();
        }
    };
    private final Lambda<Type, Type> ERASE_LAMBDA;
    private static final TypeVisitorLambda<Thunk<Class<?>>> ERASED_CLASS = new TypeVisitorLambda<Thunk<Class<?>>>(){

        @Override
        public Thunk<Class<?>> forBooleanType(BooleanType t) {
            return LambdaUtil.valueLambda(Boolean.TYPE);
        }

        @Override
        public Thunk<Class<?>> forCharType(CharType t) {
            return LambdaUtil.valueLambda(Character.TYPE);
        }

        @Override
        public Thunk<Class<?>> forByteType(ByteType t) {
            return LambdaUtil.valueLambda(Byte.TYPE);
        }

        @Override
        public Thunk<Class<?>> forShortType(ShortType t) {
            return LambdaUtil.valueLambda(Short.TYPE);
        }

        @Override
        public Thunk<Class<?>> forIntType(IntType t) {
            return LambdaUtil.valueLambda(Integer.TYPE);
        }

        @Override
        public Thunk<Class<?>> forLongType(LongType t) {
            return LambdaUtil.valueLambda(Long.TYPE);
        }

        @Override
        public Thunk<Class<?>> forFloatType(FloatType t) {
            return LambdaUtil.valueLambda(Float.TYPE);
        }

        @Override
        public Thunk<Class<?>> forDoubleType(DoubleType t) {
            return LambdaUtil.valueLambda(Double.TYPE);
        }

        @Override
        public Thunk<Class<?>> forNullType(NullType t) {
            return this.forSimpleClassType(TypeSystem.OBJECT);
        }

        @Override
        public Thunk<Class<?>> forSimpleArrayType(SimpleArrayType t) {
            Thunk elementType = (Thunk)t.ofType().apply(this);
            return elementType == null ? null : SymbolUtil.arrayClassThunk(elementType);
        }

        @Override
        public Thunk<Class<?>> forVarargArrayType(VarargArrayType t) {
            Thunk elementType = (Thunk)t.ofType().apply(this);
            return elementType == null ? null : SymbolUtil.arrayClassThunk(elementType);
        }

        @Override
        public Thunk<Class<?>> forSimpleClassType(SimpleClassType t) {
            return this.wrapDJClass(t.ofClass());
        }

        @Override
        public Thunk<Class<?>> forRawClassType(RawClassType t) {
            return this.wrapDJClass(t.ofClass());
        }

        @Override
        public Thunk<Class<?>> forParameterizedClassType(ParameterizedClassType t) {
            return this.wrapDJClass(t.ofClass());
        }

        @Override
        public Thunk<Class<?>> forVariableType(VariableType t) {
            return (Thunk)t.symbol().upperBound().apply(this);
        }

        @Override
        public Thunk<Class<?>> forIntersectionType(IntersectionType t) {
            Iterator<? extends Type> sups = t.ofTypes().iterator();
            if (!sups.hasNext()) {
                return null;
            }
            return (Thunk)sups.next().apply(this);
        }

        @Override
        public Thunk<Class<?>> forUnionType(UnionType t) {
            return this.forSimpleClassType(TypeSystem.OBJECT);
        }

        @Override
        public Thunk<Class<?>> forWildcard(Wildcard t) {
            throw new IllegalArgumentException();
        }

        @Override
        public Thunk<Class<?>> forVoidType(VoidType t) {
            return LambdaUtil.valueLambda(Void.TYPE);
        }

        @Override
        public Thunk<Class<?>> forTopType(TopType t) {
            throw new IllegalArgumentException();
        }

        @Override
        public Thunk<Class<?>> forBottomType(BottomType t) {
            throw new IllegalArgumentException();
        }

        private Thunk<Class<?>> wrapDJClass(final DJClass c) {
            return new Thunk<Class<?>>(){

                @Override
                public Class<?> value() {
                    return c.load();
                }
            };
        }
    };
    private final TypeVisitorLambda<Type> ARRAY_ELEMENT_TYPE;
    private static final Lambda<Type, Expression> EMPTY_EXPRESSION_FOR_TYPE = new Lambda<Type, Expression>(){

        @Override
        public Expression value(Type t) {
            Expression result = TypeUtil.makeEmptyExpression();
            NodeProperties.setType(result, t);
            return result;
        }
    };

    protected StandardTypeSystem() {
        Class<?> c;
        try {
            c = Class.forName("java.lang.Iterable");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        this.ITERABLE = c == null ? null : this.makeClassType(SymbolUtil.wrapClass(c));
        this.COLLECTION = this.makeClassType(SymbolUtil.wrapClass(Collection.class));
        try {
            c = Class.forName("java.lang.Enum");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        this.ENUM = c == null ? null : this.makeClassType(SymbolUtil.wrapClass(c));
        this.CLASS = SymbolUtil.wrapClass(Class.class);
        this.IS_REIFIABLE = new TypeAbstractVisitor<Boolean>(){

            @Override
            public Boolean defaultCase(Type t) {
                return false;
            }

            @Override
            public Boolean forPrimitiveType(PrimitiveType t) {
                return true;
            }

            @Override
            public Boolean forNullType(NullType t) {
                return true;
            }

            @Override
            public Boolean forArrayType(ArrayType t) {
                return t.ofType().apply(this);
            }

            @Override
            public Boolean forSimpleClassType(SimpleClassType t) {
                return true;
            }

            @Override
            public Boolean forRawClassType(RawClassType t) {
                return true;
            }

            @Override
            public Boolean forVoidType(VoidType t) {
                return true;
            }

            @Override
            public Boolean forParameterizedClassType(ParameterizedClassType t) {
                for (Type type : t.typeArguments()) {
                    if (((Boolean)type.apply(StandardTypeSystem.this.IS_UNBOUNDED_WILDCARD)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
        this.IS_UNBOUNDED_WILDCARD = new TypeAbstractVisitor<Boolean>(){

            @Override
            public Boolean defaultCase(Type t) {
                return false;
            }

            @Override
            public Boolean forWildcard(Wildcard t) {
                return StandardTypeSystem.this.isEqual(t.symbol().upperBound(), TypeSystem.OBJECT) && StandardTypeSystem.this.isEqual(t.symbol().lowerBound(), TypeSystem.NULL);
            }
        };
        this.CAPTURE = new TypeAbstractVisitor<Type>(){

            @Override
            public Type defaultCase(Type t) {
                return t;
            }

            @Override
            public Type forParameterizedClassType(ParameterizedClassType t) {
                return StandardTypeSystem.this.capture(t);
            }
        };
        this.ERASE_LAMBDA = new Lambda<Type, Type>(){

            @Override
            public Type value(Type t) {
                return StandardTypeSystem.this.erase(t);
            }
        };
        this.ARRAY_ELEMENT_TYPE = new TypeAbstractVisitor<Type>(){

            @Override
            public Type defaultCase(Type t) {
                throw new IllegalArgumentException();
            }

            @Override
            public Type forArrayType(ArrayType t) {
                return t.ofType();
            }

            @Override
            public Type forVariableType(VariableType t) {
                return t.symbol().upperBound().apply(this);
            }

            @Override
            public Type forIntersectionType(IntersectionType t) {
                return StandardTypeSystem.this.meet(IterUtil.map(t.ofTypes(), new Lambda<Type, Type>(){

                    @Override
                    public Type value(Type arrayT) {
                        return (Boolean)arrayT.apply(IS_ARRAY) != false ? (Type)arrayT.apply(StandardTypeSystem.this.ARRAY_ELEMENT_TYPE) : TypeSystem.TOP;
                    }
                }));
            }

            @Override
            public Type forUnionType(UnionType t) {
                return StandardTypeSystem.this.join(IterUtil.map(t.ofTypes(), this));
            }
        };
        this._supportBoxing = true;
    }

    protected StandardTypeSystem(boolean supportBoxing) {
        Class<?> c;
        try {
            c = Class.forName("java.lang.Iterable");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        this.ITERABLE = c == null ? null : this.makeClassType(SymbolUtil.wrapClass(c));
        this.COLLECTION = this.makeClassType(SymbolUtil.wrapClass(Collection.class));
        try {
            c = Class.forName("java.lang.Enum");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        this.ENUM = c == null ? null : this.makeClassType(SymbolUtil.wrapClass(c));
        this.CLASS = SymbolUtil.wrapClass(Class.class);
        this.IS_REIFIABLE = new /* invalid duplicate definition of identical inner class */;
        this.IS_UNBOUNDED_WILDCARD = new /* invalid duplicate definition of identical inner class */;
        this.CAPTURE = new /* invalid duplicate definition of identical inner class */;
        this.ERASE_LAMBDA = new /* invalid duplicate definition of identical inner class */;
        this.ARRAY_ELEMENT_TYPE = new /* invalid duplicate definition of identical inner class */;
        this._supportBoxing = supportBoxing;
    }

    @Override
    public abstract boolean isWellFormed(Type var1);

    @Override
    public abstract boolean isEqual(Type var1, Type var2);

    @Override
    public abstract boolean isSubtype(Type var1, Type var2);

    @Override
    public abstract Type join(Iterable<? extends Type> var1);

    @Override
    public abstract Type meet(Iterable<? extends Type> var1);

    protected abstract Iterable<Type> captureTypeArgs(Iterable<? extends Type> var1, Iterable<? extends VariableType> var2);

    protected abstract Iterable<Type> inferTypeArguments(Iterable<? extends VariableType> var1, Iterable<? extends Type> var2, Type var3, Iterable<? extends Type> var4, Option<Type> var5);

    @Override
    public boolean isPrimitive(Type t) {
        return t.apply(IS_PRIMITIVE);
    }

    @Override
    public boolean isReference(Type t) {
        return t.apply(IS_REFERENCE);
    }

    @Override
    public boolean isArray(Type t) {
        return t.apply(IS_ARRAY);
    }

    @Override
    public boolean isIterable(Type t) {
        return this.isSubtype(t, this.ITERABLE == null ? this.COLLECTION : this.ITERABLE);
    }

    @Override
    public boolean isEnum(Type t) {
        return this.ENUM != null && this.isSubtype(t, this.ENUM);
    }

    @Override
    public boolean isReifiable(Type t) {
        return t.apply(this.IS_REIFIABLE);
    }

    @Override
    public boolean isConcrete(Type t) {
        return t.apply(IS_CONCRETE);
    }

    @Override
    public boolean isStatic(Type t) {
        return t.apply(IS_STATIC);
    }

    @Override
    public boolean isExtendable(Type t) {
        return t.apply(IS_EXTENDABLE);
    }

    @Override
    public boolean isImplementable(Type t) {
        return t.apply(IS_IMPLEMENTABLE);
    }

    @Override
    public boolean isCastable(Type target, Type expT) {
        try {
            Expression e = TypeUtil.makeEmptyExpression();
            NodeProperties.setType(e, expT);
            this.cast(target, e);
            return true;
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            return false;
        }
    }

    @Override
    public boolean isAssignable(Type target, Type expT) {
        try {
            Expression e = TypeUtil.makeEmptyExpression();
            NodeProperties.setType(e, expT);
            this.assign(target, e);
            return true;
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            return false;
        }
    }

    @Override
    public boolean isAssignable(Type target, Type expT, Object expValue) {
        try {
            Expression e = TypeUtil.makeEmptyExpression();
            NodeProperties.setType(e, expT);
            NodeProperties.setValue(e, expValue);
            this.assign(target, e);
            return true;
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            return false;
        }
    }

    @Override
    public boolean isPrimitiveConvertible(Type t) {
        return this.isPrimitive(t) || this._supportBoxing && !this.isSubtype(t, NULL) && (this.isSubtype(t, BOOLEAN_CLASS) || this.isSubtype(t, CHARACTER_CLASS) || this.isSubtype(t, BYTE_CLASS) || this.isSubtype(t, SHORT_CLASS) || this.isSubtype(t, INTEGER_CLASS) || this.isSubtype(t, LONG_CLASS) || this.isSubtype(t, FLOAT_CLASS) || this.isSubtype(t, DOUBLE_CLASS));
    }

    @Override
    public boolean isReferenceConvertible(Type t) {
        return this.isReference(t) || this._supportBoxing && t instanceof PrimitiveType;
    }

    public Type immediateSuperclass(Type t) {
        if (t instanceof ClassType) {
            return ((ClassType)t).ofClass().immediateSuperclass();
        }
        return null;
    }

    @Override
    public Type capture(Type t) {
        return t.apply(this.CAPTURE);
    }

    protected ParameterizedClassType capture(ParameterizedClassType t) {
        boolean ground = true;
        for (Type type : t.typeArguments()) {
            if (!(type instanceof Wildcard)) continue;
            ground = false;
            break;
        }
        if (ground) {
            return t;
        }
        Iterable<VariableType> params = SymbolUtil.allTypeParameters(t.ofClass());
        Iterable<Type> iterable = this.captureTypeArgs(t.typeArguments(), params);
        return new ParameterizedClassType(t.ofClass(), iterable);
    }

    @Override
    public Type erase(Type t) {
        return t.apply(ERASE);
    }

    @Override
    public Thunk<Class<?>> erasedClass(Type t) {
        return t.apply(ERASED_CLASS);
    }

    @Override
    public Type reflectionClassOf(Type t) {
        if (IterUtil.isEmpty(SymbolUtil.allTypeParameters(this.CLASS))) {
            return this.makeClassType(this.CLASS);
        }
        try {
            return this.makeClassType(this.CLASS, IterUtil.make(t));
        }
        catch (TypeSystem.InvalidTypeArgumentException e) {
            throw new RuntimeException("java.lang.Class has unexpected type parameter(s)");
        }
    }

    @Override
    public Type arrayElementType(Type t) {
        return t.apply(this.ARRAY_ELEMENT_TYPE);
    }

    protected Type substitute(Type t, Iterable<? extends VariableType> params, Iterable<? extends Type> args) {
        return this.substitute(t, new SubstitutionMap(params, args));
    }

    protected Type substitute(Type t, Map<? extends VariableType, ? extends Type> map) {
        return this.substitute(t, new SubstitutionMap(map));
    }

    protected Type substitute(Type t, final SubstitutionMap sigma) {
        if (sigma.isEmpty()) {
            return t;
        }
        final PrecomputedRecursionStack stack = PrecomputedRecursionStack.make();
        return t.apply(new TypeUpdateVisitor(){

            public Type forVariableType(VariableType t) {
                Type result = sigma.get(t);
                return result == null ? t : result;
            }

            public Type forWildcard(final Wildcard t) {
                final Wildcard newWildcard = new Wildcard(new BoundedSymbol(new Object()));
                Thunk<Type> substituteBounds = new Thunk<Type>(){

                    @Override
                    public Type value() {
                        BoundedSymbol bounds = t.symbol();
                        Type newUpper = this.recur(bounds.upperBound());
                        Type newLower = this.recur(bounds.lowerBound());
                        if (newUpper == bounds.upperBound() && newLower == bounds.lowerBound()) {
                            return t;
                        }
                        newWildcard.symbol().initializeUpperBound(newUpper);
                        newWildcard.symbol().initializeLowerBound(newLower);
                        return newWildcard;
                    }
                };
                return stack.apply(substituteBounds, newWildcard, t);
            }
        });
    }

    private Iterable<? extends Type> substitute(Iterable<? extends Type> ts, Iterable<? extends VariableType> vars, Iterable<? extends Type> values) {
        return this.substitute(ts, new SubstitutionMap(vars, values));
    }

    private Iterable<? extends Type> substitute(Iterable<? extends Type> ts, final SubstitutionMap sigma) {
        if (sigma.isEmpty()) {
            return ts;
        }
        return IterUtil.mapSnapshot(ts, new Lambda<Type, Type>(){

            @Override
            public Type value(Type t) {
                return StandardTypeSystem.this.substitute(t, sigma);
            }
        });
    }

    @Override
    public String userRepresentation(Type t) {
        final StringBuilder result = new StringBuilder();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class VariableHandler {
            private final List<VariableType> _vars = new ArrayList<VariableType>();
            private final Map<VariableType, String> _names = new HashMap<VariableType, String>();
            int _captureVars = 0;

            VariableHandler() {
            }

            public boolean isEmpty() {
                for (VariableType v : this._vars) {
                    boolean printLower;
                    Type upper = v.symbol().upperBound();
                    Type lower = v.symbol().lowerBound();
                    boolean printUpper = !StandardTypeSystem.this.isEqual(upper, TypeSystem.OBJECT);
                    boolean bl = printLower = !StandardTypeSystem.this.isEqual(lower, TypeSystem.NULL);
                    if (!printUpper && !printLower) continue;
                    return false;
                }
                return true;
            }

            public String registerVariable(VariableType v) {
                String result2 = this._names.get(v);
                if (result2 == null) {
                    if (v.symbol().generated()) {
                        ++this._captureVars;
                        result2 = "?" + this._captureVars;
                    } else {
                        result2 = v.symbol().name();
                    }
                    this._vars.add(v);
                    this._names.put(v, result2);
                }
                return result2;
            }

            public void dumpBounds(Runnable1<Type> dumpType) {
                boolean printedFirst = false;
                for (int i = 0; i < this._vars.size(); ++i) {
                    boolean printLower;
                    VariableType v = this._vars.get(i);
                    Type upper = v.symbol().upperBound();
                    Type lower = v.symbol().lowerBound();
                    boolean printUpper = !StandardTypeSystem.this.isEqual(upper, TypeSystem.OBJECT);
                    boolean bl = printLower = !StandardTypeSystem.this.isEqual(lower, TypeSystem.NULL);
                    if (printUpper || printLower) {
                        if (printedFirst) {
                            result.append("; ");
                        } else {
                            printedFirst = true;
                        }
                    }
                    if (printUpper) {
                        result.append(this._names.get(v));
                        result.append(" <: ");
                        dumpType.run(upper);
                    }
                    if (!printLower) continue;
                    if (printUpper) {
                        result.append(", ");
                    }
                    result.append(this._names.get(v));
                    result.append(" :> ");
                    dumpType.run(lower);
                }
            }
        }
        final VariableHandler variableHandler = new VariableHandler();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DumpType
        implements TypeVisitor_void,
        Runnable1<Type> {
            final RecursionStack<Type> _stack = new RecursionStack();

            DumpType() {
            }

            @Override
            public void run(final Type t) {
                Runnable recur = new Runnable(){

                    public void run() {
                        t.apply(this);
                    }
                };
                Runnable dontRecur = new Runnable(){

                    public void run() {
                        result.append("...");
                    }
                };
                this._stack.run(recur, dontRecur, t);
            }

            @Override
            public void forBooleanType(BooleanType t) {
                result.append("boolean");
            }

            @Override
            public void forCharType(CharType t) {
                result.append("char");
            }

            @Override
            public void forByteType(ByteType t) {
                result.append("byte");
            }

            @Override
            public void forShortType(ShortType t) {
                result.append("short");
            }

            @Override
            public void forIntType(IntType t) {
                result.append("int");
            }

            @Override
            public void forLongType(LongType t) {
                result.append("long");
            }

            @Override
            public void forFloatType(FloatType t) {
                result.append("float");
            }

            @Override
            public void forDoubleType(DoubleType t) {
                result.append("double");
            }

            @Override
            public void forNullType(NullType t) {
                result.append("(null)");
            }

            @Override
            public void forVoidType(VoidType t) {
                result.append("void");
            }

            @Override
            public void forTopType(TopType t) {
                result.append("(top)");
            }

            @Override
            public void forBottomType(BottomType t) {
                result.append("(bottom)");
            }

            @Override
            public void forSimpleArrayType(SimpleArrayType t) {
                this.run(t.ofType());
                result.append("[]");
            }

            @Override
            public void forVarargArrayType(VarargArrayType t) {
                this.run(t.ofType());
                result.append("[]");
            }

            @Override
            public void forSimpleClassType(SimpleClassType t) {
                result.append(SymbolUtil.shortName(t.ofClass()));
            }

            @Override
            public void forRawClassType(RawClassType t) {
                result.append("raw ");
                result.append(SymbolUtil.shortName(t.ofClass()));
            }

            @Override
            public void forParameterizedClassType(ParameterizedClassType t) {
                Iterator<DJClass> classes = SymbolUtil.outerClassChain(t.ofClass()).iterator();
                Iterator<? extends Type> targs = t.typeArguments().iterator();
                DJClass c = classes.next();
                result.append(SymbolUtil.shortName(c));
                while (c != null) {
                    Iterable<VariableType> params;
                    DJClass inner;
                    DJClass dJClass = inner = classes.hasNext() ? classes.next() : null;
                    if (!(inner != null && inner.isStatic() || IterUtil.isEmpty(params = c.declaredTypeParameters()))) {
                        result.append("<");
                        boolean firstParam = true;
                        for (VariableType param : params) {
                            if (!firstParam) {
                                result.append(", ");
                            }
                            firstParam = false;
                            this.run(targs.next());
                        }
                        result.append(">");
                    }
                    if (inner != null) {
                        result.append(".");
                        result.append(c.declaredName());
                    }
                    c = inner;
                }
            }

            @Override
            public void forVariableType(VariableType t) {
                String name = variableHandler.registerVariable(t);
                result.append(name);
            }

            @Override
            public void forIntersectionType(IntersectionType t) {
                int size = IterUtil.sizeOf(t.ofTypes());
                if (size == 0) {
                    result.append("(empty intersect)");
                } else if (size == 1) {
                    result.append("(intersect ");
                    this.run(IterUtil.first(t.ofTypes()));
                    result.append(")");
                } else {
                    boolean first = true;
                    for (Type type : t.ofTypes()) {
                        if (first) {
                            first = false;
                        } else {
                            result.append(" & ");
                        }
                        this.run(type);
                    }
                }
            }

            @Override
            public void forUnionType(UnionType t) {
                int size = IterUtil.sizeOf(t.ofTypes());
                if (size == 0) {
                    result.append("(empty union)");
                } else if (size == 1) {
                    result.append("(union ");
                    this.run(IterUtil.first(t.ofTypes()));
                    result.append(")");
                } else {
                    boolean first = true;
                    for (Type type : t.ofTypes()) {
                        if (first) {
                            first = false;
                        } else {
                            result.append(" | ");
                        }
                        this.run(type);
                    }
                }
            }

            @Override
            public void forWildcard(Wildcard t) {
                result.append("?");
                if (!StandardTypeSystem.this.isEqual(t.symbol().upperBound(), TypeSystem.OBJECT)) {
                    result.append(" extends ");
                    this.run(t.symbol().upperBound());
                }
                if (!StandardTypeSystem.this.isEqual(t.symbol().lowerBound(), TypeSystem.NULL)) {
                    result.append(" super ");
                    this.run(t.symbol().lowerBound());
                }
            }
        }
        DumpType dumpType = new DumpType();
        dumpType.run(t);
        if (!variableHandler.isEmpty()) {
            result.append(" (");
            variableHandler.dumpBounds(dumpType);
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public ClassType makeClassType(DJClass c) {
        if (IterUtil.isEmpty(SymbolUtil.allTypeParameters(c))) {
            return new SimpleClassType(c);
        }
        return new RawClassType(c);
    }

    @Override
    public ClassType makeClassType(DJClass c, Iterable<? extends Type> args) throws TypeSystem.InvalidTypeArgumentException {
        if (IterUtil.isEmpty(args)) {
            return this.makeClassType(c);
        }
        Iterable<VariableType> params = SymbolUtil.allTypeParameters(c);
        if (IterUtil.sizeOf(params) != IterUtil.sizeOf(args)) {
            throw new TypeSystem.InvalidTypeArgumentException();
        }
        ParameterizedClassType result = new ParameterizedClassType(c, args);
        return result;
    }

    @Override
    public Expression makePrimitive(Expression e) throws TypeSystem.UnsupportedConversionException {
        Type t = NodeProperties.getType(e);
        if (this.isPrimitive(t)) {
            return e;
        }
        if (!this._supportBoxing) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        if (this.isSubtype(t, NULL)) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        if (this.isSubtype(t, BOOLEAN_CLASS)) {
            return this.unbox(e, "booleanValue");
        }
        if (this.isSubtype(t, CHARACTER_CLASS)) {
            return this.unbox(e, "charValue");
        }
        if (this.isSubtype(t, BYTE_CLASS)) {
            return this.unbox(e, "byteValue");
        }
        if (this.isSubtype(t, SHORT_CLASS)) {
            return this.unbox(e, "shortValue");
        }
        if (this.isSubtype(t, INTEGER_CLASS)) {
            return this.unbox(e, "intValue");
        }
        if (this.isSubtype(t, LONG_CLASS)) {
            return this.unbox(e, "longValue");
        }
        if (this.isSubtype(t, FLOAT_CLASS)) {
            return this.unbox(e, "floatValue");
        }
        if (this.isSubtype(t, DOUBLE_CLASS)) {
            return this.unbox(e, "doubleValue");
        }
        throw new TypeSystem.UnsupportedConversionException();
    }

    private Expression unbox(Expression exp, String methodName) {
        ObjectMethodCall result = new ObjectMethodCall(exp, methodName, null, exp.getSourceInfo());
        try {
            TypeSystem.ObjectMethodInvocation inv = this.lookupMethod(exp, methodName, EMPTY_TYPE_ITERABLE, EMPTY_EXPRESSION_ITERABLE, NONE_TYPE_OPTION);
            result.setExpression(inv.object());
            result.setArguments(CollectUtil.makeList(inv.args()));
            NodeProperties.setMethod(result, inv.method());
            NodeProperties.setType(result, this.capture(inv.returnType()));
            return result;
        }
        catch (TypeSystem.TypeSystemException e) {
            throw new RuntimeException("Unboxing method inaccessible", e);
        }
    }

    @Override
    public Expression makeReference(final Expression e) throws TypeSystem.UnsupportedConversionException {
        Type t = NodeProperties.getType(e);
        if (this.isReference(t)) {
            return e;
        }
        if (!this._supportBoxing) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        Expression result = t.apply(new TypeAbstractVisitor<Expression>(){

            @Override
            public Expression defaultCase(Type t) {
                return null;
            }

            @Override
            public Expression forBooleanType(BooleanType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.BOOLEAN_CLASS);
            }

            @Override
            public Expression forCharType(CharType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.CHARACTER_CLASS);
            }

            @Override
            public Expression forByteType(ByteType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.BYTE_CLASS);
            }

            @Override
            public Expression forShortType(ShortType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.SHORT_CLASS);
            }

            @Override
            public Expression forIntType(IntType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.INTEGER_CLASS);
            }

            @Override
            public Expression forLongType(LongType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.LONG_CLASS);
            }

            @Override
            public Expression forFloatType(FloatType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.FLOAT_CLASS);
            }

            @Override
            public Expression forDoubleType(DoubleType t) {
                return StandardTypeSystem.this.box(e, TypeSystem.DOUBLE_CLASS);
            }
        });
        if (result == null) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        return result;
    }

    private Expression box(Expression exp, ClassType boxedType) {
        ReferenceTypeName boxedTypeName = new ReferenceTypeName("java", "lang", boxedType.ofClass().declaredName());
        NodeProperties.setType(boxedTypeName, boxedType);
        List<Expression> arguments = Collections.singletonList(exp);
        if (JavaVersion.CURRENT.supports(JavaVersion.JAVA_5)) {
            StaticMethodCall m = new StaticMethodCall(boxedTypeName, "valueOf", arguments, exp.getSourceInfo());
            try {
                TypeSystem.StaticMethodInvocation inv = this.lookupStaticMethod(boxedType, "valueOf", EMPTY_TYPE_ITERABLE, arguments, NONE_TYPE_OPTION);
                m.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(m, inv.method());
                NodeProperties.setType(m, this.capture(inv.returnType()));
                return m;
            }
            catch (TypeSystem.TypeSystemException e) {
                throw new RuntimeException("Boxing method inaccessible", e);
            }
        }
        SimpleAllocation k = new SimpleAllocation(boxedTypeName, arguments, exp.getSourceInfo());
        try {
            TypeSystem.ConstructorInvocation inv = this.lookupConstructor(boxedType, EMPTY_TYPE_ITERABLE, arguments, NONE_TYPE_OPTION);
            k.setArguments(CollectUtil.makeList(inv.args()));
            NodeProperties.setConstructor(k, inv.constructor());
            NodeProperties.setType(k, boxedType);
            return k;
        }
        catch (TypeSystem.TypeSystemException e) {
            throw new RuntimeException("Boxing constructor inaccessible", e);
        }
    }

    @Override
    public Expression unaryPromote(final Expression e) throws TypeSystem.UnsupportedConversionException {
        Expression result = NodeProperties.getType(e).apply(new TypeAbstractVisitor<Expression>(){

            @Override
            public Expression defaultCase(Type t) {
                return null;
            }

            @Override
            public Expression forNumericType(NumericType t) {
                return e;
            }

            @Override
            public Expression forCharType(CharType t) {
                return StandardTypeSystem.this.makeCast(TypeSystem.INT, e);
            }

            @Override
            public Expression forByteType(ByteType t) {
                return StandardTypeSystem.this.makeCast(TypeSystem.INT, e);
            }

            @Override
            public Expression forShortType(ShortType t) {
                return StandardTypeSystem.this.makeCast(TypeSystem.INT, e);
            }
        });
        if (result == null) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        return result;
    }

    @Override
    public Pair<Expression, Expression> binaryPromote(final Expression e1, final Expression e2) throws TypeSystem.UnsupportedConversionException {
        Type t2;
        final Type t1 = NodeProperties.getType(e1);
        Pair<Expression, Expression> result = this.join(t1, t2 = NodeProperties.getType(e2)).apply(new TypeAbstractVisitor<Pair<Expression, Expression>>(){

            @Override
            public Pair<Expression, Expression> defaultCase(Type commonT) {
                if (!(t1 instanceof NumericType) || !(t2 instanceof NumericType)) {
                    return null;
                }
                throw new IllegalArgumentException("Unexpected join result");
            }

            @Override
            public Pair<Expression, Expression> forDoubleType(DoubleType commonT) {
                return Pair.make(t1 instanceof DoubleType ? e1 : StandardTypeSystem.this.makeCast(TypeSystem.DOUBLE, e1), t2 instanceof DoubleType ? e2 : StandardTypeSystem.this.makeCast(TypeSystem.DOUBLE, e2));
            }

            @Override
            public Pair<Expression, Expression> forFloatType(FloatType commonT) {
                return Pair.make(t1 instanceof FloatType ? e1 : StandardTypeSystem.this.makeCast(TypeSystem.FLOAT, e1), t2 instanceof FloatType ? e2 : StandardTypeSystem.this.makeCast(TypeSystem.FLOAT, e2));
            }

            @Override
            public Pair<Expression, Expression> forLongType(LongType commonT) {
                return Pair.make(t1 instanceof LongType ? e1 : StandardTypeSystem.this.makeCast(TypeSystem.LONG, e1), t2 instanceof LongType ? e2 : StandardTypeSystem.this.makeCast(TypeSystem.LONG, e2));
            }

            @Override
            public Pair<Expression, Expression> forIntType(IntType commonT) {
                return Pair.make(t1 instanceof IntType ? e1 : StandardTypeSystem.this.makeCast(TypeSystem.INT, e1), t2 instanceof IntType ? e2 : StandardTypeSystem.this.makeCast(TypeSystem.INT, e2));
            }

            @Override
            public Pair<Expression, Expression> forShortType(ShortType commonT) {
                return Pair.make(StandardTypeSystem.this.makeCast(TypeSystem.INT, e1), StandardTypeSystem.this.makeCast(TypeSystem.INT, e2));
            }

            @Override
            public Pair<Expression, Expression> forByteType(ByteType commonT) {
                return Pair.make(StandardTypeSystem.this.makeCast(TypeSystem.INT, e1), StandardTypeSystem.this.makeCast(TypeSystem.INT, e2));
            }

            @Override
            public Pair<Expression, Expression> forCharType(CharType commonT) {
                return Pair.make(StandardTypeSystem.this.makeCast(TypeSystem.INT, e1), StandardTypeSystem.this.makeCast(TypeSystem.INT, e2));
            }
        });
        if (result == null) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        return result;
    }

    @Override
    public Pair<Expression, Expression> mergeConditional(final Expression e1, final Expression e2) throws TypeSystem.UnsupportedConversionException {
        return NodeProperties.getType(e1).apply(new TypeAbstractVisitor<Pair<Expression, Expression>>(){

            @Override
            public Pair<Expression, Expression> defaultCase(Type t1) {
                if (this.isNumericReference(t1)) {
                    return this.checkForNumericE2();
                }
                if (this.isBooleanReference(t1) && NodeProperties.getType(e2) instanceof BooleanType) {
                    try {
                        return Pair.make(StandardTypeSystem.this.makePrimitive(e1), e2);
                    }
                    catch (TypeSystem.UnsupportedConversionException e) {
                        throw new RuntimeException("isBooleanReference() lied");
                    }
                }
                return this.joinReferences();
            }

            @Override
            public Pair<Expression, Expression> forBooleanType(BooleanType t1) {
                Type t2 = NodeProperties.getType(e2);
                if (t2 instanceof BooleanType) {
                    return Pair.make(e1, e2);
                }
                if (this.isBooleanReference(t2)) {
                    try {
                        return Pair.make(e1, StandardTypeSystem.this.makePrimitive(e2));
                    }
                    catch (TypeSystem.UnsupportedConversionException e) {
                        throw new RuntimeException("isBooleanReference() lied");
                    }
                }
                return this.joinReferences();
            }

            @Override
            public Pair<Expression, Expression> forNumericType(NumericType t1) {
                return this.checkForNumericE2();
            }

            private boolean isNumericReference(Type t) {
                return StandardTypeSystem.this._supportBoxing && (StandardTypeSystem.this.isSubtype(t, TypeSystem.CHARACTER_CLASS) || StandardTypeSystem.this.isSubtype(t, TypeSystem.BYTE_CLASS) || StandardTypeSystem.this.isSubtype(t, TypeSystem.SHORT_CLASS) || StandardTypeSystem.this.isSubtype(t, TypeSystem.INTEGER_CLASS) || StandardTypeSystem.this.isSubtype(t, TypeSystem.LONG_CLASS) || StandardTypeSystem.this.isSubtype(t, TypeSystem.FLOAT_CLASS) || StandardTypeSystem.this.isSubtype(t, TypeSystem.DOUBLE_CLASS));
            }

            private boolean isBooleanReference(Type t) {
                return StandardTypeSystem.this._supportBoxing && StandardTypeSystem.this.isSubtype(t, TypeSystem.BOOLEAN_CLASS);
            }

            private Pair<Expression, Expression> checkForNumericE2() {
                return NodeProperties.getType(e2).apply(new TypeAbstractVisitor<Pair<Expression, Expression>>(){

                    @Override
                    public Pair<Expression, Expression> defaultCase(Type t2) {
                        if (this.isNumericReference(t2)) {
                            return this.joinNumbers();
                        }
                        return this.joinReferences();
                    }

                    @Override
                    public Pair<Expression, Expression> forNumericType(NumericType t2) {
                        return this.joinNumbers();
                    }
                });
            }

            private Pair<Expression, Expression> joinNumbers() {
                try {
                    Expression unboxed1 = StandardTypeSystem.this.makePrimitive(e1);
                    Expression unboxed2 = StandardTypeSystem.this.makePrimitive(e2);
                    Type numT1 = NodeProperties.getType(unboxed1);
                    Type numT2 = NodeProperties.getType(unboxed2);
                    Type joined = null;
                    if (NodeProperties.hasValue(unboxed1) && numT1 instanceof IntType) {
                        Type type = joined = StandardTypeSystem.this.inRange(NodeProperties.getValue(unboxed1), numT2) ? numT2 : null;
                    }
                    if (joined == null && NodeProperties.hasValue(unboxed2) && numT2 instanceof IntType) {
                        Type type = joined = StandardTypeSystem.this.inRange(NodeProperties.getValue(unboxed2), numT1) ? numT1 : null;
                    }
                    if (joined == null) {
                        joined = StandardTypeSystem.this.join(numT1, numT2);
                    }
                    Expression result1 = StandardTypeSystem.this.isEqual(numT1, joined) ? unboxed1 : StandardTypeSystem.this.makeCast(joined, unboxed1);
                    Expression result2 = StandardTypeSystem.this.isEqual(numT2, joined) ? unboxed2 : StandardTypeSystem.this.makeCast(joined, unboxed2);
                    return Pair.make(result1, result2);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new IllegalArgumentException();
                }
            }

            private Pair<Expression, Expression> joinReferences() {
                try {
                    Expression boxed1 = StandardTypeSystem.this.makeReference(e1);
                    Expression boxed2 = StandardTypeSystem.this.makeReference(e2);
                    Type refT1 = NodeProperties.getType(boxed1);
                    Type refT2 = NodeProperties.getType(boxed2);
                    Type joined = StandardTypeSystem.this.join(refT1, refT2);
                    Expression result1 = StandardTypeSystem.this.isEqual(refT1, joined) ? boxed1 : StandardTypeSystem.this.makeCast(joined, boxed1);
                    Expression result2 = StandardTypeSystem.this.isEqual(refT2, joined) ? boxed2 : StandardTypeSystem.this.makeCast(joined, boxed2);
                    return Pair.make(result1, result2);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new IllegalArgumentException();
                }
            }
        });
    }

    @Override
    public Expression cast(Type target, final Expression e) throws TypeSystem.UnsupportedConversionException {
        Expression result = target.apply(new TypeAbstractVisitor<Expression>(){

            @Override
            public Expression forPrimitiveType(PrimitiveType target) {
                try {
                    Expression result = StandardTypeSystem.this.makePrimitive(e);
                    Type source = NodeProperties.getType(result);
                    if (!StandardTypeSystem.this.isEqual(target, source)) {
                        NodeProperties.setConvertedType(result, StandardTypeSystem.this.erasedClass(target));
                    }
                    return result;
                }
                catch (TypeSystem.UnsupportedConversionException e2) {
                    return null;
                }
            }

            @Override
            public Expression defaultCase(Type target) {
                try {
                    Expression result = StandardTypeSystem.this.makeReference(e);
                    Type source = NodeProperties.getType(result);
                    if (!StandardTypeSystem.this.isSubtype(source, target)) {
                        if (StandardTypeSystem.this.isSubtype(target, source)) {
                            NodeProperties.setCheckedType(result, StandardTypeSystem.this.erasedClass(target));
                        } else {
                            throw new TypeSystem.UnsupportedConversionException();
                        }
                    }
                    return result;
                }
                catch (TypeSystem.UnsupportedConversionException e2) {
                    return null;
                }
            }
        });
        if (result == null) {
            throw new TypeSystem.UnsupportedConversionException();
        }
        return result;
    }

    @Override
    public Expression assign(Type target, final Expression exp) throws TypeSystem.UnsupportedConversionException {
        try {
            return target.apply(new TypeAbstractVisitor<Expression>(){

                @Override
                public Expression defaultCase(final Type target) {
                    return NodeProperties.getType(exp).apply(new TypeAbstractVisitor<Expression>(){

                        @Override
                        public Expression defaultCase(Type t) {
                            if (StandardTypeSystem.this.isSubtype(t, target)) {
                                return exp;
                            }
                            throw new WrappedException(new TypeSystem.UnsupportedConversionException());
                        }

                        @Override
                        public Expression forPrimitiveType(PrimitiveType t) {
                            try {
                                Expression boxed = StandardTypeSystem.this.makeReference(exp);
                                if (StandardTypeSystem.this.isSubtype(NodeProperties.getType(boxed), target)) {
                                    return exp;
                                }
                                throw new TypeSystem.UnsupportedConversionException();
                            }
                            catch (TypeSystem.UnsupportedConversionException e) {
                                throw new WrappedException(e);
                            }
                        }

                        @Override
                        public Expression forCharType(CharType t) {
                            try {
                                if (NodeProperties.hasValue(exp)) {
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.BYTE_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.BYTE)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.BYTE, exp));
                                    }
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.SHORT_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.SHORT)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.SHORT, exp));
                                    }
                                }
                                return this.forPrimitiveType(t);
                            }
                            catch (TypeSystem.UnsupportedConversionException e) {
                                throw new WrappedException(e);
                            }
                        }

                        @Override
                        public Expression forByteType(ByteType t) {
                            try {
                                if (NodeProperties.hasValue(exp) && StandardTypeSystem.this.isEqual(target, TypeSystem.CHARACTER_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.CHAR)) {
                                    return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.CHAR, exp));
                                }
                                return this.forPrimitiveType(t);
                            }
                            catch (TypeSystem.UnsupportedConversionException e) {
                                throw new WrappedException(e);
                            }
                        }

                        @Override
                        public Expression forShortType(ShortType t) {
                            try {
                                if (NodeProperties.hasValue(exp)) {
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.BYTE_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.BYTE)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.BYTE, exp));
                                    }
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.CHARACTER_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.CHAR)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.CHAR, exp));
                                    }
                                }
                                return this.forPrimitiveType(t);
                            }
                            catch (TypeSystem.UnsupportedConversionException e) {
                                throw new WrappedException(e);
                            }
                        }

                        @Override
                        public Expression forIntType(IntType t) {
                            try {
                                if (NodeProperties.hasValue(exp)) {
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.BYTE_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.BYTE)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.BYTE, exp));
                                    }
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.SHORT_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.SHORT)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.SHORT, exp));
                                    }
                                    if (StandardTypeSystem.this.isEqual(target, TypeSystem.CHARACTER_CLASS) && StandardTypeSystem.this.inRange(NodeProperties.getValue(exp), TypeSystem.CHAR)) {
                                        return StandardTypeSystem.this.makeReference(StandardTypeSystem.this.makeCast(TypeSystem.CHAR, exp));
                                    }
                                }
                                return this.forPrimitiveType(t);
                            }
                            catch (TypeSystem.UnsupportedConversionException e) {
                                throw new WrappedException(e);
                            }
                        }
                    });
                }

                @Override
                public Expression forPrimitiveType(PrimitiveType target) {
                    try {
                        Expression unboxed = StandardTypeSystem.this.makePrimitive(exp);
                        Type t = NodeProperties.getType(unboxed);
                        if (StandardTypeSystem.this.isEqual(t, target)) {
                            return unboxed;
                        }
                        if (StandardTypeSystem.this.isSubtype(t, target)) {
                            return StandardTypeSystem.this.makeCast(target, unboxed);
                        }
                        throw new TypeSystem.UnsupportedConversionException();
                    }
                    catch (TypeSystem.UnsupportedConversionException e) {
                        throw new WrappedException(e);
                    }
                }

                @Override
                public Expression forCharType(CharType target) {
                    return this.handleSmallPrimitive(target);
                }

                @Override
                public Expression forByteType(ByteType target) {
                    return this.handleSmallPrimitive(target);
                }

                @Override
                public Expression forShortType(ShortType target) {
                    return this.handleSmallPrimitive(target);
                }

                private Expression handleSmallPrimitive(PrimitiveType target) {
                    try {
                        Expression unboxed = StandardTypeSystem.this.makePrimitive(exp);
                        Type t = NodeProperties.getType(unboxed);
                        if (NodeProperties.hasValue(unboxed) && t instanceof IntType && StandardTypeSystem.this.inRange(NodeProperties.getValue(unboxed), target)) {
                            return StandardTypeSystem.this.makeCast(target, unboxed);
                        }
                        if (StandardTypeSystem.this.isEqual(t, target)) {
                            return unboxed;
                        }
                        if (StandardTypeSystem.this.isSubtype(t, target)) {
                            return StandardTypeSystem.this.makeCast(target, unboxed);
                        }
                        throw new TypeSystem.UnsupportedConversionException();
                    }
                    catch (TypeSystem.UnsupportedConversionException e) {
                        throw new WrappedException(e);
                    }
                }
            });
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof TypeSystem.UnsupportedConversionException) {
                throw (TypeSystem.UnsupportedConversionException)e.getCause();
            }
            throw e;
        }
    }

    private Expression makeCast(Type target, Expression e) {
        CastExpression result = new CastExpression(null, e, e.getSourceInfo());
        if (this.isPrimitive(target) && !this.isEqual(target, NodeProperties.getType(e))) {
            NodeProperties.setConvertedType(e, this.erasedClass(target));
        }
        NodeProperties.setType(result, target);
        return result;
    }

    private Expression makeArray(ArrayType arrayType, Iterable<? extends Expression> elements) {
        Thunk<Class<?>> erasedType = this.erasedClass(arrayType);
        TypeName tn = TypeUtil.makeEmptyTypeName();
        NodeProperties.setType(tn, arrayType.ofType());
        ArrayInitializer init = new ArrayInitializer(CollectUtil.makeList(elements));
        NodeProperties.setType(init, arrayType);
        NodeProperties.setErasedType(init, erasedType);
        ArrayAllocation result = new ArrayAllocation(tn, new ArrayAllocation.TypeDescriptor(new ArrayList(0), 1, init, SourceInfo.NONE));
        NodeProperties.setType(result, arrayType);
        NodeProperties.setErasedType(result, erasedType);
        return result;
    }

    private boolean inRange(final Object value, Type t) {
        if (this.isReference(t)) {
            return value == null;
        }
        return t.apply(new TypeAbstractVisitor<Boolean>(){

            @Override
            public Boolean defaultCase(Type t) {
                return false;
            }

            @Override
            public Boolean forBooleanType(BooleanType t) {
                return value instanceof Boolean;
            }

            @Override
            public Boolean forCharType(CharType t) {
                return this.checkNumber(0L, 65535L);
            }

            @Override
            public Boolean forByteType(ByteType t) {
                return this.checkNumber(-128L, 127L);
            }

            @Override
            public Boolean forShortType(ShortType t) {
                return this.checkNumber(-32768L, 32767L);
            }

            @Override
            public Boolean forIntType(IntType t) {
                return this.checkNumber(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }

            @Override
            public Boolean forLongType(LongType t) {
                return this.checkNumber(Long.MIN_VALUE, Long.MAX_VALUE);
            }

            private Boolean checkNumber(long lowerBound, long upperBound) {
                if (value instanceof Number && !(value instanceof Float) && !(value instanceof Double)) {
                    long val = ((Number)value).longValue();
                    return lowerBound <= val && val <= upperBound;
                }
                return false;
            }
        });
    }

    protected Type immediateSupertype(ClassType t) {
        return t.apply(new TypeAbstractVisitor<Type>(){

            @Override
            public Type defaultCase(Type t) {
                throw new IllegalArgumentException();
            }

            @Override
            public Type forSimpleClassType(SimpleClassType t) {
                return StandardTypeSystem.this.immediateSupertype(t);
            }

            @Override
            public Type forRawClassType(RawClassType t) {
                return StandardTypeSystem.this.immediateSupertype(t);
            }

            @Override
            public Type forParameterizedClassType(ParameterizedClassType t) {
                return StandardTypeSystem.this.immediateSupertype(t);
            }
        });
    }

    protected Type immediateSupertype(SimpleClassType t) {
        if (t.equals(OBJECT)) {
            return null;
        }
        return new IntersectionType(IterUtil.compose(OBJECT, t.ofClass().declaredSupertypes()));
    }

    protected Type immediateSupertype(RawClassType t) {
        SizedIterable<Type> erasedSups = IterUtil.map(t.ofClass().declaredSupertypes(), new Lambda<Type, Type>(){

            @Override
            public Type value(Type t) {
                return (Type)t.apply(ERASE);
            }
        });
        return new IntersectionType(IterUtil.compose(OBJECT, erasedSups));
    }

    protected Type immediateSupertype(ParameterizedClassType t) {
        ParameterizedClassType tCap = this.capture(t);
        DJClass c = tCap.ofClass();
        Iterable<? extends Type> sups = this.substitute(c.declaredSupertypes(), SymbolUtil.allTypeParameters(c), tCap.typeArguments());
        return new IntersectionType(IterUtil.compose(OBJECT, sups));
    }

    private SignatureChecker makeChecker(Iterable<? extends VariableType> tparams, Iterable<? extends Type> targs, Iterable<? extends Type> params, Iterable<? extends Expression> args, Type returned, Option<Type> expected) {
        int paramCount;
        int argCount = IterUtil.sizeOf(args);
        if (argCount == (paramCount = IterUtil.sizeOf(params)) - 1) {
            if (IterUtil.isEmpty(tparams)) {
                return new EmptyVarargChecker(params, args, tparams, EMPTY_TYPE_ITERABLE);
            }
            if (IterUtil.isEmpty(targs)) {
                return new EmptyVarargInferenceChecker(params, args, tparams, returned, expected);
            }
            if (IterUtil.sizeOf(tparams) == IterUtil.sizeOf(targs) && this.inBounds(tparams, targs)) {
                return new EmptyVarargChecker(this.substitute(params, tparams, targs), args, tparams, targs);
            }
            return NullChecker.INSTANCE;
        }
        if (argCount == paramCount) {
            if (IterUtil.isEmpty(tparams)) {
                return new SimpleChecker(params, args, tparams, EMPTY_TYPE_ITERABLE);
            }
            if (IterUtil.isEmpty(targs)) {
                return new InferenceChecker(params, args, tparams, returned, expected);
            }
            if (IterUtil.sizeOf(tparams) == IterUtil.sizeOf(targs) && this.inBounds(tparams, targs)) {
                return new SimpleChecker(this.substitute(params, tparams, targs), args, tparams, targs);
            }
            return NullChecker.INSTANCE;
        }
        if (argCount > paramCount && paramCount >= 1) {
            if (IterUtil.isEmpty(tparams)) {
                return new MultiVarargChecker(params, args, tparams, EMPTY_TYPE_ITERABLE);
            }
            if (IterUtil.isEmpty(targs)) {
                return new MultiVarargInferenceChecker(params, args, tparams, returned, expected);
            }
            if (IterUtil.sizeOf(tparams) == IterUtil.sizeOf(targs) && this.inBounds(tparams, targs)) {
                return new MultiVarargChecker(this.substitute(params, tparams, targs), args, tparams, targs);
            }
            return NullChecker.INSTANCE;
        }
        return NullChecker.INSTANCE;
    }

    private <T, R> Iterable<R> findSignatureMatches(Iterable<? extends T> sigs, Lambda<? super T, ? extends SignatureChecker> makeChecker, Lambda2<? super T, ? super SignatureChecker, ? extends R> makeResult) {
        SnapshotIterable<? extends SignatureChecker> checkers = IterUtil.mapSnapshot(sigs, makeChecker);
        SizedIterable<Pair<T, SignatureChecker>> pairs = IterUtil.zip(sigs, checkers);
        Iterable<Object> resultPairs = IterUtil.empty();
        for (Pair pair : pairs) {
            if (!((SignatureChecker)pair.second()).matches()) continue;
            resultPairs = IterUtil.compose(resultPairs, pair);
        }
        if (IterUtil.isEmpty(resultPairs)) {
            for (Pair pair : pairs) {
                if (!((SignatureChecker)pair.second()).matchesWithBoxing()) continue;
                resultPairs = IterUtil.compose(resultPairs, pair);
            }
        }
        if (IterUtil.isEmpty(resultPairs)) {
            for (Pair pair : pairs) {
                if (!((SignatureChecker)pair.second()).matchesWithVarargs()) continue;
                resultPairs = IterUtil.compose(resultPairs, pair);
            }
        }
        resultPairs = this.mostSpecificSignatures(resultPairs);
        return IterUtil.map(IterUtil.pairFirsts(resultPairs), IterUtil.pairSeconds(resultPairs), makeResult);
    }

    private <T extends Pair<?, SignatureChecker>> Iterable<T> mostSpecificSignatures(Iterable<T> allSigs) {
        AbstractIterable result = IterUtil.empty();
        for (Pair sig : allSigs) {
            Pair sig2;
            boolean keep = true;
            Iterator<T> i$ = allSigs.iterator();
            while (i$.hasNext() && (keep &= sig == (sig2 = (Pair)i$.next()) || this.isMoreSpecific((SignatureChecker)sig.second(), (SignatureChecker)sig2.second()))) {
            }
            if (!keep) continue;
            result = IterUtil.compose(result, sig);
        }
        if (IterUtil.isEmpty(result)) {
            return allSigs;
        }
        return result;
    }

    private boolean isMoreSpecific(SignatureChecker sig1, SignatureChecker sig2) {
        SignatureChecker c = this.makeChecker(sig2.typeParameters(), EMPTY_TYPE_ITERABLE, sig2.parameters(), IterUtil.mapSnapshot(sig1.parameters(), EMPTY_EXPRESSION_FOR_TYPE), BOTTOM, NONE_TYPE_OPTION);
        return c.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSystem.ConstructorInvocation lookupConstructor(Type t, final Iterable<? extends Type> typeArgs, final Iterable<? extends Expression> args, final Option<Type> expected) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "typeArgs", "arg types", "expected"}, this.wrap(t), this.wrap(typeArgs), this.wrap(IterUtil.map(args, NodeProperties.NODE_TYPE)), this.wrap(expected));
        try {
            Iterable<TypeSystem.ConstructorInvocation> results = t.apply(new TypeAbstractVisitor<Iterable<TypeSystem.ConstructorInvocation>>(){

                @Override
                public Iterable<TypeSystem.ConstructorInvocation> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.ConstructorInvocation> forSimpleClassType(final SimpleClassType t) {
                    Iterable<DJConstructor> allConstructors = t.ofClass().declaredConstructors();
                    Lambda<DJConstructor, SignatureChecker> makeChecker = new Lambda<DJConstructor, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJConstructor k) {
                            return StandardTypeSystem.this.makeChecker(k.declaredTypeParameters(), typeArgs, SymbolUtil.declaredParameterTypes(k), args, t, expected);
                        }
                    };
                    Lambda2<DJConstructor, SignatureChecker, TypeSystem.ConstructorInvocation> makeResult = new Lambda2<DJConstructor, SignatureChecker, TypeSystem.ConstructorInvocation>(){

                        @Override
                        public TypeSystem.ConstructorInvocation value(DJConstructor k, SignatureChecker checker) {
                            SubstitutionMap sigma = new SubstitutionMap(checker.typeParameters(), checker.typeArguments());
                            return new TypeSystem.ConstructorInvocation(k, checker.typeArguments(), checker.arguments(), k.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(allConstructors, makeChecker, makeResult);
                }

                @Override
                public Iterable<TypeSystem.ConstructorInvocation> forRawClassType(final RawClassType t) {
                    Iterable<DJConstructor> allConstructors = t.ofClass().declaredConstructors();
                    Lambda<DJConstructor, SignatureChecker> makeChecker = new Lambda<DJConstructor, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJConstructor k) {
                            return StandardTypeSystem.this.makeChecker(IterUtil.empty(), typeArgs, IterUtil.map(SymbolUtil.declaredParameterTypes(k), StandardTypeSystem.this.ERASE_LAMBDA), args, t, expected);
                        }
                    };
                    Lambda2<DJConstructor, SignatureChecker, TypeSystem.ConstructorInvocation> makeResult = new Lambda2<DJConstructor, SignatureChecker, TypeSystem.ConstructorInvocation>(){

                        @Override
                        public TypeSystem.ConstructorInvocation value(DJConstructor k, SignatureChecker checker) {
                            return new TypeSystem.ConstructorInvocation(k, checker.typeArguments(), checker.arguments(), k.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(allConstructors, makeChecker, makeResult);
                }

                @Override
                public Iterable<TypeSystem.ConstructorInvocation> forParameterizedClassType(final ParameterizedClassType t) {
                    final SubstitutionMap classSigma = new SubstitutionMap(t.ofClass().declaredTypeParameters(), t.typeArguments());
                    Iterable<DJConstructor> allConstructors = t.ofClass().declaredConstructors();
                    Lambda<DJConstructor, SignatureChecker> makeChecker = new Lambda<DJConstructor, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJConstructor k) {
                            return StandardTypeSystem.this.makeChecker(k.declaredTypeParameters(), typeArgs, StandardTypeSystem.this.substitute(SymbolUtil.declaredParameterTypes(k), classSigma), args, t, expected);
                        }
                    };
                    Lambda2<DJConstructor, SignatureChecker, TypeSystem.ConstructorInvocation> makeResult = new Lambda2<DJConstructor, SignatureChecker, TypeSystem.ConstructorInvocation>(){

                        @Override
                        public TypeSystem.ConstructorInvocation value(DJConstructor k, SignatureChecker checker) {
                            return new TypeSystem.ConstructorInvocation(k, checker.typeArguments(), checker.arguments(), k.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(allConstructors, makeChecker, makeResult);
                }
            });
            int matches = IterUtil.sizeOf(results);
            if (matches != 1) {
                throw new TypeSystem.UnmatchedLookupException(matches);
            }
            TypeSystem.ConstructorInvocation constructorInvocation = IterUtil.first(results);
            return constructorInvocation;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    @Override
    public boolean containsMethod(Type t, String name) {
        return this.containsMethod(t, name, false);
    }

    @Override
    public boolean containsStaticMethod(Type t, String name) {
        return this.containsMethod(t, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsMethod(Type t, final String name, final boolean requireStatic) {
        DebugUtil.debug.logStart(new String[]{"t", "name", "requireStatic"}, this.wrap(t), name, requireStatic);
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LookupMethod
            extends TypeAbstractVisitor<Iterable<Object>> {
                private boolean _includePrivate;

                public LookupMethod(boolean includePrivate) {
                    this._includePrivate = includePrivate;
                }

                private boolean validMethod(DJMethod m) {
                    return !(!this._includePrivate && m.accessibility().equals((Object)Access.PRIVATE) || requireStatic && !m.isStatic());
                }

                @Override
                public Iterable<Object> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<Object> forClassType(ClassType t) {
                    DebugUtil.debug.logValues(new String[]{"t", "methods"}, StandardTypeSystem.this.wrap(t), t.ofClass().declaredMethods());
                    for (DJMethod m : t.ofClass().declaredMethods()) {
                        if (!m.declaredName().equals(name) || !this.validMethod(m)) continue;
                        return IterUtil.singleton(null);
                    }
                    return IterUtil.empty();
                }
            }
            Iterable<Object> results = this.lookupMember(t, new LookupMethod(true), new LookupMethod(false));
            boolean bl = !IterUtil.isEmpty(results);
            return bl;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSystem.ObjectMethodInvocation lookupMethod(final Expression object, final String name, final Iterable<? extends Type> typeArgs, final Iterable<? extends Expression> args, final Option<Type> expected) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "name", "typeArgs", "arg types", "expected"}, this.wrap(NodeProperties.getType(object)), name, this.wrap(typeArgs), this.wrap(IterUtil.map(args, NodeProperties.NODE_TYPE)), this.wrap(expected));
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LookupMethod
            extends TypeAbstractVisitor<Iterable<TypeSystem.ObjectMethodInvocation>> {
                private Predicate<? super DJMethod> _matchMethod;

                public LookupMethod(final boolean includePrivate) {
                    this._matchMethod = new Predicate<DJMethod>(){

                        @Override
                        public boolean contains(DJMethod m) {
                            if (m.declaredName().equals(name)) {
                                return includePrivate || !m.accessibility().equals((Object)Access.PRIVATE);
                            }
                            return false;
                        }
                    };
                }

                @Override
                public Iterable<TypeSystem.ObjectMethodInvocation> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.ObjectMethodInvocation> forSimpleClassType(final SimpleClassType t) {
                    FilteredIterable<? super DJMethod> methods = IterUtil.filter(t.ofClass().declaredMethods(), this._matchMethod);
                    Lambda<DJMethod, SignatureChecker> makeChecker = new Lambda<DJMethod, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJMethod m) {
                            return StandardTypeSystem.this.makeChecker(m.declaredTypeParameters(), typeArgs, SymbolUtil.declaredParameterTypes(m), args, m.returnType(), expected);
                        }
                    };
                    Lambda2<DJMethod, SignatureChecker, TypeSystem.ObjectMethodInvocation> makeResult = new Lambda2<DJMethod, SignatureChecker, TypeSystem.ObjectMethodInvocation>(){

                        @Override
                        public TypeSystem.ObjectMethodInvocation value(DJMethod m, SignatureChecker checker) {
                            SubstitutionMap sigma = new SubstitutionMap(checker.typeParameters(), checker.typeArguments());
                            Type returned = StandardTypeSystem.this.substitute(m.returnType(), sigma);
                            return new TypeSystem.ObjectMethodInvocation(m, returned, StandardTypeSystem.this.makeCast(t, object), checker.typeArguments(), checker.arguments(), m.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(methods, makeChecker, makeResult);
                }

                @Override
                public Iterable<TypeSystem.ObjectMethodInvocation> forRawClassType(final RawClassType t) {
                    FilteredIterable<? super DJMethod> methods = IterUtil.filter(t.ofClass().declaredMethods(), this._matchMethod);
                    Lambda<DJMethod, SignatureChecker> makeChecker = new Lambda<DJMethod, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJMethod m) {
                            return StandardTypeSystem.this.makeChecker(IterUtil.empty(), typeArgs, IterUtil.map(SymbolUtil.declaredParameterTypes(m), StandardTypeSystem.this.ERASE_LAMBDA), args, m.returnType(), expected);
                        }
                    };
                    Lambda2<DJMethod, SignatureChecker, TypeSystem.ObjectMethodInvocation> makeResult = new Lambda2<DJMethod, SignatureChecker, TypeSystem.ObjectMethodInvocation>(){

                        @Override
                        public TypeSystem.ObjectMethodInvocation value(DJMethod m, SignatureChecker checker) {
                            Type returned = StandardTypeSystem.this.erase(m.returnType());
                            return new TypeSystem.ObjectMethodInvocation(m, returned, StandardTypeSystem.this.makeCast(t, object), checker.typeArguments(), checker.arguments(), m.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(methods, makeChecker, makeResult);
                }

                @Override
                public Iterable<TypeSystem.ObjectMethodInvocation> forParameterizedClassType(final ParameterizedClassType t) {
                    final SubstitutionMap classSigma = new SubstitutionMap(SymbolUtil.allTypeParameters(t.ofClass()), t.typeArguments());
                    FilteredIterable<? super DJMethod> methods = IterUtil.filter(t.ofClass().declaredMethods(), this._matchMethod);
                    Lambda<DJMethod, SignatureChecker> makeChecker = new Lambda<DJMethod, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJMethod m) {
                            return StandardTypeSystem.this.makeChecker(m.declaredTypeParameters(), typeArgs, StandardTypeSystem.this.substitute(SymbolUtil.declaredParameterTypes(m), classSigma), args, m.returnType(), expected);
                        }
                    };
                    Lambda2<DJMethod, SignatureChecker, TypeSystem.ObjectMethodInvocation> makeResult = new Lambda2<DJMethod, SignatureChecker, TypeSystem.ObjectMethodInvocation>(){

                        @Override
                        public TypeSystem.ObjectMethodInvocation value(DJMethod m, SignatureChecker checker) {
                            SubstitutionMap sigma = new SubstitutionMap(checker.typeParameters(), checker.typeArguments());
                            Type rawReturned = m.returnType();
                            Type returned = StandardTypeSystem.this.substitute(StandardTypeSystem.this.substitute(rawReturned, classSigma), sigma);
                            return new TypeSystem.ObjectMethodInvocation(m, returned, StandardTypeSystem.this.makeCast(t, object), checker.typeArguments(), checker.arguments(), m.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(methods, makeChecker, makeResult);
                }
            }
            Iterable<TypeSystem.ObjectMethodInvocation> results = this.lookupMember(NodeProperties.getType(object), new LookupMethod(true), new LookupMethod(false));
            int matches = IterUtil.sizeOf(results);
            if (matches != 1) {
                throw new TypeSystem.UnmatchedLookupException(matches);
            }
            TypeSystem.ObjectMethodInvocation objectMethodInvocation = IterUtil.first(results);
            return objectMethodInvocation;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSystem.StaticMethodInvocation lookupStaticMethod(Type t, final String name, final Iterable<? extends Type> typeArgs, final Iterable<? extends Expression> args, final Option<Type> expected) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "name", "typeArgs", "arg types", "expected"}, this.wrap(t), name, this.wrap(typeArgs), this.wrap(IterUtil.map(args, NodeProperties.NODE_TYPE)), this.wrap(expected));
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LookupMethod
            extends TypeAbstractVisitor<Iterable<TypeSystem.StaticMethodInvocation>> {
                private Predicate<? super DJMethod> _matchMethod;

                public LookupMethod(final boolean includePrivate) {
                    this._matchMethod = new Predicate<DJMethod>(){

                        @Override
                        public boolean contains(DJMethod m) {
                            if (m.declaredName().equals(name)) {
                                if (includePrivate) {
                                    return m.isStatic();
                                }
                                return m.isStatic() && !m.accessibility().equals((Object)Access.PRIVATE);
                            }
                            return false;
                        }
                    };
                }

                @Override
                public Iterable<TypeSystem.StaticMethodInvocation> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.StaticMethodInvocation> forSimpleClassType(SimpleClassType t) {
                    FilteredIterable<? super DJMethod> methods = IterUtil.filter(t.ofClass().declaredMethods(), this._matchMethod);
                    Lambda<DJMethod, SignatureChecker> makeChecker = new Lambda<DJMethod, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJMethod m) {
                            return StandardTypeSystem.this.makeChecker(m.declaredTypeParameters(), typeArgs, SymbolUtil.declaredParameterTypes(m), args, m.returnType(), expected);
                        }
                    };
                    Lambda2<DJMethod, SignatureChecker, TypeSystem.StaticMethodInvocation> makeResult = new Lambda2<DJMethod, SignatureChecker, TypeSystem.StaticMethodInvocation>(){

                        @Override
                        public TypeSystem.StaticMethodInvocation value(DJMethod m, SignatureChecker checker) {
                            SubstitutionMap sigma = new SubstitutionMap(checker.typeParameters(), checker.typeArguments());
                            Type returned = StandardTypeSystem.this.substitute(m.returnType(), sigma);
                            return new TypeSystem.StaticMethodInvocation(m, returned, checker.typeArguments(), checker.arguments(), m.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(methods, makeChecker, makeResult);
                }

                @Override
                public Iterable<TypeSystem.StaticMethodInvocation> forRawClassType(RawClassType t) {
                    FilteredIterable<? super DJMethod> methods = IterUtil.filter(t.ofClass().declaredMethods(), this._matchMethod);
                    Lambda<DJMethod, SignatureChecker> makeChecker = new Lambda<DJMethod, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJMethod m) {
                            return StandardTypeSystem.this.makeChecker(IterUtil.empty(), typeArgs, IterUtil.map(SymbolUtil.declaredParameterTypes(m), StandardTypeSystem.this.ERASE_LAMBDA), args, m.returnType(), expected);
                        }
                    };
                    Lambda2<DJMethod, SignatureChecker, TypeSystem.StaticMethodInvocation> makeResult = new Lambda2<DJMethod, SignatureChecker, TypeSystem.StaticMethodInvocation>(){

                        @Override
                        public TypeSystem.StaticMethodInvocation value(DJMethod m, SignatureChecker checker) {
                            Type returned = StandardTypeSystem.this.erase(m.returnType());
                            return new TypeSystem.StaticMethodInvocation(m, returned, checker.typeArguments(), checker.arguments(), m.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(methods, makeChecker, makeResult);
                }

                @Override
                public Iterable<TypeSystem.StaticMethodInvocation> forParameterizedClassType(ParameterizedClassType t) {
                    final SubstitutionMap classSigma = new SubstitutionMap(SymbolUtil.allTypeParameters(t.ofClass()), t.typeArguments());
                    FilteredIterable<? super DJMethod> methods = IterUtil.filter(t.ofClass().declaredMethods(), this._matchMethod);
                    Lambda<DJMethod, SignatureChecker> makeChecker = new Lambda<DJMethod, SignatureChecker>(){

                        @Override
                        public SignatureChecker value(DJMethod m) {
                            return StandardTypeSystem.this.makeChecker(m.declaredTypeParameters(), typeArgs, StandardTypeSystem.this.substitute(SymbolUtil.declaredParameterTypes(m), classSigma), args, m.returnType(), expected);
                        }
                    };
                    Lambda2<DJMethod, SignatureChecker, TypeSystem.StaticMethodInvocation> makeResult = new Lambda2<DJMethod, SignatureChecker, TypeSystem.StaticMethodInvocation>(){

                        @Override
                        public TypeSystem.StaticMethodInvocation value(DJMethod m, SignatureChecker checker) {
                            SubstitutionMap sigma = new SubstitutionMap(checker.typeParameters(), checker.typeArguments());
                            Type rawReturned = m.returnType();
                            Type returned = StandardTypeSystem.this.substitute(StandardTypeSystem.this.substitute(rawReturned, classSigma), sigma);
                            return new TypeSystem.StaticMethodInvocation(m, returned, checker.typeArguments(), checker.arguments(), m.thrownTypes());
                        }
                    };
                    return StandardTypeSystem.this.findSignatureMatches(methods, makeChecker, makeResult);
                }
            }
            Iterable<TypeSystem.StaticMethodInvocation> results = this.lookupMember(t, new LookupMethod(true), new LookupMethod(false));
            int matches = IterUtil.sizeOf(results);
            if (matches != 1) {
                throw new TypeSystem.UnmatchedLookupException(matches);
            }
            TypeSystem.StaticMethodInvocation staticMethodInvocation = IterUtil.first(results);
            return staticMethodInvocation;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    @Override
    public boolean containsField(Type t, String name) {
        return this.containsField(t, name, false);
    }

    @Override
    public boolean containsStaticField(Type t, String name) {
        return this.containsField(t, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsField(Type t, final String name, final boolean requireStatic) {
        DebugUtil.debug.logStart(new String[]{"t", "name", "requireStatic"}, this.wrap(t), name, requireStatic);
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LookupField
            extends TypeAbstractVisitor<Iterable<Object>> {
                private boolean _includePrivate;

                public LookupField(boolean includePrivate) {
                    this._includePrivate = includePrivate;
                }

                private boolean validField(DJField f) {
                    return !(!this._includePrivate && f.accessibility().equals((Object)Access.PRIVATE) || requireStatic && !f.isStatic());
                }

                @Override
                public Iterable<Object> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<Object> forArrayType(ArrayType t) {
                    return name.equals("length") ? IterUtil.singleton(null) : IterUtil.empty();
                }

                @Override
                public Iterable<Object> forClassType(ClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        return IterUtil.singleton(null);
                    }
                    return IterUtil.empty();
                }
            }
            Iterable<Object> results = this.lookupMember(t, new LookupField(true), new LookupField(false));
            boolean bl = !IterUtil.isEmpty(results);
            return bl;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSystem.ObjectFieldReference lookupField(final Expression object, final String name) throws TypeSystem.InvalidTargetException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "name"}, this.wrap(NodeProperties.getType(object)), name);
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LookupField
            extends TypeAbstractVisitor<Iterable<TypeSystem.ObjectFieldReference>> {
                private boolean _includePrivate;

                public LookupField(boolean includePrivate) {
                    this._includePrivate = includePrivate;
                }

                private boolean validField(DJField f) {
                    return this._includePrivate || !f.accessibility().equals((Object)Access.PRIVATE);
                }

                @Override
                public Iterable<TypeSystem.ObjectFieldReference> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.ObjectFieldReference> forArrayType(ArrayType t) {
                    if (name.equals("length")) {
                        return IterUtil.make(new TypeSystem.ObjectFieldReference(ArrayLengthField.INSTANCE, TypeSystem.INT, object));
                    }
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.ObjectFieldReference> forSimpleClassType(SimpleClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        return IterUtil.make(new TypeSystem.ObjectFieldReference(f, f.type(), StandardTypeSystem.this.makeCast(t, object)));
                    }
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.ObjectFieldReference> forRawClassType(RawClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        return IterUtil.make(new TypeSystem.ObjectFieldReference(f, StandardTypeSystem.this.erase(f.type()), StandardTypeSystem.this.makeCast(t, object)));
                    }
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.ObjectFieldReference> forParameterizedClassType(ParameterizedClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        Type fieldType = StandardTypeSystem.this.substitute(f.type(), SymbolUtil.allTypeParameters(t.ofClass()), t.typeArguments());
                        return IterUtil.make(new TypeSystem.ObjectFieldReference(f, fieldType, StandardTypeSystem.this.makeCast(t, object)));
                    }
                    return IterUtil.empty();
                }
            }
            Iterable<TypeSystem.ObjectFieldReference> results = this.lookupMember(NodeProperties.getType(object), new LookupField(true), new LookupField(false));
            int matches = IterUtil.sizeOf(results);
            if (matches != 1) {
                throw new TypeSystem.UnmatchedLookupException(matches);
            }
            TypeSystem.ObjectFieldReference objectFieldReference = IterUtil.first(results);
            return objectFieldReference;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSystem.StaticFieldReference lookupStaticField(Type t, final String name) throws TypeSystem.InvalidTargetException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "name"}, this.wrap(t), name);
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LookupField
            extends TypeAbstractVisitor<Iterable<TypeSystem.StaticFieldReference>> {
                private boolean _includePrivate;

                public LookupField(boolean includePrivate) {
                    this._includePrivate = includePrivate;
                }

                private boolean validField(DJField f) {
                    if (this._includePrivate) {
                        return f.isStatic();
                    }
                    return f.isStatic() && !f.accessibility().equals((Object)Access.PRIVATE);
                }

                @Override
                public Iterable<TypeSystem.StaticFieldReference> defaultCase(Type t) {
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.StaticFieldReference> forSimpleClassType(SimpleClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        return IterUtil.make(new TypeSystem.StaticFieldReference(f, f.type()));
                    }
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.StaticFieldReference> forRawClassType(RawClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        return IterUtil.make(new TypeSystem.StaticFieldReference(f, StandardTypeSystem.this.erase(f.type())));
                    }
                    return IterUtil.empty();
                }

                @Override
                public Iterable<TypeSystem.StaticFieldReference> forParameterizedClassType(ParameterizedClassType t) {
                    for (DJField f : t.ofClass().declaredFields()) {
                        if (!f.declaredName().equals(name) || !this.validField(f)) continue;
                        Type fieldType = StandardTypeSystem.this.substitute(f.type(), SymbolUtil.allTypeParameters(t.ofClass()), t.typeArguments());
                        return IterUtil.make(new TypeSystem.StaticFieldReference(f, fieldType));
                    }
                    return IterUtil.empty();
                }
            }
            Iterable<TypeSystem.StaticFieldReference> results = this.lookupMember(t, new LookupField(true), new LookupField(false));
            int matches = IterUtil.sizeOf(results);
            if (matches != 1) {
                throw new TypeSystem.UnmatchedLookupException(matches);
            }
            TypeSystem.StaticFieldReference staticFieldReference = IterUtil.first(results);
            return staticFieldReference;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsClass(Type t, final String name) {
        DebugUtil.debug.logStart(new String[]{"t", "name"}, this.wrap(t), name);
        try {
            Lambda<Boolean, Predicate<DJClass>> makePred = new Lambda<Boolean, Predicate<DJClass>>(){

                @Override
                public Predicate<DJClass> value(final Boolean includePrivate) {
                    return new Predicate<DJClass>(){

                        @Override
                        public boolean contains(DJClass c) {
                            if (c.declaredName().equals(name)) {
                                return includePrivate != false || !c.accessibility().equals((Object)Access.PRIVATE);
                            }
                            return false;
                        }
                    };
                }
            };
            Iterable<? extends ClassType> classes = this.lookupClasses(t, (Lambda<? super Boolean, ? extends Predicate<? super DJClass>>)makePred, EMPTY_TYPE_ITERABLE);
            boolean bl = !IterUtil.isEmpty(classes);
            return bl;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsStaticClass(Type t, final String name) {
        DebugUtil.debug.logStart(new String[]{"t", "name"}, this.wrap(t), name);
        try {
            Lambda<Boolean, Predicate<DJClass>> makePred = new Lambda<Boolean, Predicate<DJClass>>(){

                @Override
                public Predicate<DJClass> value(final Boolean includePrivate) {
                    return new Predicate<DJClass>(){

                        @Override
                        public boolean contains(DJClass c) {
                            if (c.declaredName().equals(name)) {
                                if (includePrivate.booleanValue()) {
                                    return c.isStatic();
                                }
                                return c.isStatic() && !c.accessibility().equals((Object)Access.PRIVATE);
                            }
                            return false;
                        }
                    };
                }
            };
            Iterable<? extends ClassType> classes = this.lookupClasses(t, (Lambda<? super Boolean, ? extends Predicate<? super DJClass>>)makePred, EMPTY_TYPE_ITERABLE);
            boolean bl = !IterUtil.isEmpty(classes);
            return bl;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    @Override
    public ClassType lookupClass(Expression object, String name, Iterable<? extends Type> typeArgs) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        return this.lookupClass(NodeProperties.getType(object), name, typeArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassType lookupClass(Type t, final String name, Iterable<? extends Type> typeArgs) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "name", "typeArgs"}, t, name, typeArgs);
        try {
            Lambda<Boolean, Predicate<DJClass>> makePred = new Lambda<Boolean, Predicate<DJClass>>(){

                @Override
                public Predicate<DJClass> value(final Boolean includePrivate) {
                    return new Predicate<DJClass>(){

                        @Override
                        public boolean contains(DJClass c) {
                            if (c.declaredName().equals(name)) {
                                return includePrivate != false || !c.accessibility().equals((Object)Access.PRIVATE);
                            }
                            return false;
                        }
                    };
                }
            };
            ClassType classType = this.lookupClass(t, (Lambda<? super Boolean, ? extends Predicate<? super DJClass>>)makePred, typeArgs, name);
            return classType;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassType lookupStaticClass(Type t, final String name, Iterable<? extends Type> typeArgs) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        DebugUtil.debug.logStart(new String[]{"t", "name", "typeArgs"}, t, name, typeArgs);
        try {
            Lambda<Boolean, Predicate<DJClass>> makePred = new Lambda<Boolean, Predicate<DJClass>>(){

                @Override
                public Predicate<DJClass> value(final Boolean includePrivate) {
                    return new Predicate<DJClass>(){

                        @Override
                        public boolean contains(DJClass c) {
                            if (c.declaredName().equals(name)) {
                                if (includePrivate.booleanValue()) {
                                    return c.isStatic();
                                }
                                return c.isStatic() && !c.accessibility().equals((Object)Access.PRIVATE);
                            }
                            return false;
                        }
                    };
                }
            };
            ClassType classType = this.lookupClass(t, (Lambda<? super Boolean, ? extends Predicate<? super DJClass>>)makePred, typeArgs, name);
            return classType;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    private ClassType lookupClass(Type t, Lambda<? super Boolean, ? extends Predicate<? super DJClass>> makePred, Iterable<? extends Type> typeArgs, String name) throws TypeSystem.InvalidTargetException, TypeSystem.InvalidTypeArgumentException, TypeSystem.UnmatchedLookupException {
        Iterable<? extends ClassType> results = this.lookupClasses(t, makePred, typeArgs);
        int matches = IterUtil.sizeOf(results);
        if (matches != 1) {
            throw new TypeSystem.UnmatchedLookupException(matches);
        }
        ClassType result = IterUtil.first(results);
        final Iterable<VariableType> params = SymbolUtil.allTypeParameters(result.ofClass());
        try {
            return result.apply(new TypeAbstractVisitor<ClassType>(){

                @Override
                public ClassType defaultCase(Type t) {
                    throw new IllegalArgumentException();
                }

                @Override
                public ClassType forSimpleClassType(SimpleClassType t) {
                    if (IterUtil.isEmpty(params)) {
                        return t;
                    }
                    return new RawClassType(t.ofClass());
                }

                @Override
                public ClassType forRawClassType(RawClassType t) {
                    return t;
                }

                @Override
                public ClassType forParameterizedClassType(ParameterizedClassType t) {
                    try {
                        if (IterUtil.sizeOf(params) != IterUtil.sizeOf(t.typeArguments())) {
                            throw new TypeSystem.InvalidTypeArgumentException();
                        }
                        return t;
                    }
                    catch (TypeSystem.InvalidTypeArgumentException e) {
                        throw new WrappedException(e);
                    }
                }
            });
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof TypeSystem.InvalidTypeArgumentException) {
                throw (TypeSystem.InvalidTypeArgumentException)e.getCause();
            }
            throw e;
        }
    }

    private Iterable<? extends ClassType> lookupClasses(Type t, Lambda<? super Boolean, ? extends Predicate<? super DJClass>> makePred, final Iterable<? extends Type> typeArgs) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LookupClass
        extends TypeAbstractVisitor<Iterable<ClassType>> {
            private final Predicate<? super DJClass> _matchInner;

            public LookupClass(Predicate<? super DJClass> matchInner) {
                this._matchInner = matchInner;
            }

            @Override
            public Iterable<ClassType> defaultCase(Type t) {
                return IterUtil.empty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterable<ClassType> forClassType(final ClassType t) {
                DebugUtil.debug.logStart("t", (Object)this.wrap(t));
                try {
                    Lambda<DJClass, ClassType> makeType = new Lambda<DJClass, ClassType>(){

                        @Override
                        public ClassType value(DJClass c) {
                            ClassType dynamicOuter = c.isStatic() ? SymbolUtil.dynamicOuterClassType(t) : t;
                            if (dynamicOuter instanceof ParameterizedClassType) {
                                Iterable<? extends Type> outerTypeArgs = ((ParameterizedClassType)dynamicOuter).typeArguments();
                                return new ParameterizedClassType(c, IterUtil.compose(outerTypeArgs, typeArgs));
                            }
                            if (dynamicOuter instanceof RawClassType) {
                                return IterUtil.isEmpty(typeArgs) ? new RawClassType(c) : new ParameterizedClassType(c, typeArgs);
                            }
                            return IterUtil.isEmpty(typeArgs) ? new SimpleClassType(c) : new ParameterizedClassType(c, typeArgs);
                        }
                    };
                    DebugUtil.debug.logValue("declaredClasses", t.ofClass().declaredClasses());
                    SnapshotIterable<ClassType> snapshotIterable = IterUtil.mapSnapshot(IterUtil.filter(t.ofClass().declaredClasses(), this._matchInner), makeType);
                    return snapshotIterable;
                }
                finally {
                    DebugUtil.debug.logEnd();
                }
            }
        }
        return this.lookupMember(t, new LookupClass(makePred.value((Boolean)true)), new LookupClass(makePred.value((Boolean)false)));
    }

    protected boolean inBounds(Iterable<? extends VariableType> params, Iterable<? extends Type> args) {
        SubstitutionMap sigma = new SubstitutionMap(params, args);
        for (Pair pair : IterUtil.zip(params, args)) {
            VariableType param = (VariableType)pair.first();
            Type arg = (Type)pair.second();
            if (!this.isSubtype(this.substitute(param.symbol().lowerBound(), sigma), arg)) {
                return false;
            }
            if (this.isSubtype(arg, this.substitute(param.symbol().upperBound(), sigma))) continue;
            return false;
        }
        return true;
    }

    private <T> Iterable<? extends T> lookupMember(Type t, TypeVisitor<? extends Iterable<? extends T>> baseCase, TypeVisitor<? extends Iterable<? extends T>> recursiveBaseCase) {
        return this.lookupMember(t, new HashSet<Type>(), baseCase, recursiveBaseCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Iterable<? extends T> lookupMember(Type t, final Set<Type> alreadyChecked, TypeVisitor<? extends Iterable<? extends T>> baseCase, final TypeVisitor<? extends Iterable<? extends T>> recursiveBaseCase) {
        DebugUtil.debug.logStart("t", (Object)this.wrap(t));
        try {
            if (alreadyChecked.contains(t)) {
                EmptyIterable emptyIterable = IterUtil.empty();
                return emptyIterable;
            }
            final Iterable<? extends T> baseResult = t.apply(baseCase);
            alreadyChecked.add(t);
            if (!IterUtil.isEmpty(baseResult)) {
                Iterable<? extends T> iterable = baseResult;
                return iterable;
            }
            Iterable iterable = (Iterable)t.apply(new TypeAbstractVisitor<Iterable<? extends T>>(){

                @Override
                public Iterable<? extends T> defaultCase(Type t) {
                    return baseResult;
                }

                @Override
                public Iterable<? extends T> forArrayType(ArrayType t) {
                    return StandardTypeSystem.this.lookupMember(CLONEABLE_AND_SERIALIZABLE, alreadyChecked, recursiveBaseCase, recursiveBaseCase);
                }

                @Override
                public Iterable<? extends T> forSimpleClassType(SimpleClassType t) {
                    Type superT = StandardTypeSystem.this.immediateSupertype(t);
                    if (superT == null) {
                        return baseResult;
                    }
                    return StandardTypeSystem.this.lookupMember(superT, alreadyChecked, recursiveBaseCase, recursiveBaseCase);
                }

                @Override
                public Iterable<? extends T> forRawClassType(RawClassType t) {
                    Type superT = StandardTypeSystem.this.immediateSupertype(t);
                    if (superT == null) {
                        return baseResult;
                    }
                    return StandardTypeSystem.this.lookupMember(superT, alreadyChecked, recursiveBaseCase, recursiveBaseCase);
                }

                @Override
                public Iterable<? extends T> forParameterizedClassType(ParameterizedClassType t) {
                    Type superT = StandardTypeSystem.this.immediateSupertype(t);
                    if (superT == null) {
                        return baseResult;
                    }
                    return StandardTypeSystem.this.lookupMember(superT, alreadyChecked, recursiveBaseCase, recursiveBaseCase);
                }

                @Override
                public Iterable<? extends T> forVariableType(VariableType t) {
                    return StandardTypeSystem.this.lookupMember(t.symbol().upperBound(), alreadyChecked, recursiveBaseCase, recursiveBaseCase);
                }

                @Override
                public Iterable<? extends T> forIntersectionType(IntersectionType t) {
                    AbstractIterable result = IterUtil.empty();
                    for (Type type : t.ofTypes()) {
                        Iterable forSup = StandardTypeSystem.this.lookupMember(type, alreadyChecked, recursiveBaseCase, recursiveBaseCase);
                        result = IterUtil.compose(result, forSup);
                    }
                    return result;
                }
            });
            return iterable;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiVarargInferenceChecker
    extends InferenceChecker {
        private Type _varargParam;
        private Iterable<Expression> _varargArgs;

        public MultiVarargInferenceChecker(Iterable<? extends Type> params, Iterable<? extends Expression> args, Iterable<? extends VariableType> tparams, Type returned, Option<Type> expected) {
            super(params, args, tparams, returned, expected);
            this._varargParam = (Type)IterUtil.last(this._params);
            this._params = IterUtil.skipLast(this._params);
            Pair splitArgs = IterUtil.split(this._args, IterUtil.sizeOf(this._params));
            this._args = splitArgs.first();
            this._varargArgs = splitArgs.second();
        }

        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public boolean matchesWithBoxing() {
            return false;
        }

        @Override
        public boolean matchesWithVarargs() {
            if (this._varargParam instanceof VarargArrayType) {
                this.boxArgs();
                ArrayType arrayT = (ArrayType)this._varargParam;
                final Type elementT = arrayT.ofType();
                Lambda<Expression, Expression> makeBoxed = new Lambda<Expression, Expression>(){

                    @Override
                    public Expression value(Expression e) {
                        return MultiVarargInferenceChecker.this.boxingConvert(e, elementT);
                    }
                };
                SizedIterable<Expression> boxedVarargArgs = IterUtil.map(this._varargArgs, makeBoxed);
                ComposedIterable<Expression> inferenceArgs = IterUtil.compose(this._args, boxedVarargArgs);
                SnapshotIterable<Type> argTypes = IterUtil.mapSnapshot(inferenceArgs, NodeProperties.NODE_TYPE);
                FiniteSequenceIterable<Type> varargParams = IterUtil.copy(elementT, IterUtil.sizeOf(this._varargArgs));
                ComposedIterable<Type> paramTypes = IterUtil.compose(this._params, varargParams);
                this._targs = StandardTypeSystem.this.inferTypeArguments(this._tparams, paramTypes, this._returned, argTypes, this._expected);
                if (this._targs != null) {
                    this._params = IterUtil.compose(this._params, this._varargParam);
                    Expression newArg = StandardTypeSystem.this.makeArray((ArrayType)StandardTypeSystem.this.substitute(arrayT, (Iterable<? extends VariableType>)this._tparams, (Iterable<? extends Type>)this._targs), boxedVarargArgs);
                    this._args = IterUtil.compose(this._args, newArg);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiVarargChecker
    extends SimpleChecker {
        private Type _varargParam;
        private Iterable<Expression> _varargArgs;

        public MultiVarargChecker(Iterable<? extends Type> params, Iterable<? extends Expression> args, Iterable<? extends VariableType> tparams, Iterable<? extends Type> targs) {
            super(params, args, tparams, targs);
            this._varargParam = (Type)IterUtil.last(this._params);
            this._params = IterUtil.skipLast(this._params);
            Pair splitArgs = IterUtil.split(this._args, IterUtil.sizeOf(this._params));
            this._args = splitArgs.first();
            this._varargArgs = splitArgs.second();
        }

        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public boolean matchesWithBoxing() {
            return false;
        }

        @Override
        public boolean matchesWithVarargs() {
            if (this._varargParam instanceof VarargArrayType) {
                this.boxArgs();
                if (super.matches()) {
                    ArrayType arrayT = (ArrayType)StandardTypeSystem.this.substitute(this._varargParam, (Iterable<? extends VariableType>)this._tparams, (Iterable<? extends Type>)this._targs);
                    Type elementT = arrayT.ofType();
                    Iterable<Expression> boxedVarargArgs = TypeSystem.EMPTY_EXPRESSION_ITERABLE;
                    for (Expression arg : this._varargArgs) {
                        Expression boxed = this.boxingConvert(arg, elementT);
                        if (!StandardTypeSystem.this.isSubtype(NodeProperties.getType(boxed), elementT)) {
                            return false;
                        }
                        boxedVarargArgs = IterUtil.compose(boxedVarargArgs, boxed);
                    }
                    this._params = IterUtil.compose(this._params, this._varargParam);
                    this._args = IterUtil.compose(this._args, StandardTypeSystem.this.makeArray(arrayT, boxedVarargArgs));
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyVarargInferenceChecker
    extends InferenceChecker {
        private Type _varargParam;

        public EmptyVarargInferenceChecker(Iterable<? extends Type> params, Iterable<? extends Expression> args, Iterable<? extends VariableType> tparams, Type returned, Option<Type> expected) {
            super(params, args, tparams, returned, expected);
            this._varargParam = (Type)IterUtil.last(this._params);
            this._params = IterUtil.skipLast(this._params);
        }

        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public boolean matchesWithBoxing() {
            return false;
        }

        @Override
        public boolean matchesWithVarargs() {
            if (this._varargParam instanceof VarargArrayType) {
                this.boxArgs();
                if (super.matches()) {
                    this._params = IterUtil.compose(this._params, this._varargParam);
                    ArrayType arrayT = (ArrayType)StandardTypeSystem.this.substitute(this._varargParam, (Iterable<? extends VariableType>)this._tparams, (Iterable<? extends Type>)this._targs);
                    this._args = IterUtil.compose(this._args, StandardTypeSystem.this.makeArray(arrayT, TypeSystem.EMPTY_EXPRESSION_ITERABLE));
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyVarargChecker
    extends SimpleChecker {
        private Type _varargParam;

        public EmptyVarargChecker(Iterable<? extends Type> params, Iterable<? extends Expression> args, Iterable<? extends VariableType> tparams, Iterable<? extends Type> targs) {
            super(params, args, tparams, targs);
            this._varargParam = (Type)IterUtil.last(this._params);
            this._params = IterUtil.skipLast(this._params);
        }

        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public boolean matchesWithBoxing() {
            return false;
        }

        @Override
        public boolean matchesWithVarargs() {
            if (this._varargParam instanceof VarargArrayType) {
                this.boxArgs();
                if (super.matches()) {
                    this._params = IterUtil.compose(this._params, this._varargParam);
                    ArrayType arrayT = (ArrayType)StandardTypeSystem.this.substitute(this._varargParam, (Iterable<? extends VariableType>)this._tparams, (Iterable<? extends Type>)this._targs);
                    this._args = IterUtil.compose(this._args, StandardTypeSystem.this.makeArray(arrayT, TypeSystem.EMPTY_EXPRESSION_ITERABLE));
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InferenceChecker
    extends SimpleChecker {
        protected final Type _returned;
        protected final Option<Type> _expected;

        public InferenceChecker(Iterable<? extends Type> params, Iterable<? extends Expression> args, Iterable<? extends VariableType> tparams, Type returned, Option<Type> expected) {
            super(params, args, tparams, null);
            this._returned = returned;
            if (expected.isSome()) {
                Expression exp = TypeUtil.makeEmptyExpression();
                NodeProperties.setType(exp, expected.unwrap());
                this._expected = Option.some(NodeProperties.getType(this.boxingConvert(exp, this._returned)));
            } else {
                this._expected = expected;
            }
        }

        @Override
        public boolean matches() {
            SnapshotIterable<Type> argTypes = IterUtil.mapSnapshot(this._args, NodeProperties.NODE_TYPE);
            this._targs = StandardTypeSystem.this.inferTypeArguments(this._tparams, this._params, this._returned, argTypes, this._expected);
            return this._targs != null;
        }

        @Override
        public boolean matchesWithBoxing() {
            return this.boxArgs() && this.matches();
        }

        @Override
        public boolean matchesWithVarargs() {
            if (this._paramForVarargs instanceof VarargArrayType) {
                ArrayType arrayT = (ArrayType)this._paramForVarargs;
                Type elementT = arrayT.ofType();
                this._argForVarargs = this.boxingConvert(this._argForVarargs, elementT);
                ComposedIterable<Expression> inferenceArgs = IterUtil.compose(IterUtil.skipLast(this._args), this._argForVarargs);
                SnapshotIterable<Type> argTypes = IterUtil.mapSnapshot(inferenceArgs, NodeProperties.NODE_TYPE);
                ComposedIterable<Type> paramTypes = IterUtil.compose(IterUtil.skipLast(this._params), elementT);
                this._targs = StandardTypeSystem.this.inferTypeArguments(this._tparams, paramTypes, this._returned, argTypes, this._expected);
                if (this._targs != null) {
                    Expression newArg = StandardTypeSystem.this.makeArray((ArrayType)StandardTypeSystem.this.substitute(arrayT, (Iterable<? extends VariableType>)this._tparams, (Iterable<? extends Type>)this._targs), IterUtil.make(this._argForVarargs));
                    this._args = IterUtil.compose(IterUtil.skipLast(this._args), newArg);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleChecker
    extends SignatureChecker {
        protected Iterable<? extends Type> _params;
        protected Iterable<? extends Expression> _args;
        protected Iterable<? extends VariableType> _tparams;
        protected Iterable<? extends Type> _targs;
        protected Type _paramForVarargs;
        protected Expression _argForVarargs;
        protected boolean _matchesAllButLast;

        public SimpleChecker(Iterable<? extends Type> params, Iterable<? extends Expression> args, Iterable<? extends VariableType> tparams, Iterable<? extends Type> targs) {
            this._params = params;
            this._args = args;
            this._tparams = tparams;
            this._targs = targs;
        }

        @Override
        public Iterable<? extends VariableType> typeParameters() {
            return this._tparams;
        }

        @Override
        public Iterable<? extends Type> typeArguments() {
            return this._targs;
        }

        @Override
        public Iterable<? extends Type> parameters() {
            return this._params;
        }

        @Override
        public Iterable<? extends Expression> arguments() {
            return this._args;
        }

        @Override
        public boolean matches() {
            Iterator<? extends Type> pI = this._params.iterator();
            Iterator<? extends Expression> aI = this._args.iterator();
            while (pI.hasNext()) {
                if (StandardTypeSystem.this.isSubtype(NodeProperties.getType(aI.next()), pI.next())) continue;
                this._matchesAllButLast = !pI.hasNext();
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesWithBoxing() {
            return this.boxArgs() && this.matches();
        }

        @Override
        public boolean matchesWithVarargs() {
            if (this._matchesAllButLast && this._paramForVarargs instanceof VarargArrayType) {
                ArrayType arrayT = (ArrayType)StandardTypeSystem.this.substitute(this._paramForVarargs, this._tparams, this._targs);
                Type elementT = arrayT.ofType();
                this._argForVarargs = this.boxingConvert(this._argForVarargs, elementT);
                if (StandardTypeSystem.this.isSubtype(NodeProperties.getType(this._argForVarargs), elementT)) {
                    Expression newArg = StandardTypeSystem.this.makeArray(arrayT, IterUtil.make(this._argForVarargs));
                    this._args = IterUtil.compose(IterUtil.skipLast(this._args), newArg);
                    return true;
                }
            }
            return false;
        }

        protected boolean boxArgs() {
            Iterable<Expression> newArgs = TypeSystem.EMPTY_EXPRESSION_ITERABLE;
            boolean result = false;
            Iterator<? extends Type> pI = this._params.iterator();
            Iterator<? extends Expression> aI = this._args.iterator();
            while (pI.hasNext()) {
                Expression newArg;
                Type pT = pI.next();
                Expression aE = aI.next();
                if (!pI.hasNext()) {
                    this._paramForVarargs = pT;
                    this._argForVarargs = aE;
                }
                if ((newArg = this.boxingConvert(aE, pT)) != aE) {
                    result = true;
                }
                newArgs = IterUtil.compose(newArgs, newArg);
            }
            if (result) {
                this._args = newArgs;
            }
            return result;
        }

        protected Expression boxingConvert(Expression exp, Type target) {
            Type t = NodeProperties.getType(exp);
            if (StandardTypeSystem.this.isPrimitive(target) && StandardTypeSystem.this.isPrimitiveConvertible(t)) {
                try {
                    return StandardTypeSystem.this.makePrimitive(exp);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new RuntimeException("isPrimitiveConvertible() lied");
                }
            }
            if (StandardTypeSystem.this.isReference(target) && StandardTypeSystem.this.isReferenceConvertible(t)) {
                try {
                    return StandardTypeSystem.this.makeReference(exp);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new RuntimeException("isReferenceConvertible() lied");
                }
            }
            return exp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullChecker
    extends SignatureChecker {
        public static final NullChecker INSTANCE = new NullChecker();

        private NullChecker() {
        }

        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public boolean matchesWithBoxing() {
            return false;
        }

        @Override
        public boolean matchesWithVarargs() {
            return false;
        }

        @Override
        public Iterable<? extends VariableType> typeParameters() {
            throw new IllegalStateException();
        }

        @Override
        public Iterable<? extends Type> typeArguments() {
            throw new IllegalStateException();
        }

        @Override
        public Iterable<? extends Type> parameters() {
            throw new IllegalStateException();
        }

        @Override
        public Iterable<? extends Expression> arguments() {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SignatureChecker {
        private SignatureChecker() {
        }

        public abstract boolean matches();

        public abstract boolean matchesWithBoxing();

        public abstract boolean matchesWithVarargs();

        public abstract Iterable<? extends VariableType> typeParameters();

        public abstract Iterable<? extends Type> typeArguments();

        public abstract Iterable<? extends Type> parameters();

        public abstract Iterable<? extends Expression> arguments();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SubstitutionMap {
        private Map<VariableType, Type> _sigma;
        private Iterable<? extends VariableType> _vars;
        private Iterable<? extends Type> _values;
        public static final SubstitutionMap EMPTY = new SubstitutionMap(IterUtil.empty(), TypeSystem.EMPTY_TYPE_ITERABLE);

        public SubstitutionMap(Iterable<? extends VariableType> vars, Iterable<? extends Type> values) {
            this._sigma = null;
            this._vars = vars;
            this._values = values;
        }

        public SubstitutionMap(Map<? extends VariableType, ? extends Type> map) {
            this._sigma = new HashMap<VariableType, Type>(map);
        }

        public boolean isEmpty() {
            if (this._sigma == null) {
                return IterUtil.isEmpty(this._vars);
            }
            return this._sigma.isEmpty();
        }

        public Type get(VariableType v) {
            if (this._sigma == null) {
                this.initSigma();
            }
            return this._sigma.get(v);
        }

        private void initSigma() {
            this._sigma = new HashMap<VariableType, Type>();
            for (Pair pair : IterUtil.zip(this._vars, this._values)) {
                this._sigma.put((VariableType)pair.first(), (Type)pair.second());
            }
            this._vars = null;
            this._values = null;
        }
    }
}

