/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.symbol;

import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.StandardTypeSystem;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ArrayType;
import edu.rice.cs.dynamicjava.symbol.type.BottomType;
import edu.rice.cs.dynamicjava.symbol.type.BoundType;
import edu.rice.cs.dynamicjava.symbol.type.ByteType;
import edu.rice.cs.dynamicjava.symbol.type.CharType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.FloatType;
import edu.rice.cs.dynamicjava.symbol.type.FloatingPointType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.IntegerType;
import edu.rice.cs.dynamicjava.symbol.type.IntersectionType;
import edu.rice.cs.dynamicjava.symbol.type.LongType;
import edu.rice.cs.dynamicjava.symbol.type.NullType;
import edu.rice.cs.dynamicjava.symbol.type.ParameterizedClassType;
import edu.rice.cs.dynamicjava.symbol.type.RawClassType;
import edu.rice.cs.dynamicjava.symbol.type.ShortType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleClassType;
import edu.rice.cs.dynamicjava.symbol.type.TopType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.TypeAbstractVisitor;
import edu.rice.cs.dynamicjava.symbol.type.TypeUpdateVisitor;
import edu.rice.cs.dynamicjava.symbol.type.TypeVisitorLambda;
import edu.rice.cs.dynamicjava.symbol.type.UnionType;
import edu.rice.cs.dynamicjava.symbol.type.ValidType;
import edu.rice.cs.dynamicjava.symbol.type.VarargArrayType;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.dynamicjava.symbol.type.Wildcard;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.Order;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.recur.RecursionStack2;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.plt.tuple.Triple;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedTypeSystem
extends StandardTypeSystem {
    public static final ExtendedTypeSystem INSTANCE = new ExtendedTypeSystem();
    private final TypeVisitorLambda<Iterable<? extends Type>> DISJUNCTS = new TypeAbstractVisitor<Iterable<? extends Type>>(){

        @Override
        public Iterable<? extends Type> forValidType(ValidType t) {
            return IterUtil.singleton(t);
        }

        @Override
        public Iterable<? extends Type> forUnionType(UnionType t) {
            return t.ofTypes();
        }
    };
    private final TypeVisitorLambda<Iterable<? extends Type>> CONJUNCTS = new TypeAbstractVisitor<Iterable<? extends Type>>(){

        @Override
        public Iterable<? extends Type> forValidType(ValidType t) {
            return IterUtil.singleton(t);
        }

        @Override
        public Iterable<? extends Type> forIntersectionType(IntersectionType t) {
            return t.ofTypes();
        }
    };
    private ConstraintScenario TRUE = new ConstraintScenario();
    private ConstraintFormula FALSE = new ConstraintFormula(){

        @Override
        public boolean isSatisfiable() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterable<ConstraintScenario> scenarios() {
            return IterUtil.empty();
        }

        @Override
        public ConstraintFormula and(ConstraintFormula that) {
            return this;
        }

        @Override
        public ConstraintFormula or(ConstraintFormula that) {
            return that;
        }
    };
    private Order<ConstraintScenario> SCENARIO_IMPLICATION = new Order<ConstraintScenario>(){

        @Override
        public boolean contains(ConstraintScenario ant, ConstraintScenario cons) {
            NormSubtyper sub = new NormSubtyper();
            for (VariableType var : cons.boundVariables()) {
                if (!sub.contains(ant.upperBound(var), cons.upperBound(var))) {
                    return false;
                }
                if (sub.contains(cons.lowerBound(var), ant.lowerBound(var))) continue;
                return false;
            }
            return true;
        }
    };

    @Override
    public boolean isWellFormed(Type t) {
        return new WellFormedChecker().contains(t);
    }

    @Override
    public boolean isEqual(Type t1, Type t2) {
        Type t2Norm;
        if (t1.equals(t2)) {
            return true;
        }
        NormSubtyper sub = new NormSubtyper();
        Normalizer norm = new Normalizer(sub);
        Type t1Norm = (Type)norm.value(t1);
        return sub.contains(t1Norm, t2Norm = (Type)norm.value(t2)) && sub.contains(t2Norm, t1Norm);
    }

    @Override
    public boolean isSubtype(Type subT, Type superT) {
        NormSubtyper sub = new NormSubtyper();
        Normalizer norm = new Normalizer(sub);
        return sub.contains((Type)norm.value(subT), (Type)norm.value(superT));
    }

    @Override
    public Type join(Iterable<? extends Type> ts) {
        NormSubtyper sub = new NormSubtyper();
        return new NormJoiner(sub).value((Iterable<? extends Type>)IterUtil.map(ts, new Normalizer(sub)));
    }

    @Override
    public Type meet(Iterable<? extends Type> ts) {
        NormSubtyper sub = new NormSubtyper();
        return new NormMeeter(sub).value((Iterable<? extends Type>)IterUtil.map(ts, new Normalizer(sub)));
    }

    @Override
    protected Iterable<Type> captureTypeArgs(Iterable<? extends Type> targs, Iterable<? extends VariableType> params) {
        LinkedList<BoundedSymbol> captureVars = new LinkedList<BoundedSymbol>();
        LinkedList<Type> newArgs = new LinkedList<Type>();
        for (Type type : targs) {
            if (type instanceof Wildcard) {
                BoundedSymbol boundedSymbol = new BoundedSymbol(new Object());
                captureVars.add(boundedSymbol);
                newArgs.add(new VariableType(boundedSymbol));
                continue;
            }
            captureVars.add(null);
            newArgs.add(type);
        }
        StandardTypeSystem.SubstitutionMap sigma = new StandardTypeSystem.SubstitutionMap(params, newArgs);
        for (Triple triple : IterUtil.zip(captureVars, targs, params)) {
            Type arg = (Type)triple.second();
            if (!(arg instanceof Wildcard)) continue;
            Wildcard argW = (Wildcard)arg;
            Type argU = argW.symbol().upperBound();
            Type argL = argW.symbol().lowerBound();
            VariableType param = (VariableType)triple.third();
            Type paramU = this.substitute(param.symbol().upperBound(), sigma);
            Type paramL = this.substitute(param.symbol().lowerBound(), sigma);
            Type captureU = argU.equals(paramU) ? argU : new IntersectionType(IterUtil.make(argU, paramU));
            Type captureL = argL.equals(paramL) ? argL : new UnionType(IterUtil.make(argL, paramL));
            ((BoundedSymbol)triple.first()).initializeUpperBound(captureU);
            ((BoundedSymbol)triple.first()).initializeLowerBound(captureL);
        }
        return newArgs;
    }

    private ConstraintFormula lowerBound(VariableType var, Type lower) {
        NormSubtyper sub = new NormSubtyper();
        if (sub.contains(NULL, lower) && sub.contains(lower, OBJECT)) {
            return new ConstraintScenario(lower, var);
        }
        return this.FALSE;
    }

    private ConstraintFormula upperBound(VariableType var, Type upper) {
        NormSubtyper sub = new NormSubtyper();
        if (sub.contains(NULL, upper) && sub.contains(upper, OBJECT)) {
            return new ConstraintScenario(var, upper);
        }
        return this.FALSE;
    }

    @Override
    protected Iterable<Type> inferTypeArguments(Iterable<? extends VariableType> tparams, Iterable<? extends Type> params, Type returned, Iterable<? extends Type> args, Option<Type> expected) {
        Pair pair;
        Inferencer inf = new Inferencer(CollectUtil.makeSet(tparams));
        ConstraintFormula constraints = this.TRUE;
        NormSubtyper sub = new NormSubtyper();
        Normalizer norm = new Normalizer(sub);
        Iterator i$ = IterUtil.zip(IterUtil.map(args, norm), IterUtil.map(params, norm)).iterator();
        while (i$.hasNext() && (constraints = constraints.and(inf.subtypeNorm((Type)(pair = (Pair)i$.next()).first(), (Type)pair.second()))).isSatisfiable()) {
        }
        if (expected.isSome() && constraints.isSatisfiable()) {
            constraints = constraints.and(inf.supertypeNorm((Type)norm.value(expected.unwrap()), (Type)norm.value(returned)));
        }
        ConstraintFormula transConstraints = this.FALSE;
        for (final ConstraintScenario s : constraints.scenarios()) {
            VariableType variableType;
            ConstraintFormula cf = s;
            Iterator<? extends VariableType> i$2 = tparams.iterator();
            while (i$2.hasNext() && (cf = cf.and(inf.subtypeNorm(s.lowerBound(variableType = i$2.next()), (Type)norm.value(variableType.symbol().upperBound())))).isSatisfiable() && (cf = cf.and(inf.supertypeNorm(s.upperBound(variableType), (Type)norm.value(variableType.symbol().lowerBound())))).isSatisfiable()) {
            }
            if (!(transConstraints = transConstraints.or(cf)).isEmpty()) continue;
            break;
        }
        if (!transConstraints.isSatisfiable()) {
            return null;
        }
        for (final ConstraintScenario s : transConstraints.scenarios()) {
            SnapshotIterable<Type> result = IterUtil.mapSnapshot(tparams, new Lambda<VariableType, Type>(){

                @Override
                public Type value(VariableType param) {
                    return s.lowerBound(param);
                }
            });
            if (!this.inBounds(tparams, result)) continue;
            return result;
        }
        for (final ConstraintScenario s : transConstraints.scenarios()) {
            LinkedList<Wildcard> constraintWs = new LinkedList<Wildcard>();
            for (VariableType variableType : tparams) {
                BoundedSymbol sym = new BoundedSymbol(new Object(), s.upperBound(variableType), s.lowerBound(variableType));
                constraintWs.add(new Wildcard(sym));
            }
            Iterable<Type> result = this.captureTypeArgs(constraintWs, tparams);
            if (!IterUtil.and(result, new WellFormedChecker())) continue;
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Inferencer {
        private final Set<? extends VariableType> _vars;
        private final RecursionStack2<Type, Type> _subStack;
        private final RecursionStack2<Type, Type> _supStack;
        private final NormSubtyper _subtyper;
        private final TypeVisitorLambda<Boolean> _containsVar = new TypeAbstractVisitor<Boolean>(){
            private final RecursionStack<Type> _stack = new RecursionStack();

            @Override
            public Boolean defaultCase(Type t) {
                return false;
            }

            @Override
            public Boolean forArrayType(ArrayType t) {
                return t.ofType().apply(this);
            }

            @Override
            public Boolean forParameterizedClassType(ParameterizedClassType t) {
                return this.checkList(t.typeArguments());
            }

            @Override
            public Boolean forBoundType(BoundType t) {
                return this.checkList(t.ofTypes());
            }

            @Override
            public Boolean forVariableType(VariableType t) {
                return Inferencer.this._vars.contains(t) || this.checkBoundedSymbol(t, t.symbol()) != false;
            }

            @Override
            public Boolean forWildcard(Wildcard w) {
                return this.checkBoundedSymbol(w, w.symbol());
            }

            private Boolean checkList(Iterable<? extends Type> types) {
                for (Type type : types) {
                    if (!type.apply(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            private Boolean checkBoundedSymbol(Type t, final BoundedSymbol s) {
                final 3 visitor = this;
                Thunk<Boolean> handleBounds = new Thunk<Boolean>(){

                    @Override
                    public Boolean value() {
                        return (Boolean)s.lowerBound().apply(visitor) != false || (Boolean)s.upperBound().apply(visitor) != false;
                    }
                };
                return this._stack.apply(handleBounds, Boolean.valueOf(false), t);
            }
        };

        public Inferencer(Set<? extends VariableType> vars) {
            this._vars = vars;
            this._subStack = new RecursionStack2();
            this._supStack = new RecursionStack2();
            this._subtyper = new NormSubtyper();
        }

        public ConstraintFormula subtypeNorm(final Type arg, final Type param) {
            if (!param.apply(this._containsVar).booleanValue()) {
                return this._subtyper.contains(arg, param) ? ExtendedTypeSystem.this.TRUE : ExtendedTypeSystem.this.FALSE;
            }
            return param.apply(new TypeAbstractVisitor<ConstraintFormula>(){

                @Override
                public ConstraintFormula defaultCase(Type param2) {
                    throw new IllegalArgumentException();
                }

                @Override
                public ConstraintFormula forArrayType(final ArrayType param2) {
                    return arg.apply(new ArgVisitor(){

                        public ConstraintFormula forArrayType(ArrayType arg) {
                            if (ExtendedTypeSystem.this.isPrimitive(arg.ofType())) {
                                return Inferencer.this.equivalentNorm(arg.ofType(), param2.ofType());
                            }
                            return Inferencer.this.subtypeNorm(arg.ofType(), param2.ofType());
                        }
                    });
                }

                @Override
                public ConstraintFormula forParameterizedClassType(final ParameterizedClassType param2) {
                    return arg.apply(new ArgVisitor(){

                        public ConstraintFormula forArrayType(ArrayType arg) {
                            return Inferencer.this.subtypeNorm(StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE, param2);
                        }

                        public ConstraintFormula forClassType(ClassType arg) {
                            Type argSuper = ExtendedTypeSystem.this.immediateSupertype(arg);
                            if (argSuper == null) {
                                return ExtendedTypeSystem.this.FALSE;
                            }
                            return Inferencer.this.subtypeNorm(argSuper, param2);
                        }

                        public ConstraintFormula forParameterizedClassType(final ParameterizedClassType arg) {
                            ConstraintFormula cf = ExtendedTypeSystem.this.FALSE;
                            if (((Object)param2.ofClass()).equals(arg.ofClass())) {
                                Thunk<ConstraintFormula> recurOnTargs = new Thunk<ConstraintFormula>(){

                                    @Override
                                    public ConstraintFormula value() {
                                        ParameterizedClassType argCap = ExtendedTypeSystem.this.capture(arg);
                                        ConstraintFormula result = ExtendedTypeSystem.this.TRUE;
                                        for (Pair pair : IterUtil.zip(argCap.typeArguments(), param2.typeArguments())) {
                                            final Type argArg = (Type)pair.first();
                                            Type paramArg = (Type)pair.second();
                                            if ((result = result.and(paramArg.apply(new TypeAbstractVisitor<ConstraintFormula>(){

                                                @Override
                                                public ConstraintFormula defaultCase(Type paramArg) {
                                                    return Inferencer.this.equivalentNorm(argArg, paramArg);
                                                }

                                                @Override
                                                public ConstraintFormula forWildcard(Wildcard paramArg) {
                                                    ConstraintFormula wildResult = Inferencer.this.supertypeNorm(argArg, paramArg.symbol().lowerBound());
                                                    if (wildResult.isSatisfiable()) {
                                                        wildResult = wildResult.and(Inferencer.this.subtypeNorm(argArg, paramArg.symbol().upperBound()));
                                                    }
                                                    return wildResult;
                                                }
                                            }))).isSatisfiable()) continue;
                                            break;
                                        }
                                        return result;
                                    }
                                };
                                cf = Inferencer.this._subStack.apply(recurOnTargs, ExtendedTypeSystem.this.FALSE, arg, param2);
                            }
                            if (!cf.isEmpty()) {
                                cf = cf.or(this.forClassType(arg));
                            }
                            return cf;
                        }
                    });
                }

                @Override
                public ConstraintFormula forVariableType(final VariableType param2) {
                    if (Inferencer.this._vars.contains(param2)) {
                        return ExtendedTypeSystem.this.lowerBound(param2, arg);
                    }
                    return arg.apply(new ArgVisitor(){

                        public ConstraintFormula defaultCase(final Type arg) {
                            Thunk<ConstraintFormula> recurOnBound = new Thunk<ConstraintFormula>(){

                                @Override
                                public ConstraintFormula value() {
                                    return Inferencer.this.subtypeNorm(arg, (Type)new Normalizer(Inferencer.this._subtyper).value(param2.symbol().lowerBound()));
                                }
                            };
                            Thunk<ConstraintFormula> infiniteCase = new Thunk<ConstraintFormula>(){

                                @Override
                                public ConstraintFormula value() {
                                    return Inferencer.this.subtypeNorm(arg, TypeSystem.NULL);
                                }
                            };
                            return Inferencer.this._subStack.apply(recurOnBound, infiniteCase, arg, param2);
                        }

                        public ConstraintFormula forVariableType(VariableType arg) {
                            ConstraintFormula result = super.forVariableType(arg);
                            if (!result.isEmpty()) {
                                result = result.or(this.defaultCase(arg));
                            }
                            return result;
                        }

                        public ConstraintFormula forIntersectionType(IntersectionType arg) {
                            ConstraintFormula result = super.forIntersectionType(arg);
                            if (!result.isEmpty()) {
                                result = result.or(this.defaultCase(arg));
                            }
                            return result;
                        }
                    });
                }

                @Override
                public ConstraintFormula forIntersectionType(final IntersectionType param2) {
                    return arg.apply(new ArgVisitor(){

                        public ConstraintFormula defaultCase(Type arg) {
                            Type supParam;
                            ConstraintFormula result = ExtendedTypeSystem.this.TRUE;
                            Iterator<? extends Type> i$ = param2.ofTypes().iterator();
                            while (i$.hasNext() && (result = result.and(Inferencer.this.subtypeNorm(arg, supParam = i$.next()))).isSatisfiable()) {
                            }
                            return result;
                        }

                        public ConstraintFormula forVariableType(VariableType arg) {
                            return this.defaultCase(arg);
                        }

                        public ConstraintFormula forIntersectionType(IntersectionType arg) {
                            return this.defaultCase(arg);
                        }
                    });
                }

                @Override
                public ConstraintFormula forUnionType(final UnionType param2) {
                    return arg.apply(new ArgVisitor(){

                        public ConstraintFormula defaultCase(Type arg) {
                            Type subParam;
                            ConstraintFormula result = ExtendedTypeSystem.this.FALSE;
                            Iterator<? extends Type> i$ = param2.ofTypes().iterator();
                            while (i$.hasNext() && !(result = result.or(Inferencer.this.subtypeNorm(arg, subParam = i$.next()))).isEmpty()) {
                            }
                            return result;
                        }

                        public ConstraintFormula forVariableType(VariableType arg) {
                            ConstraintFormula result = super.forVariableType(arg);
                            if (!result.isEmpty()) {
                                result = result.or(this.defaultCase(arg));
                            }
                            return result;
                        }

                        public ConstraintFormula forIntersectionType(IntersectionType arg) {
                            return this.defaultCase(arg);
                        }
                    });
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ArgVisitor
                extends TypeAbstractVisitor<ConstraintFormula> {
                    ArgVisitor() {
                    }

                    @Override
                    public ConstraintFormula defaultCase(Type arg) {
                        return ExtendedTypeSystem.this.FALSE;
                    }

                    @Override
                    public ConstraintFormula forNullType(NullType arg) {
                        return ExtendedTypeSystem.this.TRUE;
                    }

                    @Override
                    public ConstraintFormula forBottomType(BottomType arg) {
                        return ExtendedTypeSystem.this.TRUE;
                    }

                    @Override
                    public ConstraintFormula forVariableType(final VariableType arg) {
                        Thunk<ConstraintFormula> recurOnBound = new Thunk<ConstraintFormula>(){

                            @Override
                            public ConstraintFormula value() {
                                return Inferencer.this.subtypeNorm((Type)new Normalizer(Inferencer.this._subtyper).value(arg.symbol().upperBound()), param);
                            }
                        };
                        Thunk<ConstraintFormula> infiniteCase = new Thunk<ConstraintFormula>(){

                            @Override
                            public ConstraintFormula value() {
                                return Inferencer.this.subtypeNorm(TypeSystem.OBJECT, param);
                            }
                        };
                        return Inferencer.this._subStack.apply(recurOnBound, infiniteCase, arg, param);
                    }

                    @Override
                    public ConstraintFormula forIntersectionType(IntersectionType arg) {
                        Type supArg;
                        ConstraintFormula result = ExtendedTypeSystem.this.FALSE;
                        Iterator<? extends Type> i$ = arg.ofTypes().iterator();
                        while (i$.hasNext() && !(result = result.or(Inferencer.this.subtypeNorm(supArg = i$.next(), param))).isEmpty()) {
                        }
                        return result;
                    }

                    @Override
                    public ConstraintFormula forUnionType(UnionType arg) {
                        Type subArg;
                        ConstraintFormula result = ExtendedTypeSystem.this.TRUE;
                        Iterator<? extends Type> i$ = arg.ofTypes().iterator();
                        while (i$.hasNext() && (result = result.and(Inferencer.this.subtypeNorm(subArg = i$.next(), param))).isSatisfiable()) {
                        }
                        return result;
                    }
                }
            });
        }

        public ConstraintFormula supertypeNorm(final Type arg, final Type param) {
            if (!param.apply(this._containsVar).booleanValue()) {
                return new NormSubtyper().contains(param, arg) ? ExtendedTypeSystem.this.TRUE : ExtendedTypeSystem.this.FALSE;
            }
            return param.apply(new TypeAbstractVisitor<ConstraintFormula>(){

                @Override
                public ConstraintFormula defaultCase(Type param2) {
                    throw new IllegalArgumentException();
                }

                @Override
                public ConstraintFormula forArrayType(final ArrayType param2) {
                    return arg.apply(new Inferencer.ArgVisitor(){

                        public ConstraintFormula forArrayType(ArrayType arg) {
                            if (ExtendedTypeSystem.this.isPrimitive(arg.ofType())) {
                                return Inferencer.this.equivalentNorm(arg.ofType(), param2.ofType());
                            }
                            return Inferencer.this.supertypeNorm(arg.ofType(), param2.ofType());
                        }

                        public ConstraintFormula forClassType(ClassType arg) {
                            return Inferencer.this.supertypeNorm(arg, StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE);
                        }
                    });
                }

                @Override
                public ConstraintFormula forParameterizedClassType(final ParameterizedClassType param2) {
                    return arg.apply(new Inferencer.ArgVisitor(){

                        public ConstraintFormula forClassType(ClassType arg) {
                            Type paramSuper = ExtendedTypeSystem.this.immediateSupertype(param2);
                            if (paramSuper == null) {
                                return ExtendedTypeSystem.this.FALSE;
                            }
                            return Inferencer.this.supertypeNorm(arg, paramSuper);
                        }

                        public ConstraintFormula forParameterizedClassType(final ParameterizedClassType arg) {
                            ConstraintFormula cf = ExtendedTypeSystem.this.FALSE;
                            if (((Object)param2.ofClass()).equals(arg.ofClass())) {
                                Thunk<ConstraintFormula> recurOnTargs = new Thunk<ConstraintFormula>(){

                                    @Override
                                    public ConstraintFormula value() {
                                        Type paramArg;
                                        Pair pair;
                                        Type argArg;
                                        ParameterizedClassType paramCap = ExtendedTypeSystem.this.capture(param2);
                                        ConstraintFormula result = ExtendedTypeSystem.this.TRUE;
                                        Iterator i$ = IterUtil.zip(arg.typeArguments(), paramCap.typeArguments()).iterator();
                                        while (i$.hasNext() && (result = result.and((argArg = (Type)(pair = (Pair)i$.next()).first()).apply(new TypeAbstractVisitor<ConstraintFormula>(paramArg = (Type)pair.second()){
                                            final /* synthetic */ Type val$paramArg;
                                            {
                                                this.val$paramArg = type;
                                            }

                                            @Override
                                            public ConstraintFormula defaultCase(Type argArg) {
                                                return Inferencer.this.equivalentNorm(argArg, this.val$paramArg);
                                            }

                                            @Override
                                            public ConstraintFormula forWildcard(Wildcard argArg) {
                                                ConstraintFormula wildResult = Inferencer.this.subtypeNorm(argArg.symbol().lowerBound(), this.val$paramArg);
                                                if (wildResult.isSatisfiable()) {
                                                    wildResult = wildResult.and(Inferencer.this.supertypeNorm(argArg.symbol().upperBound(), this.val$paramArg));
                                                }
                                                return wildResult;
                                            }
                                        }))).isSatisfiable()) {
                                        }
                                        return result;
                                    }
                                };
                                cf = Inferencer.this._supStack.apply(recurOnTargs, ExtendedTypeSystem.this.FALSE, arg, param2);
                            }
                            if (!cf.isEmpty()) {
                                cf = cf.or(this.forClassType(arg));
                            }
                            return cf;
                        }
                    });
                }

                @Override
                public ConstraintFormula forVariableType(final VariableType param2) {
                    if (Inferencer.this._vars.contains(param2)) {
                        return ExtendedTypeSystem.this.upperBound(param2, arg);
                    }
                    return arg.apply(new Inferencer.ArgVisitor(){

                        public ConstraintFormula defaultCase(final Type arg) {
                            Thunk<ConstraintFormula> recurOnBound = new Thunk<ConstraintFormula>(){

                                @Override
                                public ConstraintFormula value() {
                                    return Inferencer.this.supertypeNorm(arg, (Type)new Normalizer(Inferencer.this._subtyper).value(param2.symbol().upperBound()));
                                }
                            };
                            Thunk<ConstraintFormula> infiniteCase = new Thunk<ConstraintFormula>(){

                                @Override
                                public ConstraintFormula value() {
                                    return Inferencer.this.supertypeNorm(arg, TypeSystem.OBJECT);
                                }
                            };
                            return Inferencer.this._supStack.apply(recurOnBound, infiniteCase, arg, param2);
                        }

                        public ConstraintFormula forVariableType(VariableType arg) {
                            ConstraintFormula result = this.defaultCase(arg);
                            if (!result.isEmpty()) {
                                result = result.or(super.forVariableType(arg));
                            }
                            return result;
                        }

                        public ConstraintFormula forUnionType(UnionType arg) {
                            ConstraintFormula result = this.defaultCase(arg);
                            if (!result.isEmpty()) {
                                result = result.or(super.forUnionType(arg));
                            }
                            return result;
                        }
                    });
                }

                @Override
                public ConstraintFormula forIntersectionType(final IntersectionType param2) {
                    return arg.apply(new Inferencer.ArgVisitor(){

                        public ConstraintFormula defaultCase(Type arg) {
                            Type supParam;
                            ConstraintFormula result = ExtendedTypeSystem.this.FALSE;
                            Iterator<? extends Type> i$ = param2.ofTypes().iterator();
                            while (i$.hasNext() && !(result = result.or(Inferencer.this.supertypeNorm(arg, supParam = i$.next()))).isEmpty()) {
                            }
                            return result;
                        }

                        public ConstraintFormula forVariableType(VariableType arg) {
                            ConstraintFormula result = this.defaultCase(arg);
                            if (!result.isEmpty()) {
                                result = result.or(super.forVariableType(arg));
                            }
                            return result;
                        }

                        public ConstraintFormula forUnionType(UnionType arg) {
                            return this.defaultCase(arg);
                        }
                    });
                }

                @Override
                public ConstraintFormula forUnionType(final UnionType param2) {
                    return arg.apply(new Inferencer.ArgVisitor(){

                        public ConstraintFormula defaultCase(Type arg) {
                            Type subParam;
                            ConstraintFormula result = ExtendedTypeSystem.this.TRUE;
                            Iterator<? extends Type> i$ = param2.ofTypes().iterator();
                            while (i$.hasNext() && (result = result.and(Inferencer.this.supertypeNorm(arg, subParam = i$.next()))).isSatisfiable()) {
                            }
                            return result;
                        }

                        public ConstraintFormula forVariableType(VariableType arg) {
                            return this.defaultCase(arg);
                        }

                        public ConstraintFormula forIntersectionType(IntersectionType arg) {
                            return this.defaultCase(arg);
                        }

                        public ConstraintFormula forUnionType(UnionType arg) {
                            return this.defaultCase(arg);
                        }
                    });
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Inferencer.ArgVisitor
                extends TypeAbstractVisitor<ConstraintFormula> {
                    Inferencer.ArgVisitor() {
                    }

                    @Override
                    public ConstraintFormula defaultCase(Type arg) {
                        return ExtendedTypeSystem.this.FALSE;
                    }

                    @Override
                    public ConstraintFormula forTopType(TopType arg) {
                        return ExtendedTypeSystem.this.TRUE;
                    }

                    @Override
                    public ConstraintFormula forVariableType(final VariableType arg) {
                        Thunk<ConstraintFormula> recurOnBound = new Thunk<ConstraintFormula>(){

                            @Override
                            public ConstraintFormula value() {
                                return Inferencer.this.supertypeNorm((Type)new Normalizer(Inferencer.this._subtyper).value(arg.symbol().lowerBound()), param);
                            }
                        };
                        Thunk<ConstraintFormula> infiniteCase = new Thunk<ConstraintFormula>(){

                            @Override
                            public ConstraintFormula value() {
                                return Inferencer.this.supertypeNorm(TypeSystem.NULL, param);
                            }
                        };
                        return Inferencer.this._subStack.apply(recurOnBound, infiniteCase, arg, param);
                    }

                    @Override
                    public ConstraintFormula forIntersectionType(IntersectionType arg) {
                        Type supArg;
                        ConstraintFormula result = ExtendedTypeSystem.this.TRUE;
                        Iterator<? extends Type> i$ = arg.ofTypes().iterator();
                        while (i$.hasNext() && (result = result.and(Inferencer.this.supertypeNorm(supArg = i$.next(), param))).isSatisfiable()) {
                        }
                        return result;
                    }

                    @Override
                    public ConstraintFormula forUnionType(UnionType arg) {
                        Type subArg;
                        ConstraintFormula result = ExtendedTypeSystem.this.FALSE;
                        Iterator<? extends Type> i$ = arg.ofTypes().iterator();
                        while (i$.hasNext() && !(result = result.or(Inferencer.this.supertypeNorm(subArg = i$.next(), param))).isEmpty()) {
                        }
                        return result;
                    }
                }
            });
        }

        public ConstraintFormula equivalentNorm(Type arg, Type param) {
            ConstraintFormula result = this.subtypeNorm(arg, param);
            if (result.isSatisfiable()) {
                result = result.and(this.supertypeNorm(arg, param));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisjunctiveConstraint
    extends ConstraintFormula {
        private final Iterable<ConstraintScenario> _scenarios;

        protected DisjunctiveConstraint(Iterable<ConstraintScenario> scenarios) {
            this._scenarios = scenarios;
        }

        @Override
        public boolean isSatisfiable() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterable<ConstraintScenario> scenarios() {
            return this._scenarios;
        }

        @Override
        public ConstraintFormula and(ConstraintFormula that) {
            Lambda<ConstraintFormula, Iterable<ConstraintScenario>> scenarios = new Lambda<ConstraintFormula, Iterable<ConstraintScenario>>(){

                @Override
                public Iterable<ConstraintScenario> value(ConstraintFormula f) {
                    return f.scenarios();
                }
            };
            Lambda<Iterable<ConstraintScenario>, Option<ConstraintScenario>> conjunction = new Lambda<Iterable<ConstraintScenario>, Option<ConstraintScenario>>(){

                @Override
                public Option<ConstraintScenario> value(Iterable<ConstraintScenario> scenarios) {
                    Option<ConstraintScenario> result = Option.some(ExtendedTypeSystem.this.TRUE);
                    for (ConstraintScenario s : scenarios) {
                        if (!(result = result.unwrap().and(s)).isNone()) continue;
                        break;
                    }
                    return result;
                }
            };
            Iterable<Option<ConstraintScenario>> disjuncts = IterUtil.distribute(IterUtil.make(this, that), scenarios, conjunction);
            ConstraintFormula result = ExtendedTypeSystem.this.FALSE;
            for (Option<ConstraintScenario> s : disjuncts) {
                if (!s.isSome()) continue;
                result = result.or(s.unwrap());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstraintScenario
    extends ConstraintFormula {
        private final Map<VariableType, Type> _lowerBounds;
        private final Map<VariableType, Type> _upperBounds;

        protected ConstraintScenario() {
            this._lowerBounds = new HashMap<VariableType, Type>();
            this._upperBounds = new HashMap<VariableType, Type>();
        }

        protected ConstraintScenario(VariableType var, Type upper) {
            this();
            this._upperBounds.put(var, upper);
        }

        protected ConstraintScenario(Type lower, VariableType var) {
            this();
            this._lowerBounds.put(var, lower);
        }

        @Override
        public boolean isSatisfiable() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this._lowerBounds.isEmpty() && this._upperBounds.isEmpty();
        }

        @Override
        public Iterable<ConstraintScenario> scenarios() {
            return IterUtil.singleton(this);
        }

        @Override
        public ConstraintFormula and(ConstraintFormula that) {
            ConstraintFormula result = ExtendedTypeSystem.this.FALSE;
            for (ConstraintScenario s : that.scenarios()) {
                result = result.or(Option.unwrap(this.and(s), ExtendedTypeSystem.this.FALSE));
            }
            return result;
        }

        public Option<ConstraintScenario> and(ConstraintScenario that) {
            ConstraintScenario result = new ConstraintScenario();
            NormSubtyper sub = new NormSubtyper();
            NormJoiner join = new NormJoiner(sub);
            NormMeeter meet = new NormMeeter(sub);
            for (VariableType variableType : CollectUtil.union(this._lowerBounds.keySet(), that._lowerBounds.keySet())) {
                result._lowerBounds.put(variableType, join.value((Iterable<? extends Type>)IterUtil.make(this.lowerBound(variableType), that.lowerBound(variableType))));
            }
            for (VariableType variableType : CollectUtil.union(this._upperBounds.keySet(), that._upperBounds.keySet())) {
                result._upperBounds.put(variableType, meet.value((Iterable<? extends Type>)IterUtil.make(this.upperBound(variableType), that.upperBound(variableType))));
            }
            return result.isWellFormed() ? Option.some(result) : Option.none();
        }

        public Set<VariableType> boundVariables() {
            return CollectUtil.union(this._lowerBounds.keySet(), this._upperBounds.keySet());
        }

        public Type upperBound(VariableType var) {
            Type result = this._upperBounds.get(var);
            return result == null ? TypeSystem.OBJECT : result;
        }

        public Type lowerBound(VariableType var) {
            Type result = this._lowerBounds.get(var);
            return result == null ? TypeSystem.NULL : result;
        }

        protected boolean isWellFormed() {
            NormSubtyper sub = new NormSubtyper();
            for (VariableType var : CollectUtil.intersection(this._lowerBounds.keySet(), this._upperBounds.keySet())) {
                if (sub.contains(this.lowerBound(var), this.upperBound(var))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ConstraintFormula {
        private ConstraintFormula() {
        }

        public abstract boolean isSatisfiable();

        public abstract boolean isEmpty();

        public abstract Iterable<ConstraintScenario> scenarios();

        public abstract ConstraintFormula and(ConstraintFormula var1);

        public ConstraintFormula or(ConstraintFormula that) {
            List<ConstraintScenario> scenarios = CollectUtil.composeMaxLists(this.scenarios(), that.scenarios(), ExtendedTypeSystem.this.SCENARIO_IMPLICATION);
            if (scenarios.isEmpty()) {
                return ExtendedTypeSystem.this.FALSE;
            }
            if (scenarios.size() == 1) {
                return scenarios.get(0);
            }
            return new DisjunctiveConstraint(scenarios);
        }

        public String toString() {
            if (this.isEmpty()) {
                return "{}";
            }
            if (!this.isSatisfiable()) {
                return "{ false }";
            }
            StringBuilder result = new StringBuilder();
            boolean firstScenario = true;
            for (ConstraintScenario s : this.scenarios()) {
                if (!firstScenario) {
                    result.append(" | ");
                }
                firstScenario = false;
                result.append("{ ");
                boolean firstVar = true;
                for (VariableType var : s.boundVariables()) {
                    if (firstVar) {
                        result.append(", ");
                    }
                    firstVar = false;
                    result.append(ExtendedTypeSystem.this.userRepresentation(s.lowerBound(var)));
                    result.append(" <: ");
                    result.append(var.symbol().name());
                    result.append(" <: ");
                    result.append(ExtendedTypeSystem.this.userRepresentation(s.upperBound(var)));
                }
                result.append(" }");
            }
            return result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormMeeter
    implements Lambda<Iterable<? extends Type>, Type> {
        private final NormSubtyper _subtyper;
        private final Lambda<Iterable<? extends Type>, Type> _meetAtomic = new Lambda<Iterable<? extends Type>, Type>(){

            @Override
            public Type value(Iterable<? extends Type> atoms) {
                List<Type> conjuncts = CollectUtil.minList(atoms, NormMeeter.this._subtyper);
                switch (conjuncts.size()) {
                    case 0: {
                        return TypeSystem.TOP;
                    }
                    case 1: {
                        return conjuncts.get(0);
                    }
                }
                return new IntersectionType(conjuncts);
            }
        };

        public NormMeeter(NormSubtyper subtyper) {
            this._subtyper = subtyper;
        }

        @Override
        public Type value(Iterable<? extends Type> elements) {
            if (IterUtil.or(elements, LambdaUtil.bindSecond(LambdaUtil.INSTANCE_OF, UnionType.class))) {
                final NormJoiner joiner = new NormJoiner(this._subtyper);
                SizedIterable<Iterable<Type>> posElements = IterUtil.map(elements, new Lambda<Type, Iterable<Type>>(){

                    @Override
                    public Iterable<Type> value(Type element) {
                        return (Iterable)IterUtil.distribute(element, ExtendedTypeSystem.this.DISJUNCTS, ExtendedTypeSystem.this.CONJUNCTS, joiner, LambdaUtil.identity());
                    }
                });
                List<Type> conjuncts = CollectUtil.minList(IterUtil.collapse(posElements), new NormSubtyper());
                return IterUtil.distribute(conjuncts, LambdaUtil.identity(), ExtendedTypeSystem.this.DISJUNCTS, this._meetAtomic, joiner);
            }
            return this._meetAtomic.value(IterUtil.collapse(IterUtil.map(elements, ExtendedTypeSystem.this.CONJUNCTS)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormJoiner
    implements Lambda<Iterable<? extends Type>, Type> {
        private final NormSubtyper _subtyper;

        public NormJoiner(NormSubtyper subtyper) {
            this._subtyper = subtyper;
        }

        @Override
        public Type value(Iterable<? extends Type> elements) {
            List<Type> disjuncts = CollectUtil.maxList(IterUtil.collapse(IterUtil.map(elements, ExtendedTypeSystem.this.DISJUNCTS)), this._subtyper);
            switch (disjuncts.size()) {
                case 0: {
                    return TypeSystem.BOTTOM;
                }
                case 1: {
                    return disjuncts.get(0);
                }
            }
            return new UnionType(disjuncts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Normalizer
    extends TypeUpdateVisitor {
        private final NormSubtyper _subtyper;

        public Normalizer(NormSubtyper subtyper) {
            this._subtyper = subtyper;
        }

        @Override
        public Type forIntersectionTypeOnly(IntersectionType t, Iterable<? extends Type> normTypes) {
            Type result = new NormMeeter(this._subtyper).value(normTypes);
            return t.equals(result) ? t : result;
        }

        @Override
        public Type forUnionTypeOnly(UnionType t, Iterable<? extends Type> normTypes) {
            Type result = new NormJoiner(this._subtyper).value(normTypes);
            return t.equals(result) ? t : result;
        }

        @Override
        public Type forWildcardOnly(Wildcard w) {
            BoundedSymbol b = w.symbol();
            Type newUpper = this.recur(b.upperBound());
            Type newLower = this.recur(b.lowerBound());
            if (newUpper == b.upperBound() && newLower == b.lowerBound()) {
                return w;
            }
            return new Wildcard(new BoundedSymbol(new Object(), newUpper, newLower));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormSubtyper
    implements Order<Type>,
    Lambda2<Type, Type, Boolean> {
        RecursionStack2<Type, Type> _stack = new RecursionStack2();

        private NormSubtyper() {
        }

        @Override
        public Boolean value(Type subT, Type superT) {
            return this.contains(subT, superT);
        }

        public Predicate<Type> supertypes(Type sub) {
            return LambdaUtil.bindFirst(this, sub);
        }

        public Predicate<Type> subtypes(Type sup) {
            return LambdaUtil.bindSecond(this, sup);
        }

        @Override
        public boolean contains(final Type subT, final Type superT) {
            if (subT.equals(superT)) {
                return true;
            }
            Boolean result = superT.apply(new TypeAbstractVisitor<Boolean>(){

                @Override
                public Boolean defaultCase(Type superT) {
                    return null;
                }

                @Override
                public Boolean forVariableType(final VariableType superT) {
                    return subT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(final Type subT) {
                            Thunk<Boolean> checkLowerBound = new Thunk<Boolean>(){

                                @Override
                                public Boolean value() {
                                    Type bound = (Type)new Normalizer(NormSubtyper.this).value(superT.symbol().lowerBound());
                                    return NormSubtyper.this.contains(subT, bound);
                                }
                            };
                            Thunk<Boolean> checkInfinite = new Thunk<Boolean>(){

                                @Override
                                public Boolean value() {
                                    return NormSubtyper.this.contains(subT, TypeSystem.NULL);
                                }
                            };
                            return NormSubtyper.this._stack.apply(checkLowerBound, checkInfinite, subT, (Type)superT);
                        }

                        @Override
                        public Boolean forVariableType(VariableType subT) {
                            return this.defaultCase(subT) != false ? Boolean.valueOf(true) : null;
                        }

                        @Override
                        public Boolean forIntersectionType(IntersectionType subT) {
                            return this.defaultCase(subT) != false ? Boolean.valueOf(true) : null;
                        }

                        @Override
                        public Boolean forBottomType(BottomType subT) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forIntersectionType(IntersectionType superT) {
                    if (subT instanceof BottomType) {
                        return true;
                    }
                    return IterUtil.and(superT.ofTypes(), NormSubtyper.this.supertypes(subT));
                }

                @Override
                public Boolean forUnionType(final UnionType superT) {
                    return subT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type t) {
                            return IterUtil.or(superT.ofTypes(), NormSubtyper.this.supertypes(subT));
                        }

                        @Override
                        public Boolean forVariableType(VariableType t) {
                            return this.defaultCase(subT) != false ? Boolean.valueOf(true) : null;
                        }

                        @Override
                        public Boolean forUnionType(UnionType t) {
                            return null;
                        }

                        @Override
                        public Boolean forBottomType(BottomType t) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forTopType(TopType superT) {
                    return true;
                }
            });
            if (result != null) {
                return result;
            }
            return subT.apply(new TypeAbstractVisitor<Boolean>(){

                @Override
                public Boolean defaultCase(Type t) {
                    return false;
                }

                @Override
                public Boolean forCharType(CharType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forCharType(CharType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forIntType(IntType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forLongType(LongType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forFloatingPointType(FloatingPointType superT) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forByteType(ByteType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forIntegerType(IntegerType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forFloatingPointType(FloatingPointType superT) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forShortType(ShortType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forShortType(ShortType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forIntType(IntType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forLongType(LongType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forFloatingPointType(FloatingPointType superT) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forIntType(IntType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forIntType(IntType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forLongType(LongType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forFloatingPointType(FloatingPointType superT) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forLongType(LongType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forLongType(LongType superT) {
                            return true;
                        }

                        @Override
                        public Boolean forFloatingPointType(FloatingPointType superT) {
                            return true;
                        }
                    });
                }

                @Override
                public Boolean forFloatType(FloatType subT) {
                    return superT instanceof FloatingPointType;
                }

                @Override
                public Boolean forNullType(NullType subT) {
                    return ExtendedTypeSystem.this.isReference(superT);
                }

                @Override
                public Boolean forSimpleArrayType(SimpleArrayType subT) {
                    return this.handleArrayType(subT);
                }

                @Override
                public Boolean forVarargArrayType(VarargArrayType subT) {
                    return this.handleArrayType(subT);
                }

                private Boolean handleArrayType(final ArrayType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forArrayType(ArrayType superT) {
                            if (ExtendedTypeSystem.this.isPrimitive(subT.ofType())) {
                                return subT.ofType().equals(superT.ofType());
                            }
                            return NormSubtyper.this.contains(subT.ofType(), superT.ofType());
                        }

                        @Override
                        public Boolean forClassType(ClassType superT) {
                            return NormSubtyper.this.contains(StandardTypeSystem.CLONEABLE_AND_SERIALIZABLE, superT);
                        }
                    });
                }

                @Override
                public Boolean forClassType(final ClassType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forClassType(final ClassType superT) {
                            final Type newSub = ExtendedTypeSystem.this.immediateSupertype(subT);
                            if (newSub == null) {
                                return false;
                            }
                            Thunk<Boolean> recurOnParent = new Thunk<Boolean>(){

                                @Override
                                public Boolean value() {
                                    Type newSubNorm = (Type)new Normalizer(NormSubtyper.this).value(newSub);
                                    return NormSubtyper.this.contains(newSubNorm, superT);
                                }
                            };
                            return NormSubtyper.this._stack.apply(recurOnParent, Boolean.valueOf(false), (Type)subT, (Type)superT);
                        }
                    });
                }

                @Override
                public Boolean forParameterizedClassType(final ParameterizedClassType subT) {
                    return superT.apply(new TypeAbstractVisitor<Boolean>(){

                        @Override
                        public Boolean defaultCase(Type superT) {
                            return false;
                        }

                        @Override
                        public Boolean forParameterizedClassType(final ParameterizedClassType superT) {
                            if (((Object)subT.ofClass()).equals(superT.ofClass())) {
                                Thunk<Boolean> containedArgs = new Thunk<Boolean>(){

                                    @Override
                                    public Boolean value() {
                                        Pair args;
                                        boolean result = true;
                                        ParameterizedClassType subCapT = ExtendedTypeSystem.this.capture(subT);
                                        Iterator i$ = IterUtil.zip(subCapT.typeArguments(), superT.typeArguments()).iterator();
                                        while (i$.hasNext() && (result &= ((Type)(args = (Pair)i$.next()).second()).apply(new TypeAbstractVisitor<Boolean>(){

                                            @Override
                                            public Boolean defaultCase(Type superArg) {
                                                Type subArg = (Type)args.first();
                                                return NormSubtyper.this.contains(subArg, superArg) && NormSubtyper.this.contains(superArg, subArg);
                                            }

                                            @Override
                                            public Boolean forWildcard(Wildcard superArg) {
                                                Type subArg = (Type)args.first();
                                                return NormSubtyper.this.contains(superArg.symbol().lowerBound(), subArg) && NormSubtyper.this.contains(subArg, superArg.symbol().upperBound());
                                            }
                                        }).booleanValue())) {
                                        }
                                        return result;
                                    }
                                };
                                return NormSubtyper.this._stack.apply(containedArgs, Boolean.valueOf(false), (Type)subT, (Type)superT) != false || this.forClassType(superT) != false;
                            }
                            return this.forClassType(superT);
                        }

                        @Override
                        public Boolean forClassType(ClassType superT) {
                            Type newSub = ExtendedTypeSystem.this.immediateSupertype(subT);
                            if (newSub == null) {
                                return false;
                            }
                            return NormSubtyper.this.contains(newSub, superT) || NormSubtyper.this.contains(ExtendedTypeSystem.this.erase(subT), superT);
                        }
                    });
                }

                @Override
                public Boolean forVariableType(final VariableType subT) {
                    Thunk<Boolean> checkUpperBound = new Thunk<Boolean>(){

                        @Override
                        public Boolean value() {
                            Type bound = (Type)new Normalizer(NormSubtyper.this).value(subT.symbol().upperBound());
                            return NormSubtyper.this.contains(bound, superT);
                        }
                    };
                    Thunk<Boolean> checkInfinite = new Thunk<Boolean>(){

                        @Override
                        public Boolean value() {
                            return NormSubtyper.this.contains(TypeSystem.OBJECT, superT);
                        }
                    };
                    return NormSubtyper.this._stack.apply(checkUpperBound, checkInfinite, (Type)subT, superT);
                }

                @Override
                public Boolean forIntersectionType(IntersectionType subT) {
                    return IterUtil.or(subT.ofTypes(), NormSubtyper.this.subtypes(superT));
                }

                @Override
                public Boolean forUnionType(UnionType subT) {
                    return IterUtil.and(subT.ofTypes(), NormSubtyper.this.subtypes(superT));
                }

                @Override
                public Boolean forBottomType(BottomType subT) {
                    return true;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WellFormedChecker
    extends TypeAbstractVisitor<Boolean>
    implements Predicate<Type> {
        RecursionStack<Type> _stack = new RecursionStack();

        private WellFormedChecker() {
        }

        @Override
        public boolean contains(Type t) {
            return t.apply(this);
        }

        @Override
        public Boolean defaultCase(Type t) {
            return true;
        }

        @Override
        public Boolean forArrayType(ArrayType t) {
            return t.ofType().apply(this);
        }

        @Override
        public Boolean forSimpleClassType(SimpleClassType t) {
            return IterUtil.isEmpty(SymbolUtil.allTypeParameters(t.ofClass()));
        }

        @Override
        public Boolean forRawClassType(RawClassType t) {
            return !IterUtil.isEmpty(SymbolUtil.allTypeParameters(t.ofClass()));
        }

        @Override
        public Boolean forParameterizedClassType(ParameterizedClassType t) {
            Iterable<VariableType> params;
            Iterable<? extends Type> args = t.typeArguments();
            if (IterUtil.and(args, this) && IterUtil.sizeOf(params = SymbolUtil.allTypeParameters(t.ofClass())) == IterUtil.sizeOf(args)) {
                Iterable<Type> captArgs = ExtendedTypeSystem.this.captureTypeArgs(args, params);
                for (Pair pair : IterUtil.zip(args, captArgs)) {
                    if (pair.first() == pair.second() || ((Type)pair.second()).apply(this).booleanValue()) continue;
                    return false;
                }
                return ExtendedTypeSystem.this.inBounds(params, captArgs);
            }
            return false;
        }

        @Override
        public Boolean forBoundType(BoundType t) {
            return IterUtil.and(t.ofTypes(), this);
        }

        @Override
        public Boolean forVariableType(final VariableType t) {
            Thunk<Boolean> checkVar = new Thunk<Boolean>(){

                @Override
                public Boolean value() {
                    return WellFormedChecker.this.checkBoundedSymbol(t.symbol());
                }
            };
            return this._stack.apply(checkVar, Boolean.valueOf(true), (Type)t);
        }

        @Override
        public Boolean forWildcard(Wildcard w) {
            return this.checkBoundedSymbol(w.symbol());
        }

        private boolean checkBoundedSymbol(BoundedSymbol s) {
            Type lower = s.lowerBound();
            Type upper = s.upperBound();
            return lower.apply(this) != false && upper.apply(this) != false && ExtendedTypeSystem.this.isSubtype(lower, upper);
        }
    }
}

