/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.sourcechecker;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.CheckerException;
import edu.rice.cs.dynamicjava.interpreter.ClassChecker;
import edu.rice.cs.dynamicjava.interpreter.CompositeException;
import edu.rice.cs.dynamicjava.interpreter.InternalException;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.dynamicjava.interpreter.LibraryContext;
import edu.rice.cs.dynamicjava.interpreter.ParserException;
import edu.rice.cs.dynamicjava.interpreter.TopLevelContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.sourcechecker.CompilationUnitChecker;
import edu.rice.cs.dynamicjava.sourcechecker.SourceException;
import edu.rice.cs.dynamicjava.symbol.ExtendedTypeSystem;
import edu.rice.cs.dynamicjava.symbol.JLSTypeSystem;
import edu.rice.cs.dynamicjava.symbol.Library;
import edu.rice.cs.dynamicjava.symbol.StandardTypeSystem;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TreeLibrary;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.collect.UnindexedRelation;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.CollapsedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.text.ArgumentParser;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.parser.wrapper.JavaCCParser;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.tree.CompilationUnit;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceChecker {
    private final Options _opt;
    private final boolean _quiet;
    private int _statusCount;

    public SourceChecker(Options opt, boolean quiet) {
        this._opt = opt;
        this._quiet = quiet;
        this._statusCount = 0;
    }

    public void check(File ... sources) throws InterpreterException {
        this.check(IterUtil.asIterable(sources), IterUtil.empty());
    }

    public void check(Iterable<? extends File> sources) throws InterpreterException {
        this.check(sources, IterUtil.empty());
    }

    public void check(Iterable<? extends File> sources, Iterable<? extends File> classPath) throws InterpreterException {
        Iterable<CompilationUnit> tree = this.parse(sources);
        TypeContext context = this.makeContext(tree, classPath);
        Relation<TypeDeclaration, ClassChecker> decls = this.extractDeclarations(tree, context);
        this.initializeClassSignatures(decls);
        this.checkSignatures(decls);
        this.checkBodies(decls);
    }

    private Iterable<CompilationUnit> parse(Iterable<? extends File> sources) throws InterpreterException {
        final ArrayList<CompilationUnit> result = new ArrayList<CompilationUnit>();
        CollapsedIterable<File> files = IterUtil.collapse(IterUtil.map(sources, new Lambda<File, Iterable<File>>(){
            private final FileFilter _filter = IOUtil.extensionFilePredicate("java");

            @Override
            public Iterable<File> value(File f) {
                return IOUtil.listFilesRecursively(f, this._filter);
            }
        }));
        new Phase<File>("Parsing"){

            @Override
            protected void step(File source) throws InterpreterException {
                try {
                    JavaCCParser parser = new JavaCCParser(new FileReader(source), source, SourceChecker.this._opt);
                    result.add(parser.parseCompilationUnit());
                }
                catch (ParseError e) {
                    throw new ParserException(e);
                }
                catch (FileNotFoundException e) {
                    throw new SourceException(e);
                }
            }

            @Override
            protected SourceInfo location(File f) {
                return SourceInfo.point(f, 0, 0);
            }
        }.run(files);
        return result;
    }

    private TypeContext makeContext(Iterable<CompilationUnit> sources, Iterable<? extends File> cp) {
        Library classLib = SymbolUtil.classLibrary(new PathClassLoader(null, cp));
        DebugUtil.debug.logStart("creating TreeLibrary");
        TreeLibrary sourceLib = new TreeLibrary(sources, classLib.classLoader(), this._opt);
        DebugUtil.debug.logEnd("creating TreeLibrary");
        return new TopLevelContext(new LibraryContext(new LibraryContext(classLib), sourceLib));
    }

    private Relation<TypeDeclaration, ClassChecker> extractDeclarations(Iterable<CompilationUnit> sources, TypeContext context) throws InterpreterException {
        final CompilationUnitChecker unitChecker = new CompilationUnitChecker(context, this._opt);
        final UnindexedRelation<TypeDeclaration, ClassChecker> checkers = UnindexedRelation.makeLinkedHashBased();
        new Phase<CompilationUnit>("Resolving imports"){

            @Override
            protected void step(CompilationUnit u) throws InterpreterException {
                checkers.addAll(unitChecker.extractDeclarations(u));
            }

            @Override
            protected SourceInfo location(CompilationUnit arg) {
                return arg.getSourceInfo();
            }
        }.run(sources);
        return checkers;
    }

    private void initializeClassSignatures(Relation<TypeDeclaration, ClassChecker> decls) throws InterpreterException {
        new ClassCheckerPhase("Checking class signatures"){

            protected void step(TypeDeclaration ast, ClassChecker checker) {
                checker.initializeClassSignatures(ast);
            }
        }.run(decls);
    }

    private void checkSignatures(Relation<TypeDeclaration, ClassChecker> decls) throws InterpreterException {
        new ClassCheckerPhase("Checking class member signatures"){

            protected void step(TypeDeclaration ast, ClassChecker checker) {
                checker.checkSignatures(ast);
            }
        }.run(decls);
    }

    private void checkBodies(Relation<TypeDeclaration, ClassChecker> decls) throws InterpreterException {
        new ClassCheckerPhase("Checking class member bodies"){

            protected void step(TypeDeclaration ast, ClassChecker checker) {
                checker.checkBodies(ast);
            }
        }.run(decls);
    }

    private void startStatus(String description) {
        this._statusCount = 0;
        if (!this._quiet) {
            String fullDesc = TextUtil.padRight(description + "...", ' ', 36);
            System.out.print(fullDesc);
            System.out.flush();
        }
    }

    private void incrementStatus() {
        ++this._statusCount;
        if (!this._quiet && this._statusCount % 10 == 0) {
            System.out.print('*');
            System.out.flush();
        }
    }

    private void endStatus() {
        if (!this._quiet) {
            System.out.println();
        }
    }

    public static void main(String ... args) {
        ArgumentParser argParser = new ArgumentParser();
        argParser.supportOption("classpath", "");
        argParser.supportAlias("cp", "classpath");
        argParser.supportOption("jls", new String[0]);
        argParser.requireParams(1);
        ArgumentParser.Result parsedArgs = argParser.parse(args);
        final StandardTypeSystem ts = parsedArgs.hasOption("jls") ? JLSTypeSystem.INSTANCE : ExtendedTypeSystem.INSTANCE;
        Options opt = new Options(){

            public TypeSystem typeSystem() {
                return ts;
            }

            public boolean enforceAllAccess() {
                return true;
            }
        };
        SizedIterable<File> cp = IOUtil.parsePath(parsedArgs.getUnaryOption("classpath"));
        SizedIterable<File> sources = IterUtil.map(parsedArgs.params(), IOUtil.FILE_FACTORY);
        try {
            new SourceChecker(opt, false).check(sources, cp);
            System.out.println("Completed checking successfully.");
        }
        catch (InterpreterException e) {
            DebugUtil.debug.log(e);
            e.printUserMessage(new PrintWriter(System.out, true));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClassCheckerPhase
    extends Phase<Pair<TypeDeclaration, ClassChecker>> {
        protected ClassCheckerPhase(String description) {
            super(description);
        }

        @Override
        protected final void step(Pair<TypeDeclaration, ClassChecker> arg) throws InterpreterException {
            try {
                this.step(arg.first(), arg.second());
            }
            catch (ExecutionError e) {
                throw new CheckerException(e);
            }
        }

        @Override
        protected final SourceInfo location(Pair<TypeDeclaration, ClassChecker> arg) {
            return arg.first().getSourceInfo();
        }

        protected abstract void step(TypeDeclaration var1, ClassChecker var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Phase<T> {
        private final String _description;

        protected Phase(String description) {
            this._description = description;
        }

        protected abstract void step(T var1) throws InterpreterException;

        protected abstract SourceInfo location(T var1);

        public void run(Iterable<? extends T> args) throws InterpreterException {
            ArrayList<InterpreterException> errors = new ArrayList<InterpreterException>();
            DebugUtil.debug.logStart(this._description);
            SourceChecker.this.startStatus(this._description);
            for (T arg : args) {
                DebugUtil.debug.logStart("location", (Object)this.location(arg));
                try {
                    this.step(arg);
                }
                catch (InterpreterException e) {
                    errors.add(e);
                }
                catch (RuntimeException e) {
                    errors.add(new InternalException(e, this.location(arg)));
                }
                SourceChecker.this.incrementStatus();
                DebugUtil.debug.logEnd();
            }
            SourceChecker.this.endStatus();
            DebugUtil.debug.logEnd(this._description);
            if (!errors.isEmpty()) {
                throw CompositeException.make(errors);
            }
        }
    }
}

