/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.LibraryContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TopLevelAccessModule;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SequenceIterator;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelContext
extends DelegatingContext {
    private final TypeContext _next;
    private final String _currentPackage;
    private final Iterator<Integer> _anonymousCounter;
    private final HashSet<String> _onDemandPackages;
    private final HashSet<DJClass> _onDemandClasses;
    private final HashSet<DJClass> _staticOnDemandClasses;
    private final HashMap<String, DJClass> _importedTopLevelClasses;
    private final HashMap<String, DJClass> _importedMemberClasses;
    private final HashMap<String, DJClass> _importedFields;
    private final HashMap<String, DJClass> _importedMethods;

    public TopLevelContext(ClassLoader loader) {
        this(new LibraryContext(SymbolUtil.classLibrary(loader)));
    }

    public TopLevelContext(TypeContext next) {
        super(next);
        this._next = next;
        this._currentPackage = "";
        this._anonymousCounter = new SequenceIterator<Integer>(1, LambdaUtil.INCREMENT_INT);
        this._onDemandPackages = new HashSet();
        this._onDemandClasses = new HashSet();
        this._staticOnDemandClasses = new HashSet();
        this._importedTopLevelClasses = new HashMap();
        this._importedMemberClasses = new HashMap();
        this._importedFields = new HashMap();
        this._importedMethods = new HashMap();
        this._onDemandPackages.add("java.lang");
    }

    private TopLevelContext(TopLevelContext copy) {
        this(copy._next, copy._currentPackage, copy);
    }

    private TopLevelContext(TypeContext next, String currentPackage, TopLevelContext bindings) {
        super(next);
        this._next = next;
        this._currentPackage = currentPackage;
        this._anonymousCounter = bindings._anonymousCounter;
        this._onDemandPackages = (HashSet)bindings._onDemandPackages.clone();
        this._onDemandClasses = (HashSet)bindings._onDemandClasses.clone();
        this._staticOnDemandClasses = (HashSet)bindings._staticOnDemandClasses.clone();
        this._importedTopLevelClasses = (HashMap)bindings._importedTopLevelClasses.clone();
        this._importedMemberClasses = (HashMap)bindings._importedMemberClasses.clone();
        this._importedFields = (HashMap)bindings._importedFields.clone();
        this._importedMethods = (HashMap)bindings._importedMethods.clone();
    }

    @Override
    protected TypeContext duplicate(TypeContext next) {
        return new TopLevelContext(next, this._currentPackage, this);
    }

    @Override
    public TypeContext setPackage(String name) {
        return new TopLevelContext(this._next, name, this);
    }

    @Override
    public TypeContext importTopLevelClasses(String pkg) {
        TopLevelContext result = new TopLevelContext(this);
        result._onDemandPackages.add(pkg);
        return result;
    }

    @Override
    public TypeContext importMemberClasses(DJClass outer) {
        TopLevelContext result = new TopLevelContext(this);
        result._onDemandClasses.add(outer);
        return result;
    }

    @Override
    public TypeContext importStaticMembers(DJClass c) {
        TopLevelContext result = new TopLevelContext(this);
        result._staticOnDemandClasses.add(c);
        return result;
    }

    @Override
    public TypeContext importTopLevelClass(DJClass c) {
        TopLevelContext result = new TopLevelContext(this);
        String name = c.declaredName();
        result._importedMemberClasses.remove(name);
        result._importedTopLevelClasses.put(name, c);
        return result;
    }

    @Override
    public TypeContext importMemberClass(DJClass outer, String name) {
        TopLevelContext result = new TopLevelContext(this);
        result._importedTopLevelClasses.remove(name);
        result._importedMemberClasses.put(name, outer);
        return result;
    }

    @Override
    public TypeContext importField(DJClass c, String name) {
        TopLevelContext result = new TopLevelContext(this);
        result._importedFields.put(name, c);
        return result;
    }

    @Override
    public TypeContext importMethod(DJClass c, String name) {
        TopLevelContext result = new TopLevelContext(this);
        result._importedMethods.put(name, c);
        return result;
    }

    @Override
    public boolean typeExists(String name, TypeSystem ts) {
        return this.topLevelClassExists(name, ts) || this.memberClassExists(name, ts) || super.typeVariableExists(name, ts);
    }

    @Override
    public boolean topLevelClassExists(String name, TypeSystem ts) {
        try {
            return this.getTopLevelClass(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        if (TextUtil.contains(name, 46)) {
            return super.getTopLevelClass(name, ts);
        }
        DJClass result = this._importedTopLevelClasses.get(name);
        if (result == null && (result = super.getTopLevelClass(this.makeClassName(name), ts)) == null) {
            LinkedList<String> onDemandNames = new LinkedList<String>();
            for (String p : this._onDemandPackages) {
                String fullName = p + "." + name;
                if (!super.topLevelClassExists(fullName, ts)) continue;
                onDemandNames.add(fullName);
            }
            if (onDemandNames.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandNames.size() == 1) {
                result = super.getTopLevelClass((String)onDemandNames.get(0), ts);
            }
        }
        return result;
    }

    @Override
    public boolean memberClassExists(String name, TypeSystem ts) {
        try {
            return this.typeContainingMemberClass(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedMemberClasses.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            ClassType t;
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._onDemandClasses) {
                t = ts.makeClassType(c);
                if (!ts.containsClass(t, name)) continue;
                onDemandMatches.add(t);
            }
            for (DJClass c : this._staticOnDemandClasses) {
                t = ts.makeClassType(c);
                if (!ts.containsStaticClass(t, name)) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
            if (result == null) {
                result = super.typeContainingMemberClass(name, ts);
            }
        }
        return result;
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.fieldExists(name, ts) || super.localVariableExists(name, ts);
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        try {
            return this.typeContainingField(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedFields.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._staticOnDemandClasses) {
                ClassType t = ts.makeClassType(c);
                if (!ts.containsStaticField(t, name)) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
            if (result == null) {
                result = super.typeContainingField(name, ts);
            }
        }
        return result;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.methodExists(name, ts) || super.localFunctionExists(name, ts);
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        try {
            return this.typeContainingMethod(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    @Override
    public ClassType typeContainingMethod(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedMethods.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._staticOnDemandClasses) {
                ClassType t = ts.makeClassType(c);
                if (!ts.containsStaticMethod(t, name)) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
            if (result == null) {
                result = super.typeContainingMethod(name, ts);
            }
        }
        return result;
    }

    @Override
    public Access.Module accessModule() {
        return new TopLevelAccessModule(this._currentPackage);
    }

    @Override
    public String makeClassName(String n) {
        return this._currentPackage.equals("") ? n : this._currentPackage + "." + n;
    }

    @Override
    public String makeAnonymousClassName() {
        return this.makeClassName("$" + this._anonymousCounter.next().toString());
    }

    @Override
    public DJClass getThis() {
        return null;
    }

    @Override
    public DJClass getThis(String className) {
        return null;
    }

    @Override
    public Type getReturnType() {
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return IterUtil.singleton(TypeSystem.THROWABLE);
    }
}

