/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.ClassChecker;
import edu.rice.cs.dynamicjava.interpreter.ExpressionChecker;
import edu.rice.cs.dynamicjava.interpreter.FunctionContext;
import edu.rice.cs.dynamicjava.interpreter.FunctionSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.LocalContext;
import edu.rice.cs.dynamicjava.interpreter.TreeClassLoader;
import edu.rice.cs.dynamicjava.interpreter.TryBlockContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.interpreter.TypeNameChecker;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.TreeClass;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.BooleanType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.IntegralType;
import edu.rice.cs.dynamicjava.symbol.type.LongType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VoidType;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.HashSet;
import java.util.LinkedList;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeUtil;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionStatement;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.ModifierSet;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.tiger.PolymorphicMethodDeclaration;
import koala.dynamicjava.tree.tiger.TypeParameter;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementChecker
extends AbstractVisitor<TypeContext>
implements Lambda<Node, TypeContext> {
    private final TypeContext context;
    private final Options opt;
    private final TypeSystem ts;

    public StatementChecker(TypeContext ctx, Options options) {
        this.context = ctx;
        this.opt = options;
        this.ts = this.opt.typeSystem();
    }

    @Override
    public TypeContext value(Node n) {
        return n.acceptVisitor(this);
    }

    private Type checkType(Expression exp) {
        return new ExpressionChecker(this.context, this.opt).check(exp);
    }

    private TypeContext checkList(Iterable<? extends Node> l) {
        TypeContext c = this.context;
        for (Node node : l) {
            c = node.acceptVisitor(new StatementChecker(c, this.opt));
        }
        return c;
    }

    private Type checkType(Expression exp, Type expected) {
        return new ExpressionChecker(this.context, this.opt).check(exp, expected);
    }

    private Iterable<Type> checkTypes(Iterable<? extends Expression> l) {
        return new ExpressionChecker(this.context, this.opt).checkList(l);
    }

    private Type checkTypeName(TypeName t) {
        return new TypeNameChecker(this.context, this.opt).check(t);
    }

    @Override
    public TypeContext visit(PackageDeclaration node) {
        return this.context.setPackage(node.getName());
    }

    @Override
    public TypeContext visit(ImportDeclaration node) {
        ClassType t;
        if (node.isStatic()) {
            if (node.isPackage()) {
                ClassType t2 = this.resolveClassName(node.getName(), node);
                if (t2 == null) {
                    NodeProperties.setErrorStrings(node, node.getName());
                    throw new ExecutionError("undefined.class", node);
                }
                return this.context.importStaticMembers(t2.ofClass());
            }
            Pair<String, String> split = this.splitName(node.getName());
            if (split.first() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("undefined.name", node);
            }
            ClassType t3 = this.resolveClassName(split.first(), node);
            if (t3 == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("undefined.class", node);
            }
            String member = split.second();
            TypeContext result = this.context;
            if (this.ts.containsStaticField(t3, member)) {
                result = result.importField(t3.ofClass(), member);
            }
            if (this.ts.containsStaticMethod(t3, member)) {
                result = result.importMethod(t3.ofClass(), member);
            }
            if (this.ts.containsStaticClass(t3, member)) {
                result = result.importMemberClass(t3.ofClass(), member);
            }
            if (result == this.context) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("undefined.name", node);
            }
            return result;
        }
        if (node.isPackage()) {
            ClassType t4 = this.resolveClassName(node.getName(), node);
            if (t4 == null) {
                return this.context.importTopLevelClasses(node.getName());
            }
            return this.context.importMemberClasses(t4.ofClass());
        }
        Pair<String, String> split = this.splitName(node.getName());
        if (split.first() != null && (t = this.resolveClassName(split.first(), node)) != null) {
            if (this.ts.containsClass(t, split.second())) {
                return this.context.importMemberClass(t.ofClass(), split.second());
            }
            NodeProperties.setErrorStrings(node, split.second());
            throw new ExecutionError("undefined.class", node);
        }
        try {
            DJClass c = this.context.getTopLevelClass(node.getName(), this.ts);
            if (c == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("undefined.class", node);
            }
            return this.context.importTopLevelClass(c);
        }
        catch (AmbiguousNameException e) {
            throw new ExecutionError("ambiguous.name", node);
        }
    }

    private ClassType resolveClassName(String name, Node node) {
        String topLevelName = "";
        ClassType result = null;
        boolean first = true;
        for (String piece : name.split("\\.")) {
            if (result == null) {
                if (!first) {
                    topLevelName = topLevelName + ".";
                }
                first = false;
                topLevelName = topLevelName + piece;
                try {
                    DJClass c = this.context.getTopLevelClass(topLevelName, this.ts);
                    result = c == null ? null : this.ts.makeClassType(c);
                    continue;
                }
                catch (AmbiguousNameException e) {
                    throw new ExecutionError("ambiguous.name", node);
                }
            }
            try {
                result = this.ts.lookupClass(result, piece, IterUtil.empty());
            }
            catch (TypeSystem.InvalidTargetException e) {
                throw new RuntimeException("unexpected bad type");
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new RuntimeException("can't create raw type");
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                if (this.ts.containsClass(result, piece)) {
                    throw new ExecutionError("ambiguous.name", node);
                }
                NodeProperties.setErrorStrings(node, piece);
                throw new ExecutionError("undefined.class", node);
            }
        }
        return result;
    }

    private Pair<String, String> splitName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return Pair.make(null, name);
        }
        return Pair.make(name.substring(0, dot), name.substring(dot + 1));
    }

    @Override
    public TypeContext visit(VariableDeclaration node) {
        if (node.getType() == null) {
            Type initT = this.checkType(node.getInitializer());
            LocalVariable v = new LocalVariable(node.getName(), initT, node.getModifiers().isFinal());
            NodeProperties.setVariable(node, v);
            NodeProperties.setErasedType(node, this.ts.erasedClass(initT));
            return new LocalContext(this.context, v);
        }
        Type t = this.checkTypeName(node.getType());
        LocalVariable v = new LocalVariable(node.getName(), t, node.getModifiers().isFinal());
        NodeProperties.setVariable(node, v);
        NodeProperties.setErasedType(node, this.ts.erasedClass(t));
        LocalContext newContext = new LocalContext(this.context, v);
        if (node.getInitializer() != null) {
            Type initT = this.checkType(node.getInitializer(), t);
            try {
                Expression newInit = this.ts.assign(t, node.getInitializer());
                node.setInitializer(newInit);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                NodeProperties.setErrorStrings(node, this.ts.userRepresentation(initT), this.ts.userRepresentation(t));
                throw new ExecutionError("assignment.types", node);
            }
        }
        return newContext;
    }

    @Override
    public TypeContext visit(ClassDeclaration node) {
        return this.handleTypeDeclaration(node);
    }

    @Override
    public TypeContext visit(InterfaceDeclaration node) {
        return this.handleTypeDeclaration(node);
    }

    private TypeContext handleTypeDeclaration(TypeDeclaration node) {
        TreeClassLoader loader = new TreeClassLoader(this.context.getClassLoader(), this.opt);
        TreeClass c = new TreeClass(this.context.makeClassName(node.getName()), null, this.context.accessModule(), node, loader, this.opt);
        NodeProperties.setDJClass(node, c);
        ClassChecker classChecker = new ClassChecker(c, loader, this.context, this.opt);
        classChecker.initializeClassSignatures(node);
        classChecker.checkSignatures(node);
        classChecker.checkBodies(node);
        return new LocalContext(this.context, loader, c);
    }

    @Override
    public TypeContext visit(MethodDeclaration node) {
        LocalFunction f = new LocalFunction(node);
        FunctionSignatureContext sigContext = new FunctionSignatureContext(this.context, f);
        TypeNameChecker sigChecker = new TypeNameChecker(sigContext, this.opt);
        TypeParameter[] tparams = node instanceof PolymorphicMethodDeclaration ? ((PolymorphicMethodDeclaration)node).getTypeParameters() : new TypeParameter[]{};
        sigChecker.checkTypeParameters(tparams);
        Type returnT = sigChecker.check(node.getReturnType());
        NodeProperties.setErasedType(node, this.ts.erasedClass(returnT));
        for (FormalParameter formalParameter : node.getParameters()) {
            Type t = sigChecker.check(formalParameter.getType());
            NodeProperties.setVariable(formalParameter, new LocalVariable(formalParameter.getName(), t, formalParameter.getModifiers().isFinal()));
        }
        for (ReferenceTypeName referenceTypeName : node.getExceptions()) {
            sigChecker.check(referenceTypeName);
        }
        if (node.getBody() == null) {
            NodeProperties.setErrorStrings(node, node.getName());
            throw new ExecutionError("missing.method.body", node);
        }
        FunctionContext bodyContext = new FunctionContext(sigContext, f);
        node.getBody().acceptVisitor(new StatementChecker(bodyContext, this.opt));
        return new LocalContext(this.context, f);
    }

    @Override
    public TypeContext visit(WhileStatement node) {
        this.checkType(node.getCondition());
        try {
            Expression exp = this.ts.makePrimitive(node.getCondition());
            if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                throw new ExecutionError("condition.type", node);
            }
            node.setCondition(exp);
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            throw new ExecutionError("condition.type", node);
        }
        node.getBody().acceptVisitor(this);
        return this.context;
    }

    @Override
    public TypeContext visit(DoStatement node) {
        node.getBody().acceptVisitor(this);
        this.checkType(node.getCondition());
        try {
            Expression exp = this.ts.makePrimitive(node.getCondition());
            if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                throw new ExecutionError("condition.type", node);
            }
            node.setCondition(exp);
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            throw new ExecutionError("condition.type", node);
        }
        return this.context;
    }

    @Override
    public TypeContext visit(ForStatement node) {
        TypeContext newContext = this.context;
        if (node.getInitialization() != null) {
            newContext = this.checkList(node.getInitialization());
        }
        StatementChecker checker = new StatementChecker(newContext, this.opt);
        if (node.getCondition() != null) {
            checker.checkType(node.getCondition());
            try {
                Expression exp = this.ts.makePrimitive(node.getCondition());
                if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                    throw new ExecutionError("condition.type", node);
                }
                node.setCondition(exp);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("condition.type", node);
            }
        }
        if (node.getUpdate() != null) {
            checker.checkList(node.getUpdate());
        }
        node.getBody().acceptVisitor(checker);
        return this.context;
    }

    @Override
    public TypeContext visit(ForEachStatement node) {
        LocalContext newContext;
        block7: {
            FormalParameter p = node.getParameter();
            Type paramT = this.checkTypeName(p.getType());
            LocalVariable var = NodeProperties.setVariable(p, new LocalVariable(p.getName(), paramT, p.getModifiers().isFinal()));
            newContext = new LocalContext(this.context, var);
            Type collType = this.checkType(node.getCollection());
            if (this.ts.isArray(collType)) {
                Type elementType = this.ts.arrayElementType(collType);
                if (!this.ts.isAssignable(paramT, elementType)) {
                    NodeProperties.setErrorStrings(node, this.ts.userRepresentation(elementType), this.ts.userRepresentation(paramT));
                    throw new ExecutionError("assignment.types", node);
                }
            } else {
                if (this.ts.isIterable(collType)) {
                    try {
                        TypeSystem.ObjectMethodInvocation iteratorInv = this.ts.lookupMethod(node.getCollection(), "iterator", IterUtil.empty(), IterUtil.empty(), Option.<Type>none());
                        Expression getIterator = TypeUtil.makeEmptyExpression(node.getCollection());
                        NodeProperties.setType(getIterator, iteratorInv.returnType());
                        TypeSystem.ObjectMethodInvocation nextInv = this.ts.lookupMethod(getIterator, "next", IterUtil.empty(), IterUtil.empty(), Option.<Type>none());
                        if (!this.ts.isAssignable(paramT, nextInv.returnType())) {
                            NodeProperties.setErrorStrings(node, this.ts.userRepresentation(nextInv.returnType()), this.ts.userRepresentation(paramT));
                            throw new ExecutionError("assignment.types", node);
                        }
                        break block7;
                    }
                    catch (TypeSystem.TypeSystemException e) {
                        throw new RuntimeException("ts.isIterable() lied");
                    }
                }
                throw new ExecutionError("iterable.type", node);
            }
        }
        node.getBody().acceptVisitor(new StatementChecker(newContext, this.opt));
        return this.context;
    }

    @Override
    public TypeContext visit(IfThenStatement node) {
        this.checkType(node.getCondition());
        try {
            Expression exp = this.ts.makePrimitive(node.getCondition());
            if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                throw new ExecutionError("condition.type", node);
            }
            node.setCondition(exp);
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            throw new ExecutionError("condition.type", node);
        }
        node.getThenStatement().acceptVisitor(this);
        return this.context;
    }

    @Override
    public TypeContext visit(IfThenElseStatement node) {
        this.checkType(node.getCondition());
        try {
            Expression exp = this.ts.makePrimitive(node.getCondition());
            if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                throw new ExecutionError("condition.type", node);
            }
            node.setCondition(exp);
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            throw new ExecutionError("condition.type", node);
        }
        node.getThenStatement().acceptVisitor(this);
        node.getElseStatement().acceptVisitor(this);
        return this.context;
    }

    @Override
    public TypeContext visit(SwitchStatement node) {
        Type t = this.checkType(node.getSelector());
        if (!this.ts.isEnum(t)) {
            try {
                Expression exp = this.ts.makePrimitive(node.getSelector());
                if (!(NodeProperties.getType(exp) instanceof IntegralType) || NodeProperties.getType(exp) instanceof LongType) {
                    NodeProperties.setErrorStrings(node, this.ts.userRepresentation(t));
                    throw new ExecutionError("selector.type", node);
                }
                node.setSelector(exp);
                t = NodeProperties.getType(exp);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("selector.type", node);
            }
        }
        HashSet<Object> values = new HashSet<Object>();
        boolean hasDefault = false;
        for (SwitchBlock bk : node.getBindings()) {
            bk.acceptVisitor(this);
            if (bk.getExpression() == null) {
                if (hasDefault) {
                    throw new ExecutionError("duplicate.switch.case", node);
                }
                hasDefault = true;
                continue;
            }
            Expression exp = bk.getExpression();
            if (!NodeProperties.hasValue(exp) || NodeProperties.getValue(exp) == null) {
                throw new ExecutionError("invalid.constant", exp);
            }
            if (!this.ts.isAssignable(t, NodeProperties.getType(exp), NodeProperties.getValue(exp))) {
                NodeProperties.setErrorStrings(node, this.ts.userRepresentation(NodeProperties.getType(exp)));
                throw new ExecutionError("switch.label.type", exp);
            }
            if (values.contains(NodeProperties.getValue(exp))) {
                throw new ExecutionError("duplicate.switch.case", node);
            }
            values.add(NodeProperties.getValue(exp));
        }
        return this.context;
    }

    @Override
    public TypeContext visit(SwitchBlock node) {
        if (node.getExpression() != null) {
            this.checkType(node.getExpression());
        }
        if (node.getStatements() != null) {
            this.checkList(node.getStatements());
        }
        return this.context;
    }

    @Override
    public TypeContext visit(LabeledStatement node) {
        return node.getStatement().acceptVisitor(this);
    }

    @Override
    public TypeContext visit(TryStatement node) {
        LinkedList<Type> caughtTypes = new LinkedList<Type>();
        for (CatchStatement c : node.getCatchStatements()) {
            FormalParameter p = c.getException();
            Type caughtT = this.checkTypeName(p.getType());
            if (!this.ts.isAssignable(TypeSystem.THROWABLE, caughtT)) {
                NodeProperties.setErrorStrings(c, this.ts.userRepresentation(caughtT));
                throw new ExecutionError("catch.type", c);
            }
            if (!this.ts.isReifiable(caughtT)) {
                throw new ExecutionError("reifiable.type", c);
            }
            NodeProperties.setVariable(p, new LocalVariable(p.getName(), caughtT, p.getModifiers().isFinal()));
            NodeProperties.setErasedType(c, this.ts.erasedClass(caughtT));
            caughtTypes.add(caughtT);
        }
        TryBlockContext tryContext = new TryBlockContext(this.context, caughtTypes);
        node.getTryBlock().acceptVisitor(new StatementChecker(tryContext, this.opt));
        for (CatchStatement c : node.getCatchStatements()) {
            LocalContext catchContext = new LocalContext(this.context, NodeProperties.getVariable(c.getException()));
            c.getBlock().acceptVisitor(new StatementChecker(catchContext, this.opt));
        }
        if (node.getFinallyBlock() != null) {
            node.getFinallyBlock().acceptVisitor(this);
        }
        return this.context;
    }

    @Override
    public TypeContext visit(ThrowStatement node) {
        Type thrown = this.checkType(node.getExpression());
        if (!this.ts.isAssignable(TypeSystem.THROWABLE, thrown)) {
            NodeProperties.setErrorStrings(node, this.ts.userRepresentation(thrown));
            throw new ExecutionError("throw.type", node);
        }
        if (this.ts.isAssignable(TypeSystem.EXCEPTION, thrown)) {
            boolean valid = false;
            ComposedIterable<Type> allowed = IterUtil.compose(TypeSystem.RUNTIME_EXCEPTION, this.context.getDeclaredThrownTypes());
            for (Type t : allowed) {
                if (!this.ts.isAssignable(t, thrown)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                NodeProperties.setErrorStrings(node, this.ts.userRepresentation(thrown));
                throw new ExecutionError("uncaught.exception", node);
            }
        }
        return this.context;
    }

    @Override
    public TypeContext visit(ReturnStatement node) {
        Type expected = this.context.getReturnType();
        if (expected == null) {
            throw new ExecutionError("return.not.allowed", node);
        }
        if (node.getExpression() == null) {
            if (!expected.equals(TypeSystem.VOID)) {
                NodeProperties.setErrorStrings(node, this.ts.userRepresentation(TypeSystem.VOID), this.ts.userRepresentation(expected));
                throw new ExecutionError("return.type", node);
            }
        } else {
            this.checkType(node.getExpression(), expected);
            try {
                Expression newExp = this.ts.assign(expected, node.getExpression());
                node.setExpression(newExp);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                NodeProperties.setErrorStrings(node, this.ts.userRepresentation(NodeProperties.getType(node.getExpression())), this.ts.userRepresentation(expected));
                throw new ExecutionError("return.type", node);
            }
        }
        return this.context;
    }

    @Override
    public TypeContext visit(AssertStatement node) {
        Type failType;
        this.checkType(node.getCondition());
        try {
            Expression exp = this.ts.makePrimitive(node.getCondition());
            if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                throw new ExecutionError("condition.type", node);
            }
            node.setCondition(exp);
        }
        catch (TypeSystem.UnsupportedConversionException e) {
            throw new ExecutionError("condition.type", node);
        }
        if (node.getFailString() != null && (failType = this.checkType(node.getFailString())) instanceof VoidType) {
            throw new ExecutionError("assertion.fail.type", node);
        }
        return this.context;
    }

    @Override
    public TypeContext visit(SynchronizedStatement node) {
        Type lockT = this.checkType(node.getLock());
        if (!this.ts.isReference(lockT)) {
            throw new ExecutionError("lock.type", node);
        }
        node.getBody().acceptVisitor(this);
        return this.context;
    }

    @Override
    public TypeContext visit(BlockStatement node) {
        this.checkList(node.getStatements());
        return this.context;
    }

    @Override
    public TypeContext visit(EmptyStatement node) {
        return this.context;
    }

    @Override
    public TypeContext visit(BreakStatement node) {
        return this.context;
    }

    @Override
    public TypeContext visit(ContinueStatement node) {
        return this.context;
    }

    @Override
    public TypeContext visit(ExpressionStatement node) {
        String name;
        AmbiguousName ambigName;
        SimpleAssignExpression assign;
        if (node.getExpression() instanceof SimpleAssignExpression && !this.opt.requireVariableType() && (node.getHasSemicolon() || !this.opt.requireSemicolon()) && (assign = (SimpleAssignExpression)node.getExpression()).getLeftExpression() instanceof AmbiguousName && (ambigName = (AmbiguousName)assign.getLeftExpression()).getIdentifiers().size() == 1 && !this.context.variableExists(name = ambigName.getRepresentation(), this.opt.typeSystem())) {
            VariableDeclaration decl = new VariableDeclaration(ModifierSet.make(), null, name, assign.getRightExpression(), node.getSourceInfo());
            NodeProperties.setStatementTranslation(node, decl);
            return ((Node)decl).acceptVisitor(this);
        }
        this.checkType(node.getExpression());
        return this.context;
    }
}

