/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.BaseContext;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.Library;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.plt.iter.IterUtil;

public class LibraryContext
extends DelegatingContext {
    private final Library _library;

    public LibraryContext(TypeContext next, Library lib) {
        super(next);
        this._library = lib;
    }

    public LibraryContext(Library lib) {
        this(BaseContext.INSTANCE, lib);
    }

    protected TypeContext duplicate(TypeContext next) {
        return new LibraryContext(next, this._library);
    }

    public boolean typeExists(String name, TypeSystem ts) {
        return !IterUtil.isEmpty(this._library.declaredClasses(name)) || super.typeExists(name, ts);
    }

    public boolean topLevelClassExists(String name, TypeSystem ts) {
        return !IterUtil.isEmpty(this._library.declaredClasses(name)) || super.topLevelClassExists(name, ts);
    }

    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        Iterable<DJClass> matches = this._library.declaredClasses(name);
        int size = IterUtil.sizeOf(matches, 2);
        switch (size) {
            case 0: {
                return super.getTopLevelClass(name, ts);
            }
            case 1: {
                return IterUtil.first(matches);
            }
        }
        throw new AmbiguousNameException();
    }

    public ClassLoader getClassLoader() {
        return this._library.classLoader();
    }
}

