/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ForcedChoiceOption;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForcedChoiceOptionComponent
extends OptionComponent<String> {
    private volatile JComboBox _comboBox;

    public ForcedChoiceOptionComponent(ForcedChoiceOption option, String labelText, SwingFrame parent) {
        super(option, labelText, parent);
        Iterator<String> values = option.getLegalValues();
        this._comboBox = new JComboBox();
        this._comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ForcedChoiceOptionComponent.this.notifyChangeListeners();
            }
        });
        while (values.hasNext()) {
            String currValue = values.next();
            this._comboBox.addItem(currValue);
        }
        this.resetToCurrent((String)DrJava.getConfig().getSetting(this._option));
    }

    public ForcedChoiceOptionComponent(ForcedChoiceOption option, String labelText, SwingFrame parent, String description) {
        this(option, labelText, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._comboBox.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    public void resetToCurrent(String current) {
        this._comboBox.setSelectedItem(current);
    }

    @Override
    public JComponent getComponent() {
        return this._comboBox;
    }

    @Override
    public boolean updateConfig() {
        String oldValue = (String)DrJava.getConfig().getSetting(this._option);
        String newValue = this._comboBox.getSelectedItem().toString();
        if (!newValue.equals(oldValue)) {
            DrJava.getConfig().setSetting(this._option, newValue);
        }
        return true;
    }

    public String getCurrentComboBoxValue() {
        return this._comboBox.getSelectedItem().toString();
    }

    @Override
    public void setValue(String value) {
        this.resetToCurrent(value);
    }
}

