/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegionsTreePanel<R extends OrderedDocumentRegion>
extends TabbedPanel {
    protected JPanel _leftPane;
    protected DefaultMutableTreeNode _rootNode;
    protected DefaultTreeModel _regTreeModel;
    public JTree _regTree;
    protected String _title;
    protected RegionManager<R> _regionManager;
    protected JPopupMenu _regionPopupMenu;
    protected final SingleDisplayModel _model;
    protected final MainFrame _frame;
    protected JPanel _buttonPanel;
    protected DefaultTreeCellRenderer dtcr;
    protected final IChangeState DEFAULT_STATE;
    protected IChangeState _changeState;
    protected volatile HashMap<OpenDefinitionsDocument, DefaultMutableTreeNode> _docToTreeNode;
    protected volatile IdentityHashMap<R, DefaultMutableTreeNode> _regionToTreeNode;

    public RegionsTreePanel(MainFrame frame, String title, RegionManager<R> regionManager) {
        super(frame, title);
        this._changeState = this.DEFAULT_STATE = new DefaultState();
        this._docToTreeNode = new HashMap();
        this._regionToTreeNode = new IdentityHashMap();
        this._title = title;
        this._regionManager = regionManager;
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._model = frame.getModel();
        this.removeAll();
        this._changeState = this.DEFAULT_STATE;
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        this._leftPane = new JPanel(new BorderLayout());
        this._setupRegionTree();
        this.add((Component)this._leftPane, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        this._setupButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this.updateButtons();
        RegionsTreePanel._setColors(this._regTree);
    }

    private static void _setColors(Component c) {
        new ForegroundColorListener(c);
        new BackgroundColorListener(c);
    }

    @Override
    protected void _close() {
        super._close();
        this.updateButtons();
    }

    @Override
    public boolean requestFocusInWindow() {
        assert (EventQueue.isDispatchThread());
        this.updatePanel();
        return super.requestFocusInWindow();
    }

    protected void updatePanel() {
        this._regTreeModel.reload();
        this.expandTree();
        this.repaint();
    }

    protected boolean _requestFocusInWindow() {
        this.updatePanel();
        this.updateButtons();
        return super.requestFocusInWindow();
    }

    private void _setupRegionTree() {
        this._rootNode = new DefaultMutableTreeNode(this._title);
        this._regTreeModel = new DefaultTreeModel(this._rootNode);
        this._regTree = new RegionTree(this._regTreeModel);
        this._regTree.setEditable(false);
        this._regTree.getSelectionModel().setSelectionMode(4);
        this._regTree.setShowsRootHandles(true);
        this._regTree.setRootVisible(false);
        this._regTree.putClientProperty("JTree.lineStyle", "Angled");
        this._regTree.setScrollsOnExpand(true);
        this._regTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                RegionsTreePanel.this.updateButtons();
            }
        });
        this._regTree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RegionsTreePanel.this.performDefaultAction();
                }
            }
        });
        this.dtcr = new RegionRenderer();
        this.dtcr.setOpaque(false);
        this._regTree.setCellRenderer(this.dtcr);
        this._leftPane.add(new JScrollPane(this._regTree));
        this._initPopup();
        ToolTipManager.sharedInstance().registerComponent(this._regTree);
    }

    protected void updateButtons() {
        this._updateButtons();
    }

    protected void _updateButtons() {
    }

    public void expandAll() {
        TreeNode root = (TreeNode)this._regTree.getModel().getRoot();
        this.expandRecursive(this._regTree, new TreePath(root), true);
    }

    public void collapseAll() {
        TreeNode root = (TreeNode)this._regTree.getModel().getRoot();
        this.expandRecursive(this._regTree, new TreePath(root), false);
    }

    protected void _remove() {
        int[] rows = this._regTree.getSelectionRows();
        int len = rows.length;
        int row = len > 0 ? rows[0] : 0;
        this._frame.removeCurrentLocationHighlight();
        for (OrderedDocumentRegion r : this.getSelectedRegions()) {
            this._regionManager.removeRegion(r);
        }
        int rowCount = this._regTree.getRowCount();
        if (rowCount == 0) {
            return;
        }
        if (row >= rowCount) {
            row = Math.max(0, rowCount - 1);
        }
        this._requestFocusInWindow();
        this._regTree.scrollRowToVisible(row);
        this._regTree.setSelectionRow(row);
        if (this._regTree.getLeadSelectionPath().getPathCount() < 2) {
            this._regTree.setSelectionRow(row + 1);
        }
    }

    private void expandRecursive(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandRecursive(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void performDefaultAction() {
    }

    protected JComponent[] makeButtons() {
        return new JComponent[0];
    }

    private void _setupButtonPanel() {
        JPanel mainButtons = new JPanel();
        JPanel emptyPanel = new JPanel();
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainButtons.setLayout(gbLayout);
        JComponent[] buts = this.makeButtons();
        closeButtonPanel.add((Component)this._closeButton, "North");
        for (JComponent b : buts) {
            mainButtons.add(b);
        }
        mainButtons.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        for (JComponent b : buts) {
            gbLayout.setConstraints(b, c);
        }
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        this._buttonPanel.add((Component)mainButtons, "Center");
        this._buttonPanel.add((Component)closeButtonPanel, "East");
    }

    protected AbstractAction[] makePopupMenuActions() {
        return null;
    }

    private void _initPopup() {
        this._regionPopupMenu = new JPopupMenu(this._title);
        AbstractAction[] acts = this.makePopupMenuActions();
        if (acts != null) {
            for (AbstractAction a : acts) {
                this._regionPopupMenu.add(a);
            }
            this._regTree.addMouseListener(new RegionMouseAdapter());
        }
    }

    DefaultMutableTreeNode getNode(OpenDefinitionsDocument doc) {
        return this._docToTreeNode.get(doc);
    }

    DefaultMutableTreeNode getNode(R region) {
        return this._regionToTreeNode.get(region);
    }

    protected ArrayList<R> getSelectedRegions() {
        ArrayList regs = new ArrayList();
        TreePath[] paths = this._regTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path == null || path.getPathCount() != 3) continue;
                DefaultMutableTreeNode lineNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object r = ((RegionTreeUserObj)lineNode.getUserObject()).region();
                regs.add(r);
            }
        }
        return regs;
    }

    protected void goToRegion() {
        ArrayList<R> r = this.getSelectedRegions();
        if (r.size() == 1) {
            this._frame.scrollToDocumentAndOffset(((OrderedDocumentRegion)r.get(0)).getDocument(), ((OrderedDocumentRegion)r.get(0)).getStartOffset(), false);
        }
    }

    public void addRegion(R r) {
        try {
            OpenDefinitionsDocument doc = r.getDocument();
            DefaultMutableTreeNode docNode = this._docToTreeNode.get(doc);
            if (docNode == null) {
                docNode = new DefaultMutableTreeNode(doc.getRawFile());
                this._regTreeModel.insertNodeInto(docNode, this._rootNode, this._rootNode.getChildCount());
                this._docToTreeNode.put(doc, docNode);
            }
            Enumeration<TreeNode> regionNodes = docNode.children();
            int startOffset = r.getStartOffset();
            int index = 0;
            while (true) {
                if (!regionNodes.hasMoreElements()) {
                    this.insertNewRegionNode(r, docNode, index);
                    break;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)regionNodes.nextElement();
                RegionTreeUserObj userObject = (RegionTreeUserObj)node.getUserObject();
                Object nodeRegion = userObject.region();
                int nodeOffset = nodeRegion.getStartOffset();
                if (nodeOffset >= startOffset) {
                    this.insertNewRegionNode(r, docNode, index);
                    break;
                }
                ++index;
            }
            this._changeState.updateButtons();
        }
        catch (Exception e) {
            DrJavaErrorHandler.record(e);
            throw new UnexpectedException(e);
        }
    }

    private void insertNewRegionNode(R r, DefaultMutableTreeNode docNode, int pos) {
        DefaultMutableTreeNode newRegionNode = new DefaultMutableTreeNode(this.makeRegionTreeUserObj(r));
        this._regTreeModel.insertNodeInto(newRegionNode, docNode, pos);
        this._regionToTreeNode.put(r, newRegionNode);
        this._changeState.scrollPathToVisible(new TreePath(newRegionNode.getPath()));
        this._changeState.setLastAdded(newRegionNode);
    }

    public void expandTree() {
        int ct = this._regTree.getRowCount();
        for (int i = ct - 1; i >= 0; --i) {
            this._regTree.expandRow(i);
        }
    }

    public void removeRegion(R r) {
        assert (EventQueue.isDispatchThread());
        this._changeState.setLastAdded(null);
        DefaultMutableTreeNode regionNode = this._regionToTreeNode.get(r);
        if (regionNode != null) {
            this._regionToTreeNode.remove(r);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)regionNode.getParent();
            this._regTreeModel.removeNodeFromParent(regionNode);
            if (parent.getChildCount() == 0) {
                OpenDefinitionsDocument doc = r.getDocument();
                this._docToTreeNode.remove(doc);
                this._regTreeModel.removeNodeFromParent(parent);
            }
        }
        this._changeState.updateButtons();
        this.closeIfEmpty();
    }

    protected void closeIfEmpty() {
        if (this._regionManager.getDocuments().isEmpty()) {
            this._close();
        }
    }

    public void reload(R startRegion, R endRegion) {
        OrderedDocumentRegion r;
        SortedSet<R> tail = this._regionManager.getTailSet(startRegion);
        Iterator iterator = tail.iterator();
        while (iterator.hasNext() && (r = (OrderedDocumentRegion)iterator.next()).compareTo(endRegion) <= 0) {
            this._regTreeModel.reload(this.getNode(r));
        }
    }

    protected RegionTreeUserObj<R> makeRegionTreeUserObj(R r) {
        return new RegionTreeUserObj<R>(r);
    }

    protected class DefaultState
    implements IChangeState {
        public void scrollPathToVisible(TreePath tp) {
            RegionsTreePanel.this._regTree.scrollPathToVisible(tp);
        }

        public void updateButtons() {
            RegionsTreePanel.this.updateButtons();
        }

        public void setLastAdded(DefaultMutableTreeNode node) {
        }

        public void switchStateTo(IChangeState newState) {
            RegionsTreePanel.this._changeState = newState;
        }

        protected DefaultState() {
        }
    }

    protected static interface IChangeState {
        public void scrollPathToVisible(TreePath var1);

        public void updateButtons();

        public void setLastAdded(DefaultMutableTreeNode var1);

        public void switchStateTo(IChangeState var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RegionTreeUserObj<R extends OrderedDocumentRegion> {
        protected R _region;

        public int lineNumber() {
            return this._region.getDocument().getLineOfOffset(this._region.getStartOffset()) + 1;
        }

        public R region() {
            return this._region;
        }

        public RegionTreeUserObj(R r) {
            this._region = r;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(120);
            sb.append("<html>");
            sb.append(this.lineNumber());
            sb.append(": ");
            String text = this._region.getString();
            int len = text.length();
            if (text.lastIndexOf(10) != len - 1) {
                sb.append(StringOps.flatten(text));
            } else {
                sb.append(text);
            }
            sb.append("</html>");
            return sb.toString();
        }
    }

    protected class RegionTree
    extends JTree {
        public RegionTree(DefaultTreeModel s) {
            super(s);
        }

        public void setForeground(Color c) {
            super.setForeground(c);
            if (RegionsTreePanel.this.dtcr != null) {
                RegionsTreePanel.this.dtcr.setTextNonSelectionColor(c);
            }
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            if (RegionsTreePanel.this != null && RegionsTreePanel.this.dtcr != null) {
                RegionsTreePanel.this.dtcr.setBackgroundNonSelectionColor(c);
            }
        }
    }

    protected class RegionMouseAdapter
    extends RightClickMouseAdapter {
        protected RegionMouseAdapter() {
        }

        protected void _popupAction(MouseEvent e) {
            int y;
            int x = e.getX();
            TreePath path = RegionsTreePanel.this._regTree.getPathForLocation(x, y = e.getY());
            if (path != null && path.getPathCount() == 3) {
                RegionsTreePanel.this._regTree.setSelectionRow(RegionsTreePanel.this._regTree.getRowForLocation(x, y));
                RegionsTreePanel.this._regionPopupMenu.show(e.getComponent(), x, y);
            }
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                RegionsTreePanel.this.performDefaultAction();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegionRenderer
    extends DefaultTreeCellRenderer {
        RegionRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object o;
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, leaf, row, hasFocus);
            Thunk<String> tooltip = null;
            if (DrJava.getConfig().getSetting(OptionConstants.SHOW_CODE_PREVIEW_POPUPS).booleanValue() && leaf && (o = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof RegionTreeUserObj) {
                tooltip = new Thunk<String>(){

                    @Override
                    public String value() {
                        RegionTreeUserObj userObject = (RegionTreeUserObj)o;
                        Object r = userObject.region();
                        OpenDefinitionsDocument doc = r.getDocument();
                        try {
                            int rEnd;
                            int endOffset;
                            int lnr = doc.getLineOfOffset(r.getStartOffset()) + 1;
                            int startOffset = doc._getOffset(lnr - 3);
                            if (startOffset < 0) {
                                startOffset = 0;
                            }
                            if ((endOffset = doc._getOffset(lnr + 3)) < 0) {
                                endOffset = doc.getLength() - 1;
                            }
                            String s = doc.getText(startOffset, endOffset - startOffset);
                            int rStart = r.getStartOffset() - startOffset;
                            if (rStart < 0) {
                                rStart = 0;
                            }
                            if ((rEnd = r.getEndOffset() - startOffset) > s.length()) {
                                rEnd = s.length();
                            }
                            if (rStart <= s.length() && rEnd >= rStart) {
                                String t1 = StringOps.encodeHTML(s.substring(0, rStart));
                                String t2 = StringOps.encodeHTML(s.substring(rStart, rEnd));
                                String t3 = StringOps.encodeHTML(s.substring(rEnd));
                                s = t1 + "<font color=#ff0000>" + t2 + "</font>" + t3;
                            } else {
                                s = StringOps.encodeHTML(s);
                            }
                            return "<html><pre>" + s + "</pre></html>";
                        }
                        catch (BadLocationException ble) {
                            return "";
                        }
                    }
                };
                this.setText(node.getUserObject().toString());
                this.setIcon(null);
            }
            this.setToolTipText(tooltip);
            return this;
        }

        public void setToolTipText(Thunk<String> text) {
            Object oldText = this.getClientProperty("ToolTipText");
            this.putClientProperty("ToolTipText", text);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            if (text != null) {
                if (oldText == null) {
                    toolTipManager.registerComponent(this);
                }
            } else {
                toolTipManager.unregisterComponent(this);
            }
        }

        @Override
        public String getToolTipText() {
            Object o = this.getClientProperty("ToolTipText");
            if (o instanceof Thunk) {
                String s = (String)((Thunk)o).value();
                this.putClientProperty("ToolTipText", s);
                return s;
            }
            return (String)o;
        }
    }
}

