/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsEditorKit;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.HighlightManager;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.text.EditorKit;
import javax.swing.text.Keymap;
import javax.swing.text.StyledEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionsPane
extends AbstractDJPane
implements OptionConstants,
ClipboardOwner {
    protected final Keymap _keymap;
    private boolean _antiAliasText = false;
    static StyledEditorKit EDITOR_KIT = new InteractionsEditorKit();
    protected Runnable _beep = new Runnable(){

        public void run() {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private final InteractionsDJDocument _doc;

    public Runnable getBeep() {
        return this._beep;
    }

    public InteractionsPane(InteractionsDJDocument doc) {
        this("INTERACTIONS_KEYMAP", doc);
    }

    public InteractionsPane(String keymapName, InteractionsDJDocument doc) {
        super(doc);
        this._doc = doc;
        this._keymap = InteractionsPane.addKeymap(keymapName, this.getKeymap());
        this.setCaretPosition(doc.getLength());
        this.setHighlighter(new ReverseHighlighter());
        this._highlightManager = new HighlightManager(this);
        this._antiAliasText = DrJava.getConfig().getSetting(TEXT_ANTIALIAS);
        new ForegroundColorListener(this);
        new BackgroundColorListener(this);
        AntiAliasOptionListener aaTemp = new AntiAliasOptionListener();
        DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, aaTemp);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    public void addActionForKeyStroke(KeyStroke stroke, Action action) {
        KeyStroke[] keys = this._keymap.getKeyStrokesForAction(action);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this._keymap.removeKeyStrokeBinding(keys[i]);
            }
        }
        this._keymap.addActionForKeyStroke(stroke, action);
        this.setKeymap(this._keymap);
    }

    public void addActionForKeyStroke(Vector<KeyStroke> stroke, Action action) {
        KeyStroke[] keys = this._keymap.getKeyStrokesForAction(action);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this._keymap.removeKeyStrokeBinding(keys[i]);
            }
        }
        for (KeyStroke ks : stroke) {
            this._keymap.addActionForKeyStroke(ks, action);
        }
        this.setKeymap(this._keymap);
    }

    public void setBeep(Runnable beep) {
        this._beep = beep;
    }

    public void highlightError(int offset, int length) {
        this._highlightManager.addHighlight(offset, offset + length, ERROR_PAINTER);
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        if (this._antiAliasText && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(g);
    }

    @Override
    public DJDocument getDJDocument() {
        return this._doc;
    }

    @Override
    protected void matchUpdate(int offset) {
        if (!this._doc.hasPrompt()) {
            return;
        }
        this._doc.setCurrentLocation(offset);
        this._removePreviousHighlight();
        int to2 = this.getCaretPosition();
        int from = this._doc.balanceBackward();
        if (from > -1) {
            from = to2 - from;
            this._addHighlight(from, to2);
        } else {
            from = to2;
            to2 = this._doc.balanceForward();
            if (to2 > -1) {
                this._addHighlight(from - 1, to2 += from);
            }
        }
    }

    @Override
    protected void updateStatusField() {
    }

    @Override
    protected void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) {
        assert (EventQueue.isDispatchThread());
        try {
            this._doc.indentLines(selStart, selEnd, reason, pm);
            this.setCaretPos(this._doc.getCurrentLocation());
        }
        catch (OperationCanceledException oce) {
            throw new UnexpectedException(oce);
        }
    }

    @Override
    protected boolean shouldIndent(int selStart, int selEnd) {
        return true;
    }

    public abstract int getPromptPos();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AntiAliasOptionListener
    implements OptionListener<Boolean> {
        private AntiAliasOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            InteractionsPane.this._antiAliasText = (Boolean)oce.value;
            InteractionsPane.this.repaint();
        }
    }
}

