/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.ui.AbstractConsoleController;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsController
extends AbstractConsoleController {
    private static final String INPUT_ENTERED_NAME = "Input Entered";
    private static final String INSERT_NEWLINE_NAME = "Insert Newline";
    private static final String INSERT_END_OF_STREAM = "Insert End of Stream";
    public static final String INPUT_BOX_STYLE = "input.box.style";
    public static final String INPUT_BOX_SYMBOL = "[DrJava Input Box]";
    private volatile InteractionsModel _model;
    private volatile InteractionsDocument _doc;
    private volatile SimpleAttributeSet _errStyle;
    private final SimpleAttributeSet _debugStyle;
    private volatile Lambda<String, String> _insertTextCommand;
    private volatile Runnable _inputCompletionCommand;
    private final Runnable _disableCloseSystemInMenuItemCommand;
    private static final Lambda<String, String> _defaultInsertTextCommand = new Lambda<String, String>(){

        @Override
        public String value(String input) {
            throw new UnsupportedOperationException("Cannot insert text. There is no console input in progress");
        }
    };
    private static final Runnable _defaultInputCompletionCommand = new Runnable(){

        public void run() {
        }
    };
    private volatile InputBox _box;
    private volatile String _result;
    private volatile boolean _endOfStream = false;
    protected volatile InputListener _inputListener = new InputListener(){

        public String getConsoleInput() {
            if (InteractionsController.this._endOfStream) {
                return "";
            }
            final CompletionMonitor completionMonitor = new CompletionMonitor();
            InteractionsController.this._box = new InputBox(InteractionsController.this._endOfStream);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Lambda<String, String> insertTextCommand = InteractionsController.this._box.makeInsertTextCommand();
                    Runnable inputCompletionCommand = new Runnable(){

                        public void run() {
                            assert (EventQueue.isDispatchThread());
                            InteractionsController.this._setConsoleInputCommands(_defaultInputCompletionCommand, _defaultInsertTextCommand);
                            InteractionsController.this._box.disableInputs();
                            InteractionsController.this._result = InteractionsController.this._box.getText();
                            if (InteractionsController.this._box.wasClosedWithEnter()) {
                                InteractionsController.this._result = InteractionsController.this._result + "\n";
                            }
                            InteractionsController.this.setEndOfStream(InteractionsController.this._box.isEndOfStream());
                            InteractionsController.this._pane.setEditable(true);
                            InteractionsController.this._pane.setCaretPosition(InteractionsController.this._doc.getLength());
                            InteractionsController.this._pane.requestFocusInWindow();
                            completionMonitor.signal();
                        }
                    };
                    InteractionsController.this._box.setInputCompletionCommand(inputCompletionCommand);
                    InteractionsController.this._setConsoleInputCommands(inputCompletionCommand, insertTextCommand);
                    InteractionsController.this._pane.setEditable(true);
                    SimpleAttributeSet inputAttributes = new SimpleAttributeSet();
                    StyleConstants.setComponent(inputAttributes, InteractionsController.this._box);
                    InteractionsController.this._doc.insertBeforeLastPrompt(" ", "default");
                    InteractionsController.this._interactionsDJDocument.setDocStyle(InteractionsController.INPUT_BOX_STYLE, inputAttributes);
                    InteractionsController.this._doc.insertBeforeLastPrompt(InteractionsController.INPUT_BOX_SYMBOL, InteractionsController.INPUT_BOX_STYLE);
                    InteractionsController.this._doc.insertBeforeLastPrompt("\n", "default");
                    InteractionsController.this._box.setVisible(true);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            InteractionsController.this._box.requestFocusInWindow();
                        }
                    });
                    InteractionsController.this._pane.setEditable(false);
                }
            });
            InteractionsController.this.fireConsoleInputStarted();
            completionMonitor.attemptEnsureSignaled();
            InteractionsController.this.fireConsoleInputCompleted(InteractionsController.this._result);
            return InteractionsController.this._result;
        }
    };
    private ArrayList<ConsoleStateListener> _consoleStateListeners;
    private InteractionsListener _viewListener = new InteractionsListener(){

        public void interactionStarted() {
        }

        public void interactionEnded() {
            InteractionsController.this._pane.requestFocusInWindow();
        }

        public void interactionErrorOccurred(int offset, int length) {
        }

        public void interpreterResetting() {
            assert (EventQueue.isDispatchThread());
            InteractionsController.this._interactionsDJDocument.clearColoring();
            InteractionsController.this._endOfStream = false;
        }

        public void interpreterReady(File wd) {
        }

        public void interpreterResetFailed(Throwable t) {
        }

        public void interpreterExited(int status) {
        }

        public void interpreterChanged(boolean inProgress) {
        }

        public void interactionIncomplete() {
        }
    };
    AbstractAction evalAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            InteractionsController.this._model.interpretCurrentInteraction();
        }
    };
    AbstractAction historyPrevAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.this._doc.recallPreviousInteractionInHistory()) {
                    InteractionsController.this.moveToEnd();
                }
                if (!InteractionsController.this._isCursorAfterPrompt()) {
                    InteractionsController.this.moveToPrompt();
                }
            }
        }
    };
    AbstractAction historyNextAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!(InteractionsController.this._busy() || !InteractionsController.this._doc.recallNextInteractionInHistory() && InteractionsController.this._isCursorAfterPrompt())) {
                InteractionsController.this.moveToPrompt();
            }
        }
    };
    AbstractAction moveUpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.this._shouldGoIntoHistory(InteractionsController.this._doc.getPromptPos(), InteractionsController.this._pane.getCaretPosition())) {
                    InteractionsController.this.historyPrevAction.actionPerformed(e);
                } else {
                    InteractionsController.this.defaultUpAction.actionPerformed(e);
                    if (!InteractionsController.this._isCursorAfterPrompt()) {
                        InteractionsController.this.moveToPrompt();
                    }
                }
            }
        }
    };
    AbstractAction moveDownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.this._shouldGoIntoHistory(InteractionsController.this._pane.getCaretPosition(), InteractionsController.this._interactionsDJDocument.getLength())) {
                    InteractionsController.this.historyNextAction.actionPerformed(e);
                } else {
                    InteractionsController.this.defaultDownAction.actionPerformed(e);
                }
            }
        }
    };
    Action defaultUpAction;
    Action defaultDownAction;
    AbstractAction historyReverseSearchAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                InteractionsController.this._doc.reverseSearchInteractionsInHistory();
                InteractionsController.this.moveToEnd();
            }
        }
    };
    AbstractAction historyForwardSearchAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                InteractionsController.this._doc.forwardSearchInteractionsInHistory();
                InteractionsController.this.moveToEnd();
            }
        }
    };
    AbstractAction moveLeftAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                int promptPos = InteractionsController.this._doc.getPromptPos();
                int pos = InteractionsController.this._pane.getCaretPosition();
                if (pos < promptPos) {
                    InteractionsController.this.moveToPrompt();
                } else if (pos == promptPos) {
                    InteractionsController.this.moveToEnd();
                } else {
                    InteractionsController.this._pane.setCaretPosition(pos - 1);
                }
            }
        }
    };
    AbstractAction moveRightAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int pos = InteractionsController.this._pane.getCaretPosition();
            if (pos < InteractionsController.this._doc.getPromptPos()) {
                InteractionsController.this.moveToEnd();
            } else if (pos >= InteractionsController.this._doc.getLength()) {
                InteractionsController.this.moveToPrompt();
            } else {
                InteractionsController.this._pane.setCaretPosition(pos + 1);
            }
        }
    };
    AbstractAction prevWordAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int promptPos;
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < (promptPos = InteractionsController.this._doc.getPromptPos())) {
                InteractionsController.this.moveToPrompt();
            } else if (position == promptPos) {
                InteractionsController.this.moveToEnd();
            } else {
                InteractionsController.this._pane.getActionMap().get("caret-previous-word").actionPerformed(e);
            }
        }
    };
    AbstractAction nextWordAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int promptPos;
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < (promptPos = InteractionsController.this._doc.getPromptPos())) {
                InteractionsController.this.moveToEnd();
            } else if (position >= InteractionsController.this._doc.getLength()) {
                InteractionsController.this.moveToPrompt();
            } else {
                InteractionsController.this._pane.getActionMap().get("caret-next-word").actionPerformed(e);
            }
        }
    };
    AbstractAction indentKeyActionTab = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            InteractionsController.this._pane.indent();
        }
    };
    AbstractAction indentKeyActionLine = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            InteractionsController.this._doc.append("\n", null);
            InteractionsController.this._pane.indent(Indenter.IndentReason.ENTER_KEY_PRESS);
        }
    };

    public InteractionsController(final InteractionsModel model, InteractionsDJDocument adapter, Runnable disableCloseSystemInMenuItemCommand) {
        this(model, adapter, new InteractionsPane(adapter){

            public int getPromptPos() {
                return model.getDocument().getPromptPos();
            }
        }, disableCloseSystemInMenuItemCommand);
    }

    public InteractionsController(InteractionsModel model, InteractionsDJDocument adapter, InteractionsPane pane, Runnable disableCloseSystemInMenuItemCommand) {
        super(adapter, pane);
        this._disableCloseSystemInMenuItemCommand = disableCloseSystemInMenuItemCommand;
        StyledEditorKit d = InteractionsPane.EDITOR_KIT;
        for (Action a : ((DefaultEditorKit)d).getActions()) {
            if (a.getValue("Name").equals("caret-up")) {
                this.defaultUpAction = a;
            }
            if (!a.getValue("Name").equals("caret-down")) continue;
            this.defaultDownAction = a;
        }
        this._model = model;
        this._doc = model.getDocument();
        this._errStyle = new SimpleAttributeSet();
        this._debugStyle = new SimpleAttributeSet();
        this._model.setInputListener(this._inputListener);
        this._model.addListener(this._viewListener);
        this._model.setUpPane(pane);
        this._inputCompletionCommand = _defaultInputCompletionCommand;
        this._insertTextCommand = _defaultInsertTextCommand;
        this._consoleStateListeners = new ArrayList();
        this._init();
    }

    public void addConsoleStateListener(ConsoleStateListener listener) {
        this._consoleStateListeners.add(listener);
    }

    public void removeConsoleStateListener(ConsoleStateListener listener) {
        this._consoleStateListeners.remove(listener);
    }

    private void fireConsoleInputStarted() {
        for (ConsoleStateListener listener : this._consoleStateListeners) {
            listener.consoleInputStarted(this);
        }
    }

    private void fireConsoleInputCompleted(String text) {
        for (ConsoleStateListener listener : this._consoleStateListeners) {
            listener.consoleInputCompleted(text, this);
        }
    }

    public void setEndOfStream(boolean tf) {
        this._endOfStream = tf;
        if (this._box != null) {
            this._box.setEndOfStream(tf);
        }
        if (tf) {
            this._disableCloseSystemInMenuItemCommand.run();
        }
    }

    public InputListener getInputListener() {
        return this._inputListener;
    }

    public void interruptConsoleInput() {
        EventQueue.invokeLater(this._inputCompletionCommand);
    }

    public void insertConsoleText(String input) {
        this._insertTextCommand.value(input);
    }

    public InteractionsModel getInteractionsModel() {
        return this._model;
    }

    @Override
    public ConsoleDocument getConsoleDoc() {
        return this._doc;
    }

    public InteractionsDocument getDocument() {
        return this._doc;
    }

    @Override
    protected void _addDocumentStyles() {
        super._addDocumentStyles();
        this._errStyle.addAttributes(this._defaultStyle);
        this._errStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_ERROR_COLOR));
        this._errStyle.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this._interactionsDJDocument.setDocStyle("error", this._errStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.INTERACTIONS_ERROR_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                InteractionsController.this._errStyle.addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
        this._debugStyle.addAttributes(this._defaultStyle);
        this._debugStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.DEBUG_MESSAGE_COLOR));
        this._debugStyle.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this._interactionsDJDocument.setDocStyle("debugger", this._debugStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_MESSAGE_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                InteractionsController.this._debugStyle.addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
    }

    @Override
    protected void _updateStyles(AttributeSet newSet) {
        super._updateStyles(newSet);
        this._errStyle.addAttributes(newSet);
        StyleConstants.setBold(this._errStyle, true);
        this._debugStyle.addAttributes(newSet);
        StyleConstants.setBold(this._debugStyle, true);
    }

    @Override
    protected void _setupModel() {
        this._doc.setBeep(this._pane.getBeep());
    }

    @Override
    protected void _setupView() {
        super._setupView();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), (Action)this.evalAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), (Action)this.newLineAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(66, mask), (Action)this.clearCurrentAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(224, 0), (Action)this.moveUpAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), (Action)this.moveUpAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, mask), (Action)this.historyPrevAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(225, 0), (Action)this.moveDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), (Action)this.moveDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, mask), (Action)this.historyNextAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), (Action)this.historyReverseSearchAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), (Action)this.historyForwardSearchAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(226, 0), (Action)this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), (Action)this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(227, 0), (Action)this.moveRightAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), (Action)this.moveRightAction);
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_WORD)), (Action)this.prevWordAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_PREVIOUS_WORD, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                InteractionsController.this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_WORD)), (Action)InteractionsController.this.prevWordAction);
            }
        });
        this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_WORD)), (Action)this.nextWordAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_NEXT_WORD, new OptionListener<Vector<KeyStroke>>(){

            @Override
            public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                InteractionsController.this._pane.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_WORD)), (Action)InteractionsController.this.nextWordAction);
            }
        });
    }

    private void _setConsoleInputCommands(Runnable inputCompletionCommand, Lambda<String, String> insertTextCommand) {
        this._insertTextCommand = insertTextCommand;
        this._inputCompletionCommand = inputCompletionCommand;
    }

    private boolean _shouldGoIntoHistory(int start, int end) {
        if (this._isCursorAfterPrompt() && end >= start) {
            String text = "";
            try {
                text = this._interactionsDJDocument.getText(start, end - start);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            if (text.indexOf("\n") != -1) {
                return false;
            }
        }
        return true;
    }

    private boolean _isCursorAfterPrompt() {
        return this._pane.getCaretPosition() >= this._doc.getPromptPos();
    }

    public static interface ConsoleStateListener
    extends EventListener {
        public void consoleInputStarted(InteractionsController var1);

        public void consoleInputCompleted(String var1, InteractionsController var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputBox
    extends JTextArea {
        private static final int BORDER_WIDTH = 1;
        private static final int INNER_BUFFER_WIDTH = 3;
        private static final int OUTER_BUFFER_WIDTH = 2;
        private volatile Color _bgColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR);
        private volatile Color _fgColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR);
        private volatile Color _sysInColor = DrJava.getConfig().getSetting(OptionConstants.SYSTEM_IN_COLOR);
        private volatile boolean _antiAliasText = DrJava.getConfig().getSetting(OptionConstants.TEXT_ANTIALIAS);
        private volatile boolean _endOfStream = false;
        private volatile boolean _closedWithEnter = false;

        public InputBox(boolean endOfStream) {
            this._endOfStream = endOfStream;
            this.setForeground(this._sysInColor);
            this.setBackground(this._bgColor);
            this.setCaretColor(this._fgColor);
            this.setBorder(this._createBorder());
            this.setLineWrap(true);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.this._fgColor = (Color)oe.value;
                    InputBox.this.setBorder(InputBox.this._createBorder());
                    InputBox.this.setCaretColor((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.this._bgColor = (Color)oe.value;
                    InputBox.this.setBorder(InputBox.this._createBorder());
                    InputBox.this.setBackground((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_IN_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.this._sysInColor = (Color)oe.value;
                    InputBox.this.setForeground((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, new OptionListener<Boolean>(){

                @Override
                public void optionChanged(OptionEvent<Boolean> oce) {
                    InputBox.this._antiAliasText = (Boolean)oce.value;
                    InputBox.this.repaint();
                }
            });
            AbstractAction newLineAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    InputBox.this.insert("\n", InputBox.this.getCaretPosition());
                }
            };
            InputMap im = this.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(10, 1), InteractionsController.INSERT_NEWLINE_NAME);
            im.put(KeyStroke.getKeyStroke(10, 2), InteractionsController.INSERT_NEWLINE_NAME);
            ActionMap am = this.getActionMap();
            am.put(InteractionsController.INSERT_NEWLINE_NAME, newLineAction);
        }

        public boolean isEndOfStream() {
            return this._endOfStream;
        }

        public void setEndOfStream(boolean tf) {
            this._endOfStream = tf;
        }

        public boolean wasClosedWithEnter() {
            return this._closedWithEnter;
        }

        private Border _createBorder() {
            Border outerouter = BorderFactory.createLineBorder(this._bgColor, 2);
            Border outer = BorderFactory.createLineBorder(this._fgColor, 1);
            Border inner = BorderFactory.createLineBorder(this._bgColor, 3);
            CompoundBorder temp = BorderFactory.createCompoundBorder(outer, inner);
            return BorderFactory.createCompoundBorder(outerouter, temp);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this._antiAliasText && g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            super.paintComponent(g);
        }

        void setInputCompletionCommand(final Runnable command) {
            InputMap im = this.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(10, 0), InteractionsController.INPUT_ENTERED_NAME);
            for (KeyStroke k : (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_CLOSE_SYSTEM_IN))) {
                im.put(k, InteractionsController.INSERT_END_OF_STREAM);
            }
            ActionMap am = this.getActionMap();
            am.put(InteractionsController.INPUT_ENTERED_NAME, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    InputBox.this._closedWithEnter = true;
                    command.run();
                }
            });
            am.put(InteractionsController.INSERT_END_OF_STREAM, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    InputBox.this._endOfStream = true;
                    command.run();
                }
            });
        }

        Lambda<String, String> makeInsertTextCommand() {
            return new Lambda<String, String>(){

                @Override
                public String value(String input) {
                    InputBox.this.insert(input, InputBox.this.getCaretPosition());
                    return input;
                }
            };
        }

        void disableInputs() {
            this.setEditable(false);
            ActionMap am = this.getActionMap();
            Action action = am.get(InteractionsController.INPUT_ENTERED_NAME);
            if (action != null) {
                action.setEnabled(false);
            }
            if ((action = am.get(InteractionsController.INSERT_NEWLINE_NAME)) != null) {
                action.setEnabled(false);
            }
            this.getCaret().setVisible(false);
        }
    }
}

