/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DrJavaErrorWindow
extends JDialog {
    public static final String SF_ADD_BUG_URL = "http://sourceforge.net/tracker/?func=add&group_id=44253&atid=438935/";
    public static final String SF_LINK_NAME = "http://sourceforge.net/projects/drjava";
    private volatile JEditorPane _errorInfo;
    private final JTextArea _stackTrace;
    private final JLabel _indexLabel;
    private final JScrollPane _stackTraceScroll;
    private final JPanel _bottomPanel;
    private final JPanel _buttonPanel;
    private final JButton _copyButton;
    private final JButton _okButton;
    private final JButton _nextButton;
    private final JButton _prevButton;
    private final JButton _dismissButton;
    private volatile int _errorCount;
    private volatile Throwable _error;
    private volatile int _errorIndex;
    private static volatile JFrame _parentFrame = null;
    private static volatile boolean _parentChanged = true;
    private static volatile DrJavaErrorWindow _singletonInstance;
    protected WindowAdapter _windowListener = new WindowAdapter(){

        public void windowDeactivated(WindowEvent we) {
            DrJavaErrorWindow.this.toFront();
        }

        public void windowClosing(WindowEvent we) {
            DrJavaErrorWindow.this.dispose();
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }
    };
    private final Action _okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorWindow.this.dispose();
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }
    };
    private final Action _prevAction = new AbstractAction("Previous"){

        public void actionPerformed(ActionEvent e) {
            if (DrJavaErrorWindow.this._errorIndex > 0) {
                --DrJavaErrorWindow.this._errorIndex;
                DrJavaErrorWindow.this._error = DrJavaErrorHandler.getError(DrJavaErrorWindow.this._errorIndex);
                if (DrJavaErrorWindow.this._errorIndex == 0) {
                    this.setEnabled(false);
                }
                if (DrJavaErrorWindow.this._errorCount > 1) {
                    DrJavaErrorWindow.this._nextAction.setEnabled(true);
                }
                DrJavaErrorWindow.this.updateErrorInfo();
            }
        }
    };
    private final Action _nextAction = new AbstractAction("Next"){

        public void actionPerformed(ActionEvent e) {
            if (DrJavaErrorWindow.this._errorIndex < DrJavaErrorWindow.this._errorCount - 1) {
                ++DrJavaErrorWindow.this._errorIndex;
                DrJavaErrorWindow.this._error = DrJavaErrorHandler.getError(DrJavaErrorWindow.this._errorIndex);
                if (DrJavaErrorWindow.this._errorIndex == DrJavaErrorWindow.this._errorCount - 1) {
                    this.setEnabled(false);
                }
                if (DrJavaErrorWindow.this._errorCount > 1) {
                    DrJavaErrorWindow.this._prevAction.setEnabled(true);
                }
                DrJavaErrorWindow.this.updateErrorInfo();
            }
        }
    };
    private Action _dismissAction = new AbstractAction("Dismiss"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorHandler.clearErrors();
            DrJavaErrorWindow.this._errorCount = 0;
            DrJavaErrorWindow.this._error = null;
            DrJavaErrorWindow.this._errorIndex = -1;
            this.setEnabled(false);
            DrJavaErrorWindow.this._prevAction.setEnabled(false);
            DrJavaErrorWindow.this._nextAction.setEnabled(false);
            DrJavaErrorWindow.this._copyAction.setEnabled(false);
            DrJavaErrorWindow.this.updateErrorInfo();
            JButton errorsButton = DrJavaErrorHandler.getButton();
            if (errorsButton != null) {
                errorsButton.setVisible(false);
            }
            DrJavaErrorWindow.this._okAction.actionPerformed(e);
        }
    };
    private Action _copyAction = new AbstractAction("Copy This Error"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorWindow.this._stackTrace.grabFocus();
            DrJavaErrorWindow.this._stackTrace.getActionMap().get("select-all").actionPerformed(e);
            DrJavaErrorWindow.this._stackTrace.getActionMap().get("copy-to-clipboard").actionPerformed(e);
        }
    };
    private static final String HEADER_HTML = "<html><font size=\"-1\" face=\"sans-serif, Arial, Helvetica, Geneva\"><b>";
    private static final String ERRORS_FOOTER_HTML = "Please submit a bug report containing the information below and an account of the actions that caused the bug (if known) to <a href=\"http://sourceforge.net/tracker/?func=add&group_id=44253&atid=438935/\"><b>http://sourceforge.net/projects/drjava</b></a>.<br>You may wish to save all your work and restart DrJava.<br>Thanks for your help in making DrJava better!</b></font></p></html>";
    private static final String NO_ERRORS_HTML = "No errors occurred!<br>Thanks for using DrJava!</b></font></p></html>";

    public static void setFrame(JFrame f) {
        _parentFrame = f;
        _parentChanged = true;
    }

    public static JFrame getFrame() {
        return _parentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DrJavaErrorWindow singleton() {
        if (!_parentChanged) return _singletonInstance;
        Class<DrJavaErrorWindow> clazz = DrJavaErrorWindow.class;
        synchronized (DrJavaErrorWindow.class) {
            if (!_parentChanged) return _singletonInstance;
            _singletonInstance = new DrJavaErrorWindow();
            _parentChanged = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _singletonInstance;
        }
    }

    private DrJavaErrorWindow() {
        super((Frame)_parentFrame, "DrJava Errors");
        this.setSize(600, 400);
        this._stackTrace = new JTextArea();
        this._stackTrace.setEditable(false);
        this._prevButton = new JButton(this._prevAction);
        this._nextButton = new JButton(this._nextAction);
        this._copyButton = new JButton(this._copyAction);
        this._dismissButton = new JButton(this._dismissAction);
        this._okButton = new JButton(this._okAction);
        this._bottomPanel = new JPanel(new BorderLayout());
        this._buttonPanel = new JPanel();
        this._buttonPanel.add(this._prevButton);
        this._buttonPanel.add(this._nextButton);
        this._buttonPanel.add(this._copyButton);
        this._buttonPanel.add(this._dismissButton);
        this._buttonPanel.add(this._okButton);
        this._indexLabel = new JLabel();
        this._bottomPanel.add((Component)this._indexLabel, "Center");
        this._bottomPanel.add((Component)this._buttonPanel, "East");
        this._stackTraceScroll = new BorderlessScrollPane(this._stackTrace, 22, 32);
        this._errorInfo = new JEditorPane("text/html", "<html><font size=\"-1\" face=\"sans-serif, Arial, Helvetica, Geneva\"><b>No errors occurred!<br>Thanks for using DrJava!</b></font></p></html>");
        this._errorInfo.setEditable(false);
        this._errorInfo.setBackground(this.getContentPane().getBackground());
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)this._errorInfo, "North");
        cp.add((Component)this._stackTraceScroll, "Center");
        cp.add((Component)this._bottomPanel, "South");
        this.getRootPane().setDefaultButton(this._okButton);
        this.init();
    }

    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this.init();
            if (_parentFrame != null) {
                DrJavaRoot.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            }
            this.toFront();
        } else if (_parentFrame != null) {
            DrJavaRoot.removeModalWindowAdapter(this);
            _parentFrame.toFront();
        }
        super.setVisible(vis);
    }

    private void init() {
        this._errorCount = DrJavaErrorHandler.getErrorCount();
        if (this._errorCount > 0) {
            this._error = DrJavaErrorHandler.getError(0);
            this._errorIndex = 0;
        } else {
            this._error = null;
            this._errorIndex = -1;
        }
        this._prevAction.setEnabled(false);
        this._nextAction.setEnabled(this._errorCount > 1);
        this._dismissAction.setEnabled(this._errorCount > 0);
        this._copyAction.setEnabled(this._errorCount > 0);
        this.updateErrorInfo();
    }

    private void updateErrorInfo() {
        this.getContentPane().remove(this._errorInfo);
        if (this._error != null) {
            StringBuilder b = new StringBuilder();
            if (this._error instanceof DrJavaErrorHandler.LoggedCondition) {
                b.append("Logged condition: ");
                b.append(this._error.getMessage());
                b.append('\n');
                boolean first = true;
                for (StackTraceElement ste : this._error.getStackTrace()) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    b.append("\tat ");
                    b.append(ste);
                    b.append('\n');
                }
            } else {
                b.append(StringOps.getStackTrace(this._error));
                if (this._error instanceof UnexpectedException) {
                    Throwable t = ((UnexpectedException)this._error).getCause();
                    b.append("\nCaused by:\n");
                    b.append(StringOps.getStackTrace(t));
                }
            }
            b.append("\n\n");
            b.append(DrJavaErrorWindow.getSystemAndDrJavaInfo());
            this._stackTrace.setText(b.toString());
            this._stackTrace.setCaretPosition(0);
            StringBuilder b2 = new StringBuilder();
            b2.append(HEADER_HTML);
            b2.append(this._errorCount);
            b2.append(" error");
            b2.append(this._errorCount > 1 ? "s" : "");
            b2.append(" occured!<br>");
            b2.append(ERRORS_FOOTER_HTML);
            this._errorInfo = new JEditorPane("text/html", b2.toString());
            this._errorInfo.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            PlatformFactory.ONLY.openURL(e.getURL());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this._errorInfo.setEditable(false);
            this._errorInfo.setBackground(this.getContentPane().getBackground());
            this._indexLabel.setText("Error " + (this._errorIndex + 1) + " of " + this._errorCount);
        } else {
            this._errorInfo = new JEditorPane("text/html", "<html><font size=\"-1\" face=\"sans-serif, Arial, Helvetica, Geneva\"><b>No errors occurred!<br>Thanks for using DrJava!</b></font></p></html>");
            this._errorInfo.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            PlatformFactory.ONLY.openURL(e.getURL());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this._errorInfo.setEditable(false);
            this._errorInfo.setBackground(this.getContentPane().getBackground());
            this._stackTrace.setText("");
            this._indexLabel.setText("");
        }
        this.getContentPane().add((Component)this._errorInfo, "North");
        this.validate();
    }

    public static String getSystemAndDrJavaInfo() {
        StringBuilder b = new StringBuilder();
        b.append("System Properties:\n");
        b.append("DrJava Version ");
        b.append(Version.getVersionString());
        b.append('\n');
        b.append("DrJava Build Time ");
        b.append(Version.getBuildTimeString());
        b.append("\n\n");
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            b.append(entry.getKey());
            b.append(" = ");
            if (entry.getKey().equals("line.separator")) {
                b.append("\"");
                String ls = (String)entry.getValue();
                for (int i = 0; i < ls.length(); ++i) {
                    char ch = ls.charAt(i);
                    b.append("\\u");
                    String hexString = "0000" + Integer.toHexString(ch);
                    b.append(hexString.substring(hexString.length() - 4));
                }
                b.append("\"");
            } else {
                b.append(entry.getValue());
            }
            b.append('\n');
        }
        b.append('\n');
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DrJava.getConfig().saveConfiguration(baos, "DrJava configuration file");
            b.append(baos.toString());
        }
        catch (IOException ioe) {
            b.append("IOException when trying to print DrJava configuration file");
        }
        b.append("\n\nUsed memory: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        b.append("\nFree memory: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().freeMemory()));
        b.append("\nTotal memory: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory()));
        b.append("\nTotal memory can expand to: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().maxMemory()));
        b.append("\n\nNumber of processors/cores: ");
        b.append(Runtime.getRuntime().availableProcessors());
        b.append("\n\n");
        String infoText = b.toString();
        String userHome = System.getProperty("user.home");
        String anonUserHome = "<anonymized user.home>";
        infoText = DrJavaErrorWindow.replaceString(infoText, userHome, anonUserHome);
        String userDir = System.getProperty("user.dir");
        String anonUserDir = "<anonymized user.dir>";
        infoText = DrJavaErrorWindow.replaceString(infoText, userDir, anonUserDir);
        String userName = System.getProperty("user.name");
        String anonUserName = "<anonymized user.name>";
        infoText = DrJavaErrorWindow.replaceString(infoText, userName, anonUserName);
        return infoText;
    }

    private static String replaceString(String text, String orig, String repl) {
        int pos = 0;
        while ((pos = text.indexOf(orig, pos)) >= 0) {
            text = text.substring(0, pos) + repl + text.substring(pos + orig.length(), text.length());
        }
        return text;
    }
}

