/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import java.awt.EventQueue;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RMIInteractionsModel
extends InteractionsModel {
    protected final MainJVM _jvm;

    public RMIInteractionsModel(MainJVM jvm, ConsoleDocumentInterface cDoc, File wd, int historySize, int writeDelay) {
        super(cDoc, wd, historySize, writeDelay);
        this._jvm = jvm;
    }

    @Override
    protected void _interpret(String toEval) {
        DebugUtil.debug.logStart("Interpret " + toEval);
        this._jvm.interpret(toEval);
        DebugUtil.debug.logEnd();
    }

    @Override
    public String getVariableToString(String var, int ... indices) {
        Option<String> result = this._jvm.getVariableToString(var, indices);
        return result.unwrap("");
    }

    @Override
    public String getVariableType(String var, int ... indices) {
        Option<String> result = this._jvm.getVariableType(var, indices);
        return result.unwrap("");
    }

    @Override
    public void addProjectClassPath(File f) {
        this._jvm.addProjectClassPath(f);
    }

    @Override
    public void addBuildDirectoryClassPath(File f) {
        this._jvm.addBuildDirectoryClassPath(f);
    }

    @Override
    public void addProjectFilesClassPath(File f) {
        this._jvm.addProjectFilesClassPath(f);
    }

    @Override
    public void addExternalFilesClassPath(File f) {
        this._jvm.addExternalFilesClassPath(f);
    }

    @Override
    public void addExtraClassPath(File f) {
        this._jvm.addExtraClassPath(f);
    }

    @Override
    protected void _resetInterpreter(File wd, boolean force) {
        this.setToDefaultInterpreter();
        this._jvm.setWorkingDirectory(wd);
        this._jvm.restartInterpreterJVM(force);
    }

    public void addInterpreter(String name) {
        this._jvm.addInterpreter(name);
    }

    public void removeInterpreter(String name) {
        this._jvm.removeInterpreter(name);
    }

    public void setActiveInterpreter(String name, String prompt) {
        Option<Pair<Boolean, Boolean>> result = this._jvm.setActiveInterpreter(name);
        DebugUtil.debug.logValue("result", result);
        if (result.isSome() && result.unwrap().first().booleanValue()) {
            boolean inProgress = result.unwrap().second();
            this._updateDocument(prompt, inProgress);
            this._notifyInterpreterChanged(inProgress);
        }
    }

    public void setToDefaultInterpreter() {
        Option<Pair<Boolean, Boolean>> result = this._jvm.setToDefaultInterpreter();
        if (result.isSome() && result.unwrap().first().booleanValue()) {
            boolean inProgress = result.unwrap().second();
            this._updateDocument("> ", inProgress);
            this._notifyInterpreterChanged(inProgress);
        }
    }

    private void _updateDocument(String prompt, boolean inProgress) {
        assert (EventQueue.isDispatchThread());
        this._document.setPrompt(prompt);
        this._document.insertNewline(this._document.getLength());
        this._document.insertPrompt();
        this._document.setInProgress(inProgress);
        this.scrollToCaret();
    }

    protected abstract void _notifyInterpreterChanged(boolean var1);

    public void setEnforceAllAccess(boolean enforce) {
        this._jvm.setEnforceAllAccess(enforce);
    }

    public void setEnforcePrivateAccess(boolean enforce) {
        this._jvm.setEnforcePrivateAccess(enforce);
    }

    public void setRequireSemicolon(boolean require) {
        this._jvm.setRequireSemicolon(require);
    }

    public void setRequireVariableType(boolean require) {
        this._jvm.setRequireVariableType(require);
    }

    public Iterable<File> getClassPath() {
        Option<Iterable<File>> result = this._jvm.getClassPath();
        return result.unwrap(IterUtil.empty());
    }
}

