/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.javadoc;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.javadoc.JavadocEventNotifier;
import edu.rice.cs.drjava.model.javadoc.JavadocListener;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.DirectorySelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.OperationCanceledException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavadocModel
implements JavadocModel {
    private GlobalModel _model;
    private final JavadocEventNotifier _notifier = new JavadocEventNotifier();
    private final JVMBuilder _jvmBuilder;
    private CompilerErrorModel _javadocErrorModel;

    public DefaultJavadocModel(GlobalModel model, File javaCommand, Iterable<File> toolsPath) {
        this._model = model;
        JVMBuilder builder = JVMBuilder.DEFAULT;
        if (javaCommand != null) {
            builder = builder.javaCommand(javaCommand);
        }
        if (toolsPath != null) {
            builder = builder.classPath(toolsPath);
        }
        this._jvmBuilder = builder;
        this._javadocErrorModel = new CompilerErrorModel();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addListener(JavadocListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(JavadocListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public CompilerErrorModel getJavadocErrorModel() {
        return this._javadocErrorModel;
    }

    @Override
    public void resetJavadocErrors() {
        this._javadocErrorModel = new CompilerErrorModel();
    }

    @Override
    public void javadocAll(DirectorySelector select, final FileSaveSelector saver) throws IOException {
        if (this._model.hasModifiedDocuments() || this._model.hasUntitledDocuments()) {
            return;
        }
        FileConfiguration config = DrJava.getConfig();
        File destDir = config.getSetting(OptionConstants.JAVADOC_DESTINATION);
        try {
            destDir = destDir.equals(FileOps.NULL_FILE) ? select.getDirectory(null) : select.getDirectory(destDir);
            while (!(destDir.exists() && destDir.isDirectory() && destDir.canWrite())) {
                if (!destDir.getPath().equals("") && !destDir.exists()) {
                    boolean create = select.askUser("The directory you chose does not exist:\n'" + destDir + "'\nWould you like to create it?", "Create Directory?");
                    if (create) {
                        boolean dirMade = destDir.mkdirs();
                        if (dirMade) continue;
                        throw new IOException("Could not create directory: " + destDir);
                    }
                    return;
                }
                if (!destDir.isDirectory() || destDir.getPath().equals("")) {
                    select.warnUser("The file you chose is not a directory:\n'" + destDir + "'\n" + "Please choose another.", "Not a Directory!");
                    destDir = select.getDirectory(null);
                    continue;
                }
                select.warnUser("The directory you chose is not writable:\n'" + destDir + "'\n" + "Please choose another directory.", "Cannot Write to Destination!");
                destDir = select.getDirectory(null);
            }
        }
        catch (OperationCanceledException oce) {
            return;
        }
        this._notifier.javadocStarted();
        final File destDirF = destDir;
        new Thread("DrJava Javadoc Thread"){

            public void run() {
                DefaultJavadocModel.this._javadocAllWorker(destDirF, saver);
            }
        }.start();
    }

    private void _javadocAllWorker(File destDirFile, FileSaveSelector saver) {
        ArrayList<String> docFiles = new ArrayList<String>();
        for (OpenDefinitionsDocument doc : this._model.getOpenDefinitionsDocuments()) {
            try {
                File file = this._getFileFromDocument(doc, saver);
                docFiles.add(file.getPath());
            }
            catch (IllegalStateException e) {
            }
            catch (IOException ioe) {}
        }
        if (docFiles.size() == 0) {
            return;
        }
        this._runJavadoc(docFiles, destDirFile, IterUtil.<String>empty(), true);
    }

    @Override
    public void javadocDocument(OpenDefinitionsDocument doc, FileSaveSelector saver) throws IOException {
        if (doc.isUntitled() || doc.isModifiedSinceSave()) {
            this._notifier.saveBeforeJavadoc();
        }
        if (doc.isUntitled() || doc.isModifiedSinceSave()) {
            return;
        }
        final File file = this._getFileFromDocument(doc, saver);
        final File destDir = IOUtil.createAndMarkTempDirectory("DrJava-javadoc", "");
        this._notifier.javadocStarted();
        new Thread("DrJava Javadoc Thread"){

            public void run() {
                SizedIterable<String> extraArgs = IterUtil.make("-noindex", "-notree", "-nohelp", "-nonavbar");
                DefaultJavadocModel.this._runJavadoc(IterUtil.make(file.getPath()), destDir, extraArgs, false);
            }
        }.start();
    }

    @Override
    public File suggestJavadocDestination(OpenDefinitionsDocument doc) {
        this._attemptSaveAllDocuments();
        try {
            File sourceRoot = doc.getSourceRoot();
            return new File(sourceRoot, "doc");
        }
        catch (InvalidPackageException ipe) {
            return null;
        }
    }

    private void _attemptSaveAllDocuments() {
        if (this._model.hasModifiedDocuments() || this._model.hasUntitledDocuments()) {
            this._notifier.saveBeforeJavadoc();
        }
    }

    private void _runJavadoc(Iterable<String> files, File destDir, Iterable<String> extraArgs, boolean allDocs) {
        AbstractIterable args = IterUtil.empty();
        args = IterUtil.compose(args, IterUtil.make("-d", destDir.getPath()));
        args = IterUtil.compose(args, IterUtil.make("-classpath", IOUtil.pathToString(this._model.getClassPath())));
        args = IterUtil.compose(args, this._getLinkArgs());
        args = IterUtil.compose(args, "-" + DrJava.getConfig().getSetting(OptionConstants.JAVADOC_ACCESS_LEVEL));
        args = IterUtil.compose(args, extraArgs);
        String custom = DrJava.getConfig().getSetting(OptionConstants.JAVADOC_CUSTOM_PARAMS);
        args = IterUtil.compose(args, ArgumentTokenizer.tokenize(custom));
        args = IterUtil.compose(args, files);
        ArrayList<DJError> errors = new ArrayList<DJError>();
        try {
            Process p = this._jvmBuilder.start("com.sun.tools.javadoc.Main", args);
            TaskController<String> outputString = ConcurrentUtil.processOutAsString(p);
            TaskController<String> errorString = ConcurrentUtil.processErrAsString(p);
            p.waitFor();
            errors.addAll(this._extractErrors((String)outputString.value()));
            errors.addAll(this._extractErrors((String)errorString.value()));
        }
        catch (IOException e) {
            errors.add(new DJError("IOException: " + e.getMessage(), false));
        }
        catch (InterruptedException e) {
            errors.add(new DJError("InterruptedException: " + e.getMessage(), false));
        }
        this._javadocErrorModel = new CompilerErrorModel(IterUtil.toArray(errors, DJError.class), this._model);
        boolean success = this._javadocErrorModel.hasOnlyWarnings();
        if (!allDocs) {
            IOUtil.deleteOnExitRecursively(destDir);
        }
        this._notifier.javadocEnded(success, destDir, allDocs);
    }

    private Iterable<String> _getLinkArgs() {
        FileConfiguration config = DrJava.getConfig();
        String linkVersion = config.getSetting(OptionConstants.JAVADOC_LINK_VERSION);
        if (linkVersion.equals("1.3")) {
            return IterUtil.make("-link", config.getSetting(OptionConstants.JAVADOC_1_3_LINK));
        }
        if (linkVersion.equals("1.4")) {
            return IterUtil.make("-link", config.getSetting(OptionConstants.JAVADOC_1_4_LINK));
        }
        if (linkVersion.equals("1.5")) {
            return IterUtil.make("-link", config.getSetting(OptionConstants.JAVADOC_1_5_LINK));
        }
        if (linkVersion.equals("1.6")) {
            return IterUtil.make("-link", config.getSetting(OptionConstants.JAVADOC_1_6_LINK));
        }
        return IterUtil.empty();
    }

    private List<DJError> _extractErrors(String text) {
        BufferedReader r = new BufferedReader(new StringReader(text));
        ArrayList<DJError> result = new ArrayList<DJError>();
        String[] errorIndicators = new String[]{"Error: ", "Exception: ", "invalid flag:"};
        try {
            String output = r.readLine();
            while (output != null) {
                if (TextUtil.containsAny(output, errorIndicators)) {
                    result.add(new DJError(output + '\n' + IOUtil.toString(r), false));
                } else {
                    DJError error = this._parseJavadocErrorLine(output);
                    if (error != null) {
                        result.add(error);
                    }
                }
                output = r.readLine();
            }
        }
        catch (IOException e) {
            DebugUtil.error.log(e);
        }
        return result;
    }

    private DJError _parseJavadocErrorLine(String line) {
        int errStart = line.indexOf(".java:");
        if (errStart == -1) {
            return null;
        }
        String fileName = line.substring(0, errStart + 5);
        int lineno = -1;
        StringBuilder linenoString = new StringBuilder();
        int pos = errStart + 6;
        while (line.charAt(pos) >= '0' && line.charAt(pos) <= '9') {
            linenoString.append(line.charAt(pos));
            ++pos;
        }
        if (line.charAt(pos) == ':') {
            try {
                lineno = Integer.valueOf(linenoString.toString()) - 1;
            }
            catch (NumberFormatException e) {}
        } else {
            pos = errStart;
        }
        String errMessage = line.substring(pos + 2);
        boolean isWarning = false;
        if (errMessage.substring(0, 7).equalsIgnoreCase("warning")) {
            isWarning = true;
        }
        if (lineno >= 0) {
            return new DJError(new File(fileName), lineno, 0, errMessage, isWarning);
        }
        return new DJError(new File(fileName), errMessage, isWarning);
    }

    private File _getFileFromDocument(OpenDefinitionsDocument doc, FileSaveSelector saver) throws IOException {
        try {
            return doc.getFile();
        }
        catch (FileMovedException fme) {
            if (saver.shouldSaveAfterFileMoved(doc, fme.getFile())) {
                try {
                    doc.saveFileAs(saver);
                    return doc.getFile();
                }
                catch (FileMovedException fme2) {
                    fme2.printStackTrace();
                    throw new IOException("Could not find file: " + fme2);
                }
            }
            throw new IllegalStateException("No file exists for this document.");
        }
    }
}

