/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleAction;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class ActionStartPrevStmtPlus
extends IndentRuleAction {
    private int _suffix;
    private boolean _useColon;

    public ActionStartPrevStmtPlus(int suffix, boolean colonIsDelim) {
        this._suffix = suffix;
        this._useColon = colonIsDelim;
    }

    public boolean indentLine(AbstractDJDocument doc, Indenter.IndentReason reason) {
        int prevDelimiterPos;
        boolean supResult = super.indentLine(doc, reason);
        int here = doc.getCurrentLocation();
        char[] delims = new char[]{';', '{', '}'};
        int lineStart = doc._getLineStartPos(here);
        try {
            prevDelimiterPos = doc.findPrevDelimiter(lineStart, delims);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        if (prevDelimiterPos <= 0) {
            doc.setTab(this._suffix, here);
            return supResult;
        }
        try {
            int testPos;
            char testDelim;
            char delim = doc.getText(prevDelimiterPos, 1).charAt(0);
            char[] ws = new char[]{' ', '\t', '\n', ';'};
            if (delim == ';' && ((testDelim = doc.getText(testPos = doc._findPrevCharPos(prevDelimiterPos, ws), 1).charAt(0)) == '}' || testDelim == ')')) {
                prevDelimiterPos = testPos;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        try {
            char delim = doc.getText(prevDelimiterPos, 1).charAt(0);
            if (delim == '}' || delim == ')') {
                assert (doc.getCurrentLocation() == here);
                doc.setCurrentLocation(prevDelimiterPos + 1);
                int delta = doc.balanceBackward();
                if (delta < 0) {
                    throw new UnexpectedException("No matching '{' or '(' preceding '" + delim + "' at offset " + here + " in " + doc);
                }
                doc.setCurrentLocation(here);
                assert (doc.getText(prevDelimiterPos -= delta - 1, 1).charAt(0) == '{' || doc.getText(prevDelimiterPos, 1).charAt(0) == '(');
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        char[] indentDelimsWithColon = new char[]{';', '{', '}', ':'};
        char[] indentDelimsWithoutColon = new char[]{';', '{', '}'};
        char[] indentDelims = this._useColon ? indentDelimsWithColon : indentDelimsWithoutColon;
        int indent = doc._getIndentOfCurrStmt(prevDelimiterPos, indentDelims);
        doc.setTab(indent += this._suffix, here);
        return supResult;
    }
}

