/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelStackTraceMapper {
    public static final Log LOG = new Log("llstm.txt", false);
    private HashMap<String, TreeMap<Integer, Integer>> cache;
    private GlobalModel AGmodel;

    public LanguageLevelStackTraceMapper(GlobalModel AGM) {
        this.AGmodel = AGM;
        this.cache = new HashMap();
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, File d, TreeMap<Integer, Integer> m) {
        if (!this.matches(d, s)) {
            return s;
        }
        StackTraceElement NewS = new StackTraceElement(s.getClassName(), s.getMethodName(), d.getName(), m.get(s.getLineNumber()));
        return NewS;
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, File d) {
        if (!this.matches(d, s)) {
            return s;
        }
        String FileName = d.getAbsolutePath();
        if (this.cache.containsKey(FileName)) {
            return this.replaceStackTraceElement(s, d, this.cache.get(FileName));
        }
        String dn = d.getName();
        dn = dn.substring(0, dn.lastIndexOf(46)) + ".java";
        File javaFile = new File(d.getParentFile(), dn);
        this.cache.put(FileName, this.ReadLanguageLevelLineBlock(javaFile));
        return this.replaceStackTraceElement(s, d, this.cache.get(FileName));
    }

    public StackTraceElement replaceStackTraceElement(StackTraceElement s, List<File> ds) {
        for (int i = 0; i < ds.size(); ++i) {
            s = this.replaceStackTraceElement(s, ds.get(i));
        }
        return s;
    }

    public StackTraceElement[] replaceStackTrace(StackTraceElement[] ss, List<File> ds) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.replaceStackTraceElement(ss[i], ds);
        }
        return ss;
    }

    public void clearCache() {
        this.cache = new HashMap();
    }

    private boolean matches(File f, StackTraceElement s) {
        OpenDefinitionsDocument d;
        LOG.log("matches(" + f + ", " + s + ")");
        if (s.getFileName() == null) {
            return false;
        }
        try {
            d = this.AGmodel.getDocumentForFile(f);
        }
        catch (IOException e) {
            return false;
        }
        String dn = d.getRawFile().getName();
        if (!LanguageLevelStackTraceMapper.isLLFileName(dn)) {
            return false;
        }
        dn = dn.substring(0, dn.lastIndexOf(46)) + ".java";
        String dp = d.getPackageName();
        int dotPos = s.getClassName().lastIndexOf(46);
        if (dp.length() == 0 && dotPos >= 0) {
            return false;
        }
        if (dp.length() > 0 && dotPos < 0) {
            return false;
        }
        String sp = "";
        if (dotPos >= 0) {
            sp = s.getClassName().substring(0, dotPos);
        }
        if (!dp.equals(sp)) {
            return false;
        }
        return s.getFileName().equals(dn);
    }

    public TreeMap<Integer, Integer> ReadLanguageLevelLineBlock(File LLFile) {
        BufferedReader BReader = null;
        String ReadLine = "";
        try {
            BReader = new BufferedReader(new FileReader(LLFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            ReadLine = BReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        LOG.log("ReadLine = '" + ReadLine + "'");
        LOG.log("\tlastIndex = " + ReadLine.lastIndexOf(" "));
        Integer MapSize = new Integer(ReadLine.substring(ReadLine.lastIndexOf(" ") + 1));
        try {
            ReadLine = BReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (ReadLine.indexOf("//") != 0) {
            MapSize = 0;
        }
        String temp = "";
        String numRnum = "";
        TreeMap<Integer, Integer> JavaDjMap = new TreeMap<Integer, Integer>();
        temp = ReadLine.substring(2);
        temp = temp.trim() + " ";
        for (int i = 0; i < MapSize; ++i) {
            if (temp.length() < 2) {
                temp = this.ReadLanguageLevelLineBlockHelper(BReader);
            }
            if (temp == null) break;
            numRnum = temp.substring(0, temp.indexOf(" "));
            Integer djNum = new Integer(numRnum.substring(0, numRnum.indexOf("->")));
            Integer javaNum = new Integer(numRnum.substring(numRnum.indexOf("->") + 2));
            JavaDjMap.put(javaNum, djNum);
            temp = temp.substring(temp.indexOf(" ")).trim() + " ";
        }
        return JavaDjMap;
    }

    public TreeMap<Integer, Integer> ReadLanguageLevelLineBlockRev(File LLFile) {
        BufferedReader BReader = null;
        String ReadLine = "";
        try {
            BReader = new BufferedReader(new FileReader(LLFile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            ReadLine = BReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        LOG.log("ReadLine = '" + ReadLine + "'");
        LOG.log("\tlastIndex = " + ReadLine.lastIndexOf(" "));
        Integer MapSize = new Integer(ReadLine.substring(ReadLine.lastIndexOf(" ") + 1));
        try {
            ReadLine = BReader.readLine();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (ReadLine.indexOf("//") != 0) {
            MapSize = 0;
        }
        String temp = "";
        String numRnum = "";
        TreeMap<Integer, Integer> DjJavaMap = new TreeMap<Integer, Integer>();
        temp = ReadLine.substring(2);
        temp = temp.trim() + " ";
        for (int i = 0; i < MapSize; ++i) {
            if (temp.length() < 2) {
                temp = this.ReadLanguageLevelLineBlockHelper(BReader);
            }
            if (temp == null) break;
            numRnum = temp.substring(0, temp.indexOf(" "));
            Integer djNum = new Integer(numRnum.substring(0, numRnum.indexOf("->")));
            Integer javaNum = new Integer(numRnum.substring(numRnum.indexOf("->") + 2));
            DjJavaMap.put(djNum, javaNum);
            temp = temp.substring(temp.indexOf(" ")).trim() + " ";
        }
        return DjJavaMap;
    }

    private String ReadLanguageLevelLineBlockHelper(BufferedReader BR) {
        String line = "";
        try {
            line = BR.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (line.indexOf("//") != 0) {
            return null;
        }
        line = line.substring(2).trim();
        return line;
    }

    public static boolean isLLFileName(String s) {
        return s.endsWith(".dj0") || s.endsWith(".dj1") || s.endsWith(".dj2");
    }

    public static boolean isLLFile(File f) {
        return LanguageLevelStackTraceMapper.isLLFileName(f.getName());
    }

    public static File getJavaFileForLLFile(File llFile) {
        if (!LanguageLevelStackTraceMapper.isLLFile(llFile)) {
            throw new AssertionError((Object)("File is not a language level file: " + llFile));
        }
        String dn = llFile.getPath();
        dn = dn.substring(0, dn.lastIndexOf(46)) + ".java";
        return new File(dn);
    }
}

