/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javac150Compiler
extends JavacCompiler {
    private boolean _supportsJSR14v2_4 = this._supportsJSR14v2_4();
    private boolean _isJSR14v2_5 = false;
    public static final String COMPILER_CLASS_NAME = "com.sun.tools.javac.main.JavaCompiler";
    private static final PrintWriter NULL_WRITER = new PrintWriter(new Writer(){

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    });

    public Javac150Compiler(JavaVersion.FullVersion version, String location, java.util.List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName(COMPILER_CLASS_NAME);
            try {
                Class.forName("java.lang.Enum");
            }
            catch (Exception e) {
                Class.forName("com.sun.tools.javac.main.Main$14");
                this._isJSR14v2_5 = true;
            }
            return this._isValidVersion();
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    private boolean _isValidVersion() {
        Class<Log> log = Log.class;
        Class[] validArgs1 = new Class[]{Context.class};
        try {
            log.getMethod("instance", validArgs1);
            try {
                log.getMethod("hasDiagnosticListener", new Class[0]);
                return false;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public java.util.List<? extends DJError> compile(java.util.List<? extends File> files, java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        Context context = this._createContext(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        OurLog log = new OurLog(context);
        JavaCompiler compiler = this._makeCompiler(context);
        List<String> filesToCompile = this._emptyStringList();
        for (File file : files) {
            filesToCompile = filesToCompile.prepend(file.getAbsolutePath());
        }
        try {
            compiler.compile(filesToCompile);
        }
        catch (Throwable t) {
            LinkedList<DJError> linkedList = log.getErrors();
            linkedList.addFirst(new DJError("Compile exception: " + t, false));
            DebugUtil.error.log(t);
            DebugUtil.debug.logEnd("compile() (caught an exception)");
            return linkedList;
        }
        DebugUtil.debug.logEnd("compile()");
        return log.getErrors();
    }

    @Override
    public String getName() {
        if (this._isJSR14v2_5) {
            return "JSR-14 v2.5";
        }
        return super.getName();
    }

    private Context _createContext(java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        Context context = new Context();
        Options options = Options.instance(context);
        options.putAll(CompilerOptions.getOptions(showWarnings));
        options.put("-g", "");
        if (classPath != null) {
            options.put("-classpath", IOUtil.pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put("-sourcepath", IOUtil.pathToString(sourcePath));
        }
        if (destination != null) {
            options.put("-d", destination.getPath());
        }
        if (bootClassPath != null) {
            options.put("-bootclasspath", IOUtil.pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put("-source", sourceVersion);
        }
        if (!showWarnings) {
            options.put("-nowarn", "");
        }
        if (sourceVersion != null) {
            options.put("-target", sourceVersion);
        } else {
            options.put("-target", "1.5");
        }
        return context;
    }

    protected JavaCompiler _makeCompiler(Context context) {
        Class<JavaCompiler> javaCompilerClass = JavaCompiler.class;
        Class[] validArgs1 = new Class[]{Context.class};
        if (this._supportsJSR14v2_4) {
            try {
                Method m = javaCompilerClass.getMethod("instance", validArgs1);
                return (JavaCompiler)m.invoke(null, context);
            }
            catch (NoSuchMethodException e) {
                throw new UnexpectedException(e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException(e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new UnexpectedException(e);
            }
        }
        try {
            Method m = javaCompilerClass.getMethod("make", validArgs1);
            return (JavaCompiler)m.invoke(null, context);
        }
        catch (NoSuchMethodException e) {
            throw new UnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedException(e);
        }
    }

    private boolean _supportsJSR14v2_4() {
        try {
            Class.forName("com.sun.tools.javac.main.Main$14");
            return true;
        }
        catch (Exception e) {
            try {
                Class.forName("com.sun.tools.javac.main.Main+1");
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    private List<String> _emptyStringList() {
        try {
            Method nil = List.class.getMethod("nil", new Class[0]);
            List result = (List)nil.invoke(null, new Object[0]);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception occured when invoking com.sun.tools.javac.util.List.nil()", e);
        }
        catch (Exception e) {
            try {
                List result = (List)List.class.newInstance();
                return result;
            }
            catch (Exception e2) {
                throw new RuntimeException("Unable to create an instance of com.sun.tools.javac.util.List", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OurLog
    extends Log {
        private LinkedList<DJError> _errors = new LinkedList();
        private String _sourceName = "";

        public OurLog(Context context) {
            super(context, NULL_WRITER, NULL_WRITER, NULL_WRITER);
        }

        public void warning(int pos, String key, Object ... args) {
            super.warning(pos, key, args);
            String msg = OurLog.getText((String)("compiler.warn." + key), (Object[])args);
            this._errors.addLast(new DJError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        public void mandatoryWarning(int pos, String key, Object ... args) {
            super.mandatoryWarning(pos, key, args);
            String msg = OurLog.getText((String)("compiler.warn." + key), (Object[])args);
            this._errors.addLast(new DJError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, true));
        }

        @Override
        public void error(int pos, String key, Object ... args) {
            super.error(pos, key, args);
            String msg = OurLog.getText((String)("compiler.err." + key), (Object[])args);
            this._errors.addLast(new DJError(new File(this.currentSource().toString()), Position.line((int)pos) - 1, Position.column((int)pos) - 1, msg, false));
        }

        public void note(String key, Object ... args) {
            super.note(key, args);
        }

        public void mandatoryNote(String key, Object ... args) {
            super.mandatoryNote(key, args);
        }

        public LinkedList<DJError> getErrors() {
            return this._errors;
        }
    }
}

