/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.compiler.CompilerEventNotifier;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.LanguageLevelStackTraceMapper;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.Options;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.ScrollableListDialog;
import edu.rice.cs.util.swing.Utilities;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompilerModel
implements CompilerModel {
    private final List<CompilerInterface> _compilers;
    private CompilerInterface _active;
    private final CompilerEventNotifier _notifier = new CompilerEventNotifier();
    private final GlobalModel _model;
    private CompilerErrorModel _compilerErrorModel;
    private Object _compilerLock = new Object();
    public LanguageLevelStackTraceMapper _LLSTM;

    public DefaultCompilerModel(GlobalModel m, Iterable<? extends CompilerInterface> compilers) {
        this._compilers = new ArrayList<CompilerInterface>();
        for (CompilerInterface compilerInterface : compilers) {
            this._compilers.add(compilerInterface);
        }
        this._active = this._compilers.size() > 0 ? this._compilers.get(0) : NoCompilerAvailable.ONLY;
        this._model = m;
        this._compilerErrorModel = new CompilerErrorModel(new DJError[0], this._model);
        this._LLSTM = new LanguageLevelStackTraceMapper(m);
    }

    @Override
    public Object getCompilerLock() {
        return this._compilerLock;
    }

    @Override
    public void addListener(CompilerListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(CompilerListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public void compileAll() throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(this._model.getOpenDefinitionsDocuments());
        } else {
            this._notifier.compileAborted(new UnexpectedException("Some modified open files are unsaved"));
        }
    }

    @Override
    public void compileProject() throws IOException {
        if (!this._model.isProjectActive()) {
            throw new UnexpectedException("compileProject invoked when DrJava is not in project mode");
        }
        if (this._prepareForCompile()) {
            this._doCompile(this._model.getProjectDocuments());
        } else {
            this._notifier.compileAborted(new UnexpectedException("Project contains unsaved modified files"));
        }
    }

    @Override
    public void compile(List<OpenDefinitionsDocument> defDocs) throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(defDocs);
        } else {
            this._notifier.compileAborted(new UnexpectedException("The files to be compiled include unsaved modified files"));
        }
    }

    @Override
    public void compile(OpenDefinitionsDocument doc) throws IOException {
        if (this._prepareForCompile()) {
            this._doCompile(Arrays.asList(doc));
        } else {
            this._notifier.compileAborted(new UnexpectedException(doc + "is modified but unsaved"));
        }
    }

    private boolean _prepareForCompile() {
        if (this._model.hasModifiedDocuments()) {
            this._notifier.saveBeforeCompile();
        }
        return !this._model.hasModifiedDocuments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doCompile(List<OpenDefinitionsDocument> docs) throws IOException {
        ArrayList<File> excludedFiles;
        block11: {
            this._LLSTM.clearCache();
            ArrayList<File> filesToCompile = new ArrayList<File>();
            excludedFiles = new ArrayList<File>();
            ArrayList<DJError> packageErrors = new ArrayList<DJError>();
            for (OpenDefinitionsDocument doc : docs) {
                if (doc.isSourceFile()) {
                    File f = doc.getFile();
                    if (f != null && f != FileOps.NULL_FILE) {
                        filesToCompile.add(f);
                    }
                    doc.setCachedClassFile(FileOps.NULL_FILE);
                    try {
                        doc.getSourceRoot();
                    }
                    catch (InvalidPackageException e) {
                        packageErrors.add(new DJError(f, e.getMessage(), false));
                    }
                    continue;
                }
                excludedFiles.add(doc.getFile());
            }
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultCompilerModel.this._notifier.compileStarted();
                }
            });
            try {
                if (!packageErrors.isEmpty()) {
                    this._distributeErrors(packageErrors);
                    break block11;
                }
                try {
                    File buildDir = this._model.getBuildDirectory();
                    if (buildDir != null && buildDir != FileOps.NULL_FILE && !buildDir.exists() && !buildDir.mkdirs()) {
                        throw new IOException("Could not create build directory: " + buildDir);
                    }
                    this._compileFiles(filesToCompile, buildDir);
                }
                catch (Throwable t) {
                    DJError err = new DJError(t.toString(), false);
                    this._distributeErrors(Arrays.asList(err));
                    throw new UnexpectedException(t);
                }
            }
            catch (Throwable throwable) {
                Utilities.invokeLater(new Runnable(excludedFiles){
                    final /* synthetic */ ArrayList val$excludedFiles;
                    {
                        this.val$excludedFiles = arrayList;
                    }

                    public void run() {
                        DefaultCompilerModel.this._notifier.compileEnded(DefaultCompilerModel.this._model.getWorkingDirectory(), this.val$excludedFiles);
                    }
                });
                throw throwable;
            }
        }
        Utilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private LinkedList<DJError> _parseExceptions2CompilerErrors(LinkedList<JExprParseException> pes) {
        LinkedList<DJError> errors = new LinkedList<DJError>();
        for (JExprParseException pe : pes) {
            errors.addLast(new DJError(pe.getFile(), pe.currentToken.beginLine - 1, pe.currentToken.beginColumn - 1, pe.getMessage(), false));
        }
        return errors;
    }

    private LinkedList<DJError> _visitorErrors2CompilerErrors(LinkedList<Pair<String, JExpressionIF>> visitorErrors) {
        LinkedList<DJError> errors = new LinkedList<DJError>();
        for (Pair pair : visitorErrors) {
            String message = (String)pair.getFirst();
            JExpressionIF jexpr = (JExpressionIF)pair.getSecond();
            SourceInfo si = jexpr == null ? JExprParser.NO_SOURCE_INFO : ((JExpressionIF)pair.getSecond()).getSourceInfo();
            errors.addLast(new DJError(si.getFile(), si.getStartLine() - 1, si.getStartColumn() - 1, message, false));
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileFiles(List<File> files, File buildDir) throws IOException {
        if (!files.isEmpty()) {
            if (buildDir == FileOps.NULL_FILE) {
                buildDir = null;
            }
            if (buildDir != null) {
                buildDir = IOUtil.attemptCanonicalFile(buildDir);
            }
            List<File> classPath = CollectUtil.makeList(this._model.getClassPath());
            List<File> bootClassPath = null;
            String bootProp = System.getProperty("drjava.bootclasspath");
            if (bootProp != null) {
                bootClassPath = CollectUtil.makeList(IOUtil.parsePath(bootProp));
            }
            LinkedList<DJError> errors = new LinkedList<DJError>();
            List<File> preprocessedFiles = this._compileLanguageLevelsFiles(files, errors, classPath, bootClassPath);
            if (errors.isEmpty()) {
                CompilerInterface compiler = this.getActiveCompiler();
                Object object = this._compilerLock;
                synchronized (object) {
                    if (preprocessedFiles == null) {
                        errors.addAll(compiler.compile(files, classPath, null, buildDir, bootClassPath, null, true));
                    } else {
                        errors.addAll(compiler.compile(preprocessedFiles, classPath, null, buildDir, bootClassPath, null, false));
                    }
                }
            }
            this._distributeErrors(errors);
        } else {
            this._distributeErrors(Collections.emptyList());
        }
    }

    private static List<File> _testFileSort(List<File> files) {
        LinkedList<File> testFiles = new LinkedList<File>();
        LinkedList<File> otherFiles = new LinkedList<File>();
        for (File f : files) {
            if (f.getName().contains("Test")) {
                testFiles.add(f);
                continue;
            }
            otherFiles.add(f);
        }
        otherFiles.addAll(testFiles);
        return otherFiles;
    }

    private List<File> _compileLanguageLevelsFiles(List<File> files, List<DJError> errors, Iterable<File> classPath, Iterable<File> bootClassPath) {
        String fileName;
        File canonicalFile;
        HashSet<File> javaFileSet = new HashSet<File>();
        LinkedList<File> newFiles = new LinkedList<File>();
        final LinkedList<File> filesToBeClosed = new LinkedList<File>();
        boolean containsLanguageLevels = false;
        for (File f : files) {
            canonicalFile = IOUtil.attemptCanonicalFile(f);
            fileName = canonicalFile.getPath();
            int lastIndex = fileName.lastIndexOf(".dj");
            if (lastIndex != -1) {
                containsLanguageLevels = true;
                File javaFile = new File(fileName.substring(0, lastIndex) + ".java");
                if (files.contains(javaFile)) {
                    filesToBeClosed.add(javaFile);
                } else {
                    javaFile.delete();
                }
                javaFileSet.add(javaFile);
                newFiles.add(javaFile);
                continue;
            }
            javaFileSet.add(canonicalFile);
        }
        for (File f : filesToBeClosed) {
            canonicalFile = IOUtil.attemptCanonicalFile(f);
            fileName = canonicalFile.getPath();
            if (!files.contains(new File(fileName.substring(0, fileName.lastIndexOf(".java")) + ".dj0")) && !files.contains(new File(fileName.substring(0, fileName.lastIndexOf(".java")) + ".dj1")) && !files.contains(new File(fileName.substring(0, fileName.lastIndexOf(".java")) + ".dj2"))) continue;
            files.remove(new File(fileName));
        }
        if (!filesToBeClosed.isEmpty()) {
            JButton closeButton = new JButton(new AbstractAction("Close Files"){

                public void actionPerformed(ActionEvent e) {
                }
            });
            JButton keepButton = new JButton(new AbstractAction("Keep Open"){

                public void actionPerformed(ActionEvent e) {
                    filesToBeClosed.clear();
                }
            });
            ScrollableListDialog dialog = new ScrollableListDialog.Builder().setTitle("Java File" + (filesToBeClosed.size() == 1 ? "" : "s") + " Need to Be Closed").setText("The following .java " + (filesToBeClosed.size() == 1 ? "file has a matching .dj? file" : "files have matching .dj? files") + " open.\n" + (filesToBeClosed.size() == 1 ? "This .java file needs" : "These .java files need") + " to be closed for proper compiling.").setItems(filesToBeClosed).setMessageType(2).setFitToScreen(true).clearButtons().addButton(closeButton).addButton(keepButton).build();
            dialog.showDialog();
            LinkedList<OpenDefinitionsDocument> docsToBeClosed = new LinkedList<OpenDefinitionsDocument>();
            for (File f : filesToBeClosed) {
                try {
                    docsToBeClosed.add(this._model.getDocumentForFile(f));
                }
                catch (IOException ioe) {}
            }
            this._model.closeFiles(docsToBeClosed);
            for (File f : filesToBeClosed) {
                f.delete();
            }
        }
        if (containsLanguageLevels) {
            File buildDir = this._model.getBuildDirectory();
            File sourceDir = this._model.getProjectRoot();
            if (!DrJava.getConfig().getSetting(OptionConstants.DELETE_LL_CLASS_FILES).equals(OptionConstants.DELETE_LL_CLASS_FILES_CHOICES.get(0))) {
                final HashSet<File> dirsWithLLFiles = new HashSet<File>();
                for (File f : newFiles) {
                    try {
                        File dir = f.getParentFile();
                        if (buildDir != null && buildDir != FileOps.NULL_FILE && sourceDir != null && sourceDir != FileOps.NULL_FILE) {
                            String rel = FileOps.stringMakeRelativeTo(dir, sourceDir);
                            dir = new File(buildDir, rel);
                        }
                        dirsWithLLFiles.add(dir);
                    }
                    catch (IOException ioe) {}
                }
                if (DrJava.getConfig().getSetting(OptionConstants.DELETE_LL_CLASS_FILES).equals(OptionConstants.DELETE_LL_CLASS_FILES_CHOICES.get(1))) {
                    JButton deleteButton = new JButton(new AbstractAction("Delete Class Files"){

                        public void actionPerformed(ActionEvent e) {
                        }
                    });
                    JButton keepButton = new JButton(new AbstractAction("Keep Class Files"){

                        public void actionPerformed(ActionEvent e) {
                            dirsWithLLFiles.clear();
                        }
                    });
                    ScrollableListDialog dialog = new ScrollableListDialog.Builder().setTitle("Delete Class Files").setText("We suggest that you delete all class files in the directories with language\nlevel files. Do you want to delete the class files in the following director" + (dirsWithLLFiles.size() == 1 ? "y" : "ies") + "?").setItems(new ArrayList(dirsWithLLFiles)).setMessageType(3).setFitToScreen(true).clearButtons().addButton(deleteButton).addButton(keepButton).build();
                    dialog.showDialog();
                }
                for (File f : dirsWithLLFiles) {
                    f.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            int endPos = name.lastIndexOf(".class");
                            if (endPos < 0) {
                                return false;
                            }
                            new File(dir, name).delete();
                            return false;
                        }
                    });
                }
            }
            LanguageLevelConverter llc = new LanguageLevelConverter();
            Options llOpts = bootClassPath == null ? new Options(this.getActiveCompiler().version(), classPath) : new Options(this.getActiveCompiler().version(), classPath, bootClassPath);
            HashMap<File, Set<String>> sourceToTopLevelClassMap = new HashMap<File, Set<String>>();
            Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> llErrors = llc.convert(DefaultCompilerModel._testFileSort(files).toArray(new File[0]), llOpts, sourceToTopLevelClassMap);
            errors.addAll(this._parseExceptions2CompilerErrors(llErrors.getFirst()));
            errors.addAll(this._visitorErrors2CompilerErrors(llErrors.getSecond()));
        }
        if (containsLanguageLevels) {
            return new LinkedList<File>(javaFileSet);
        }
        return null;
    }

    private void _distributeErrors(List<? extends DJError> errors) throws IOException {
        this._compilerErrorModel = new CompilerErrorModel(errors.toArray(new DJError[0]), this._model);
        this._model.setNumCompErrors(this._compilerErrorModel.getNumCompErrors());
    }

    @Override
    public CompilerErrorModel getCompilerErrorModel() {
        return this._compilerErrorModel;
    }

    @Override
    public int getNumErrors() {
        return this.getCompilerErrorModel().getNumErrors();
    }

    public int getNumCompErrors() {
        return this.getCompilerErrorModel().getNumCompErrors();
    }

    public int getNumWarnings() {
        return this.getCompilerErrorModel().getNumWarnings();
    }

    @Override
    public void resetCompilerErrors() {
        this._compilerErrorModel = new CompilerErrorModel(new DJError[0], this._model);
    }

    @Override
    public Iterable<CompilerInterface> getAvailableCompilers() {
        if (this._compilers.isEmpty()) {
            return IterUtil.singleton(NoCompilerAvailable.ONLY);
        }
        return IterUtil.snapshot(this._compilers);
    }

    @Override
    public CompilerInterface getActiveCompiler() {
        return this._active;
    }

    @Override
    public void setActiveCompiler(CompilerInterface compiler) {
        if (!this._compilers.isEmpty() || !compiler.equals(NoCompilerAvailable.ONLY)) {
            if (this._compilers.contains(compiler)) {
                this._active = compiler;
                this._notifier.activeCompilerChanged();
            } else {
                throw new IllegalArgumentException("Compiler is not in the list of available compilers: " + compiler);
            }
        }
    }

    @Override
    public void addCompiler(CompilerInterface compiler) {
        if (this._compilers.isEmpty()) {
            this._active = compiler;
        }
        this._compilers.add(compiler);
    }

    public void smartDeleteClassFiles(Map<File, Set<String>> sourceToTopLevelClassMap) {
        File buildDir = this._model.getBuildDirectory();
        File sourceDir = this._model.getProjectRoot();
        HashMap dirToClassNameMap = new HashMap();
        for (Map.Entry<File, Set<String>> entry : sourceToTopLevelClassMap.entrySet()) {
            try {
                HashSet classNames;
                File dir = entry.getKey().getParentFile();
                if (buildDir != null && buildDir != FileOps.NULL_FILE && sourceDir != null && sourceDir != FileOps.NULL_FILE) {
                    String rel = FileOps.stringMakeRelativeTo(dir, sourceDir);
                    dir = new File(buildDir, rel);
                }
                if ((classNames = (HashSet)dirToClassNameMap.get(dir)) == null) {
                    classNames = new HashSet();
                }
                classNames.addAll(entry.getValue());
                dirToClassNameMap.put(dir, classNames);
            }
            catch (IOException ioe) {}
        }
        for (final Map.Entry<File, Set<String>> entry : dirToClassNameMap.entrySet()) {
            entry.getKey().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    Set classNames;
                    int endPos = name.lastIndexOf(".class");
                    if (endPos < 0) {
                        return false;
                    }
                    int dollarPos = name.indexOf(36);
                    if (dollarPos >= 0 && dollarPos < endPos) {
                        endPos = dollarPos;
                    }
                    if ((classNames = (Set)entry.getValue()).contains(name.substring(0, endPos))) {
                        new File(dir, name).delete();
                    }
                    return false;
                }
            });
        }
    }

    @Override
    public LanguageLevelStackTraceMapper getLLSTM() {
        return this._LLSTM;
    }
}

