/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import java.io.File;
import java.util.List;

public class JDKToolsLibrary {
    private final JavaVersion.FullVersion _version;
    private final CompilerInterface _compiler;
    private final Debugger _debugger;
    private final JavadocModel _javadoc;

    protected JDKToolsLibrary(JavaVersion.FullVersion version, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc) {
        this._version = version;
        this._compiler = compiler;
        this._debugger = debugger;
        this._javadoc = javadoc;
    }

    public JavaVersion.FullVersion version() {
        return this._version;
    }

    public CompilerInterface compiler() {
        return this._compiler;
    }

    public Debugger debugger() {
        return this._debugger;
    }

    public JavadocModel javadoc() {
        return this._javadoc;
    }

    public boolean isValid() {
        return this._compiler.isAvailable() || this._debugger.isAvailable() || this._javadoc.isAvailable();
    }

    public String toString() {
        return "JDK library " + this._version.versionString();
    }

    protected static String adapterForCompiler(JavaVersion version) {
        switch (version) {
            case JAVA_6: {
                return "edu.rice.cs.drjava.model.compiler.Javac160Compiler";
            }
            case JAVA_5: {
                return "edu.rice.cs.drjava.model.compiler.Javac150Compiler";
            }
            case JAVA_1_4: {
                return "edu.rice.cs.drjava.model.compiler.Javac141Compiler";
            }
        }
        return null;
    }

    protected static String adapterForDebugger(JavaVersion version) {
        switch (version) {
            case JAVA_6: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
            case JAVA_5: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
            case JAVA_1_4: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
        }
        return null;
    }

    public static JDKToolsLibrary makeFromRuntime(GlobalModel model) {
        JavaVersion.FullVersion version = JavaVersion.CURRENT_FULL;
        CompilerInterface compiler = NoCompilerAvailable.ONLY;
        String compilerAdapter = JDKToolsLibrary.adapterForCompiler(version.majorVersion());
        if (compilerAdapter != null) {
            List<File> bootClassPath = null;
            String bootProp = System.getProperty("sun.boot.class.path");
            if (bootProp != null) {
                bootClassPath = CollectUtil.makeList(IOUtil.parsePath(bootProp));
            }
            try {
                Class[] sig = new Class[]{JavaVersion.FullVersion.class, String.class, List.class};
                Object[] args = new Object[]{version, "the runtime class path", bootClassPath};
                CompilerInterface attempt = (CompilerInterface)ReflectUtil.loadObject(compilerAdapter, sig, args);
                if (attempt.isAvailable()) {
                    compiler = attempt;
                }
            }
            catch (ReflectException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        Debugger debugger = NoDebuggerAvailable.ONLY;
        String debuggerAdapter = JDKToolsLibrary.adapterForDebugger(version.majorVersion());
        if (debuggerAdapter != null) {
            try {
                Debugger attempt = (Debugger)ReflectUtil.loadObject(debuggerAdapter, new Class[]{GlobalModel.class}, new Object[]{model});
                if (attempt.isAvailable()) {
                    debugger = attempt;
                }
            }
            catch (ReflectException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        JavadocModel javadoc = new NoJavadocAvailable(model);
        try {
            Class.forName("com.sun.tools.javadoc.Main");
            javadoc = new DefaultJavadocModel(model, null, ReflectUtil.SYSTEM_CLASS_PATH);
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        return new JDKToolsLibrary(version, compiler, debugger, javadoc);
    }
}

