/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ConfigProperty;
import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.JavaSystemProperty;
import edu.rice.cs.drjava.config.OptionMap;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.drjava.config.VariableProperty;
import edu.rice.cs.plt.lambda.Lambda2;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMaps
implements Cloneable {
    protected Map<String, Map<String, DrJavaProperty>> _props = new TreeMap<String, Map<String, DrJavaProperty>>();
    public static final PropertyMaps TEMPLATE = new PropertyMaps();
    public static final Lambda2<DrJavaProperty, PropertyMaps, String> GET_LAZY;
    public static final Lambda2<DrJavaProperty, PropertyMaps, String> GET_CURRENT;
    protected HashMap<String, Stack<VariableProperty>> _variables = new HashMap();
    protected static final String VARIABLES_CATEGORY = "$Variables$";

    public DrJavaProperty getProperty(String category, String name) {
        Map<String, DrJavaProperty> m = this._props.get(category);
        if (m == null) {
            throw new IllegalArgumentException("DrJavaProperty category unknown.");
        }
        return m.get(name);
    }

    public DrJavaProperty getProperty(String key) {
        for (String category : this._props.keySet()) {
            DrJavaProperty p = this.getProperty(category, key);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public void removeProperty(DrJavaProperty p) {
        for (String category : this._props.keySet()) {
            this._props.get(category).remove(p);
        }
    }

    public DrJavaProperty setProperty(String category, DrJavaProperty p) {
        Map<String, DrJavaProperty> m = this._props.get(category);
        if (m == null) {
            m = new HashMap<String, DrJavaProperty>();
            this._props.put(category, m);
        }
        m.put(p.getName(), p);
        return p;
    }

    public void clearCategory(String category) {
        this._props.remove(category);
    }

    public Set<String> getCategories() {
        return this._props.keySet();
    }

    public Map<String, DrJavaProperty> getProperties(String category) {
        Map<String, DrJavaProperty> m = this._props.get(category);
        if (m == null) {
            throw new IllegalArgumentException("DrJavaProperty category unknown.");
        }
        return m;
    }

    public void clearVariables() {
        this._props.remove(VARIABLES_CATEGORY);
    }

    public void addVariable(String name, String value) {
        for (String category : this._props.keySet()) {
            if (category.equals(VARIABLES_CATEGORY) || this.getProperty(category, name) == null) continue;
            throw new IllegalArgumentException("Variable " + name + " already used for a built-in property");
        }
        VariableProperty p = new VariableProperty(name, value);
        this.setProperty(VARIABLES_CATEGORY, p);
        Stack<VariableProperty> varStack = this._variables.get(name);
        if (varStack == null) {
            varStack = new Stack();
            this._variables.put(name, varStack);
        }
        varStack.push(p);
    }

    public void setVariable(String name, String value) {
        Stack<VariableProperty> varStack = this._variables.get(name);
        if (varStack == null || varStack.empty()) {
            throw new IllegalArgumentException("Variable " + name + " does not exist.");
        }
        VariableProperty p = varStack.peek();
        p.setValue(value);
    }

    public void removeVariable(String name) {
        Stack<VariableProperty> varStack = this._variables.get(name);
        if (varStack == null || varStack.empty()) {
            throw new IllegalArgumentException("Variable " + name + " does not exist.");
        }
        VariableProperty p = varStack.pop();
        if (varStack.empty()) {
            this._variables.remove(name);
            this.removeProperty(p);
        } else {
            this.setProperty(VARIABLES_CATEGORY, varStack.peek());
        }
    }

    public PropertyMaps clone() throws CloneNotSupportedException {
        PropertyMaps clone = new PropertyMaps();
        clone._props.clear();
        for (String category : this._props.keySet()) {
            for (String key : this._props.get(category).keySet()) {
                clone.setProperty(category, this.getProperty(key));
            }
        }
        clone._variables.clear();
        for (String name : this._variables.keySet()) {
            Stack<VariableProperty> stack = new Stack<VariableProperty>();
            for (VariableProperty v : this._variables.get(name)) {
                stack.add(new VariableProperty(v.getName(), v.getCurrent(this)));
            }
            clone._variables.put(name, stack);
        }
        return clone;
    }

    static {
        for (Map.Entry<Object, Object> es : System.getProperties().entrySet()) {
            TEMPLATE.setProperty("Java", new JavaSystemProperty(es.getKey().toString()));
        }
        OptionMap om = DrJava.getConfig().getOptionMap();
        for (OptionParser<?> op : om.keys()) {
            String key = "config." + op.getName();
            TEMPLATE.setProperty("Config", new ConfigProperty(key));
        }
        GET_LAZY = new Lambda2<DrJavaProperty, PropertyMaps, String>(){

            @Override
            public String value(DrJavaProperty p, PropertyMaps pm) {
                return p.getLazy(pm);
            }
        };
        GET_CURRENT = new Lambda2<DrJavaProperty, PropertyMaps, String>(){

            @Override
            public String value(DrJavaProperty p, PropertyMaps pm) {
                return p.getCurrent(pm);
            }
        };
    }
}

