/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileListProperty
extends DrJavaProperty {
    protected String _sep;
    protected String _dir;

    public FileListProperty(String name, String sep, String dir, String help) {
        super(name, help);
        this._sep = sep;
        this._dir = dir;
        this.resetAttributes();
    }

    @Override
    public void invalidate() {
        this.invalidateOthers(new HashSet<DrJavaProperty>());
    }

    @Override
    public boolean isCurrent() {
        return false;
    }

    protected abstract List<File> getList(PropertyMaps var1);

    @Override
    public void update(PropertyMaps pm) {
        List<File> l;
        String quot = "";
        String q = (String)this._attributes.get("squote");
        if (q != null && q.toLowerCase().equals("true")) {
            quot = "'";
        }
        if ((q = (String)this._attributes.get("dquote")) != null && q.toLowerCase().equals("true")) {
            quot = "\"" + quot;
        }
        if ((l = this.getList(pm)).size() == 0) {
            this._value = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (File fil : l) {
            sb.append(StringOps.replaceVariables((String)this._attributes.get("sep"), pm, PropertyMaps.GET_CURRENT));
            try {
                String f = fil.toString();
                if (((String)this._attributes.get("rel")).equals("/")) {
                    f = fil.getAbsolutePath();
                } else {
                    File rf = new File(StringOps.unescapeFileName(StringOps.replaceVariables((String)this._attributes.get("rel"), pm, PropertyMaps.GET_CURRENT)));
                    f = FileOps.stringMakeRelativeTo(fil, rf);
                }
                String s = StringOps.escapeFileName(f);
                sb.append(quot);
                sb.append(s);
                sb.append(quot);
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {}
        }
        this._value = sb.toString();
        if (this._value.startsWith((String)this._attributes.get("sep"))) {
            this._value = this._value.substring(((String)this._attributes.get("sep")).length());
        }
    }

    @Override
    public void resetAttributes() {
        this._attributes.clear();
        this._attributes.put("sep", this._sep);
        this._attributes.put("rel", this._dir);
        this._attributes.put("squote", null);
        this._attributes.put("dquote", null);
    }
}

