/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.SimpleInteractionsWindow;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrJavaRoot {
    public static final int FULL_JAVA = 0;
    public static final int ELEMENTARY_LEVEL = 1;
    public static final int INTERMEDIATE_LEVEL = 2;
    public static final int ADVANCED_LEVEL = 3;
    public static final String[] LANGUAGE_LEVEL_EXTENSIONS = new String[]{"java", "dj0", "dj1", "dj2"};
    public static final String TEST_DEBUGGER_CLASS = "com.sun.jdi.Bootstrap";
    public static final String PLASTIC_THEMES_PACKAGE = "com.jgoodies.looks.plastic.theme";
    private static final PrintStream _consoleOut = System.out;
    private static final PrintStream _consoleErr = System.err;
    private static SimpleInteractionsWindow _debugConsole = null;
    private static boolean anyLineNumbersSpecified = false;
    private static MainFrame _mainFrame = null;

    public static void main(String[] args) {
        DebugUtil.debug.log("Starting up");
        PlatformFactory.ONLY.beforeUISetup();
        if (!DrJava.handleCommandLineArgs(args)) {
            System.exit(0);
        }
        final String[] filesToOpen = DrJava.getFilesToOpen();
        final int numFiles = filesToOpen.length;
        try {
            String configLAFName = DrJava.getConfig().getSetting(OptionConstants.LOOK_AND_FEEL);
            String currLAFName = UIManager.getLookAndFeel().getClass().getName();
            String failureMessage = "DrJava could not load the configured theme for the Plastic Look and Feel.\nIf you've manually edited your configuration file, try \nremoving the key \"plastic.theme\" and restarting DrJava.\nIn the meantime, the system default Look and Feel will be used.\n";
            String failureTitle = "Theme not found";
            if (Utilities.isPlasticLaf(configLAFName)) {
                String themeName = "com.jgoodies.looks.plastic.theme." + DrJava.getConfig().getSetting(OptionConstants.PLASTIC_THEMES);
                try {
                    PlasticTheme theme = (PlasticTheme)Class.forName(themeName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    PlasticLookAndFeel.setPlasticTheme(theme);
                    PlasticLookAndFeel.setTabStyle("metal");
                    Options.setPopupDropShadowEnabled(true);
                    if (!configLAFName.equals(currLAFName)) {
                        UIManager.setLookAndFeel(configLAFName);
                    }
                }
                catch (NoSuchMethodException nsmex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (SecurityException sex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (InstantiationException iex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (IllegalAccessException iaex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (IllegalArgumentException iaex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (InvocationTargetException itex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
            } else if (!configLAFName.equals(currLAFName)) {
                UIManager.setLookAndFeel(configLAFName);
            }
            _mainFrame = new MainFrame();
            DrJavaErrorWindow.setFrame(_mainFrame);
            Thread.setDefaultUncaughtExceptionHandler(DrJavaErrorHandler.INSTANCE);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    _mainFrame.start();
                    DrJavaRoot._openCommandLineFiles(_mainFrame, filesToOpen, numFiles, true);
                }
            });
            System.setOut(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    _mainFrame.getModel().systemOutPrint(s);
                }
            }));
            System.setErr(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    _mainFrame.getModel().systemErrPrint(s);
                }
            }));
            if (DrJava.getShowDebugConsole()) {
                DrJavaRoot.showDrJavaDebugConsole(_mainFrame);
            }
        }
        catch (Throwable t) {
            DebugUtil.error.log(t);
            _consoleErr.println(t.getClass().getName() + ": " + t.getMessage());
            t.printStackTrace(_consoleErr);
            System.out.println("error thrown");
            DrJavaErrorHandler.record(t);
        }
    }

    static void openCommandLineFiles(MainFrame mf, String[] filesToOpen, boolean jump) {
        DrJavaRoot.openCommandLineFiles(mf, filesToOpen, filesToOpen.length, jump);
    }

    static void openCommandLineFiles(final MainFrame mf, final String[] filesToOpen, final int len, final boolean jump) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                DrJavaRoot._openCommandLineFiles(mf, filesToOpen, len, jump);
            }
        });
    }

    private static void _openCommandLineFiles(MainFrame mf, String[] filesToOpen, int len, boolean jump) {
        anyLineNumbersSpecified = false;
        for (int i = 0; i < len; ++i) {
            String currFileName = filesToOpen[i];
            int lineNo = -1;
            int pathSepIndex = currFileName.indexOf(File.pathSeparatorChar);
            if (pathSepIndex >= 0) {
                try {
                    lineNo = Integer.valueOf(currFileName.substring(pathSepIndex + 1));
                    anyLineNumbersSpecified = true;
                }
                catch (NumberFormatException nfe) {
                    lineNo = -1;
                }
                currFileName = currFileName.substring(0, pathSepIndex);
            }
            boolean isProjectFile = currFileName.endsWith(".drjava") || currFileName.endsWith(".xml") || currFileName.endsWith(".pjt");
            final File file = new File(currFileName).getAbsoluteFile();
            FileOpenSelector command = new FileOpenSelector(){

                public File[] getFiles() {
                    return new File[]{file};
                }
            };
            try {
                if (isProjectFile) {
                    mf.openProject(command);
                    continue;
                }
                if (currFileName.endsWith(".djapp")) {
                    MainFrame.openExtProcessFile(file);
                    continue;
                }
                if (jump && lineNo >= 0) {
                    mf.open(command);
                    mf._jumpToLine(lineNo);
                    continue;
                }
                mf.getModel().openFile(command);
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (SecurityException se) {
                continue;
            }
            catch (AlreadyOpenException aoe) {
                continue;
            }
            catch (FileMovedException aoe) {
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            catch (Exception ex) {
                throw new UnexpectedException(ex);
            }
        }
    }

    public static void showDrJavaDebugConsole(MainFrame mf) {
        if (_debugConsole == null) {
            _debugConsole = new SimpleInteractionsWindow("DrJava Debug Console"){

                protected void close() {
                    this.dispose();
                    _debugConsole = null;
                }
            };
            _debugConsole.setVisible(true);
        } else {
            _debugConsole.toFront();
        }
    }

    public static PrintStream consoleErr() {
        return _consoleErr;
    }

    public static PrintStream consoleOut() {
        return _consoleOut;
    }

    public static void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        _mainFrame.dragEnter(dropTargetDragEvent);
    }

    public static void drop(DropTargetDropEvent dropTargetDropEvent) {
        _mainFrame.drop(dropTargetDropEvent);
    }

    public static void installModalWindowAdapter(Window w, Runnable1<? super WindowEvent> toFrontAction, Runnable1<? super WindowEvent> closeAction) {
        _mainFrame.installModalWindowAdapter(w, toFrontAction, closeAction);
    }

    public static void removeModalWindowAdapter(Window w) {
        _mainFrame.removeModalWindowAdapter(w);
    }

    public static void handleRemoteOpenFile(File f, int lineNo) {
        DrJava._log.log("DrJavaRoot.handleRemoteOpenFile, f=" + f);
        if (_mainFrame != null) {
            DrJava._log.log("\tcalling _mainFrame");
            _mainFrame.handleRemoteOpenFile(f, lineNo);
        } else {
            DrJava._log.log("\tadded to _filesToOpen");
            DrJava.addFileToOpen(f.getAbsolutePath());
        }
    }
}

